/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.model.internal;

import io.jans.orm.annotation.AttributesList;
import io.jans.orm.annotation.DN;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.CustomObjectAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@DataEntry
@ObjectClass(value="jansPerson")
public class JansPerson
implements Serializable {
    private static final long serialVersionUID = -1L;
    @DN
    private String dn;
    @AttributesList(name="name", value="values", multiValued="multiValued")
    private List<CustomObjectAttribute> customAttributes = new ArrayList<CustomObjectAttribute>();

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public void setCustomAttributes(List<CustomObjectAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public List<CustomObjectAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public boolean hasCustomAttributes() {
        return this.customAttributes != null && !this.customAttributes.isEmpty();
    }

    public boolean isMultiValuedCustomAttributes() {
        return this.hasCustomAttributes() && this.customAttributes.size() > 1;
    }

    public CustomObjectAttribute getCustomObjectAttribute(String name) {
        for (CustomObjectAttribute customAttribute : this.customAttributes) {
            if (!customAttribute.getName().equals(name)) continue;
            return customAttribute;
        }
        return null;
    }

    public List<String> customAttributeValues(String name) {
        for (CustomObjectAttribute customAttribute : this.customAttributes) {
            if (!customAttribute.getName().equals(name)) continue;
            List values = customAttribute.getValues();
            if (values == null || values.isEmpty()) {
                return new ArrayList<String>();
            }
            return this.convertToString(values);
        }
        return new ArrayList<String>();
    }

    public List<String> customAttributeNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (CustomObjectAttribute customAttribute : this.customAttributes) {
            ret.add(customAttribute.getName());
        }
        return ret;
    }

    public String customAttributeValue(String attributeName) {
        for (CustomObjectAttribute customAttribute : this.customAttributes) {
            if (!customAttribute.getName().equals(attributeName)) continue;
            List values = customAttribute.getValues();
            if (values == null || values.isEmpty()) {
                return null;
            }
            List<String> ret = this.convertToString(values);
            if (ret.isEmpty()) {
                return null;
            }
            return ret.get(0);
        }
        return null;
    }

    private List<String> convertToString(List<Object> values) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Object val : values) {
            if (val instanceof String) {
                String strval = (String)val;
                ret.add(strval);
                continue;
            }
            ret.add(val.toString());
        }
        return ret;
    }
}

