/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.spi.auth;

import io.jans.kc.oidc.OIDCMetaCache;
import io.jans.kc.oidc.OIDCService;
import io.jans.kc.oidc.impl.HashBasedOIDCMetaCache;
import io.jans.kc.oidc.impl.NimbusOIDCService;
import io.jans.kc.spi.auth.JansAuthenticator;
import io.jans.kc.spi.auth.JansAuthenticatorConfigProp;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class JansAuthenticatorFactory
implements AuthenticatorFactory {
    private static final String PROVIDER_ID = "kc-jans-authn";
    private static final String DISPLAY_TYPE = "Janssen Authenticator";
    private static final String REFERENCE_CATEGORY = "Janssen Authenticator";
    private static final String HELP_TEXT = "Janssen authenticator for Keycloak";
    private static final Logger log = Logger.getLogger(JansAuthenticatorFactory.class);
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.ALTERNATIVE, AuthenticationExecutionModel.Requirement.DISABLED};
    private static final OIDCMetaCache META_CACHE = new HashBasedOIDCMetaCache();
    private static final OIDCService OIDC_SERVICE = new NimbusOIDCService(META_CACHE);
    private static final JansAuthenticator INSTANCE = new JansAuthenticator(OIDC_SERVICE);

    public String getId() {
        return PROVIDER_ID;
    }

    public Authenticator create(KeycloakSession session) {
        log.debug((Object)"Janssen authenticator create()");
        return INSTANCE;
    }

    public void init(Config.Scope config) {
    }

    public void close() {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayType() {
        return "Janssen Authenticator";
    }

    public String getReferenceCategory() {
        return "Janssen Authenticator";
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return JansAuthenticatorConfigProp.asList();
    }
}

