/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.spi.protocol.mapper.saml;

import io.jans.kc.model.JansUserAttributeModel;
import io.jans.kc.spi.custom.JansThinBridgeOperationException;
import io.jans.kc.spi.custom.JansThinBridgeProvider;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.saml.mappers.AbstractSAMLProtocolMapper;
import org.keycloak.protocol.saml.mappers.SAMLAttributeStatementMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class JansSamlUserAttributeMapper
extends AbstractSAMLProtocolMapper
implements SAMLAttributeStatementMapper {
    private static final String DISPLAY_TYPE = "Janssen User Attribute";
    private static final String DISPLAY_CATEGORY = "AttributeStatement Mapper";
    private static final String HELP_TEXT = "Maps a Janssen User's Attribute to a SAML Attribute";
    private static final String PROVIDER_ID = "kc-jans-saml-user-attribute-mapper";
    private static final String JANS_ATTR_NAME_PROP_NAME = "jans.attribute.name";
    private static final String JANS_ATTR_NAME_PROP_LABEL = "Jans Attribute";
    private static final String JANS_ATTR_NAME_PROP_HELPTEXT = "Name of the Attribute in Janssen Auth Server";
    private static final List<ProviderConfigProperty> configProperties;
    private static final Logger log;

    public void init(Config.Scope scope) {
    }

    public void close() {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void transformAttributeStatement(AttributeStatementType attributeStatement, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        try {
            JansThinBridgeProvider jansThinBridge = (JansThinBridgeProvider)session.getProvider(JansThinBridgeProvider.class);
            String attributeName = (String)mappingModel.getConfig().get(JANS_ATTR_NAME_PROP_NAME);
            String loginUsername = userSession.getLoginUsername();
            JansUserAttributeModel userAttribute = jansThinBridge.getUserAttribute(loginUsername, attributeName);
            if (userAttribute == null) {
                log.info((Object)("Could not find jans attribute information for user " + loginUsername));
                return;
            }
            if (!userAttribute.isActive()) {
                log.info((Object)("Jans attribute " + attributeName + " is not active"));
                return;
            }
            AttributeType keycloakAttribute = userAttribute.asSamlKeycloakAttribute();
            if (keycloakAttribute == null) {
                log.info((Object)("Could not convert jans attribute " + attributeName + " into a keycloak attribute"));
                return;
            }
            attributeStatement.addAttribute(new AttributeStatementType.ASTChoiceType(keycloakAttribute));
        }
        catch (JansThinBridgeOperationException e) {
            log.error((Object)"Error mapping saml attribute from jans", (Throwable)e);
        }
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return DISPLAY_TYPE;
    }

    public String getDisplayCategory() {
        return DISPLAY_CATEGORY;
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    static {
        log = Logger.getLogger(JansSamlUserAttributeMapper.class);
        configProperties = ProviderConfigurationBuilder.create().property().name(JANS_ATTR_NAME_PROP_NAME).label(JANS_ATTR_NAME_PROP_LABEL).helpText(JANS_ATTR_NAME_PROP_HELPTEXT).type("String").defaultValue(null).required(true).add().build();
    }
}

