/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.spi.storage;

import io.jans.kc.model.JansUserModel;
import io.jans.kc.model.internal.JansPerson;
import io.jans.kc.spi.custom.JansThinBridgeOperationException;
import io.jans.kc.spi.custom.JansThinBridgeProvider;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.user.UserLookupProvider;

public class JansUserStorageProvider
implements UserStorageProvider,
UserLookupProvider {
    private static final Logger log = Logger.getLogger(JansUserStorageProvider.class);
    private final JansThinBridgeProvider jansThinBridge;
    private final ComponentModel model;
    private final KeycloakSession session;

    public JansUserStorageProvider(KeycloakSession session, ComponentModel model, JansThinBridgeProvider jansThinBridge) {
        this.session = session;
        this.model = model;
        this.jansThinBridge = jansThinBridge;
    }

    public void close() {
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        try {
            log.infov("getUserByUsername(). Username: {0}", (Object)username);
            JansPerson person = this.jansThinBridge.getJansUserByUsername(username);
            if (person != null) {
                return new JansUserModel(this.model, person);
            }
            return null;
        }
        catch (JansThinBridgeOperationException e) {
            log.errorv((Throwable)e, "Error fetching jans user with username " + username, new Object[0]);
            return null;
        }
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        try {
            log.infov("getUserByEmail(). Email : {0}", (Object)email);
            JansPerson person = this.jansThinBridge.getJansUserByEmail(email);
            if (person != null) {
                return new JansUserModel(this.model, person);
            }
            return null;
        }
        catch (JansThinBridgeOperationException e) {
            log.errorv((Throwable)e, "Error fetching jans user with email " + email, new Object[0]);
            return null;
        }
    }

    public UserModel getUserById(RealmModel realm, String id) {
        try {
            log.infov("getUserById(). Id: {0}", (Object)id);
            StorageId storageId = new StorageId(id);
            String inum = storageId.getExternalId();
            JansPerson person = this.jansThinBridge.getJansUserByInum(inum);
            if (person != null) {
                return new JansUserModel(this.model, person);
            }
            return null;
        }
        catch (JansThinBridgeOperationException e) {
            log.errorv((Throwable)e, "Error fetching jans user with id " + id, new Object[0]);
            return null;
        }
    }
}

