/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service;

import io.jans.model.DisplayNameEntry;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.base.Entry;
import io.jans.orm.search.filter.Filter;
import io.jans.service.CacheService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
@Named
public class LookupService
implements Serializable {
    private static final long serialVersionUID = -3707238475653913313L;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private CacheService cacheService;

    public DisplayNameEntry getDisplayNameEntry(String dn, String objectClass) throws Exception {
        String key = "l_" + objectClass + "_" + dn;
        DisplayNameEntry entry = (DisplayNameEntry)this.cacheService.get("LookupCache", key);
        if (entry == null) {
            DisplayNameEntry sample = new DisplayNameEntry();
            sample.setBaseDn(dn);
            sample.setCustomObjectClasses(new String[]{objectClass});
            List entries = this.persistenceEntryManager.findEntries((Object)sample, 1);
            if (entries.size() == 1) {
                entry = (DisplayNameEntry)entries.get(0);
            }
            this.cacheService.put("LookupCache", key, (Object)entry);
        }
        return entry;
    }

    public <T> T getDisplayNameEntry(String dn, Class<T> entryClass) throws Exception {
        String key = "l_" + entryClass.getSimpleName() + "_" + dn;
        Object entry = this.cacheService.get("LookupCache", key);
        if (entry == null) {
            entry = this.persistenceEntryManager.find((Object)dn, entryClass, null);
            this.cacheService.put("LookupCache", key, entry);
        }
        return (T)entry;
    }

    public DisplayNameEntry getDisplayNameEntry(String dn) throws Exception {
        return this.getDisplayNameEntry(dn, DisplayNameEntry.class);
    }

    public Object getTypedEntry(String dn, String clazz) throws Exception {
        if (StringUtils.isEmpty((CharSequence)clazz)) {
            return null;
        }
        Class<?> entryClass = Class.forName(clazz);
        String key = "l_" + entryClass.getSimpleName() + "_" + dn;
        Object entry = this.cacheService.get("LookupCache", key);
        if (entry == null) {
            entry = this.persistenceEntryManager.find(entryClass, (Object)dn);
            this.cacheService.put("LookupCache", key, entry);
        }
        return entry;
    }

    public <T> List<T> getDisplayNameEntries(String baseDn, Class<T> entryClass, List<String> dns) {
        List<String> inums = this.getInumsFromDns(dns);
        if (inums.size() == 0) {
            return null;
        }
        String key = this.getCompoundKey(entryClass, inums);
        List entries = (List)this.cacheService.get("LookupCache", key);
        if (entries == null) {
            Filter searchFilter = this.buildInumFilter(inums);
            entries = this.persistenceEntryManager.findEntries(baseDn, entryClass, searchFilter);
            this.cacheService.put("LookupCache", key, (Object)entries);
        }
        return entries;
    }

    public List<DisplayNameEntry> getDisplayNameEntries(String baseDn, List<String> dns) {
        return this.getDisplayNameEntries(baseDn, DisplayNameEntry.class, dns);
    }

    public Filter buildInumFilter(List<String> inums) {
        ArrayList<Filter> inumFilters = new ArrayList<Filter>(inums.size());
        for (String inum : inums) {
            inumFilters.add(Filter.createEqualityFilter((String)"inum", (Object)inum).multiValued(Boolean.valueOf(false)));
        }
        return Filter.createORFilter(inumFilters);
    }

    public List<String> getInumsFromDns(List<String> dns) {
        ArrayList<String> inums = new ArrayList<String>();
        if (dns == null) {
            return inums;
        }
        for (String dn : dns) {
            String inum = this.getInumFromDn(dn);
            if (inum == null) continue;
            inums.add(inum);
        }
        Collections.sort(inums);
        return inums;
    }

    private <T> String getCompoundKey(Class<T> entryClass, List<String> inums) {
        StringBuilder compoundKey = new StringBuilder();
        for (String inum : inums) {
            if (compoundKey.length() > 0) {
                compoundKey.append("_");
            } else {
                compoundKey.append("l_" + entryClass.getSimpleName() + "_");
            }
            compoundKey.append(inum);
        }
        return compoundKey.toString();
    }

    public List<DisplayNameEntry> getDisplayNameEntriesByEntries(String baseDn, List<? extends Entry> entries) throws Exception {
        if (entries == null) {
            return null;
        }
        Class objectClass = DisplayNameEntry.class;
        ArrayList<String> dns = new ArrayList<String>(entries.size());
        for (Entry entry : entries) {
            dns.add(entry.getDn());
            objectClass = objectClass.getClass();
        }
        return this.getDisplayNameEntries(baseDn, objectClass, dns);
    }

    public String getInumFromDn(String dn) {
        if (dn == null) {
            return null;
        }
        if (!dn.startsWith("inum=")) {
            return null;
        }
        int idx = dn.indexOf(",", 5);
        if (idx == -1) {
            return null;
        }
        return dn.substring(5, idx);
    }
}

