/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;

public class NodeTypeRecord
extends ClusterRecord {
    public static final int REGISTER = 1;
    public static final int REREGISTER = 2;
    public static final int UNREGISTER = 3;
    static final char IDENTIFIER = 'T';
    private static final int NTREG_REGISTER = 0;
    private static final int NTREG_REREGISTER = 0x40000000;
    private static final int NTREG_UNREGISTER = Integer.MIN_VALUE;
    private static final int NTREG_MASK = -1073741824;
    private int operation;
    private Collection collection;

    public NodeTypeRecord(Collection collection, boolean isRegister, Record record) {
        super(record);
        this.collection = collection;
        this.operation = isRegister ? 1 : 3;
    }

    public NodeTypeRecord(QNodeTypeDefinition ntDef, Record record) {
        super(record);
        this.collection = new ArrayList();
        this.collection.add(ntDef);
        this.operation = 2;
    }

    NodeTypeRecord(Record record) {
        super(record);
    }

    @Override
    protected void doRead() throws JournalException {
        int size = this.record.readInt();
        int opcode = size & 0xC0000000;
        size &= 0x3FFFFFFF;
        switch (opcode) {
            case 0: {
                this.operation = 1;
                this.collection = new HashSet();
                for (int i = 0; i < size; ++i) {
                    this.collection.add(this.record.readNodeTypeDef());
                }
                break;
            }
            case 0x40000000: {
                this.operation = 2;
                this.collection = new HashSet();
                this.collection.add(this.record.readNodeTypeDef());
                break;
            }
            case -2147483648: {
                this.operation = 3;
                this.collection = new HashSet();
                for (int i = 0; i < size; ++i) {
                    this.collection.add(this.record.readQName());
                }
                break;
            }
            default: {
                String msg = "Unknown opcode: " + opcode;
                throw new JournalException(msg);
            }
        }
    }

    @Override
    protected void doWrite() throws JournalException {
        this.record.writeChar('T');
        int size = this.collection.size();
        this.record.writeInt(size |= this.getBitMask());
        Iterator iter = this.collection.iterator();
        while (iter.hasNext()) {
            if (this.operation == 3) {
                this.record.writeQName((Name)iter.next());
                continue;
            }
            this.record.writeNodeTypeDef((QNodeTypeDefinition)iter.next());
        }
    }

    private int getBitMask() {
        switch (this.operation) {
            case 1: {
                return 0;
            }
            case 3: {
                return Integer.MIN_VALUE;
            }
            case 2: {
                return 0x40000000;
            }
        }
        return 0;
    }

    @Override
    public void process(ClusterRecordProcessor processor) {
        processor.process(this);
    }

    public int getOperation() {
        return this.operation;
    }

    public Collection getCollection() {
        return Collections.unmodifiableCollection(this.collection);
    }
}

