/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.ScoreNodeIterator;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeIteratorImpl
implements NodeIterator {
    private static final Logger log = LoggerFactory.getLogger(NodeIteratorImpl.class);
    protected final SessionContext sessionContext;
    protected final ScoreNodeIterator scoreNodes;
    private final int selectorIndex;
    protected int invalid = 0;
    private NodeImpl next;
    private boolean initialized;

    NodeIteratorImpl(SessionContext sessionContext, ScoreNodeIterator scoreNodes, int selectorIndex) {
        this.sessionContext = sessionContext;
        this.scoreNodes = scoreNodes;
        this.selectorIndex = selectorIndex;
    }

    public Node nextNode() throws NoSuchElementException {
        this.initialize();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        NodeImpl n = this.next;
        this.fetchNext();
        return n;
    }

    public Object next() throws NoSuchElementException {
        this.initialize();
        return this.nextNode();
    }

    public void skip(long skipNum) throws NoSuchElementException {
        this.initialize();
        if (skipNum > 0L) {
            this.scoreNodes.skip(skipNum - 1L);
            this.fetchNext();
        }
    }

    public long getSize() {
        long size = this.scoreNodes.getSize();
        if (size == -1L) {
            return size;
        }
        return size - (long)this.invalid;
    }

    public long getPosition() {
        this.initialize();
        long position = this.scoreNodes.getPosition() - (long)this.invalid;
        if (this.next != null) {
            --position;
        }
        return position;
    }

    public boolean hasNext() {
        this.initialize();
        return this.next != null;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    protected void fetchNext() {
        try {
            this.next = null;
            this.sessionContext.getSessionState().perform(new FetchNext());
        }
        catch (RepositoryException e) {
            log.warn("Failed to fetch next node", (Throwable)e);
        }
    }

    protected void initialize() {
        if (!this.initialized) {
            this.fetchNext();
            this.initialized = true;
        }
    }

    private class FetchNext
    implements SessionOperation<Object> {
        private FetchNext() {
        }

        @Override
        public Object perform(SessionContext context) {
            ItemManager itemMgr = context.getItemManager();
            while (NodeIteratorImpl.this.next == null && NodeIteratorImpl.this.scoreNodes.hasNext()) {
                ScoreNode[] sn = NodeIteratorImpl.this.scoreNodes.nextScoreNodes();
                try {
                    NodeIteratorImpl.this.next = (NodeImpl)itemMgr.getItem(sn[NodeIteratorImpl.this.selectorIndex].getNodeId());
                }
                catch (RepositoryException e) {
                    log.warn("Failed to retrieve query result node " + String.valueOf(sn[NodeIteratorImpl.this.selectorIndex].getNodeId()), (Throwable)e);
                    ++NodeIteratorImpl.this.invalid;
                }
            }
            return this;
        }
    }
}

