/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.XAItemStateManager;
import org.apache.jackrabbit.core.version.InternalActivityImpl;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionItemImpl;
import org.apache.jackrabbit.core.version.InternalVersionManagerBase;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.core.version.VersioningLock;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.core.virtual.VirtualNodeState;
import org.apache.jackrabbit.core.virtual.VirtualPropertyState;
import org.apache.jackrabbit.data.core.InternalXAResource;
import org.apache.jackrabbit.data.core.TransactionContext;
import org.apache.jackrabbit.data.core.TransactionException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class InternalXAVersionManager
extends InternalVersionManagerBase
implements EventStateCollectionFactory,
VirtualItemStateProvider,
InternalXAResource {
    private static final String CHANGE_LOG_ATTRIBUTE_NAME = "XAVersionManager.ChangeLog";
    private static final String ITEMS_ATTRIBUTE_NAME = "VersionItems";
    private final InternalVersionManagerImpl vMgr;
    private SessionImpl session;
    private Map<NodeId, InternalVersionItem> xaItems;
    private boolean vmgrLocked = false;
    private VersioningLock.WriteLock vmgrLock;
    private final NodeStateEx historyRoot;
    private final NodeStateEx activitiesRoot;

    public InternalXAVersionManager(InternalVersionManagerImpl vMgr, NodeTypeRegistry ntReg, SessionImpl session, ItemStateCacheFactory cacheFactory) throws RepositoryException {
        super(ntReg, vMgr.historiesId, vMgr.activitiesId, vMgr.getNodeIdFactory());
        NodeState state;
        this.vMgr = vMgr;
        this.session = session;
        this.stateMgr = XAItemStateManager.createInstance(vMgr.getSharedStateMgr(), this, CHANGE_LOG_ATTRIBUTE_NAME, cacheFactory);
        try {
            state = (NodeState)this.stateMgr.getItemState(this.historiesId);
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to retrieve history root", (Throwable)e);
        }
        this.historyRoot = new NodeStateEx(this.stateMgr, ntReg, state, NameConstants.JCR_VERSIONSTORAGE);
        try {
            state = (NodeState)this.stateMgr.getItemState(this.activitiesId);
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to retrieve activities root", (Throwable)e);
        }
        this.activitiesRoot = new NodeStateEx(this.stateMgr, ntReg, state, NameConstants.JCR_ACTIVITIES);
    }

    @Override
    public EventStateCollection createEventStateCollection() throws RepositoryException {
        return this.vMgr.getEscFactory().createEventStateCollection(this.session);
    }

    @Override
    public VirtualItemStateProvider getVirtualItemStateProvider() {
        return this;
    }

    @Override
    protected VersionHistoryInfo createVersionHistory(Session session, NodeState node, NodeId copiedFrom) throws RepositoryException {
        if (this.isInXA()) {
            NodeStateEx state = this.internalCreateVersionHistory(node, copiedFrom);
            InternalVersionHistoryImpl history = new InternalVersionHistoryImpl(this.vMgr, state);
            this.xaItems.put(state.getNodeId(), history);
            Name root = NameConstants.JCR_ROOTVERSION;
            return new VersionHistoryInfo(state.getNodeId(), state.getState().getChildNodeEntry(root, 1).getId());
        }
        return this.vMgr.createVersionHistory(session, node, copiedFrom);
    }

    @Override
    public NodeId createActivity(Session session, String title) throws RepositoryException {
        if (this.isInXA()) {
            NodeStateEx state = this.internalCreateActivity(title);
            InternalActivityImpl activity = new InternalActivityImpl(this.vMgr, state);
            this.xaItems.put(state.getNodeId(), activity);
            return state.getNodeId();
        }
        return this.vMgr.createActivity(session, title);
    }

    @Override
    public void removeActivity(Session session, NodeId nodeId) throws RepositoryException {
        if (this.isInXA()) {
            InternalActivityImpl act = (InternalActivityImpl)this.getItem(nodeId);
            this.internalRemoveActivity(act);
        }
        this.vMgr.removeActivity(session, nodeId);
    }

    @Override
    protected void internalRemoveActivity(InternalActivityImpl activity) throws VersionException, RepositoryException {
        if (activity.getVersionManager() != this) {
            activity = this.makeLocalCopy(activity);
            this.xaItems.put(activity.getId(), activity);
        }
        super.internalRemoveActivity(activity);
    }

    @Override
    public NodeId canCheckout(NodeStateEx state, NodeId activityId) throws RepositoryException {
        return this.vMgr.canCheckout(state, activityId);
    }

    @Override
    public InternalVersion checkin(Session session, NodeStateEx node, Calendar created) throws RepositoryException {
        if (this.isInXA()) {
            return this.checkin(node, created);
        }
        return this.vMgr.checkin(session, node, created);
    }

    @Override
    public void removeVersion(Session session, InternalVersionHistory history, Name versionName) throws RepositoryException {
        if (this.isInXA()) {
            this.internalRemoveVersion((InternalVersionHistoryImpl)history, versionName);
        } else {
            this.vMgr.removeVersion(session, history, versionName);
        }
    }

    @Override
    public void removeVersionHistory(Session session, InternalVersionHistory history) throws RepositoryException {
        if (this.isInXA()) {
            this.internalRemoveVersionHistory((InternalVersionHistoryImpl)history);
        } else {
            this.vMgr.removeVersionHistory(session, history);
        }
    }

    @Override
    public InternalVersion setVersionLabel(Session session, InternalVersionHistory history, Name version, Name label, boolean move) throws RepositoryException {
        if (this.isInXA()) {
            return this.setVersionLabel((InternalVersionHistoryImpl)history, version, label, move);
        }
        return this.vMgr.setVersionLabel(session, history, version, label, move);
    }

    @Override
    public void close() throws Exception {
        this.stateMgr.dispose();
    }

    @Override
    public boolean isVirtualRoot(ItemId id) {
        return false;
    }

    @Override
    public NodeId getVirtualRootId() {
        return null;
    }

    @Override
    public NodeId[] getVirtualRootIds() {
        return null;
    }

    @Override
    public VirtualPropertyState createPropertyState(VirtualNodeState parent, Name name, int type, boolean multiValued) throws RepositoryException {
        throw new IllegalStateException("Read-only");
    }

    @Override
    public VirtualNodeState createNodeState(VirtualNodeState parent, Name name, NodeId id, Name nodeTypeName) throws RepositoryException {
        throw new IllegalStateException("Read-only");
    }

    @Override
    public boolean setNodeReferences(ChangeLog references) {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            for (NodeReferences refs : references.modifiedRefs()) {
                changeLog.modified(refs);
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            return changeLog.get(id);
        }
        throw new NoSuchItemStateException("State not in change log: " + String.valueOf(id));
    }

    @Override
    public boolean hasItemState(ItemId id) {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            return changeLog.has(id);
        }
        return false;
    }

    @Override
    public NodeReferences getNodeReferences(NodeId id) throws NoSuchItemStateException, ItemStateException {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            return changeLog.getReferencesTo(id);
        }
        return null;
    }

    @Override
    public boolean hasNodeReferences(NodeId id) {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            return changeLog.getReferencesTo(id) != null;
        }
        return false;
    }

    @Override
    public void addListener(ItemStateListener listener) {
    }

    @Override
    public void removeListener(ItemStateListener listener) {
    }

    @Override
    protected NodeStateEx getHistoryRoot() {
        return this.historyRoot;
    }

    @Override
    protected NodeStateEx getActivitiesRoot() {
        return this.activitiesRoot;
    }

    @Override
    protected InternalVersionItem getItem(NodeId id) throws RepositoryException {
        InternalVersionItem item = null;
        if (this.xaItems != null) {
            item = this.xaItems.get(id);
        }
        if (item == null) {
            item = this.vMgr.getItem(id);
        }
        return item;
    }

    @Override
    protected boolean hasItem(NodeId id) {
        if (this.xaItems != null && this.xaItems.containsKey(id)) {
            return true;
        }
        return this.vMgr.hasItem(id);
    }

    @Override
    protected boolean hasItemReferences(NodeId id) throws RepositoryException {
        return this.session.getNodeById(id).getReferences().hasNext();
    }

    @Override
    protected NodeStateEx getNodeStateEx(NodeId parentNodeId) throws RepositoryException {
        try {
            NodeState state = (NodeState)this.stateMgr.getItemState(parentNodeId);
            return new NodeStateEx(this.stateMgr, this.ntReg, state, null);
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    protected InternalVersion internalCheckin(InternalVersionHistoryImpl history, NodeStateEx node, boolean simple, Calendar created) throws RepositoryException {
        InternalVersion version;
        NodeId frozenNodeId;
        InternalVersionItem frozenNode;
        if (history.getVersionManager() != this) {
            history = this.makeLocalCopy(history);
            this.xaItems.put(history.getId(), history);
        }
        if ((frozenNode = this.createInternalVersionItem(frozenNodeId = (version = super.internalCheckin(history, node, simple, created)).getFrozenNodeId())) != null) {
            this.xaItems.put(frozenNodeId, frozenNode);
        }
        return version;
    }

    @Override
    protected void internalRemoveVersion(InternalVersionHistoryImpl history, Name name) throws VersionException, RepositoryException {
        if (history.getVersionManager() != this) {
            history = this.makeLocalCopy(history);
            this.xaItems.put(history.getId(), history);
            InternalVersion v = history.getVersion(name);
            for (InternalVersion v1 : v.getSuccessors()) {
                this.xaItems.put(v1.getId(), v1);
            }
            for (InternalVersion v1 : v.getPredecessors()) {
                this.xaItems.put(v1.getId(), v1);
            }
        }
        super.internalRemoveVersion(history, name);
    }

    @Override
    protected InternalVersion setVersionLabel(InternalVersionHistoryImpl history, Name version, Name label, boolean move) throws RepositoryException {
        if (history.getVersionManager() != this) {
            history = this.makeLocalCopy(history);
            this.xaItems.put(history.getId(), history);
        }
        return super.setVersionLabel(history, version, label, move);
    }

    @Override
    protected void versionCreated(InternalVersion version) {
        this.xaItems.put(version.getId(), version);
    }

    @Override
    protected void versionDestroyed(InternalVersion version) {
        this.xaItems.remove(version.getId());
    }

    public void associate(TransactionContext tx) {
        ((XAItemStateManager)this.stateMgr).associate(tx);
        HashMap xaItems = null;
        if (tx != null && (xaItems = (HashMap)tx.getAttribute(ITEMS_ATTRIBUTE_NAME)) == null) {
            xaItems = new HashMap();
            tx.setAttribute(ITEMS_ATTRIBUTE_NAME, xaItems);
        }
        this.xaItems = xaItems;
    }

    public void beforeOperation(TransactionContext tx) {
        ((XAItemStateManager)this.stateMgr).beforeOperation(tx);
    }

    public void prepare(TransactionContext tx) throws TransactionException {
        if (this.vmgrLocked) {
            ((XAItemStateManager)this.stateMgr).prepare(tx);
        }
    }

    public void commit(TransactionContext tx) throws TransactionException {
        if (this.vmgrLocked) {
            ((XAItemStateManager)this.stateMgr).commit(tx);
            Map xaItems = (Map)tx.getAttribute(ITEMS_ATTRIBUTE_NAME);
            this.vMgr.itemsUpdated(xaItems.values());
        }
    }

    public void rollback(TransactionContext tx) {
        if (this.vmgrLocked) {
            ((XAItemStateManager)this.stateMgr).rollback(tx);
        }
    }

    public void afterOperation(TransactionContext tx) {
        ((XAItemStateManager)this.stateMgr).afterOperation(tx);
    }

    public InternalXAResource getXAResourceBegin() {
        return new InternalXAResource(){

            public void associate(TransactionContext tx) {
            }

            public void beforeOperation(TransactionContext tx) {
            }

            public void prepare(TransactionContext tx) {
                InternalXAVersionManager.this.vmgrLock = InternalXAVersionManager.this.vMgr.acquireWriteLock();
                InternalXAVersionManager.this.vmgrLocked = true;
            }

            public void commit(TransactionContext tx) {
                if (!InternalXAVersionManager.this.vmgrLocked) {
                    this.prepare(tx);
                }
            }

            public void rollback(TransactionContext tx) {
                if (!InternalXAVersionManager.this.vmgrLocked) {
                    this.prepare(tx);
                }
            }

            public void afterOperation(TransactionContext tx) {
            }
        };
    }

    public InternalXAResource getXAResourceEnd() {
        return new InternalXAResource(){

            public void associate(TransactionContext tx) {
            }

            public void beforeOperation(TransactionContext tx) {
            }

            public void prepare(TransactionContext tx) {
            }

            public void commit(TransactionContext tx) {
                this.internalReleaseWriteLock();
            }

            public void rollback(TransactionContext tx) {
                this.internalReleaseWriteLock();
            }

            public void afterOperation(TransactionContext tx) {
            }

            private void internalReleaseWriteLock() {
                if (InternalXAVersionManager.this.vmgrLocked) {
                    InternalXAVersionManager.this.vmgrLock.release();
                    InternalXAVersionManager.this.vmgrLocked = false;
                }
            }
        };
    }

    private boolean isInXA() {
        return this.xaItems != null;
    }

    private InternalVersionHistoryImpl makeLocalCopy(InternalVersionHistoryImpl history) throws RepositoryException {
        VersioningLock.ReadLock lock = this.acquireReadLock();
        try {
            NodeState state = (NodeState)this.stateMgr.getItemState(history.getId());
            NodeStateEx stateEx = new NodeStateEx(this.stateMgr, this.ntReg, state, null);
            InternalVersionHistoryImpl internalVersionHistoryImpl = new InternalVersionHistoryImpl(this, stateEx);
            return internalVersionHistoryImpl;
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to make local copy", (Throwable)e);
        }
        finally {
            lock.release();
        }
    }

    private InternalActivityImpl makeLocalCopy(InternalActivityImpl act) throws RepositoryException {
        VersioningLock.ReadLock lock = this.acquireReadLock();
        try {
            NodeState state = (NodeState)this.stateMgr.getItemState(act.getId());
            NodeStateEx stateEx = new NodeStateEx(this.stateMgr, this.ntReg, state, null);
            InternalActivityImpl internalActivityImpl = new InternalActivityImpl(this, stateEx);
            return internalActivityImpl;
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to make local copy", (Throwable)e);
        }
        finally {
            lock.release();
        }
    }

    boolean differentXAEnv(InternalVersionItemImpl item) {
        return item.getVersionManager() == this && (this.xaItems == null || !this.xaItems.containsKey(item.getId()));
    }
}

