/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.cache;

import io.jans.orm.PersistenceEntryManager;
import io.jans.service.cache.AbstractCacheProvider;
import io.jans.service.cache.CacheConfiguration;
import io.jans.service.cache.CacheProvider;
import io.jans.service.cache.CacheProviderType;
import io.jans.service.cache.InMemoryCacheProvider;
import io.jans.service.cache.MemcachedProvider;
import io.jans.service.cache.NativePersistenceCacheProvider;
import io.jans.service.cache.RedisProvider;
import io.jans.util.StringHelper;
import io.jans.util.security.StringEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneCacheProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneCacheProviderFactory.class);
    private PersistenceEntryManager entryManager;
    private StringEncrypter stringEncrypter;

    public StandaloneCacheProviderFactory(PersistenceEntryManager entryManager, StringEncrypter stringEncrypter) {
        this.entryManager = entryManager;
        this.stringEncrypter = stringEncrypter;
    }

    public CacheProvider<?> getCacheProvider(CacheConfiguration cacheConfiguration) {
        CacheProviderType cacheProviderType = cacheConfiguration.getCacheProviderType();
        if (cacheProviderType == null) {
            LOG.error("Failed to initialize cacheProvider, cacheProviderType is null. Fallback to IN_MEMORY type.");
            cacheProviderType = CacheProviderType.IN_MEMORY;
        }
        AbstractCacheProvider cacheProvider = null;
        switch (cacheProviderType) {
            case IN_MEMORY: {
                InMemoryCacheProvider inMemoryCacheProvider = new InMemoryCacheProvider();
                inMemoryCacheProvider.configure(cacheConfiguration);
                inMemoryCacheProvider.init();
                cacheProvider = inMemoryCacheProvider;
                break;
            }
            case MEMCACHED: {
                MemcachedProvider memcachedProvider = new MemcachedProvider();
                memcachedProvider.configure(cacheConfiguration);
                memcachedProvider.init();
                cacheProvider = memcachedProvider;
                break;
            }
            case REDIS: {
                if (this.stringEncrypter == null) {
                    throw new RuntimeException("Factory is not initialized properly. stringEncrypter is not specified");
                }
                RedisProvider redisProvider = new RedisProvider();
                redisProvider.configure(cacheConfiguration, this.stringEncrypter);
                redisProvider.init();
                cacheProvider = redisProvider;
                break;
            }
            case NATIVE_PERSISTENCE: {
                if (this.entryManager == null) {
                    throw new RuntimeException("Factory is not initialized properly. entryManager is not specified");
                }
                NativePersistenceCacheProvider nativePersistenceCacheProvider = new NativePersistenceCacheProvider();
                nativePersistenceCacheProvider.configure(cacheConfiguration, this.entryManager);
                if (StringHelper.isEmpty((String)cacheConfiguration.getNativePersistenceConfiguration().getBaseDn())) {
                    cacheConfiguration.getNativePersistenceConfiguration().setBaseDn("o=jans");
                }
                nativePersistenceCacheProvider.init();
                cacheProvider = nativePersistenceCacheProvider;
            }
        }
        if (cacheProvider == null) {
            throw new RuntimeException("Failed to initialize cacheProvider, cacheProviderType is unsupported: " + cacheProviderType);
        }
        cacheProvider.create();
        return cacheProvider;
    }
}

