/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.ConnectorConfig;
import com.google.cloud.sql.CredentialFactory;
import com.google.cloud.sql.core.ApplicationDefaultCredentialFactory;
import com.google.cloud.sql.core.ConstantCredentialFactory;
import com.google.cloud.sql.core.FileCredentialFactory;
import com.google.cloud.sql.core.ServiceAccountImpersonatingCredentialFactory;
import com.google.cloud.sql.core.SupplierCredentialFactory;

class CredentialFactoryProvider {
    private final CredentialFactory defaultCredentialFactory;

    CredentialFactoryProvider() {
        this.defaultCredentialFactory = CredentialFactoryProvider.createDefaultCredentialFactory();
    }

    CredentialFactoryProvider(CredentialFactory defaultCredentialFactory) {
        this.defaultCredentialFactory = defaultCredentialFactory;
    }

    CredentialFactory getDefaultCredentialFactory() {
        return this.defaultCredentialFactory;
    }

    private static CredentialFactory createDefaultCredentialFactory() {
        CredentialFactory credentialFactory;
        String userCredentialFactoryClassName = System.getProperty("cloudSql.socketFactory.credentialFactory");
        if (userCredentialFactoryClassName != null) {
            try {
                credentialFactory = Class.forName(userCredentialFactoryClassName).asSubclass(CredentialFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        } else {
            credentialFactory = new ApplicationDefaultCredentialFactory();
        }
        return credentialFactory;
    }

    CredentialFactory getInstanceCredentialFactory(ConnectorConfig config) {
        CredentialFactory instanceCredentialFactory = config.getGoogleCredentialsSupplier() != null ? new SupplierCredentialFactory(config.getGoogleCredentialsSupplier()) : (config.getGoogleCredentials() != null ? new ConstantCredentialFactory(config.getGoogleCredentials()) : (config.getGoogleCredentialsPath() != null ? new FileCredentialFactory(config.getGoogleCredentialsPath()) : this.getDefaultCredentialFactory()));
        if (config.getTargetPrincipal() == null && config.getDelegates() != null && !config.getDelegates().isEmpty()) {
            throw new IllegalArgumentException(String.format("Connection property %s must be when %s is set.", "cloudSqlTargetPrincipal", "cloudSqlDelegates"));
        }
        if (config.getTargetPrincipal() != null && !config.getTargetPrincipal().isEmpty()) {
            instanceCredentialFactory = new ServiceAccountImpersonatingCredentialFactory(instanceCredentialFactory, config.getTargetPrincipal(), config.getDelegates());
        }
        return instanceCredentialFactory;
    }
}

