/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.CloudSqlInstanceName;
import com.google.cloud.sql.core.DnsResolver;
import com.google.cloud.sql.core.InstanceConnectionNameResolver;
import java.util.Collection;
import java.util.Objects;
import javax.naming.NameNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DnsInstanceConnectionNameResolver
implements InstanceConnectionNameResolver {
    private static final Logger logger = LoggerFactory.getLogger(DnsInstanceConnectionNameResolver.class);
    private final DnsResolver dnsResolver;

    public DnsInstanceConnectionNameResolver(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
    }

    @Override
    public CloudSqlInstanceName resolve(String name) {
        if (CloudSqlInstanceName.isValidInstanceName(name)) {
            return new CloudSqlInstanceName(name);
        }
        if (CloudSqlInstanceName.isValidDomain(name)) {
            return this.resolveDomainName(name);
        }
        throw new IllegalArgumentException(String.format("Unable to resolve database instance for \"%s\". It should be a well-formed instance name or domain name.", name));
    }

    private CloudSqlInstanceName resolveDomainName(String name) {
        Collection<String> instanceNames;
        try {
            instanceNames = this.dnsResolver.resolveTxt(name);
        }
        catch (NameNotFoundException ne) {
            throw new IllegalArgumentException(String.format("Unable to resolve TXT record containing the instance name for domain name \"%s\".", name));
        }
        return instanceNames.stream().map(target -> {
            try {
                return new CloudSqlInstanceName((String)target, name);
            }
            catch (IllegalArgumentException e) {
                logger.info("Unable to parse instance name in TXT record for domain name \"{}\" with target \"{}\"", new Object[]{name, target, e});
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unable to parse values of TXT record for \"%s\".", name)));
    }
}

