/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.AccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class TextFormattedAccessLogMessage
extends TextFormattedLogMessage
implements AccessLogMessage {
    private static final long serialVersionUID = 458413508863077700L;
    @Nullable
    private final Long connectionID;
    @Nullable
    private final Long threadID;
    @Nullable
    private final String instanceName = this.getString(TextFormattedAccessLogFields.INSTANCE_NAME);
    @Nullable
    private final String productName = this.getString(TextFormattedAccessLogFields.PRODUCT_NAME);
    @Nullable
    private final String startupID = this.getString(TextFormattedAccessLogFields.STARTUP_ID);

    protected TextFormattedAccessLogMessage(@NotNull TextFormattedLogMessage logMessage) {
        super(logMessage);
        this.threadID = this.getLongNoThrow(TextFormattedAccessLogFields.THREAD_ID);
        this.connectionID = this.getLongNoThrow(TextFormattedAccessLogFields.CONNECTION_ID);
    }

    @Override
    @Nullable
    public final String getProductName() {
        return this.productName;
    }

    @Override
    @Nullable
    public final String getInstanceName() {
        return this.instanceName;
    }

    @Override
    @Nullable
    public final String getStartupID() {
        return this.startupID;
    }

    @Override
    @Nullable
    public final Long getThreadID() {
        return this.threadID;
    }

    @Override
    @Nullable
    public final Long getConnectionID() {
        return this.connectionID;
    }
}

