/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.monitors.ActiveOperationsMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.BackendMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ClientConnectionMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ConnectionHandlerMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.DiskSpaceUsageMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.EntryCacheMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.FIFOEntryCacheMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.GaugeMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.GeneralMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.GroupCacheMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.HostSystemRecentCPUAndMemoryMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.IndexMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.IndicatorGaugeMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.JEEnvironmentMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.LDAPExternalServerMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.LDAPStatisticsMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.LoadBalancingAlgorithmMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MemoryUsageMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.NumericGaugeMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.PerApplicationProcessingTimeHistogramMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ProcessingTimeHistogramMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ReplicaMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ReplicationServerMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ReplicationSummaryMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ResultCodeMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.StackTraceMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.SystemInfoMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.TraditionalWorkQueueMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.UnboundIDWorkQueueMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.VersionMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.X509CertificateMonitorEntry;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MonitorManager {
    private MonitorManager() {
    }

    @NotNull
    public static List<MonitorEntry> getMonitorEntries(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getMonitorEntries((LDAPInterface)connection);
    }

    @NotNull
    public static List<MonitorEntry> getMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<MonitorEntry> monitorEntries = new ArrayList<MonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(MonitorEntry.decode(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @Nullable
    public static GeneralMonitorEntry getGeneralMonitorEntry(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getGeneralMonitorEntry((LDAPInterface)connection);
    }

    @Nullable
    public static GeneralMonitorEntry getGeneralMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createPresenceFilter("objectClass");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.BASE, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getGeneralMonitorEntry");
            return null;
        }
        return new GeneralMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @Nullable
    public static ActiveOperationsMonitorEntry getActiveOperationsMonitorEntry(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getActiveOperationsMonitorEntry((LDAPInterface)connection);
    }

    @Nullable
    public static ActiveOperationsMonitorEntry getActiveOperationsMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-active-operations-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getActiveOperationsMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getActiveOperationsMonitorEntry");
        }
        return new ActiveOperationsMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @NotNull
    public static List<BackendMonitorEntry> getBackendMonitorEntries(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getBackendMonitorEntries((LDAPInterface)connection);
    }

    @NotNull
    public static List<BackendMonitorEntry> getBackendMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-backend-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<BackendMonitorEntry> monitorEntries = new ArrayList<BackendMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(new BackendMonitorEntry(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @Nullable
    public static ClientConnectionMonitorEntry getClientConnectionMonitorEntry(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getClientConnectionMonitorEntry((LDAPInterface)connection);
    }

    @Nullable
    public static ClientConnectionMonitorEntry getClientConnectionMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-client-connection-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getClientConnectionMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getClientConnectionMonitorEntry");
        }
        return new ClientConnectionMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @NotNull
    public static List<ConnectionHandlerMonitorEntry> getConnectionHandlerMonitorEntries(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getConnectionHandlerMonitorEntries((LDAPInterface)connection);
    }

    @NotNull
    public static List<ConnectionHandlerMonitorEntry> getConnectionHandlerMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-connectionhandler-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<ConnectionHandlerMonitorEntry> monitorEntries = new ArrayList<ConnectionHandlerMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(new ConnectionHandlerMonitorEntry(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @Nullable
    public static DiskSpaceUsageMonitorEntry getDiskSpaceUsageMonitorEntry(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getDiskSpaceUsageMonitorEntry((LDAPInterface)connection);
    }

    @Nullable
    public static DiskSpaceUsageMonitorEntry getDiskSpaceUsageMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-disk-space-usage-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getDiskSpaceUsageMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getDiskSpaceUsageMonitorEntry");
        }
        return new DiskSpaceUsageMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @Nullable
    public static EntryCacheMonitorEntry getEntryCacheMonitorEntry(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getEntryCacheMonitorEntry((LDAPInterface)connection);
    }

    @Nullable
    public static EntryCacheMonitorEntry getEntryCacheMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-entry-cache-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getEntryCacheMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getEntryCacheMonitorEntry");
        }
        return new EntryCacheMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @NotNull
    public static List<FIFOEntryCacheMonitorEntry> getFIFOEntryCacheMonitorEntries(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getFIFOEntryCacheMonitorEntries((LDAPInterface)connection);
    }

    @NotNull
    public static List<FIFOEntryCacheMonitorEntry> getFIFOEntryCacheMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-fifo-entry-cache-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<FIFOEntryCacheMonitorEntry> monitorEntries = new ArrayList<FIFOEntryCacheMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(new FIFOEntryCacheMonitorEntry(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @NotNull
    public static List<GaugeMonitorEntry> getGaugeMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-gauge-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<GaugeMonitorEntry> monitorEntries = new ArrayList<GaugeMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            try {
                monitorEntries.add((GaugeMonitorEntry)MonitorEntry.decode(e));
            }
            catch (Exception ex) {
                Debug.debugException(ex);
            }
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @Nullable
    public static GroupCacheMonitorEntry getGroupCacheMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-group-cache-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getGroupCacheMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getGroupCacheMonitorEntry");
        }
        return new GroupCacheMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @Nullable
    public static HostSystemRecentCPUAndMemoryMonitorEntry getHostSystemRecentCPUAndMemoryMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-host-system-cpu-memory-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getHostSystemRecentCPUAndMemoryMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getHostSystemRecentCPUAndMemoryMonitorEntry");
        }
        return new HostSystemRecentCPUAndMemoryMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @NotNull
    public static List<IndexMonitorEntry> getIndexMonitorEntries(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getIndexMonitorEntries((LDAPInterface)connection);
    }

    @NotNull
    public static List<IndexMonitorEntry> getIndexMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-index-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<IndexMonitorEntry> monitorEntries = new ArrayList<IndexMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(new IndexMonitorEntry(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @NotNull
    public static List<IndicatorGaugeMonitorEntry> getIndicatorGaugeMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-gauge-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<IndicatorGaugeMonitorEntry> monitorEntries = new ArrayList<IndicatorGaugeMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(new IndicatorGaugeMonitorEntry(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @NotNull
    public static List<JEEnvironmentMonitorEntry> getJEEnvironmentMonitorEntries(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getJEEnvironmentMonitorEntries((LDAPInterface)connection);
    }

    @NotNull
    public static List<JEEnvironmentMonitorEntry> getJEEnvironmentMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-je-environment-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<JEEnvironmentMonitorEntry> monitorEntries = new ArrayList<JEEnvironmentMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(new JEEnvironmentMonitorEntry(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @NotNull
    public static List<LDAPExternalServerMonitorEntry> getLDAPExternalServerMonitorEntries(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getLDAPExternalServerMonitorEntries((LDAPInterface)connection);
    }

    @NotNull
    public static List<LDAPExternalServerMonitorEntry> getLDAPExternalServerMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-ldap-external-server-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<LDAPExternalServerMonitorEntry> monitorEntries = new ArrayList<LDAPExternalServerMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(new LDAPExternalServerMonitorEntry(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @NotNull
    public static List<LDAPStatisticsMonitorEntry> getLDAPStatisticsMonitorEntries(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getLDAPStatisticsMonitorEntries((LDAPInterface)connection);
    }

    @NotNull
    public static List<LDAPStatisticsMonitorEntry> getLDAPStatisticsMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-ldap-statistics-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<LDAPStatisticsMonitorEntry> monitorEntries = new ArrayList<LDAPStatisticsMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(new LDAPStatisticsMonitorEntry(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @NotNull
    public static List<LoadBalancingAlgorithmMonitorEntry> getLoadBalancingAlgorithmMonitorEntries(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getLoadBalancingAlgorithmMonitorEntries((LDAPInterface)connection);
    }

    @NotNull
    public static List<LoadBalancingAlgorithmMonitorEntry> getLoadBalancingAlgorithmMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-load-balancing-algorithm-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<LoadBalancingAlgorithmMonitorEntry> monitorEntries = new ArrayList<LoadBalancingAlgorithmMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(new LoadBalancingAlgorithmMonitorEntry(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @Nullable
    public static MemoryUsageMonitorEntry getMemoryUsageMonitorEntry(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getMemoryUsageMonitorEntry((LDAPInterface)connection);
    }

    @Nullable
    public static MemoryUsageMonitorEntry getMemoryUsageMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-memory-usage-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getMemoryUsageMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getMemoryUsageMonitorEntry");
        }
        return new MemoryUsageMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @NotNull
    public static List<NumericGaugeMonitorEntry> getNumericGaugeMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-gauge-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<NumericGaugeMonitorEntry> monitorEntries = new ArrayList<NumericGaugeMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(new NumericGaugeMonitorEntry(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @NotNull
    public static List<PerApplicationProcessingTimeHistogramMonitorEntry> getPerApplicationProcessingTimeHistogramMonitorEntries(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getPerApplicationProcessingTimeHistogramMonitorEntries((LDAPInterface)connection);
    }

    @NotNull
    public static List<PerApplicationProcessingTimeHistogramMonitorEntry> getPerApplicationProcessingTimeHistogramMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-per-application-processing-time-histogram-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getPerApplicationProcessingTimeHistogramMonitorEntries");
            return Collections.emptyList();
        }
        ArrayList<PerApplicationProcessingTimeHistogramMonitorEntry> entries = new ArrayList<PerApplicationProcessingTimeHistogramMonitorEntry>(searchResult.getEntryCount());
        for (Entry entry : searchResult.getSearchEntries()) {
            entries.add(new PerApplicationProcessingTimeHistogramMonitorEntry(entry));
        }
        return entries;
    }

    @Nullable
    public static ProcessingTimeHistogramMonitorEntry getProcessingTimeHistogramMonitorEntry(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getProcessingTimeHistogramMonitorEntry((LDAPInterface)connection);
    }

    @Nullable
    public static ProcessingTimeHistogramMonitorEntry getProcessingTimeHistogramMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-processing-time-histogram-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getProcessingTimeHistogramMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getProcessingTimeHistogramMonitorEntry");
        }
        return new ProcessingTimeHistogramMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @NotNull
    public static List<ReplicaMonitorEntry> getReplicaMonitorEntries(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getReplicaMonitorEntries((LDAPInterface)connection);
    }

    @NotNull
    public static List<ReplicaMonitorEntry> getReplicaMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-replica-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<ReplicaMonitorEntry> monitorEntries = new ArrayList<ReplicaMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(new ReplicaMonitorEntry(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @Nullable
    public static ReplicationServerMonitorEntry getReplicationServerMonitorEntry(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getReplicationServerMonitorEntry((LDAPInterface)connection);
    }

    @Nullable
    public static ReplicationServerMonitorEntry getReplicationServerMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-replication-server-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getReplicationServerMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getReplicationServerMonitorEntry");
        }
        return new ReplicationServerMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @NotNull
    public static List<ReplicationSummaryMonitorEntry> getReplicationSummaryMonitorEntries(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getReplicationSummaryMonitorEntries((LDAPInterface)connection);
    }

    @NotNull
    public static List<ReplicationSummaryMonitorEntry> getReplicationSummaryMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-replication-server-summary-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<ReplicationSummaryMonitorEntry> monitorEntries = new ArrayList<ReplicationSummaryMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(new ReplicationSummaryMonitorEntry(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }

    @Nullable
    public static ResultCodeMonitorEntry getResultCodeMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-ldap-result-codes-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getResultCodeMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getResultCodeMonitorEntry");
        }
        return new ResultCodeMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @Nullable
    public static SystemInfoMonitorEntry getSystemInfoMonitorEntry(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getSystemInfoMonitorEntry((LDAPInterface)connection);
    }

    @Nullable
    public static SystemInfoMonitorEntry getSystemInfoMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-system-info-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getSystemInfoMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getSystemInfoMonitorEntry");
        }
        return new SystemInfoMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @Nullable
    public static StackTraceMonitorEntry getStackTraceMonitorEntry(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getStackTraceMonitorEntry((LDAPInterface)connection);
    }

    @Nullable
    public static StackTraceMonitorEntry getStackTraceMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-stack-trace-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getStackTraceMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getStackTraceMonitorEntry");
        }
        return new StackTraceMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @Nullable
    public static TraditionalWorkQueueMonitorEntry getTraditionalWorkQueueMonitorEntry(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getTraditionalWorkQueueMonitorEntry((LDAPInterface)connection);
    }

    @Nullable
    public static TraditionalWorkQueueMonitorEntry getTraditionalWorkQueueMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-traditional-work-queue-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getTraditionalWorkQueueMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getTraditionalWorkQueueMonitorEntry");
        }
        return new TraditionalWorkQueueMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @Nullable
    public static UnboundIDWorkQueueMonitorEntry getUnboundIDWorkQueueMonitorEntry(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getUnboundIDWorkQueueMonitorEntry((LDAPInterface)connection);
    }

    @Nullable
    public static UnboundIDWorkQueueMonitorEntry getUnboundIDWorkQueueMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-unboundid-work-queue-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getUnboundIDWorkQueueMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getUnboundIDWorkQueueMonitorEntry");
        }
        return new UnboundIDWorkQueueMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @Nullable
    public static VersionMonitorEntry getVersionMonitorEntry(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getVersionMonitorEntry((LDAPInterface)connection);
    }

    @Nullable
    public static VersionMonitorEntry getVersionMonitorEntry(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-version-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        int numEntries = searchResult.getEntryCount();
        if (numEntries == 0) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "No entries returned in getVersionMonitorEntry");
            return null;
        }
        if (numEntries != 1) {
            Debug.debug(Level.FINE, DebugType.MONITOR, "Multiple entries returned in getVersionMonitorEntry");
        }
        return new VersionMonitorEntry(searchResult.getSearchEntries().get(0));
    }

    @NotNull
    public static List<X509CertificateMonitorEntry> getX509CertificateMonitorEntries(@NotNull LDAPConnection connection) throws LDAPSearchException {
        return MonitorManager.getX509CertificateMonitorEntries((LDAPInterface)connection);
    }

    @NotNull
    public static List<X509CertificateMonitorEntry> getX509CertificateMonitorEntries(@NotNull LDAPInterface connection) throws LDAPSearchException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-x509-certificate-monitor-entry");
        SearchResult searchResult = connection.search("cn=monitor", SearchScope.SUB, filter, new String[0]);
        ArrayList<X509CertificateMonitorEntry> monitorEntries = new ArrayList<X509CertificateMonitorEntry>(searchResult.getEntryCount());
        for (SearchResultEntry e : searchResult.getSearchEntries()) {
            monitorEntries.add(new X509CertificateMonitorEntry(e));
        }
        return Collections.unmodifiableList(monitorEntries);
    }
}

