/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.model;

import io.jans.kc.model.internal.JansPerson;
import io.jans.model.GluuStatus;
import io.jans.model.JansAttribute;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;

public class JansUserAttributeModel {
    private final JansAttribute jansAttribute;
    private final JansPerson jansPerson;

    public JansUserAttributeModel(JansAttribute jansAttribute, JansPerson jansPerson) {
        this.jansAttribute = jansAttribute;
        this.jansPerson = jansPerson;
    }

    public boolean isActive() {
        return this.jansAttribute.getStatus() == GluuStatus.ACTIVE;
    }

    public AttributeType asSamlKeycloakAttribute() {
        List<String> values = this.jansPerson.customAttributeValues(this.jansAttribute.getName());
        if (values == null) {
            return null;
        }
        String samlAttributeName = this.jansAttribute.getSaml2Uri();
        String samlAttributeNameFormat = JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get();
        if (StringUtils.isEmpty((CharSequence)samlAttributeName)) {
            samlAttributeName = this.jansAttribute.getName();
            samlAttributeNameFormat = JBossSAMLURIConstants.ATTRIBUTE_FORMAT_BASIC.get();
        }
        AttributeType ret = new AttributeType(samlAttributeName);
        ret.setNameFormat(samlAttributeNameFormat);
        if (!StringUtils.isEmpty((CharSequence)this.jansAttribute.getDisplayName())) {
            ret.setFriendlyName(this.jansAttribute.getDisplayName());
        } else {
            ret.setFriendlyName(this.jansAttribute.getName());
        }
        values.forEach(arg_0 -> ((AttributeType)ret).addAttributeValue(arg_0));
        return ret;
    }
}

