/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.oidc.impl;

import io.jans.kc.oidc.OIDCMetaCache;
import java.util.HashMap;
import java.util.Map;

public class HashBasedOIDCMetaCache
implements OIDCMetaCache {
    private static final long DEFAULT_CACHE_TTL = 1200L;
    private long cacheEntryTtl;
    private Map<String, Map<String, CacheEntry>> cacheEntries;

    public HashBasedOIDCMetaCache() {
        this(1200L);
    }

    public HashBasedOIDCMetaCache(long cacheEntryTtl) {
        this.cacheEntryTtl = cacheEntryTtl;
        if (this.cacheEntryTtl == 0L) {
            this.cacheEntryTtl = 1200L;
        }
        this.cacheEntryTtl *= 1000L;
        this.cacheEntries = new HashMap<String, Map<String, CacheEntry>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String issuer, String key, Object value) {
        Map<String, Map<String, CacheEntry>> map = this.cacheEntries;
        synchronized (map) {
            this.createIfNotExistIssuerCacheEntry(issuer);
            this.addIssuerCacheEntry(issuer, key, value);
            this.performHouseCleaning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String issuer, String key) {
        Map<String, Map<String, CacheEntry>> map = this.cacheEntries;
        synchronized (map) {
            if (this.issuerCacheEntryIsMissing(issuer)) {
                this.performHouseCleaning();
                return null;
            }
            Object ret = this.getIssuerCacheEntryValue(issuer, key);
            this.performHouseCleaning();
            return ret;
        }
    }

    private boolean issuerCacheEntryIsMissing(String issuer) {
        return this.cacheEntries.get(issuer) == null;
    }

    private Object getIssuerCacheEntryValue(String issuer, String key) {
        Map<String, CacheEntry> issuerCache = this.cacheEntries.get(issuer);
        return issuerCache.get(key).getValue();
    }

    private void createIfNotExistIssuerCacheEntry(String issuer) {
        this.cacheEntries.computeIfAbsent(issuer, k -> new HashMap());
    }

    private void addIssuerCacheEntry(String issuer, String key, Object value) {
        Map<String, CacheEntry> issuerCache = this.cacheEntries.get(issuer);
        if (issuerCache == null) {
            return;
        }
        for (Map.Entry<String, CacheEntry> entry : issuerCache.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(key)) continue;
            entry.getValue().updateValue(value);
            return;
        }
        issuerCache.put(key, new CacheEntry(this.cacheEntryTtl, value));
    }

    private void performHouseCleaning() {
        for (Map.Entry<String, Map<String, CacheEntry>> cacheEntry : this.cacheEntries.entrySet()) {
            Map<String, CacheEntry> issuerCache = this.cacheEntries.get(cacheEntry.getKey());
            for (Map.Entry<String, CacheEntry> issuerEntry : issuerCache.entrySet()) {
                if (!issuerEntry.getValue().isExpired()) continue;
                issuerCache.remove(issuerEntry.getKey());
            }
        }
    }

    private class CacheEntry {
        private long updateTime = System.currentTimeMillis();
        private long ttl;
        private Object value;

        public CacheEntry(long ttl, Object value) {
            this.ttl = ttl;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.updateTime > this.ttl * 1000L;
        }

        public void updateValue(Object value) {
            this.value = value;
            this.updateTime = System.currentTimeMillis();
        }

        public void refresh() {
            this.updateTime = System.currentTimeMillis();
        }
    }
}

