/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.spi.custom.impl;

import io.jans.kc.model.JansUserAttributeModel;
import io.jans.kc.model.internal.JansPerson;
import io.jans.kc.spi.custom.JansThinBridgeOperationException;
import io.jans.kc.spi.custom.JansThinBridgeProvider;
import io.jans.model.JansAttribute;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import java.util.List;
import org.jboss.logging.Logger;

public class DefaultJansThinBridgeProvider
implements JansThinBridgeProvider {
    private static final String JANS_ATTRIBUTES_ROOT_DN = "ou=attributes,o=jans";
    private static final String JANS_PEOPLE_ROOT_DN = "ou=people,o=jans";
    private static final String UID_ATTR_NAME = "uid";
    private static final String MAIL_ATTR_NAME = "mail";
    private static final String INUM_ATTR_NAME = "inum";
    private static final Logger log = Logger.getLogger(DefaultJansThinBridgeProvider.class);
    private static final String[] defaultUserReturnAttributes = new String[]{"uid", "mail", "displayName", "givenName", "inum", "sn", "cn", "jansCreationTimestamp", "jansLastLogonTime", "updatedAt", "jansStatus"};
    private final PersistenceEntryManager persistenceEntryManager;

    public DefaultJansThinBridgeProvider(PersistenceEntryManager persistenceEntryManager) {
        this.persistenceEntryManager = persistenceEntryManager;
    }

    public void close() {
    }

    @Override
    public JansUserAttributeModel getUserAttribute(String kcLoginUsername, String attributeName) {
        try {
            String[] jansAttrReturnAttributes = new String[]{"displayName", "jansAttrTyp", "jansClaimName", "jansSAML1URI", "jansSAML2URI", "jansStatus", "jansAttrName"};
            JansAttribute jansAttr = this.findAttributeByName(attributeName, jansAttrReturnAttributes);
            if (jansAttr == null) {
                return null;
            }
            String[] jansPersonReturnAttributes = new String[]{attributeName};
            JansPerson jansPerson = this.findPersonByKcLoginUsername(kcLoginUsername, jansPersonReturnAttributes);
            if (jansPerson == null) {
                return null;
            }
            return new JansUserAttributeModel(jansAttr, jansPerson);
        }
        catch (Exception e) {
            throw new JansThinBridgeOperationException("Could not get attributes for user " + kcLoginUsername, e);
        }
    }

    @Override
    public JansPerson getJansUserByUsername(String username) {
        try {
            Filter uidSearchFilter = Filter.createEqualityFilter((String)UID_ATTR_NAME, (Object)username);
            JansPerson person = this.findPerson(uidSearchFilter, defaultUserReturnAttributes);
            if (person == null) {
                log.debugv("User with uid {0} not found in janssen", (Object)username);
                return null;
            }
            log.debugv("User with uid {0} was found in janssen", (Object)username);
            return person;
        }
        catch (Exception e) {
            throw new JansThinBridgeOperationException("Error fetching jans user with username " + username, e);
        }
    }

    @Override
    public JansPerson getJansUserByEmail(String email) {
        try {
            Filter mailSearchFilter = Filter.createEqualityFilter((String)MAIL_ATTR_NAME, (Object)email);
            JansPerson person = this.findPerson(mailSearchFilter, defaultUserReturnAttributes);
            if (person == null) {
                log.debugv("User with email {0} not found in janssen", (Object)email);
                return null;
            }
            log.debugv("User with email {0} was found in janssen", (Object)email);
            return person;
        }
        catch (Exception e) {
            throw new JansThinBridgeOperationException("Error fetching jans user with email " + email, e);
        }
    }

    @Override
    public JansPerson getJansUserByInum(String inum) {
        try {
            Filter inumSearchFilter = Filter.createEqualityFilter((String)INUM_ATTR_NAME, (Object)inum);
            JansPerson person = this.findPerson(inumSearchFilter, defaultUserReturnAttributes);
            if (person == null) {
                log.debugv("User with inum not found in janssen", (Object)inum);
                return null;
            }
            log.debugv("User with inum {0} found in janssen", (Object)inum);
            return person;
        }
        catch (Exception e) {
            throw new JansThinBridgeOperationException("Error fetching jans user with inum " + inum, e);
        }
    }

    private JansAttribute findAttributeByName(String attributeName, String[] returnAttributes) {
        Filter searchFilter = Filter.createEqualityFilter((String)"jansAttrName", (Object)attributeName);
        List searchresult = this.persistenceEntryManager.findEntries(JANS_ATTRIBUTES_ROOT_DN, JansAttribute.class, searchFilter, returnAttributes);
        return searchresult.isEmpty() ? null : (JansAttribute)searchresult.get(0);
    }

    private JansPerson findPersonByKcLoginUsername(String kcLoginUsername, String[] returnAttributes) {
        Filter uidSearchFilter = Filter.createEqualityFilter((String)UID_ATTR_NAME, (Object)kcLoginUsername);
        Filter mailSearchFilter = Filter.createEqualityFilter((String)MAIL_ATTR_NAME, (Object)kcLoginUsername);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{uidSearchFilter, mailSearchFilter});
        return this.findPerson(searchFilter, returnAttributes);
    }

    private JansPerson findPerson(Filter searchFilter, String[] returnAttributes) {
        List searchresult = this.persistenceEntryManager.findEntries(JANS_PEOPLE_ROOT_DN, JansPerson.class, searchFilter, returnAttributes);
        return searchresult.isEmpty() ? null : (JansPerson)searchresult.get(0);
    }
}

