/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.sql.CredentialFactory;
import java.io.IOException;
import java.util.Arrays;

class ApplicationDefaultCredentialFactory
implements CredentialFactory {
    ApplicationDefaultCredentialFactory() {
    }

    @Override
    public HttpRequestInitializer create() {
        GoogleCredentials credentials = this.getCredentials();
        return new HttpCredentialsAdapter((Credentials)credentials);
    }

    @Override
    public GoogleCredentials getCredentials() {
        GoogleCredentials credentials;
        try {
            credentials = GoogleCredentials.getApplicationDefault();
        }
        catch (IOException err) {
            throw new RuntimeException("Unable to obtain credentials to communicate with the Cloud SQL API", err);
        }
        if (credentials.createScopedRequired()) {
            credentials = credentials.createScoped(Arrays.asList("https://www.googleapis.com/auth/sqlservice.admin", "https://www.googleapis.com/auth/cloud-platform"));
        }
        return credentials;
    }
}

