/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class ConnectionMetadata {
    private final String preferredIpAddress;
    private final KeyManagerFactory keyManagerFactory;
    private final TrustManagerFactory trustManagerFactory;
    private final SSLContext sslContext;
    private final List<String> mdxProtocolSupport;

    public ConnectionMetadata(String preferredIpAddress, KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory, SSLContext sslContext, List<String> mdxProtocolSupport) {
        this.preferredIpAddress = preferredIpAddress;
        this.keyManagerFactory = keyManagerFactory;
        this.trustManagerFactory = trustManagerFactory;
        this.sslContext = sslContext;
        this.mdxProtocolSupport = mdxProtocolSupport;
    }

    public String getPreferredIpAddress() {
        return this.preferredIpAddress;
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public List<String> getMdxProtocolSupport() {
        return this.mdxProtocolSupport;
    }

    public boolean isMdxClientProtocolTypeSupport() {
        return this.mdxProtocolSupport != null && this.mdxProtocolSupport.contains("CLIENT_PROTOCOL_TYPE");
    }
}

