/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;

class ConscryptWorkaroundDelegatingTrustManger
extends X509ExtendedTrustManager {
    private static final boolean CONSCRYPT_TLS;
    private final X509ExtendedTrustManager tm;

    static boolean isWorkaroundNeeded() {
        return CONSCRYPT_TLS;
    }

    ConscryptWorkaroundDelegatingTrustManger(X509ExtendedTrustManager tm) {
        this.tm = tm;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.tm.checkClientTrusted(chain, this.fixAuthType(authType), socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.tm.checkClientTrusted(chain, this.fixAuthType(authType), engine);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkClientTrusted(chain, this.fixAuthType(authType));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.tm.checkServerTrusted(chain, this.fixAuthType(authType), socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.tm.checkServerTrusted(chain, this.fixAuthType(authType), engine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkServerTrusted(chain, this.fixAuthType(authType));
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }

    private String fixAuthType(String authType) {
        if ("GENERIC".equals(authType)) {
            return "UNKNOWN";
        }
        return authType;
    }

    static {
        Provider p = Security.getProvider("Conscrypt");
        if (p != null) {
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                Provider prov = ctx.getProvider();
                CONSCRYPT_TLS = "Conscrypt".equals(prov.getName());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Unable to load algorithm TLS", e);
            }
        } else {
            CONSCRYPT_TLS = false;
        }
    }
}

