/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.CredentialFactory;
import com.google.cloud.sql.core.AccessTokenSupplier;
import com.google.cloud.sql.core.CloudSqlInstanceName;
import com.google.cloud.sql.core.ConnectionConfig;
import com.google.cloud.sql.core.ConnectionInfoCache;
import com.google.cloud.sql.core.ConnectionInfoRepository;
import com.google.cloud.sql.core.ConnectionMetadata;
import com.google.cloud.sql.core.DefaultAccessTokenSupplier;
import com.google.cloud.sql.core.LazyRefreshStrategy;
import com.google.cloud.sql.core.RefreshCalculator;
import java.security.KeyPair;

class LazyRefreshConnectionInfoCache
implements ConnectionInfoCache {
    private final ConnectionConfig config;
    private final CloudSqlInstanceName instanceName;
    private final LazyRefreshStrategy refreshStrategy;

    public LazyRefreshConnectionInfoCache(ConnectionConfig config, ConnectionInfoRepository connectionInfoRepository, CredentialFactory tokenSourceFactory, KeyPair keyPair) {
        CloudSqlInstanceName instanceName = new CloudSqlInstanceName(config.getCloudSqlInstance(), config.getDomainName());
        this.config = config;
        this.instanceName = instanceName;
        AccessTokenSupplier accessTokenSupplier = DefaultAccessTokenSupplier.newInstance(config.getAuthType(), tokenSourceFactory);
        this.refreshStrategy = new LazyRefreshStrategy(config.getCloudSqlInstance(), () -> connectionInfoRepository.getConnectionInfoSync(instanceName, accessTokenSupplier, config.getAuthType(), keyPair), RefreshCalculator.DEFAULT_REFRESH_BUFFER);
    }

    @Override
    public ConnectionMetadata getConnectionMetadata(long timeoutMs) {
        return this.refreshStrategy.getConnectionInfo(timeoutMs).toConnectionMetadata(this.config, this.instanceName);
    }

    @Override
    public void forceRefresh() {
        this.refreshStrategy.forceRefresh();
    }

    @Override
    public void refreshIfExpired() {
        this.refreshStrategy.refreshIfExpired();
    }

    @Override
    public void close() {
        this.refreshStrategy.close();
    }

    @Override
    public boolean isClosed() {
        return this.refreshStrategy.isClosed();
    }

    @Override
    public ConnectionConfig getConfig() {
        return this.config;
    }
}

