/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.CloudSqlInstanceName;
import com.google.cloud.sql.core.ConnectionConfig;
import com.google.cloud.sql.core.ConnectionInfoCache;
import com.google.cloud.sql.core.ConnectionMetadata;
import com.google.cloud.sql.core.Connector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.function.Function;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MonitoredCache
implements ConnectionInfoCache {
    private static final Logger logger = LoggerFactory.getLogger(Connector.class);
    private final ConnectionInfoCache cache;
    private final Set<Socket> sockets = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final Function<ConnectionConfig, CloudSqlInstanceName> resolve;
    private final TimerTask task;

    MonitoredCache(ConnectionInfoCache cache, Timer instanceNameResolverTimer, Function<ConnectionConfig, CloudSqlInstanceName> resolve) {
        this.cache = cache;
        this.resolve = resolve;
        if (!Strings.isNullOrEmpty((String)cache.getConfig().getDomainName())) {
            long failoverPeriod = cache.getConfig().getConnectorConfig().getFailoverPeriod().toMillis();
            this.task = new TimerTask(){

                @Override
                public void run() {
                    MonitoredCache.this.checkDomainName();
                }
            };
            instanceNameResolverTimer.schedule(this.task, failoverPeriod, failoverPeriod);
        } else {
            this.task = null;
        }
    }

    @VisibleForTesting
    int getOpenSocketCount() {
        return this.sockets.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDomainName() {
        try {
            CloudSqlInstanceName resolved = this.resolve.apply(this.cache.getConfig());
            if (!resolved.getConnectionName().equals(this.cache.getConfig().getCloudSqlInstance())) {
                logger.info("Cloud SQL Instance associated with domain name {} changed from {} to {}.", new Object[]{this.cache.getConfig().getDomainName(), this.cache.getConfig().getCloudSqlInstance(), resolved.getConnectionName()});
                this.close();
                return;
            }
        }
        catch (RuntimeException e) {
            logger.debug("Cloud SQL Instance associated with domain name {} did not resolve {}.", new Object[]{this.cache.getConfig().getDomainName(), this.cache.getConfig().getCloudSqlInstance(), e});
        }
        Set<Socket> set = this.sockets;
        synchronized (set) {
            Iterator<Socket> it = this.sockets.iterator();
            while (it.hasNext()) {
                Socket socket = it.next();
                if (!socket.isClosed()) continue;
                it.remove();
            }
        }
    }

    @Override
    public ConnectionMetadata getConnectionMetadata(long timeoutMs) {
        return this.cache.getConnectionMetadata(timeoutMs);
    }

    @Override
    public void forceRefresh() {
        this.cache.forceRefresh();
    }

    @Override
    public void refreshIfExpired() {
        this.cache.refreshIfExpired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.cache.isClosed()) {
            return;
        }
        this.cache.close();
        if (this.task != null) {
            this.task.cancel();
        }
        Set<Socket> set = this.sockets;
        synchronized (set) {
            for (Socket socket : this.sockets) {
                if (socket.isClosed()) continue;
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.debug("Exception closing socket after cache closed", (Throwable)e);
                }
            }
        }
    }

    @Override
    public ConnectionConfig getConfig() {
        return this.cache.getConfig();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.cache.isClosed();
    }

    synchronized void addSocket(SSLSocket socket) {
        if (!Strings.isNullOrEmpty((String)this.cache.getConfig().getDomainName())) {
            this.sockets.add(socket);
        }
    }
}

