/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.MdxSocket;
import com.google.cloud.sql.core.mdx.MetadataExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.net.ssl.SSLSocket;

class ProtocolHandler {
    private static final byte[] SIGNATURE = "CSQLMDEX".getBytes(StandardCharsets.UTF_8);
    private final String userAgent;

    ProtocolHandler(String userAgent) {
        this.userAgent = userAgent;
    }

    MdxSocket connect(SSLSocket socket, String mdxProtocolType) throws IOException {
        return new MdxSocket(this, socket, ProtocolHandler.convertClientProtocolType(mdxProtocolType));
    }

    void sendMdx(OutputStream out, MetadataExchange.MetadataExchangeRequest.ClientProtocolType mdxClientProtocolType) throws IOException {
        MetadataExchange.MetadataExchangeRequest req = MetadataExchange.MetadataExchangeRequest.newBuilder().setClientProtocolType(mdxClientProtocolType).setUserAgent(this.userAgent).build();
        int size = req.getSerializedSize();
        out.write(SIGNATURE);
        out.write(size >>> 24 & 0xFF);
        out.write(size >>> 16 & 0xFF);
        out.write(size >>> 8 & 0xFF);
        out.write(size & 0xFF);
        req.writeTo(out);
        out.flush();
    }

    private static MetadataExchange.MetadataExchangeRequest.ClientProtocolType convertClientProtocolType(String mdxClientProtocolType) {
        MetadataExchange.MetadataExchangeRequest.ClientProtocolType clientProtocolType;
        switch (mdxClientProtocolType) {
            case "tcp": {
                clientProtocolType = MetadataExchange.MetadataExchangeRequest.ClientProtocolType.TCP;
                break;
            }
            case "tls": {
                clientProtocolType = MetadataExchange.MetadataExchangeRequest.ClientProtocolType.TLS;
                break;
            }
            case "uds": {
                clientProtocolType = MetadataExchange.MetadataExchangeRequest.ClientProtocolType.UDS;
                break;
            }
            default: {
                clientProtocolType = MetadataExchange.MetadataExchangeRequest.ClientProtocolType.CLIENT_PROTOCOL_TYPE_UNSPECIFIED;
            }
        }
        return clientProtocolType;
    }

    MetadataExchange.MetadataExchangeResponse readMdxResponse(InputStream in) throws IOException {
        int newBytes;
        in.mark(8);
        byte[] headerBytes = new byte[8];
        int bytesRead = in.read(headerBytes);
        if (bytesRead < 8 || !Arrays.equals(headerBytes, SIGNATURE)) {
            in.reset();
            return null;
        }
        int sizeL = in.read() << 24 | in.read() << 16 | in.read() << 8 | in.read();
        byte[] responseBytes = new byte[sizeL];
        for (int protoBytesRead = 0; protoBytesRead < sizeL; protoBytesRead += newBytes) {
            newBytes = in.read(responseBytes, protoBytesRead, sizeL - protoBytesRead);
            if (newBytes != -1) continue;
            throw new IOException("Failed to read MDX response: stream ended before all " + sizeL + " bytes were read. Only received " + protoBytesRead + " bytes.");
        }
        return MetadataExchange.MetadataExchangeResponse.parseFrom(responseBytes);
    }
}

