/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;

class RetryingCallable<T>
implements Callable<T> {
    private static final int RETRY_COUNT = 5;
    private final Callable<T> callable;

    public RetryingCallable(Callable<T> callable) {
        if (callable == null) {
            throw new IllegalArgumentException("call must not be null");
        }
        this.callable = callable;
    }

    @Override
    public T call() throws Exception {
        for (int attempt = 0; attempt < 5; ++attempt) {
            try {
                return this.callable.call();
            }
            catch (Exception e) {
                if (attempt == 4 || this.isFatalException(e)) {
                    throw e;
                }
                long sleep = this.exponentialBackoffMs(attempt);
                try {
                    Thread.sleep(sleep);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw e;
                }
            }
        }
        throw new RuntimeException("call was never called.");
    }

    protected boolean isFatalException(Exception e) {
        return false;
    }

    private long exponentialBackoffMs(int attempt) {
        long baseMs = 200L;
        double multi = 1.618;
        double exp = (double)attempt + 1.0 + ThreadLocalRandom.current().nextDouble();
        return (long)((double)baseMs * Math.pow(multi, exp));
    }
}

