/*
 * Decompiled with CFR 0.152.
 */
package io.jans.model.token;

import io.jans.model.token.TokenAttributes;
import io.jans.model.token.TokenType;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DN;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.Expiration;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.ObjectClass;
import java.io.Serializable;
import java.util.Date;

@DataEntry
@ObjectClass(value="jansToken")
public class TokenEntity
implements Serializable {
    private static final long serialVersionUID = 8230052124866144708L;
    @DN
    private String dn;
    @AttributeName(name="grtId", consistency=true)
    private String grantId;
    @AttributeName(name="usrId")
    private String userId;
    @AttributeName(name="jansUsrDN")
    private String userDn;
    @AttributeName(name="clnId")
    private String clientId;
    @AttributeName(name="iat")
    private Date creationDate;
    @AttributeName(name="exp")
    private Date expirationDate;
    @AttributeName(name="del")
    private boolean deletable = true;
    @AttributeName(name="authnTime")
    private Date authenticationTime;
    @AttributeName(name="scp")
    private String scope;
    @AttributeName(name="tknCde", consistency=true)
    private String tokenCode;
    @AttributeName(name="tknTyp")
    private String tokenType;
    @AttributeName(name="grtTyp")
    private String grantType;
    @AttributeName(name="jwtReq")
    private String jwtRequest;
    @AttributeName(name="authzCode", consistency=true)
    private String authorizationCode;
    @AttributeName(name="jti", consistency=true)
    private String jti;
    @AttributeName(name="nnc")
    private String nonce;
    @AttributeName(name="chlng")
    private String codeChallenge;
    @AttributeName(name="chlngMth")
    private String codeChallengeMethod;
    @AttributeName(name="clms")
    private String claims;
    @AttributeName(name="tknBndCnf")
    private String tokenBindingHash;
    @AttributeName(name="jansId")
    private String referenceId;
    @AttributeName(name="acr")
    private String authMode;
    @AttributeName(name="ssnId", consistency=true)
    private String sessionDn;
    @Expiration
    private Integer ttl;
    @AttributeName(name="attr")
    @JsonObject
    private TokenAttributes attributes;
    @AttributeName(name="dpop")
    private String dpop;

    public String getJti() {
        return this.jti;
    }

    public TokenEntity setJti(String jti) {
        this.jti = jti;
        return this;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public TokenAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new TokenAttributes();
        }
        return this.attributes;
    }

    public final void setAttributes(TokenAttributes attributes) {
        this.attributes = attributes;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public String getTokenBindingHash() {
        return this.tokenBindingHash;
    }

    public void setTokenBindingHash(String tokenBindingHash) {
        this.tokenBindingHash = tokenBindingHash;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getGrantId() {
        return this.grantId;
    }

    public void setGrantId(String grantId) {
        this.grantId = grantId;
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getTokenCode() {
        return this.tokenCode;
    }

    public void setTokenCode(String tokenCode) {
        this.tokenCode = tokenCode;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public TokenType getTokenTypeEnum() {
        return TokenType.fromValue(this.tokenType);
    }

    public boolean isAccessToken() {
        TokenType tokenTypeEnum = this.getTokenTypeEnum();
        return tokenTypeEnum == TokenType.ACCESS_TOKEN || tokenTypeEnum == TokenType.LONG_LIVED_ACCESS_TOKEN;
    }

    public boolean isLogoutStatusJwt() {
        TokenType tokenTypeEnum = this.getTokenTypeEnum();
        return tokenTypeEnum == TokenType.LOGOUT_STATUS_JWT;
    }

    public void setTokenTypeEnum(TokenType tokenType) {
        if (tokenType != null) {
            this.tokenType = tokenType.getValue();
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String userDn) {
        this.userDn = userDn;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getJwtRequest() {
        return this.jwtRequest;
    }

    public void setJwtRequest(String jwtRequest) {
        this.jwtRequest = jwtRequest;
    }

    public String getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(String authMode) {
        this.authMode = authMode;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getClaims() {
        return this.claims;
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    public String getSessionDn() {
        return this.sessionDn;
    }

    public void setSessionDn(String sessionDn) {
        this.sessionDn = sessionDn;
    }

    public String getDpop() {
        return this.dpop;
    }

    public void setDpop(String dpop) {
        this.dpop = dpop;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenEntity tokenEntity = (TokenEntity)o;
        if (this.tokenCode != null ? !this.tokenCode.equals(tokenEntity.tokenCode) : tokenEntity.tokenCode != null) {
            return false;
        }
        return this.tokenType != null ? this.tokenType.equals(tokenEntity.tokenType) : tokenEntity.tokenType == null;
    }

    public int hashCode() {
        int result = this.tokenCode != null ? this.tokenCode.hashCode() : 0;
        result = 31 * result + (this.tokenType != null ? this.tokenType.hashCode() : 0);
        return result;
    }
}

