/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.Serializable;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class JsonService
implements Serializable {
    private static final long serialVersionUID = -1595376054267897007L;
    @Inject
    private Logger log;
    private ObjectMapper mapper;

    @PostConstruct
    public void init() {
        this.mapper = new ObjectMapper();
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public <T> T jsonToObject(String json, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        return (T)this.mapper.readValue(json, clazz);
    }

    public <T> T jsonToObject(String json, JavaType valueType) throws JsonParseException, JsonMappingException, IOException {
        return (T)this.mapper.readValue(json, valueType);
    }

    public <T> String objectToJson(T obj) throws JsonGenerationException, JsonMappingException, IOException {
        return this.mapper.writeValueAsString(obj);
    }

    public <T> String objectToPrettyJson(T obj) throws JsonGenerationException, JsonMappingException, IOException {
        return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    public TypeFactory getTypeFactory() {
        return this.mapper.getTypeFactory();
    }
}

