/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.net;

import io.jans.net.InetAddressUtility;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;

@ApplicationScoped
public class NetworkService
implements Serializable {
    private static final long serialVersionUID = -1393318600428448743L;
    @Inject
    private Logger log;

    public String getRemoteIp() {
        String remoteIp = "";
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                return remoteIp;
            }
            HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
            remoteIp = request.getHeader("X-FORWARDED-FOR");
            if (StringHelper.isEmpty((String)remoteIp)) {
                remoteIp = request.getRemoteAddr();
            }
            return remoteIp;
        }
        catch (Exception ex) {
            this.log.error("Failed to get remote IP", (Throwable)ex);
            return remoteIp;
        }
    }

    public String getHost(String serverUri) {
        try {
            URI uri = new URI(serverUri);
            return uri.getHost();
        }
        catch (URISyntaxException ex) {
            this.log.error("Failed to get remote IP", (Throwable)ex);
            return serverUri;
        }
    }

    public String getMacAdress() {
        return InetAddressUtility.getMACAddressOrNull();
    }
}

