/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.NullExpression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.PredicateOperation;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanOperation;
import com.querydsl.core.types.dsl.Expressions;
import io.jans.orm.annotation.AttributeEnum;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.ldap.impl.LdapFilterConverter;
import io.jans.orm.model.AttributeType;
import io.jans.orm.reflect.property.PropertyAnnotation;
import io.jans.orm.reflect.util.ReflectHelper;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.search.filter.FilterType;
import io.jans.orm.sql.impl.SqlOps;
import io.jans.orm.sql.model.ConvertedExpression;
import io.jans.orm.sql.model.TableMapping;
import io.jans.orm.sql.operation.SqlOperationService;
import io.jans.orm.sql.operation.SupportedDbType;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.StringHelper;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFilterConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SqlFilterConverter.class);
    private static final LdapFilterConverter ldapFilterConverter = new LdapFilterConverter();
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private SqlOperationService operationService;
    private SupportedDbType dbType;
    private Path<String> stringDocAlias = ExpressionUtils.path(String.class, (String)"doc");
    private Path<Boolean> booleanDocAlias = ExpressionUtils.path(Boolean.class, (String)"doc");
    private Path<Integer> integerDocAlias = ExpressionUtils.path(Integer.class, (String)"doc");
    private Path<Long> longDocAlias = ExpressionUtils.path(Long.class, (String)"doc");
    private Path<Date> dateDocAlias = ExpressionUtils.path(Date.class, (String)"doc");
    private Path<Object> objectDocAlias = ExpressionUtils.path(Object.class, (String)"doc");
    public static String[] SPECIAL_REGEX_CHARACTERS = new String[]{"\\", "/", ".", "*", "+", "?", "|", "(", ")", "[", "]", "{", "}"};
    private Map<String, JDBCType> jdbcEnumTypesMap;

    public SqlFilterConverter(SqlOperationService operationService) {
        this.operationService = operationService;
        this.dbType = operationService.getConnectionProvider().getDbType();
        this.initJdbcEnumTypesMap();
    }

    private void initJdbcEnumTypesMap() {
        this.jdbcEnumTypesMap = new HashMap<String, JDBCType>();
        for (JDBCType sqlType : (JDBCType[])JDBCType.class.getEnumConstants()) {
            this.jdbcEnumTypesMap.put(StringHelper.toLowerCase((String)sqlType.name()), sqlType);
        }
    }

    public ConvertedExpression convertToSqlFilter(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) throws SearchException {
        return this.convertToSqlFilter(tableMapping, genericFilter, propertiesAnnotationsMap, false);
    }

    public ConvertedExpression convertToSqlFilter(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, boolean skipAlias) throws SearchException {
        return this.convertToSqlFilter(tableMapping, genericFilter, propertiesAnnotationsMap, null, skipAlias);
    }

    public ConvertedExpression convertToSqlFilter(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Function<? super Filter, Boolean> processor, boolean skipAlias) throws SearchException {
        HashMap jsonAttributes = new HashMap();
        ConvertedExpression convertedExpression = this.convertToSqlFilterImpl(tableMapping, genericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias);
        return convertedExpression;
    }

    private ConvertedExpression convertToSqlFilterImpl(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Map<String, Class<?>> jsonAttributes, Function<? super Filter, Boolean> processor, boolean skipAlias) throws SearchException {
        Predicate predicate;
        PredicateOperation operation;
        ArrayList<Predicate> expressions;
        PredicateOperation operation2;
        int i;
        if (genericFilter == null) {
            return null;
        }
        Filter currentGenericFilter = genericFilter;
        FilterType type = currentGenericFilter.getType();
        if (FilterType.RAW == type) {
            LOG.warn("RAW Ldap filter to SQL convertion will be removed in new version!!!");
            currentGenericFilter = ldapFilterConverter.convertRawLdapFilterToFilter(currentGenericFilter.getFilterString());
            type = currentGenericFilter.getType();
        }
        if (processor != null) {
            processor.apply((Filter)currentGenericFilter);
        }
        if (FilterType.NOT == type || FilterType.AND == type || FilterType.OR == type) {
            Filter[] genericFilters = currentGenericFilter.getFilters();
            Predicate[] expFilters = new Predicate[genericFilters.length];
            if (genericFilters != null) {
                Object isMultiValuedDetected;
                boolean canJoinOrFilters = FilterType.OR == type;
                ArrayList<Filter> joinOrFilters = new ArrayList<Filter>();
                String joinOrAttributeName = null;
                for (i = 0; i < genericFilters.length; ++i) {
                    Filter tmpFilter = genericFilters[i];
                    expFilters[i] = (Predicate)this.convertToSqlFilterImpl(tableMapping, tmpFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias).expression();
                    if (!canJoinOrFilters) continue;
                    if (FilterType.EQUALITY != tmpFilter.getType() || tmpFilter.getFilters() != null) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    if (tmpFilter.getMultiValued() != null) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    isMultiValuedDetected = this.determineMultiValuedByType(this.resolveAttributeName(tableMapping, tmpFilter), propertiesAnnotationsMap);
                    if (!Boolean.FALSE.equals(isMultiValuedDetected) && !Boolean.FALSE.equals(currentGenericFilter.getMultiValued())) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    if (joinOrAttributeName == null) {
                        joinOrAttributeName = this.resolveAttributeName(tableMapping, tmpFilter);
                        joinOrFilters.add(tmpFilter);
                        continue;
                    }
                    if (!joinOrAttributeName.equals(this.resolveAttributeName(tableMapping, tmpFilter))) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    joinOrFilters.add(tmpFilter);
                }
                if (FilterType.NOT == type) {
                    return ConvertedExpression.build((Expression)ExpressionUtils.predicate((Operator)Ops.NOT, (Expression[])new Expression[]{expFilters[0]}), jsonAttributes);
                }
                if (FilterType.AND == type) {
                    return ConvertedExpression.build((Expression)ExpressionUtils.allOf((Predicate[])expFilters), jsonAttributes);
                }
                if (FilterType.OR == type) {
                    if (canJoinOrFilters) {
                        ArrayList<Object> rightObjs = new ArrayList<Object>(joinOrFilters.size());
                        Filter lastEqFilter = null;
                        isMultiValuedDetected = joinOrFilters.iterator();
                        while (isMultiValuedDetected.hasNext()) {
                            Filter eqFilter;
                            lastEqFilter = eqFilter = (Filter)isMultiValuedDetected.next();
                            Object assertionValue = eqFilter.getAssertionValue();
                            if (assertionValue instanceof AttributeEnum) {
                                assertionValue = ((AttributeEnum)assertionValue).getValue();
                            }
                            rightObjs.add(assertionValue);
                        }
                        return ConvertedExpression.build((Expression)ExpressionUtils.in((Expression)this.buildTypedPath(tableMapping, lastEqFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias).expression(), rightObjs), jsonAttributes);
                    }
                    return ConvertedExpression.build((Expression)ExpressionUtils.anyOf((Predicate[])expFilters), jsonAttributes);
                }
            }
        }
        boolean multiValued = this.isMultiValue(tableMapping, currentGenericFilter, propertiesAnnotationsMap);
        TypedPath typedPathColumn = this.buildTypedPath(tableMapping, currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias);
        String pathAttributeName = this.resolvePathAttributeName(typedPathColumn, currentGenericFilter);
        Expression columnExpression = typedPathColumn.expression();
        if (FilterType.EQUALITY == type) {
            if (multiValued) {
                if (SupportedDbType.POSTGRESQL == this.dbType) {
                    if (StringHelper.isEmpty((String)pathAttributeName)) {
                        operation2 = ExpressionUtils.predicate((Operator)SqlOps.PGSQL_JSON_CONTAINS, (Expression[])new Expression[]{columnExpression, this.buildTypedArrayExpression(tableMapping, currentGenericFilter)});
                        return ConvertedExpression.build((Expression)operation2, jsonAttributes);
                    }
                    return this.buildPostgreSqlMultivaluedComparisionExpression(tableMapping, jsonAttributes, currentGenericFilter, typedPathColumn);
                }
                if (StringHelper.isEmpty((String)pathAttributeName)) {
                    operation2 = ExpressionUtils.predicate((Operator)SqlOps.JSON_CONTAINS, (Expression[])new Expression[]{columnExpression, this.buildTypedArrayExpression(tableMapping, currentGenericFilter), this.buildExpressionArrayPath(pathAttributeName, -1)});
                    return ConvertedExpression.build((Expression)operation2, jsonAttributes);
                }
                operation2 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, this.buildExpressionArrayPath(pathAttributeName, 0)});
                BooleanExpression expression = Expressions.asComparable((Expression)operation2).eq(this.buildTypedExpression(tableMapping, currentGenericFilter, pathAttributeName));
                return ConvertedExpression.build((Expression)expression, jsonAttributes);
            }
            Expression typedExpression = this.buildTypedExpression(tableMapping, currentGenericFilter, pathAttributeName);
            if (typedExpression instanceof NullExpression) {
                return ConvertedExpression.build((Expression)ExpressionUtils.isNull((Expression)columnExpression), jsonAttributes);
            }
            return ConvertedExpression.build((Expression)ExpressionUtils.eq((Expression)columnExpression, (Expression)typedExpression), jsonAttributes);
        }
        if (FilterType.LESS_OR_EQUAL == type) {
            if (multiValued) {
                if (SupportedDbType.POSTGRESQL == this.dbType) {
                    return this.buildPostgreSqlMultivaluedComparisionExpression(tableMapping, jsonAttributes, currentGenericFilter, typedPathColumn);
                }
                if (currentGenericFilter.getMultiValuedCount() > 1) {
                    expressions = new ArrayList<Predicate>(currentGenericFilter.getMultiValuedCount());
                    for (i = 0; i < currentGenericFilter.getMultiValuedCount(); ++i) {
                        operation = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, this.buildExpressionArrayPath(pathAttributeName, i)});
                        predicate = Expressions.asComparable((Expression)operation).loe(this.buildTypedExpression(tableMapping, currentGenericFilter, pathAttributeName));
                        expressions.add(predicate);
                    }
                    Predicate expression = ExpressionUtils.anyOf(expressions);
                    return ConvertedExpression.build((Expression)expression, jsonAttributes);
                }
                operation2 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, this.buildExpressionArrayPath(pathAttributeName, 0)});
                BooleanExpression expression = Expressions.asComparable((Expression)operation2).loe(this.buildTypedExpression(tableMapping, currentGenericFilter, pathAttributeName));
                return ConvertedExpression.build((Expression)expression, jsonAttributes);
            }
            return ConvertedExpression.build((Expression)Expressions.asComparable((Expression)columnExpression).loe(this.buildTypedExpression(tableMapping, currentGenericFilter, pathAttributeName)), jsonAttributes);
        }
        if (FilterType.GREATER_OR_EQUAL == type) {
            if (multiValued) {
                if (SupportedDbType.POSTGRESQL == this.dbType) {
                    return this.buildPostgreSqlMultivaluedComparisionExpression(tableMapping, jsonAttributes, currentGenericFilter, typedPathColumn);
                }
                if (currentGenericFilter.getMultiValuedCount() > 1) {
                    expressions = new ArrayList(currentGenericFilter.getMultiValuedCount());
                    for (i = 0; i < currentGenericFilter.getMultiValuedCount(); ++i) {
                        operation = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, this.buildExpressionArrayPath(pathAttributeName, i)});
                        predicate = Expressions.asComparable((Expression)operation).goe(this.buildTypedExpression(tableMapping, currentGenericFilter, pathAttributeName));
                        expressions.add(predicate);
                    }
                    Predicate expression = ExpressionUtils.anyOf(expressions);
                    return ConvertedExpression.build((Expression)expression, jsonAttributes);
                }
                operation2 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, this.buildExpressionArrayPath(pathAttributeName, 0)});
                BooleanExpression expression = Expressions.asComparable((Expression)operation2).goe(this.buildTypedExpression(tableMapping, currentGenericFilter, pathAttributeName));
                return ConvertedExpression.build((Expression)expression, jsonAttributes);
            }
            return ConvertedExpression.build((Expression)Expressions.asComparable((Expression)columnExpression).goe(this.buildTypedExpression(tableMapping, currentGenericFilter, pathAttributeName)), jsonAttributes);
        }
        if (FilterType.PRESENCE == type) {
            Expression expression;
            if (multiValued) {
                if (SupportedDbType.POSTGRESQL == this.dbType) {
                    PredicateOperation operation3 = ExpressionUtils.predicate((Operator)SqlOps.PGSQL_JSON_NOT_EMPTY_ARRAY, (Expression[])new Expression[]{columnExpression});
                    return ConvertedExpression.build((Expression)operation3, jsonAttributes);
                }
                if (currentGenericFilter.getMultiValuedCount() > 1) {
                    ArrayList<Predicate> expressions2 = new ArrayList<Predicate>(currentGenericFilter.getMultiValuedCount());
                    for (int i2 = 0; i2 < currentGenericFilter.getMultiValuedCount(); ++i2) {
                        predicate = ExpressionUtils.isNotNull((Expression)ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, this.buildExpressionArrayPath(pathAttributeName, i2)}));
                        expressions2.add(predicate);
                    }
                    Predicate predicate2 = ExpressionUtils.anyOf(expressions2);
                    return ConvertedExpression.build((Expression)predicate2, jsonAttributes);
                }
                expression = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, this.buildExpressionArrayPath(pathAttributeName, 0)});
            } else {
                expression = columnExpression;
            }
            return ConvertedExpression.build((Expression)ExpressionUtils.isNotNull((Expression)expression), jsonAttributes);
        }
        if (FilterType.APPROXIMATE_MATCH == type) {
            throw new SearchException("Convertion from APPROXIMATE_MATCH LDAP filter to SQL filter is not implemented");
        }
        if (FilterType.SUBSTRING == type) {
            Expression expression;
            String matchChar = multiValued && SupportedDbType.POSTGRESQL == this.dbType ? ".*" : "%";
            StringBuilder like = new StringBuilder();
            if (currentGenericFilter.getSubInitial() != null) {
                like.append(currentGenericFilter.getSubInitial());
            }
            like.append(matchChar);
            Predicate subAny = currentGenericFilter.getSubAny();
            if (subAny != null && ((String[])subAny).length > 0) {
                for (Predicate any : subAny) {
                    if (SupportedDbType.POSTGRESQL == this.dbType) {
                        if (multiValued) {
                            like.append(this.escapeRegex((String)any));
                        } else {
                            like.append((String)any);
                        }
                    } else {
                        like.append((String)any);
                    }
                    like.append(matchChar);
                }
            }
            if (currentGenericFilter.getSubFinal() != null) {
                like.append(currentGenericFilter.getSubFinal());
            }
            if (multiValued) {
                if (SupportedDbType.POSTGRESQL == this.dbType) {
                    String likeString = StringEscapeUtils.escapeJava((String)like.toString());
                    return this.buildPostgreSqlMultivaluedComparisionExpression(tableMapping, jsonAttributes, currentGenericFilter, typedPathColumn, Expressions.constant((Object)"like_regex"), likeString);
                }
                if (currentGenericFilter.getMultiValuedCount() > 1) {
                    ArrayList<BooleanOperation> expressions3 = new ArrayList<BooleanOperation>(currentGenericFilter.getMultiValuedCount());
                    for (int i3 = 0; i3 < currentGenericFilter.getMultiValuedCount(); ++i3) {
                        PredicateOperation operation4 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, this.buildExpressionArrayPath(pathAttributeName, i3)});
                        BooleanOperation predicate3 = Expressions.booleanOperation((Operator)Ops.LIKE, (Expression[])new Expression[]{operation4, Expressions.constant((Object)like.toString())});
                        expressions3.add(predicate3);
                    }
                    Predicate predicate4 = ExpressionUtils.anyOf(expressions3);
                    return ConvertedExpression.build((Expression)predicate4, jsonAttributes);
                }
                expression = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, this.buildExpressionArrayPath(pathAttributeName, 0)});
            } else {
                expression = columnExpression;
            }
            return ConvertedExpression.build((Expression)Expressions.booleanOperation((Operator)Ops.LIKE, (Expression[])new Expression[]{expression, Expressions.constant((Object)like.toString())}), jsonAttributes);
        }
        if (FilterType.LOWERCASE == type) {
            return ConvertedExpression.build(ExpressionUtils.toLower((Expression)columnExpression), jsonAttributes);
        }
        throw new SearchException(String.format("Unknown filter type '%s'", type));
    }

    private Expression<String> buildExpressionArrayPath(String pathAttributeName, int i) {
        if (i == -1) {
            return Expressions.constant((Object)"$");
        }
        if (StringHelper.isEmpty((String)pathAttributeName)) {
            return Expressions.constant((Object)String.format("$[%d]", i));
        }
        return Expressions.constant((Object)String.format("$[%d].%s", i, pathAttributeName));
    }

    private ConvertedExpression buildPostgreSqlMultivaluedComparisionExpression(TableMapping tableMapping, Map<String, Class<?>> jsonAttributes, Filter currentGenericFilter, TypedPath columnExpression) throws SearchException {
        Object typedArrayExpressionValue = this.prepareTypedArrayExpressionValue(tableMapping, currentGenericFilter);
        Expression operationExpression = FilterType.EQUALITY == currentGenericFilter.getType() ? Expressions.constant((Object)"==") : Expressions.constant((Object)currentGenericFilter.getType().getSign());
        return this.buildPostgreSqlMultivaluedComparisionExpression(tableMapping, jsonAttributes, currentGenericFilter, columnExpression, operationExpression, typedArrayExpressionValue);
    }

    private ConvertedExpression buildPostgreSqlMultivaluedComparisionExpression(TableMapping tableMapping, Map<String, Class<?>> jsonAttributes, Filter currentGenericFilter, TypedPath columnExpression, Expression operationExpession, Object expressionValue) {
        Object typedArrayExpression = expressionValue == null ? Expressions.nullExpression() : (expressionValue instanceof Boolean ? Expressions.asString((String)((Boolean)expressionValue).toString()) : (expressionValue instanceof String ? Expressions.asString((String)("\"" + (String)expressionValue + "\"")) : Expressions.constant((Object)expressionValue)));
        String pathAttributeName = this.resolvePathAttributeName(columnExpression, currentGenericFilter);
        PredicateOperation operation = null;
        operation = StringHelper.isEmpty((String)pathAttributeName) ? ExpressionUtils.predicate((Operator)SqlOps.PGSQL_JSON_PATH_QUERY_EXISTS, (Expression[])new Expression[]{columnExpression.expression, operationExpession, typedArrayExpression}) : ExpressionUtils.predicate((Operator)SqlOps.PGSQL_JSON_PATH_MAP_QUERY_EXISTS, (Expression[])new Expression[]{columnExpression.expression, Expressions.constant((Object)pathAttributeName), operationExpession, typedArrayExpression});
        return ConvertedExpression.build((Expression)operation, jsonAttributes);
    }

    protected Boolean isMultiValue(TableMapping tableMapping, Filter filter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) throws SearchException {
        String attributeName = this.resolveAttributeName(tableMapping, filter);
        AttributeType attributeType = null;
        if (StringHelper.isNotEmpty((String)attributeName) && (attributeType = this.resolveAttributeType(tableMapping, filter)) == null && tableMapping != null) {
            throw new SearchException(String.format(String.format("Failed to find attribute type for '%s'", attributeName), new Object[0]));
        }
        if (attributeType == null && filter.getMultiValued() != null) {
            return filter.getMultiValued();
        }
        Boolean isMultiValuedDetected = this.determineMultiValuedByType(attributeName, propertiesAnnotationsMap);
        if ((Boolean.TRUE.equals(filter.getMultiValued()) || Boolean.TRUE.equals(isMultiValuedDetected)) && attributeType != null && Boolean.TRUE.equals(attributeType.getMultiValued())) {
            return true;
        }
        return false;
    }

    private AttributeType resolveAttributeType(TableMapping tableMapping, Filter filter) throws SearchException {
        if (tableMapping == null || filter == null) {
            return null;
        }
        String attributeName = filter.getAttributeName();
        if (attributeName == null) {
            return null;
        }
        String attributeNameLower = attributeName.toLowerCase();
        AttributeType attributeType = tableMapping.getColumTypes().get(attributeNameLower);
        if (attributeType == null) {
            int idx = attributeNameLower.indexOf(".");
            if (idx != -1) {
                attributeNameLower = attributeNameLower.substring(0, idx).toLowerCase();
                attributeType = tableMapping.getColumTypes().get(attributeNameLower);
                if (attributeType != null) {
                    return attributeType;
                }
            }
            throw new SearchException(String.format("Unknown column name '%s' in table/child table '%s'", attributeName, tableMapping.getTableName()));
        }
        return attributeType;
    }

    private String resolveAttributeName(TableMapping tableMapping, Filter filter) throws SearchException {
        if (tableMapping == null || filter == null) {
            return filter.getAttributeName();
        }
        String attributeName = filter.getAttributeName();
        if (attributeName == null) {
            return null;
        }
        String attributeNameLower = attributeName.toLowerCase();
        if (tableMapping.getColumTypes() == null) {
            throw new SearchException(String.format("Unknown table '%s' and it's column '%s'", tableMapping.getTableName(), attributeName));
        }
        AttributeType attributeType = tableMapping.getColumTypes().get(attributeNameLower);
        if (attributeType == null) {
            int idx = attributeName.indexOf(".");
            if (idx != -1) {
                attributeName = attributeName.substring(0, idx);
                return attributeName;
            }
            throw new SearchException(String.format("Unknown column name '%s' in table/child table '%s'", attributeName, tableMapping.getTableName()));
        }
        return attributeName;
    }

    private String resolvePathAttributeName(TypedPath typedPathColumn, Filter filter) {
        String fullAttributeName = filter.getAttributeName();
        if (StringHelper.isEmpty((String)fullAttributeName)) {
            return null;
        }
        String attributeName = typedPathColumn.attribute();
        int jsonPathIdx = fullAttributeName.indexOf(attributeName, 0);
        if (jsonPathIdx > -1 && attributeName.length() + jsonPathIdx < fullAttributeName.length()) {
            return fullAttributeName.substring(attributeName.length() + jsonPathIdx + 1);
        }
        return null;
    }

    private String toInternalAttribute(TableMapping tableMapping, Filter filter) throws SearchException {
        String tableName = tableMapping == null ? null : tableMapping.getTableName();
        String attributeName = this.resolveAttributeName(tableMapping, filter);
        if (StringHelper.isEmpty((String)attributeName)) {
            Filter subFilter;
            Filter[] filterArray = filter.getFilters();
            int n = filterArray.length;
            for (int i = 0; i < n && !StringHelper.isNotEmpty((String)(attributeName = this.resolveAttributeName(tableMapping, subFilter = filterArray[i]))); ++i) {
            }
        }
        return this.toInternalAttribute(tableName, attributeName);
    }

    private String toInternalAttribute(String tableName, String attributeName) {
        if (this.operationService == null || tableName == null) {
            return attributeName;
        }
        return this.operationService.toInternalAttribute(tableName, attributeName);
    }

    private Expression buildTypedExpression(TableMapping tableMapping, Filter filter, String pathAttributeName) throws SearchException {
        Object expressionValue = this.prepareTypedExpressionValue(tableMapping, filter);
        NullExpression expression = Expressions.nullExpression();
        if (expressionValue != null) {
            expression = StringHelper.isNotEmpty((String)pathAttributeName) && SupportedDbType.MYSQL == this.dbType && expressionValue instanceof Boolean ? Expressions.constant((Object)((Boolean)expressionValue).toString()) : Expressions.constant((Object)expressionValue);
        }
        return expression;
    }

    private Expression buildTypedArrayExpression(TableMapping tableMapping, Filter filter) throws SearchException {
        Object assertionValue = this.prepareTypedArrayExpressionValue(tableMapping, filter);
        String assertionValueJson = this.convertValueToJson(Arrays.asList(assertionValue));
        return Expressions.constant((Object)assertionValueJson);
    }

    private Object prepareTypedArrayExpressionValue(TableMapping tableMapping, Filter filter) throws SearchException {
        Object assertionValue = this.prepareTypedExpressionValue(tableMapping, filter);
        if (assertionValue instanceof Date) {
            assertionValue = this.operationService.encodeTime((Date)assertionValue);
        }
        return assertionValue;
    }

    private Object prepareTypedExpressionValue(TableMapping tableMapping, Filter filter) throws SearchException {
        AttributeType attributeType = null;
        String attributeName = this.resolveAttributeName(tableMapping, filter);
        if (StringHelper.isNotEmpty((String)attributeName) && (attributeType = this.resolveAttributeType(tableMapping, filter)) == null && tableMapping != null) {
            throw new SearchException(String.format(String.format("Failed to find attribute type for '%s'", attributeName), new Object[0]));
        }
        Object assertionValue = filter.getAssertionValue();
        if (assertionValue instanceof AttributeEnum) {
            assertionValue = ((AttributeEnum)assertionValue).getValue();
        } else if (assertionValue instanceof String) {
            Date dateValue;
            if (attributeType != null && "timestamp".equals(attributeType.getType()) && (dateValue = this.operationService.decodeTime((String)assertionValue, true)) != null) {
                assertionValue = dateValue;
            }
            if (attributeType != null) {
                String columnType = attributeType.getType();
                JDBCType jdbcType = null;
                if (StringHelper.equalsIgnoreCase((String)columnType, (String)"bool")) {
                    jdbcType = JDBCType.BOOLEAN;
                } else {
                    String lowerCaseColumnType = StringHelper.toLowerCase((String)columnType);
                    if (this.jdbcEnumTypesMap.containsKey(lowerCaseColumnType)) {
                        jdbcType = this.jdbcEnumTypesMap.get(lowerCaseColumnType);
                    } else {
                        LOG.trace("Failed to determine JDBC type '{}' ", (Object)attributeType.getType());
                    }
                }
                if (jdbcType == JDBCType.SMALLINT) {
                    boolean res = StringHelper.equalsIgnoreCase((String)((String)assertionValue), (String)"true") || StringHelper.equalsIgnoreCase((String)((String)assertionValue), (String)"1");
                    assertionValue = res ? 1 : 0;
                } else if (jdbcType == JDBCType.BOOLEAN) {
                    boolean res = StringHelper.equalsIgnoreCase((String)((String)assertionValue), (String)"true") || StringHelper.equalsIgnoreCase((String)((String)assertionValue), (String)"1");
                    assertionValue = res;
                }
            }
        }
        return assertionValue;
    }

    private TypedPath buildTypedPath(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Map<String, Class<?>> jsonAttributes, Function<? super Filter, Boolean> processor, boolean skipAlias) throws SearchException {
        boolean hasSubFilters = ArrayHelper.isNotEmpty((Object[])genericFilter.getFilters());
        if (hasSubFilters) {
            Expression expression = this.convertToSqlFilterImpl(tableMapping, genericFilter.getFilters()[0], propertiesAnnotationsMap, jsonAttributes, processor, skipAlias).expression();
            return new TypedPath(null, expression);
        }
        String internalAttribute = this.toInternalAttribute(tableMapping, genericFilter);
        Expression expression = this.buildTypedPath(tableMapping, genericFilter, internalAttribute, skipAlias);
        return new TypedPath(internalAttribute, expression);
    }

    private Expression buildTypedPath(TableMapping tableMapping, Filter filter, String attributeName, boolean skipAlias) throws SearchException {
        AttributeType attributeType = this.resolveAttributeType(tableMapping, filter);
        if (attributeType == null && tableMapping != null) {
            throw new SearchException(String.format(String.format("Failed to find attribute type for '%s'", attributeName), new Object[0]));
        }
        if (attributeType != null && "timestamp".equals(attributeType.getType())) {
            if (skipAlias) {
                return Expressions.dateTimePath(Date.class, (String)attributeName);
            }
            return Expressions.dateTimePath(Date.class, this.dateDocAlias, (String)attributeName);
        }
        if (filter.getAssertionValue() instanceof String) {
            if (skipAlias) {
                return Expressions.stringPath((String)attributeName);
            }
            return Expressions.stringPath(this.stringDocAlias, (String)attributeName);
        }
        if (filter.getAssertionValue() instanceof Boolean) {
            if (skipAlias) {
                return Expressions.booleanPath((String)attributeName);
            }
            return Expressions.booleanPath(this.booleanDocAlias, (String)attributeName);
        }
        if (filter.getAssertionValue() instanceof Integer) {
            if (skipAlias) {
                return Expressions.stringPath((String)attributeName);
            }
            return Expressions.stringPath(this.integerDocAlias, (String)attributeName);
        }
        if (filter.getAssertionValue() instanceof Long) {
            if (skipAlias) {
                return Expressions.stringPath((String)attributeName);
            }
            return Expressions.stringPath(this.longDocAlias, (String)attributeName);
        }
        if (skipAlias) {
            return Expressions.stringPath((String)attributeName);
        }
        return Expressions.stringPath(this.objectDocAlias, (String)attributeName);
    }

    private Boolean determineMultiValuedByType(String attributeName, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        if (attributeName == null || propertiesAnnotationsMap == null) {
            return null;
        }
        if (StringHelper.equalsIgnoreCase((String)attributeName, (String)"objectClass")) {
            return false;
        }
        PropertyAnnotation propertyAnnotation = propertiesAnnotationsMap.get(attributeName);
        if (propertyAnnotation == null || propertyAnnotation.getParameterType() == null) {
            return null;
        }
        Class parameterType = propertyAnnotation.getParameterType();
        boolean isMultiValued = parameterType.equals(Object[].class) || parameterType.equals(String[].class) || ReflectHelper.assignableFrom((Class)parameterType, List.class) || ReflectHelper.assignableFrom((Class)parameterType, Map.class) || ReflectHelper.assignableFrom((Class)parameterType, AttributeEnum[].class);
        return isMultiValued;
    }

    protected String convertValueToJson(Object propertyValue) throws SearchException {
        try {
            String value = JSON_OBJECT_MAPPER.writeValueAsString(propertyValue);
            return value;
        }
        catch (Exception ex) {
            LOG.error("Failed to convert '{}' to json value:", propertyValue, (Object)ex);
            throw new SearchException(String.format("Failed to convert '%s' to json value", propertyValue));
        }
    }

    private Object escapeRegex(String str) {
        String result = str;
        for (String ch : SPECIAL_REGEX_CHARACTERS) {
            result = result.replace(ch, "\\" + ch);
        }
        return result;
    }

    class TypedPath {
        private String attributeName;
        private Expression expression;

        public TypedPath(String attributeName, Expression expression) {
            this.attributeName = attributeName;
            this.expression = expression;
        }

        public String attribute() {
            return this.attributeName;
        }

        public Expression expression() {
            return this.expression;
        }
    }
}

