/*
 * Decompiled with CFR 0.152.
 */
package io.jans.util.security;

import java.lang.reflect.InvocationTargetException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityProviderUtility {
    public static final String DEF_MODE_BCFIPS = "BCFIPS";
    public static final String DEF_KS_JKS = "JKS";
    public static final String DEF_KS_PKCS12 = "PKCS12";
    public static final String DEF_MODE_BCPROV = "BCPROV";
    public static final String DEF_KS_BCFKS = "BCFKS";
    public static final String DEF_EXT_JKS = "jks";
    public static final String DEF_EXT_KEYSTORE = "keystore";
    public static final String DEF_EXT_KS = "ks";
    public static final String DEF_EXT_PKCS12 = "pkcs12";
    public static final String DEF_EXT_P12 = "p12";
    public static final String DEF_EXT_PFX = "pfx";
    public static final String DEF_EXT_BCFKS = "bcfks";
    public static final String DEF_EXT_BCF = "bcf";
    public static final String DEF_EXT_BCFIPS = "bcfips";
    private static final Logger LOG = LoggerFactory.getLogger(SecurityProviderUtility.class);
    public static final String BC_PROVIDER_NAME = "BC";
    public static final String BC_FIPS_PROVIDER_NAME = "BCFIPS";
    public static boolean USE_FIPS_CHECK_COMMAND = false;
    private static SecurityModeType securityMode = null;
    private static Provider bouncyCastleProvider;
    private static final String BC_GENERIC_PROVIDER_CLASS_NAME = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final String BC_FIPS_PROVIDER_CLASS_NAME = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";

    public static void installBCProvider(boolean silent) {
        String providerName = BC_PROVIDER_NAME;
        String className = BC_GENERIC_PROVIDER_CLASS_NAME;
        if (securityMode == null || securityMode == SecurityModeType.BCFIPS_SECURITY_MODE) {
            boolean isFipsMode = SecurityProviderUtility.checkFipsMode();
            if (isFipsMode) {
                LOG.info("Fips mode is enabled");
                providerName = "BCFIPS";
                className = BC_FIPS_PROVIDER_CLASS_NAME;
                securityMode = SecurityModeType.BCFIPS_SECURITY_MODE;
            } else {
                securityMode = SecurityModeType.BCPROV_SECURITY_MODE;
            }
        }
        try {
            SecurityProviderUtility.installBCProvider(providerName, className, silent);
        }
        catch (Exception e) {
            LOG.error("Security provider '{}' doesn't exists in class path. Please deploy correct war for this environment!", (Object)providerName);
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void installBCProvider() {
        SecurityProviderUtility.installBCProvider(false);
    }

    public static void installBCProvider(String providerName, String providerClassName, boolean silent) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        bouncyCastleProvider = Security.getProvider(providerName);
        if (bouncyCastleProvider == null) {
            if (!silent) {
                LOG.info("Adding Bouncy Castle Provider");
            }
            bouncyCastleProvider = (Provider)Class.forName(providerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            Security.addProvider(bouncyCastleProvider);
            LOG.info("Provider '{}' with version {} is added", (Object)bouncyCastleProvider.getName(), (Object)bouncyCastleProvider.getVersionStr());
        } else if (!silent) {
            LOG.info("Bouncy Castle Provider was added already");
        }
    }

    public static boolean checkFipsMode() {
        try {
            Class.forName(BC_FIPS_PROVIDER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            LOG.trace("BC Fips provider is not available", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean checkRestrictedCryptography() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES/CBC/PKCS5Padding") < Integer.MAX_VALUE;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("The transform \"AES/CBC/PKCS5Padding\" is not available (the availability of this algorithm is mandatory for Java SE implementations)", e);
        }
    }

    public static String getBCProviderName() {
        return bouncyCastleProvider.getName();
    }

    public static Provider getBCProvider() {
        return bouncyCastleProvider;
    }

    public static SecurityModeType getSecurityMode() {
        return securityMode;
    }

    public static void setSecurityMode(SecurityModeType securityModeIn) {
        securityMode = securityModeIn;
    }

    public static KeyStorageType solveKeyStorageType(String keyStoreFile) {
        if (keyStoreFile == null) {
            throw new InvalidParameterException("KeyStore File isn't defined. Check configuration.");
        }
        SecurityModeType securityMode = SecurityProviderUtility.getSecurityMode();
        if (securityMode == null) {
            throw new InvalidParameterException("Security Mode wasn't initialized. Call installBCProvider() before");
        }
        String keyStoreExt = FilenameUtils.getExtension((String)keyStoreFile);
        KeyStorageType keyStorageType = KeyStorageType.fromExtension(keyStoreExt);
        boolean ksTypeFound = false;
        for (KeyStorageType ksType : securityMode.getKeystorageTypes()) {
            if (keyStorageType != ksType) continue;
            ksTypeFound = true;
            break;
        }
        if (!ksTypeFound) {
            switch (securityMode) {
                case BCFIPS_SECURITY_MODE: {
                    keyStorageType = KeyStorageType.BCFKS_KS;
                    break;
                }
                case BCPROV_SECURITY_MODE: {
                    keyStorageType = KeyStorageType.PKCS12_KS;
                }
            }
        }
        return keyStorageType;
    }

    public static boolean isBcProvMode() {
        if (securityMode == null) {
            throw new IllegalStateException("SecurityProviderUtility: securityMode is not initialized");
        }
        return SecurityModeType.BCPROV_SECURITY_MODE == securityMode;
    }

    public static boolean isBcFipsMode() {
        if (securityMode == null) {
            throw new IllegalStateException("SecurityProviderUtility: securityMode is not initialized");
        }
        return SecurityModeType.BCFIPS_SECURITY_MODE == securityMode;
    }

    public static enum SecurityModeType {
        BCPROV_SECURITY_MODE("BCPROV"),
        BCFIPS_SECURITY_MODE("BCFIPS");

        private final String value;

        private SecurityModeType(String value) {
            this.value = value;
        }

        public static SecurityModeType fromString(String param) {
            switch (param.toUpperCase()) {
                case "BCPROV": {
                    return BCPROV_SECURITY_MODE;
                }
                case "BCFIPS": {
                    return BCFIPS_SECURITY_MODE;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }

        public KeyStorageType[] getKeystorageTypes() {
            KeyStorageType[] keystorages = null;
            if (this == BCPROV_SECURITY_MODE) {
                keystorages = new KeyStorageType[]{KeyStorageType.JKS_KS, KeyStorageType.PKCS12_KS};
            } else if (this == BCFIPS_SECURITY_MODE) {
                keystorages = new KeyStorageType[]{KeyStorageType.BCFKS_KS};
            }
            return keystorages;
        }
    }

    public static enum KeyStorageType {
        JKS_KS("JKS"),
        PKCS12_KS("PKCS12"),
        BCFKS_KS("BCFKS");

        private final String value;

        private KeyStorageType(String value) {
            this.value = value;
        }

        public static KeyStorageType fromString(String param) {
            switch (param.toUpperCase()) {
                case "JKS": {
                    return JKS_KS;
                }
                case "PKCS12": {
                    return PKCS12_KS;
                }
                case "BCFKS": {
                    return BCFKS_KS;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }

        public String[] getExtensions() {
            String[] extensions = null;
            if (this == JKS_KS) {
                extensions = new String[]{SecurityProviderUtility.DEF_EXT_JKS, SecurityProviderUtility.DEF_EXT_KEYSTORE, SecurityProviderUtility.DEF_EXT_KS};
            } else if (this == PKCS12_KS) {
                extensions = new String[]{SecurityProviderUtility.DEF_EXT_PKCS12, SecurityProviderUtility.DEF_EXT_P12, SecurityProviderUtility.DEF_EXT_P12};
            } else if (this == BCFKS_KS) {
                extensions = new String[]{SecurityProviderUtility.DEF_EXT_BCFKS, SecurityProviderUtility.DEF_EXT_BCF, SecurityProviderUtility.DEF_EXT_BCFIPS};
            }
            return extensions;
        }

        public SecurityModeType getSecurityMode() {
            SecurityModeType securityModeType = null;
            if (this == JKS_KS || this == PKCS12_KS) {
                securityModeType = SecurityModeType.BCPROV_SECURITY_MODE;
            } else if (this == BCFKS_KS) {
                securityModeType = SecurityModeType.BCFIPS_SECURITY_MODE;
            }
            return securityModeType;
        }

        public static KeyStorageType fromExtension(String extension) {
            switch (extension.toLowerCase()) {
                case "jks": 
                case "keystore": 
                case "ks": {
                    return JKS_KS;
                }
                case "pkcs12": 
                case "p12": 
                case "pfx": {
                    return PKCS12_KS;
                }
                case "bcfks": 
                case "bcf": 
                case "bcfips": {
                    return BCFKS_KS;
                }
            }
            return null;
        }
    }
}

