/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.model;

import io.jans.kc.model.internal.JansPerson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SubjectCredentialManager;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.StorageId;

public class JansUserModel
implements UserModel {
    private static final String INUM_ATTR_NAME = "inum";
    private static final String UID_ATTR_NAME = "uid";
    private static final String JANS_CREATION_TIMESTAMP_ATTR_NAME = "jansCreationTimestamp";
    private static final String JANS_STATUS_ATTR_NAME = "jansStatus";
    private static final String GIVEN_NAME_ATTR_NAME = "givenName";
    private static final String MAIL_ATTR_NAME = "mail";
    private static final String EMAIL_VERIFIED_ATTR_NAME = "emailVerified";
    private static final String USER_READ_ONLY_EXCEPTION_MSG = "User is read-only for this update";
    private final JansPerson jansPerson;
    private final StorageId storageId;

    public JansUserModel(ComponentModel storageProviderModel, JansPerson jansPerson) {
        this.jansPerson = jansPerson;
        String userId = jansPerson.customAttributeValue(INUM_ATTR_NAME);
        this.storageId = new StorageId(storageProviderModel.getId(), userId);
    }

    public String getId() {
        return this.storageId.getId();
    }

    public String getUsername() {
        return this.jansPerson.customAttributeValue(UID_ATTR_NAME);
    }

    public void setUsername(String username) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public Long getCreatedTimestamp() {
        try {
            String createdStr = this.jansPerson.customAttributeValue(JANS_CREATION_TIMESTAMP_ATTR_NAME);
            if (createdStr == null) {
                return null;
            }
            return Long.parseLong(createdStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void setCreatedTimestamp(Long timestamp) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public boolean isEnabled() {
        String enabledStr = this.jansPerson.customAttributeValue(JANS_STATUS_ATTR_NAME);
        if (enabledStr == null) {
            return false;
        }
        return "active".equals(enabledStr);
    }

    public void setEnabled(boolean enabled) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public void setSingleAttribute(String name, String value) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public void setAttribute(String name, List<String> value) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public void removeAttribute(String name) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public String getFirstAttribute(String name) {
        if ("username".equals(name)) {
            return this.getUsername();
        }
        if ("firstName".equals(name)) {
            return this.getFirstName();
        }
        if ("email".equals(name)) {
            return this.getEmail();
        }
        return this.jansPerson.customAttributeValue(name);
    }

    public Stream<String> getAttributeStream(String name) {
        ArrayList<String> ret = new ArrayList<String>();
        if ("username".equals(name)) {
            ret.add(this.getUsername());
        } else if ("firstName".equals(name)) {
            ret.add(this.getFirstName());
        } else if ("email".equals(name)) {
            ret.add(this.getEmail());
        } else {
            return this.jansPerson.customAttributeValues(name).stream();
        }
        return ret.stream();
    }

    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (String attrName : this.jansPerson.customAttributeNames()) {
            ret.put(attrName, this.jansPerson.customAttributeValues(attrName));
        }
        return ret;
    }

    public Stream<String> getRequiredActionsStream() {
        return new ArrayList().stream();
    }

    public void addRequiredAction(String action) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public void removeRequiredAction(String action) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public String getFirstName() {
        return this.jansPerson.customAttributeValue(GIVEN_NAME_ATTR_NAME);
    }

    public void setFirstName(String firstName) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public String getLastName() {
        return null;
    }

    public void setLastName(String lastName) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public String getEmail() {
        return this.jansPerson.customAttributeValue(MAIL_ATTR_NAME);
    }

    public void setEmail(String email) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public boolean isEmailVerified() {
        try {
            String attr = this.jansPerson.customAttributeValue(EMAIL_VERIFIED_ATTR_NAME);
            if (attr == null) {
                return false;
            }
            return Boolean.parseBoolean(attr);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void setEmailVerified(boolean verified) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public Stream<GroupModel> getGroupsStream() {
        return new ArrayList().stream();
    }

    public long getGroupsCount() {
        return 0L;
    }

    public long getGroupsCountByNameContaining(String search) {
        return 0L;
    }

    public void joinGroup(GroupModel group) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public void leaveGroup(GroupModel group) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public boolean isMemberOf(GroupModel group) {
        return false;
    }

    public String getFederationLink() {
        return null;
    }

    public void setFederationLink(String link) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public String getServiceAccountClientLink() {
        return null;
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public SubjectCredentialManager credentialManager() {
        return null;
    }

    public Stream<RoleModel> getRealmRoleMappingsStream() {
        return new ArrayList().stream();
    }

    public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
        return new ArrayList().stream();
    }

    public boolean hasRole(RoleModel role) {
        return false;
    }

    public void grantRole(RoleModel role) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }

    public Stream<RoleModel> getRoleMappingsStream() {
        return new ArrayList().stream();
    }

    public void deleteRoleMapping(RoleModel role) {
        throw new ReadOnlyException(USER_READ_ONLY_EXCEPTION_MSG);
    }
}

