/*
 * Decompiled with CFR 0.152.
 */
package io.jans.kc.spi.rest;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resource.RealmResourceProvider;

public class JansAuthResponseResourceProvider
implements RealmResourceProvider {
    private static final Logger log = Logger.getLogger(JansAuthResponseResourceProvider.class);
    private static final String ACTION_URI_TPL_PARAM = "actionuri";
    private static final String ERR_MSG_TPL_PARAM = "authError";
    private static final String JANS_AUTH_RESPONSE_ERR_FTL = "jans-auth-response-error.ftl";
    private static final String JANS_AUTH_RESPONSE_COMPLETE_FTL = "jans-auth-response-complete.ftl";
    private static final String ERR_MSG_INVALID_REALM = "jans.error-invalid-realm";
    private static final String ERR_MSG_MISSING_DATA = "jans.error-missing-data";
    private KeycloakSession session;

    public JansAuthResponseResourceProvider(KeycloakSession session) {
        this.session = session;
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    @GET
    @NoCache
    @Produces(value={"text/html"})
    @Path(value="/auth-complete")
    public Response completeAuthentication(@QueryParam(value="code") String code, @QueryParam(value="scope") String scope, @QueryParam(value="state") String state) {
        RealmModel realm = this.getAuthenticationRealm();
        if (!this.stateIsAssociatedToRealm(realm, state)) {
            log.infov("Realm {0} is not associated to authz response and state {1}", (Object)realm.getName(), (Object)state);
            return this.createErrorResponse(ERR_MSG_INVALID_REALM);
        }
        if (!this.realmHasActionUri(realm)) {
            log.infov("Realm {0} has no action uri set to complete authentication", (Object)realm.getName());
            return this.createErrorResponse(ERR_MSG_MISSING_DATA);
        }
        this.saveAuthResultInRealm(realm, code, state);
        return this.createFinalizeAuthResponse(realm.getAttribute("kc.action-uri"));
    }

    private final RealmModel getAuthenticationRealm() {
        return this.session.getContext().getRealm();
    }

    private final boolean stateIsAssociatedToRealm(RealmModel realm, String state) {
        String expectedstate = realm.getAttribute("jans.oidc.state");
        return state.equals(expectedstate);
    }

    private final boolean realmHasActionUri(RealmModel realm) {
        String actionuri = realm.getAttribute("kc.action-uri");
        return actionuri != null;
    }

    private final void saveAuthResultInRealm(RealmModel realm, String code, String sessionState) {
        realm.setAttribute("jans.oidc.code", code);
        realm.setAttribute("jans.session.state", sessionState);
    }

    private final Response createResponseWithForm(String formtemplate, Map<String, String> attributes) {
        LoginFormsProvider lfp = (LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class);
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, String> attrEntry : attributes.entrySet()) {
                lfp.setAttribute(attrEntry.getKey(), (Object)attrEntry.getValue());
            }
        }
        return lfp.createForm(formtemplate);
    }

    private final Response createErrorResponse(String errmsgid) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ERR_MSG_TPL_PARAM, errmsgid);
        return this.createResponseWithForm(JANS_AUTH_RESPONSE_ERR_FTL, attributes);
    }

    private final Response createFinalizeAuthResponse(String actionuri) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ACTION_URI_TPL_PARAM, actionuri);
        return this.createResponseWithForm(JANS_AUTH_RESPONSE_COMPLETE_FTL, attributes);
    }
}

