/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.rs.protect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import io.jans.ca.rs.protect.Jackson;
import io.jans.ca.rs.protect.RsResource;
import io.jans.ca.rs.protect.RsResourceList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RsProtector {
    private Map<String, RsResource> resourceMap = Maps.newHashMap();

    public RsProtector(List<RsResource> resourceList) {
        Preconditions.checkNotNull(resourceList);
        for (RsResource resource : resourceList) {
            this.resourceMap.put(resource.getPath(), resource);
        }
    }

    public static RsProtector instance(InputStream inputStream) throws IOException {
        try {
            RsResourceList resourceList = RsProtector.read(inputStream);
            RsProtector rsProtector = new RsProtector(resourceList.getResources());
            return rsProtector;
        }
        finally {
            Closeables.closeQuietly((InputStream)inputStream);
        }
    }

    public static RsResourceList read(String json) throws IOException {
        return (RsResourceList)Jackson.createJsonMapper().readValue(json, RsResourceList.class);
    }

    public static RsResourceList read(InputStream json) throws IOException {
        return (RsResourceList)Jackson.createJsonMapper().readValue(json, RsResourceList.class);
    }

    public boolean hasAccess(String path, String httpMethod, String ... presentScope) {
        Preconditions.checkNotNull((Object)presentScope);
        return this.hasAccess(path, httpMethod, Arrays.asList(presentScope));
    }

    public boolean hasAccess(String path, String httpMethod, List<String> presentScopes) {
        List<String> requiredScopes;
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(presentScopes);
        Preconditions.checkNotNull((Object)httpMethod);
        Preconditions.checkState((!presentScopes.isEmpty() ? 1 : 0) != 0, (Object)"Scopes can't be empty.");
        RsResource rsResource = this.resourceMap.get(path);
        if (rsResource != null && (requiredScopes = rsResource.scopes(httpMethod)) != null) {
            return !Collections.disjoint(requiredScopes, presentScopes);
        }
        return false;
    }

    public Map<String, RsResource> getResourceMap() {
        return this.resourceMap;
    }
}

