/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.rs.protect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jackson {
    public static final String UTF8 = "UTF-8";
    private static final Logger LOG = LoggerFactory.getLogger(Jackson.class);

    public static String asJson(Object p_object) throws IOException {
        ObjectMapper mapper = Jackson.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        return mapper.writeValueAsString(p_object);
    }

    public static ObjectMapper createJsonMapper() {
        return JacksonMapperHolder.MAPPER;
    }

    public static String asPrettyJson(Object p_object) throws IOException {
        ObjectMapper mapper = Jackson.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        ObjectWriter writer = mapper.writer().withDefaultPrettyPrinter();
        return writer.writeValueAsString(p_object);
    }

    public static String asJsonSilently(Object p_object) {
        try {
            return Jackson.asPrettyJson(p_object);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private static class JacksonMapperHolder {
        private static final ObjectMapper MAPPER = JacksonMapperHolder.jsonMapper();

        private JacksonMapperHolder() {
        }

        public static ObjectMapper jsonMapper() {
            JacksonAnnotationIntrospector jackson = new JacksonAnnotationIntrospector();
            ObjectMapper mapper = new ObjectMapper();
            DeserializationConfig deserializationConfig = (DeserializationConfig)mapper.getDeserializationConfig().with((AnnotationIntrospector)jackson);
            SerializationConfig serializationConfig = (SerializationConfig)mapper.getSerializationConfig().with((AnnotationIntrospector)jackson);
            if (deserializationConfig == null || serializationConfig != null) {
                // empty if block
            }
            return mapper;
        }
    }
}

