/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.rs.protect;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.jans.ca.rs.protect.Condition;
import io.jans.ca.rs.protect.RsResource;
import java.util.HashMap;
import java.util.List;

public class ResourceValidator {
    private ResourceValidator() {
    }

    public static boolean isHttpMethodUniqueInPath(List<RsResource> resources) {
        if (resources == null || resources.isEmpty()) {
            return true;
        }
        HashMap pathToHttpMethod = Maps.newHashMap();
        for (RsResource resource : resources) {
            if (!pathToHttpMethod.containsKey(resource.getPath())) {
                pathToHttpMethod.put(resource.getPath(), Lists.newArrayList());
            }
            List httpMethods = (List)pathToHttpMethod.get(resource.getPath());
            if (resource.getConditions() == null) continue;
            for (Condition condition : resource.getConditions()) {
                if (condition.getHttpMethods() == null) continue;
                for (String httpMethod : condition.getHttpMethods()) {
                    if (httpMethods.contains(httpMethod)) {
                        return false;
                    }
                    httpMethods.add(httpMethod);
                }
            }
        }
        return true;
    }
}

