/*
 * Decompiled with CFR 0.152.
 */
package io.jans.ca.rs.protect;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Maps;
import io.jans.ca.rs.protect.Condition;
import io.jans.ca.rs.protect.Jackson;
import io.jans.ca.rs.protect.JsonLogicNode;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RsResource
implements Serializable {
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="conditions")
    private List<Condition> conditions;
    @JsonProperty(value="iat")
    private Integer iat;
    @JsonProperty(value="exp")
    private Integer exp;
    private Map<String, Condition> httpMethodToCondition = null;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public List<String> scopes(String httpMethod) {
        return this.getConditionMap().get(httpMethod).getScopes();
    }

    public Integer getIat() {
        return this.iat;
    }

    public void setIat(Integer iat) {
        this.iat = iat;
    }

    public Integer getExp() {
        return this.exp;
    }

    public void setExp(Integer exp) {
        this.exp = exp;
    }

    public JsonNode getScopeExpression(String httpMethod) {
        return this.getConditionMap().get(httpMethod).getScopeExpression();
    }

    public List<String> getScopesForTicket(String httpMethod) {
        JsonLogicNode node;
        Condition condition = this.getConditionMap().get(httpMethod);
        if (condition.getScopeExpression() != null && (node = RsResource.parseNode(condition.getScopeExpression().toString())) != null) {
            return node.getData();
        }
        return condition.getTicketScopes() != null && !condition.getTicketScopes().isEmpty() ? condition.getTicketScopes() : condition.getScopes();
    }

    public static JsonLogicNode parseNode(String json) {
        try {
            return (JsonLogicNode)Jackson.createJsonMapper().readValue(json, JsonLogicNode.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<String, Condition> getConditionMap() {
        if (this.httpMethodToCondition == null) {
            this.initMap();
        }
        return this.httpMethodToCondition;
    }

    private void initMap() {
        this.httpMethodToCondition = Maps.newHashMap();
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                if (condition.getHttpMethods() == null) continue;
                for (String httpMethod : condition.getHttpMethods()) {
                    this.httpMethodToCondition.put(httpMethod, condition);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RsResource");
        sb.append("{path='").append(this.path).append('\'');
        sb.append(", conditions=").append(this.conditions);
        sb.append(", httpMethodToCondition=").append(this.httpMethodToCondition);
        sb.append(", iat=").append(this.iat);
        sb.append(", exp=").append(this.exp);
        sb.append('}');
        return sb.toString();
    }
}

