/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.sdjwt.SdJwtClaimName;

public class DisclosureRedList {
    public static final List<String> redList = Collections.unmodifiableList(Arrays.asList("iss", "iat", "nbf", "exp", "cnf", "vct", "status"));
    private final Set<SdJwtClaimName> redListClaimNames;
    public static final DisclosureRedList defaultList = DisclosureRedList.defaultList();

    public static DisclosureRedList of(Set<SdJwtClaimName> redListClaimNames) {
        return new DisclosureRedList(redListClaimNames);
    }

    private static DisclosureRedList defaultList() {
        return new DisclosureRedList(redList.stream().map(SdJwtClaimName::of).collect(Collectors.toSet()));
    }

    private DisclosureRedList(Set<SdJwtClaimName> redListClaimNames) {
        this.redListClaimNames = Collections.unmodifiableSet(redListClaimNames);
    }

    public boolean isRedListedClaimName(SdJwtClaimName claimName) {
        return this.redListClaimNames.contains(claimName);
    }

    public boolean containsRedListedClaimNames(Collection<SdJwtClaimName> claimNames) {
        return !this.redListClaimNames.isEmpty() && !claimNames.isEmpty() && !Collections.disjoint(this.redListClaimNames, claimNames);
    }
}

