/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindComposer;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Form;
import org.zkoss.bind.FormLegacy;
import org.zkoss.bind.FormLegacyExt;
import org.zkoss.bind.GlobalCommandEvent;
import org.zkoss.bind.Phase;
import org.zkoss.bind.PhaseListener;
import org.zkoss.bind.Property;
import org.zkoss.bind.PropertyChangeEvent;
import org.zkoss.bind.SimpleForm;
import org.zkoss.bind.Validator;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.DefaultCommand;
import org.zkoss.bind.annotation.DefaultGlobalCommand;
import org.zkoss.bind.annotation.Destroy;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.MatchMedia;
import org.zkoss.bind.annotation.NotifyCommand;
import org.zkoss.bind.annotation.NotifyCommands;
import org.zkoss.bind.annotation.SmartNotifyChange;
import org.zkoss.bind.impl.AbstractAnnotatedMethodInvoker;
import org.zkoss.bind.impl.AllocUtil;
import org.zkoss.bind.impl.AnnotationUtil;
import org.zkoss.bind.impl.BindContextImpl;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.BinderUtil;
import org.zkoss.bind.impl.BindingKey;
import org.zkoss.bind.impl.ChildrenBindingHandler;
import org.zkoss.bind.impl.CommandBindingImpl;
import org.zkoss.bind.impl.FormBindingHandler;
import org.zkoss.bind.impl.ImplicitObjectContributor;
import org.zkoss.bind.impl.ImplicitObjectContributorImpl;
import org.zkoss.bind.impl.InitChildrenBindingImpl;
import org.zkoss.bind.impl.InitFormBindingImpl;
import org.zkoss.bind.impl.InitPropertyBindingImpl;
import org.zkoss.bind.impl.LoadChildrenBindingImpl;
import org.zkoss.bind.impl.LoadFormBindingImpl;
import org.zkoss.bind.impl.LoadPropertyBindingImpl;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.bind.impl.ParamCall;
import org.zkoss.bind.impl.PropertyBindingHandler;
import org.zkoss.bind.impl.PropertyImpl;
import org.zkoss.bind.impl.ReferenceBindingHandler;
import org.zkoss.bind.impl.ReferenceBindingImpl;
import org.zkoss.bind.impl.SaveFormBindingImpl;
import org.zkoss.bind.impl.SavePropertyBindingImpl;
import org.zkoss.bind.impl.SystemConverters;
import org.zkoss.bind.impl.SystemValidators;
import org.zkoss.bind.impl.TemplateRendererCtrl;
import org.zkoss.bind.impl.TemplateResolverImpl;
import org.zkoss.bind.impl.ValidationHelper;
import org.zkoss.bind.impl.WrongValuePropertyImpl;
import org.zkoss.bind.init.ViewModelAnnotationResolvers;
import org.zkoss.bind.init.ZKBinderPhaseListeners;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.ViewModelProxyObject;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.CommandBinding;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.sys.InitChildrenBinding;
import org.zkoss.bind.sys.InitFormBinding;
import org.zkoss.bind.sys.InitPropertyBinding;
import org.zkoss.bind.sys.LoadBinding;
import org.zkoss.bind.sys.LoadChildrenBinding;
import org.zkoss.bind.sys.LoadFormBinding;
import org.zkoss.bind.sys.LoadPropertyBinding;
import org.zkoss.bind.sys.PropertyBinding;
import org.zkoss.bind.sys.ReferenceBinding;
import org.zkoss.bind.sys.SaveBinding;
import org.zkoss.bind.sys.SaveFormBinding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.bind.sys.TemplateResolver;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.bind.sys.debugger.BindingAnnotationInfoChecker;
import org.zkoss.bind.sys.debugger.BindingExecutionInfoCollector;
import org.zkoss.bind.sys.debugger.DebuggerFactory;
import org.zkoss.bind.sys.debugger.impl.DefaultAnnotationInfoChecker;
import org.zkoss.bind.sys.debugger.impl.DefaultExecutionInfoCollector;
import org.zkoss.bind.sys.debugger.impl.info.AddBindingInfo;
import org.zkoss.bind.sys.debugger.impl.info.AddCommandBindingInfo;
import org.zkoss.bind.sys.debugger.impl.info.CommandInfo;
import org.zkoss.bind.sys.debugger.impl.info.EventInfo;
import org.zkoss.bind.sys.debugger.impl.info.NotifyChangeInfo;
import org.zkoss.bind.sys.tracker.Tracker;
import org.zkoss.bind.tracker.impl.TrackerImpl;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.util.CacheMap;
import org.zkoss.util.EmptyCacheMap;
import org.zkoss.util.Pair;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlShadowElement;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.ClientInfoEvent;
import org.zkoss.zk.ui.event.Deferrable;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ExecutionInit;

public class BinderImpl
implements Binder,
BinderCtrl,
Serializable {
    private static final long serialVersionUID = 1463169907348730644L;
    private static final Logger _log = LoggerFactory.getLogger(BinderImpl.class);
    private static final Map<String, Object> RENDERERS = new HashMap<String, Object>();
    private static final String ON_POST_COMMAND = "onPostCommand";
    private static final String ON_VMSGS_CHANGED = "onVMsgsChanged";
    public static final boolean DISABLE_METHOD_CACHE = Boolean.parseBoolean(Library.getProperty((String)"org.zkoss.bind.disableMethodCache", (String)"false"));
    private static final String DISABLE_METHOD_CACHE_PROP = "org.zkoss.bind.disableMethodCache";
    private static final Map<Class<?>, List<Method>> _initMethodCache = DISABLE_METHOD_CACHE ? new EmptyCacheMap() : new CacheMap(600, 1800000);
    private static final Map<Class<?>, List<Method>> _destroyMethodCache = DISABLE_METHOD_CACHE ? new EmptyCacheMap() : new CacheMap(600, 1800000);
    private static final Map<Class<?>, Map<String, CachedItem<Method>>> _commandMethodCache = DISABLE_METHOD_CACHE ? new EmptyCacheMap() : new CacheMap(200, 1800000);
    private static final Map<Class<?>, Map<String, CachedItem<Method>>> _globalCommandMethodCache = DISABLE_METHOD_CACHE ? new EmptyCacheMap() : new CacheMap(200, 1800000);
    private static final CachedItem<Method> NULL_METHOD = new CachedItem<Object>(null);
    private static final String COMMAND_METHOD_MAP_INIT = "$INIT_FLAG$";
    private static final String COMMAND_METHOD_DEFAULT = "$DEFAULT_FLAG$";
    private static final CommandMethodInfoProvider _commandMethodInfoProvider = new CommandMethodInfoProvider(){

        @Override
        public String getAnnotationName() {
            return Command.class.getSimpleName();
        }

        @Override
        public String getDefaultAnnotationName() {
            return DefaultCommand.class.getSimpleName();
        }

        @Override
        public String[] getCommandName(Method method) {
            Command cmd = ViewModelAnnotationResolvers.getAnnotation(method, Command.class);
            return cmd == null ? null : cmd.value();
        }

        @Override
        public boolean isDefaultMethod(Method method) {
            return ViewModelAnnotationResolvers.getAnnotation(method, DefaultCommand.class) != null;
        }
    };
    private static final CommandMethodInfoProvider _globalCommandMethodInfoProvider = new CommandMethodInfoProvider(){

        @Override
        public String getAnnotationName() {
            return GlobalCommand.class.getSimpleName();
        }

        @Override
        public String getDefaultAnnotationName() {
            return DefaultGlobalCommand.class.getSimpleName();
        }

        @Override
        public String[] getCommandName(Method method) {
            GlobalCommand cmd = ViewModelAnnotationResolvers.getAnnotation(method, GlobalCommand.class);
            return cmd == null ? null : cmd.value();
        }

        @Override
        public boolean isDefaultMethod(Method method) {
            return ViewModelAnnotationResolvers.getAnnotation(method, DefaultGlobalCommand.class) != null;
        }
    };
    private Component _rootComp;
    private BindEvaluatorX _eval;
    private transient List<PhaseListener> _phaseListeners;
    private Tracker _tracker;
    private final Component _dummyTarget = new AbstractComponent();
    private final Map<Component, Map<String, List<Binding>>> _bindings;
    private final FormBindingHandler _formBindingHandler;
    private final PropertyBindingHandler _propertyBindingHandler;
    private final ChildrenBindingHandler _childrenBindingHandler;
    private final ReferenceBindingHandler _refBindingHandler;
    private Map<Component, Set<SaveBinding>> _assocFormSaveBindings;
    private Map<Component, Map<SaveBinding, Set<SaveBinding>>> _reversedAssocFormSaveBindings;
    private final Map<BindingKey, CommandEventListener> _listenerMap;
    private final String _quename;
    private final String _quescope;
    private final QueueListener _queueListener;
    private ValidationMessages _validationMessages;
    private Set<BindingKey> _hasValidators;
    private final Map<Component, Map<String, TemplateResolver>> _templateResolvers;
    private boolean _hasGetConverterMethod = true;
    private boolean _hasGetValidatorMethod = true;
    private boolean _init = false;
    private boolean _activating = false;
    private transient DeferredActivator _deferredActivator;
    private transient Map<Object, Set<String>> _saveFormFields;
    private final ImplicitObjectContributor _implicitContributor;
    private static final String REF_HANDLER_CLASS_PROP = "org.zkoss.bind.ReferenceBindingHandler.class";
    private transient Map<String, Method> _matchMediaValues;
    private static final Pattern CALL_OTHER_VM_COMMAND_PATTERN = Pattern.compile("\\$([^.]*)\\..*$");
    public static final String ZKFORMPROXYNOTIFIEDKEY = "$$zkFormProxyNotified$$";
    private transient Map<String, NotifyCommand> _notifyCommands;
    private Map<String, Object> _dynamicAttrs = new HashMap<String, Object>(5){

        @Override
        public Object put(String key, Object value) {
            Object oldValue = super.put(key, null);
            BinderImpl.this.postCommand(key, Collections.singletonMap("", value));
            return oldValue;
        }
    };

    public BinderImpl() {
        this(null, null);
    }

    public BinderImpl(String qname, String qscope) {
        this._bindings = new HashMap<Component, Map<String, List<Binding>>>();
        this._formBindingHandler = new FormBindingHandler();
        this._propertyBindingHandler = new PropertyBindingHandler();
        this._childrenBindingHandler = new ChildrenBindingHandler();
        this._formBindingHandler.setBinder(this);
        this._propertyBindingHandler.setBinder(this);
        this._childrenBindingHandler.setBinder(this);
        this._refBindingHandler = MiscUtil.newInstanceFromProperty(REF_HANDLER_CLASS_PROP, null, ReferenceBindingHandler.class);
        if (this._refBindingHandler != null) {
            this._refBindingHandler.setBinder(this);
        }
        this._implicitContributor = new ImplicitObjectContributorImpl();
        this._assocFormSaveBindings = new HashMap<Component, Set<SaveBinding>>();
        this._reversedAssocFormSaveBindings = new HashMap<Component, Map<SaveBinding, Set<SaveBinding>>>();
        this._hasValidators = new HashSet<BindingKey>();
        this._templateResolvers = new HashMap<Component, Map<String, TemplateResolver>>();
        this._listenerMap = new HashMap<BindingKey, CommandEventListener>();
        this._quename = qname != null && !Strings.isEmpty((String)qname) ? qname : "$ZKBIND_DEFQUE$";
        this._quescope = qscope != null && !Strings.isBlank((String)qscope) ? qscope : "desktop";
        this._queueListener = new QueueListener();
        this.init();
    }

    private void init() {
        this._phaseListeners = new LinkedList<PhaseListener>(ZKBinderPhaseListeners.getSystemPhaseListeners());
        String clz = Library.getProperty((String)"org.zkoss.bind.PhaseListener.class");
        if (!Strings.isEmpty((String)clz)) {
            try {
                this.addPhaseListener((PhaseListener)Classes.forNameByThread((String)clz).newInstance());
            }
            catch (Exception e) {
                _log.error("Error when initial phase listener:" + clz, (Throwable)e);
            }
        }
    }

    @Override
    public void init(Component comp, Object viewModel, Map<String, Object> initArgs) {
        if (this._init) {
            throw new UiException("binder is already initialized");
        }
        this._init = true;
        this._rootComp = comp;
        this.setViewModel(viewModel);
        this._dummyTarget.addEventListener(ON_POST_COMMAND, (EventListener)new PostCommandListener());
        this._dummyTarget.addEventListener(ON_VMSGS_CHANGED, (EventListener)new VMsgsChangedListener());
        this.initQueue();
        if (viewModel instanceof Composer && !(viewModel instanceof BindComposer)) {
            _log.warn("you are using a composer [{}] as a view model", viewModel);
        }
        new AbstractAnnotatedMethodInvoker<Init>(Init.class, _initMethodCache){

            @Override
            protected boolean shouldLookupSuperclass(Init annotation) {
                return annotation.superclass();
            }
        }.invokeMethod(this, initArgs);
        this.initActivator();
        this._matchMediaValues = this.initMatchMediaValues(viewModel);
        if (!this._matchMediaValues.isEmpty()) {
            Clients.response((AuResponse)new AuInvoke(this._rootComp, "$binder"));
            Execution exec = Executions.getCurrent();
            if (exec != null) {
                Cookie[] cookies = ((HttpServletRequest)Executions.getCurrent().getNativeRequest()).getCookies();
                String[] matchMedias = null;
                JSONObject args = new JSONObject();
                if (cookies != null) {
                    for (Cookie c : cookies) {
                        String name = c.getName();
                        String value = c.getValue();
                        try {
                            value = URLDecoder.decode(value, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            _log.error("Failed to decode cookie " + name, (Throwable)e);
                            continue;
                        }
                        if ("ZKMatchMedia".equals(name)) {
                            matchMedias = value.trim().split(",");
                        } else if ("ZKClientInfo".equals(name)) {
                            args.put((Object)"$ZKCLIENTINFO$", JSONValue.parse((String)value));
                        }
                        if (matchMedias == null || args.size() == 0) continue;
                        if (matchMedias[0].isEmpty()) break;
                        for (String s : matchMedias) {
                            if (!this._matchMediaValues.containsKey(s)) continue;
                            Event evt = new Event(ON_POST_COMMAND, this._dummyTarget, (Object)new Object[]{s, args});
                            Events.postEvent((int)-1, (Event)evt);
                        }
                        break;
                    }
                }
            }
        }
    }

    private Map<String, Method> initMatchMediaValues(Object viewModel) {
        HashMap<CallSite, Method> values = new HashMap<CallSite, Method>(6);
        for (Method m : BindUtils.getViewModelClass(viewModel).getMethods()) {
            MatchMedia annomm = ViewModelAnnotationResolvers.getAnnotation(m, MatchMedia.class);
            if (annomm == null) continue;
            for (String string : annomm.value()) {
                String string2 = "$$ZKMATCHMEDIA$$" + string.trim();
                if (values.containsKey(string2)) {
                    throw new UiException("there are more then one MatchMedia method \"" + string2.substring(16) + "\" in class " + viewModel);
                }
                values.put((CallSite)((Object)string2), m);
            }
        }
        return values.isEmpty() ? Collections.emptyMap() : values;
    }

    @Override
    public void destroy(Component comp, Object viewModel) {
        new AbstractAnnotatedMethodInvoker<Destroy>(Destroy.class, _destroyMethodCache){

            @Override
            protected boolean shouldLookupSuperclass(Destroy annotation) {
                return annotation.superclass();
            }
        }.invokeMethod(this, null);
    }

    protected void checkInit() {
        if (!this._init) {
            throw new UiException("binder is not initialized yet");
        }
    }

    public Map<String, List<Binding>> getBindings(Component comp) {
        return this._bindings.get(comp);
    }

    private void doPropertyChange(Object base, String prop) {
        if (_log.isDebugEnabled()) {
            _log.debug("doPropertyChange: base=[{}],prop=[{}]", base, (Object)prop);
        }
        if (base instanceof ReferenceBinding && ((ReferenceBinding)base).getBinder() == this) {
            return;
        }
        if (base instanceof FormProxyObject) {
            Set zkProxyNotified;
            Execution execution = Executions.getCurrent();
            Set set = zkProxyNotified = execution != null ? (Set)execution.getAttribute(ZKFORMPROXYNOTIFIEDKEY) : null;
            if (zkProxyNotified != null) {
                zkProxyNotified.remove(new Pair(base, (Object)prop));
            }
        }
        Tracker tracker = this.getTracker();
        Set<LoadBinding> bindings = tracker.getLoadBindings(base, prop);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        try {
            if (collector != null) {
                collector.pushStack("NOTIFY_CHANGE");
                collector.addInfo(new NotifyChangeInfo(this._rootComp, base, prop, "Size=" + bindings.size()));
            }
            this.doPropertyChange0(base, prop, bindings);
        }
        catch (Exception ex) {
            throw new RuntimeException(MessageFormat.format("doPropertyChange: base=[{0}],prop=[{1}]", base, prop), ex);
        }
        finally {
            if (collector != null) {
                collector.popStack();
            }
        }
    }

    private void doPropertyChange0(Object base, String prop, Set<LoadBinding> bindings) {
        Execution exec = Executions.getCurrent();
        Set skipCheckChildren = (Set)exec.getAttribute(HtmlShadowElement.SKIP_DISTRIBUTED_CHILDREN_PROPERTY_CHANGE);
        for (LoadBinding binding : bindings) {
            Component comp = binding.getComponent();
            if (!(comp instanceof ShadowElement) && (comp == null || comp.getPage() == null)) continue;
            boolean skip = false;
            if (skipCheckChildren != null) {
                for (Component skipComp : skipCheckChildren) {
                    if (!Components.isAncestor((Component)skipComp, (Component)comp)) continue;
                    skip = true;
                    break;
                }
            }
            if (skip) continue;
            BindContext ctx = BindContextUtil.newBindContext(this, binding, false, null, comp, null);
            if (binding instanceof PropertyBinding) {
                BindContextUtil.setConverterArgs(this, comp, ctx, (PropertyBinding)((Object)binding));
            }
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug("doPropertyChange:binding.load() binding=[{}],context=[{}]", (Object)binding, (Object)ctx);
                }
                this.doPrePhase(Phase.LOAD_BINDING, ctx);
                binding.load(ctx);
            }
            catch (Exception ex) {
                throw new RuntimeException(MessageFormat.format("doPropertyChange:binding.load() binding=[{0}],context=[{1}]", binding, ctx), ex);
            }
            finally {
                this.doPostPhase(Phase.LOAD_BINDING, ctx);
            }
            if (binding instanceof ReferenceBinding && binding != base) {
                this.notifyChange(binding, ".");
            }
            if (this._validationMessages == null) continue;
            String attr = null;
            if (binding instanceof PropertyBinding) {
                attr = ((PropertyBinding)((Object)binding)).getFieldName();
            } else if (binding instanceof FormBinding) {
                attr = ((FormBinding)((Object)binding)).getFormId();
            }
            if (attr == null || !this.hasValidator(comp, attr)) continue;
            this._validationMessages.clearMessages(comp, attr);
        }
    }

    @Override
    public void setViewModel(Object vm) {
        this.checkInit();
        this._rootComp.setAttribute("$VM$", vm);
        this._hasGetConverterMethod = true;
        this._hasGetValidatorMethod = true;
        this.collectNotifyCommands(vm);
    }

    private void collectNotifyCommands(Object vm) {
        Class<?> viewModelClz = BindUtils.getViewModelClass(vm);
        NotifyCommands commands = ViewModelAnnotationResolvers.getAnnotation(viewModelClz, NotifyCommands.class);
        NotifyCommand command = ViewModelAnnotationResolvers.getAnnotation(viewModelClz, NotifyCommand.class);
        if (this._notifyCommands != null) {
            this._notifyCommands.clear();
        }
        if (command != null) {
            for (String cmd : command.value()) {
                this._notifyCommands = AllocUtil.inst.putMap(this._notifyCommands, cmd, command);
            }
        }
        if (commands != null) {
            for (NotifyCommand nc : commands.value()) {
                for (String cmd : nc.value()) {
                    this._notifyCommands = AllocUtil.inst.putMap(this._notifyCommands, cmd, nc);
                }
            }
        }
    }

    @Override
    public Object getViewModel() {
        this.checkInit();
        return BinderImpl.getOriginViewModel(this._rootComp.getAttribute("$VM$"));
    }

    private Object getViewModelInView() {
        this.checkInit();
        return this._rootComp.getAttribute("$VM$");
    }

    private static Object getOriginViewModel(Object vm) {
        if (vm instanceof ViewModelProxyObject) {
            vm = ((ViewModelProxyObject)vm).getOriginObject();
        }
        return vm;
    }

    @Override
    public Converter getConverter(String name) {
        this.checkInit();
        Converter converter = null;
        if (this._hasGetConverterMethod) {
            Object vm = this.getViewModel();
            Class<?> clz = BindUtils.getViewModelClass(vm);
            Method m = null;
            Object result = null;
            try {
                m = clz.getMethod("getConverter", String.class);
            }
            catch (SecurityException x) {
                this._hasGetConverterMethod = false;
            }
            catch (NoSuchMethodException e) {
                this._hasGetConverterMethod = false;
            }
            if (m != null) {
                try {
                    result = m.invoke(vm, name);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    this._hasGetConverterMethod = false;
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                if (result != null && !(result instanceof Converter)) {
                    this._hasGetConverterMethod = false;
                } else {
                    converter = (Converter)result;
                }
            }
        }
        if (converter == null) {
            converter = SystemConverters.get(name);
        }
        if (converter == null) {
            throw new UiException("Cannot find converter:" + name);
        }
        return converter;
    }

    @Override
    public Validator getValidator(String name) {
        this.checkInit();
        Validator validator = null;
        if (this._hasGetValidatorMethod) {
            Object vm = this.getViewModel();
            Class<?> clz = BindUtils.getViewModelClass(vm);
            Method m = null;
            Object result = null;
            try {
                m = clz.getMethod("getValidator", String.class);
            }
            catch (SecurityException x) {
                this._hasGetValidatorMethod = false;
            }
            catch (NoSuchMethodException e) {
                this._hasGetValidatorMethod = false;
            }
            if (m != null) {
                try {
                    result = m.invoke(vm, name);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    this._hasGetValidatorMethod = false;
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                if (result != null && !(result instanceof Validator)) {
                    this._hasGetValidatorMethod = false;
                } else {
                    validator = (Validator)result;
                }
            }
        }
        if (validator == null) {
            validator = SystemValidators.get(name);
        }
        if (validator == null) {
            throw new UiException("Cannot find validator:" + name);
        }
        return validator;
    }

    protected Object getRenderer(String name) {
        Object renderer = RENDERERS.get(name);
        if (renderer == null && name.indexOf(46) > 0) {
            try {
                renderer = Classes.newInstanceByThread((String)name);
                RENDERERS.put(name, renderer);
            }
            catch (IllegalAccessException e) {
                throw UiException.Aide.wrap((Throwable)e, (String)e.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return renderer;
    }

    @Override
    public BindEvaluatorX getEvaluatorX() {
        if (this._eval == null) {
            this._eval = BindEvaluatorXUtil.createEvaluator(null);
        }
        return this._eval;
    }

    @Override
    public void storeForm(Component comp, String id, Form form) {
        Map<Object, Set<String>> initSaveFormMap;
        Set<String> remove;
        String oldid = (String)comp.getAttribute("$FORM_ID$", 0);
        if (oldid != null && !oldid.equals(id)) {
            throw new IllegalArgumentException("try to store 2 forms in same component id : 1st " + oldid + ", 2nd " + id);
        }
        Form oldForm = (Form)comp.getAttribute(id);
        if (oldForm == form) {
            return;
        }
        comp.setAttribute("$FORM_ID$", (Object)id);
        comp.setAttribute(id, (Object)form);
        if (form instanceof FormLegacyExt) {
            FormLegacyExt fex = (FormLegacyExt)((Object)form);
            comp.setAttribute(id + "Status", (Object)fex.getStatus());
            if (oldForm instanceof FormLegacyExt) {
                for (String fn : ((FormLegacyExt)((Object)oldForm)).getLoadFieldNames()) {
                    fex.addLoadFieldName(fn);
                }
                for (String fn : ((FormLegacyExt)((Object)oldForm)).getSaveFieldNames()) {
                    fex.addSaveFieldName(fn);
                }
            }
            return;
        }
        if (form instanceof Form) {
            Form fex = form;
            comp.setAttribute(id + "Status", (Object)fex.getFormStatus());
        }
        if ((remove = (initSaveFormMap = this.initSaveFormMap()).remove(oldForm)) != null) {
            Set<String> set = initSaveFormMap.get(form);
            if (set == null) {
                set = new HashSet<String>(16);
                initSaveFormMap.put(form, set);
            }
            set.addAll(remove);
        }
    }

    @Override
    public Form getForm(Component comp, String id) {
        String oldid = (String)comp.getAttribute("$FORM_ID$", 0);
        if (oldid == null || !oldid.equals(id)) {
            return null;
        }
        return (Form)comp.getAttribute(id);
    }

    private void removeForm(Component comp) {
        String id = (String)comp.getAttribute("$FORM_ID$", 0);
        if (id != null) {
            comp.removeAttribute("$FORM_ID$");
            Object form = comp.removeAttribute(id);
            if (form != null) {
                this.initSaveFormMap().remove(form);
            }
            comp.removeAttribute(id + "Status");
        }
    }

    private void initFormLegacyBean(Component comp, String id, Object bean) {
        Form form = this.getForm(comp, id);
        if (form == null && bean instanceof FormLegacy) {
            this.storeForm(comp, id, new SimpleForm());
        }
    }

    @Override
    public void addFormInitBinding(Component comp, String id, String initExpr, Map<String, Object> initArgs) {
        this.checkInit();
        if (Strings.isBlank((String)id)) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("form id is blank", comp));
        }
        if (initExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("initExpr is null for component " + comp + ", form " + id, comp));
        }
        this.addFormInitBinding0(comp, id, initExpr, initArgs);
    }

    private void addFormInitBinding0(Component comp, String formId, String initExpr, Map<String, Object> bindingArgs) {
        if (_log.isDebugEnabled()) {
            _log.debug("add init-form-binding: comp=[{}],form=[{}],expr=[{}]", new Object[]{comp, formId, initExpr});
        }
        String attr = formId;
        InitFormBinding binding = this.newInitFormBinding(comp, attr, initExpr, bindingArgs);
        this.addBinding(comp, attr, binding);
        BindingKey bkey = this.getBindingKey(comp, attr);
        this._formBindingHandler.addInitBinding(bkey, binding);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new AddBindingInfo("form-init", comp, null, binding.getPropertyString(), formId, bindingArgs, null));
        }
        BindContext ctx = BindContextUtil.newBindContext(this, binding, false, null, comp, null);
        Object bean = this.getEvaluatorX().getValue(ctx, comp, ((InitFormBindingImpl)binding)._accessInfo.getProperty());
        this.initFormLegacyBean(comp, formId, bean);
    }

    @Override
    public void addFormLoadBindings(Component comp, String id, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs) {
        this.checkInit();
        if (Strings.isBlank((String)id)) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("form id is blank", comp));
        }
        if (loadExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("loadExpr is null for component " + comp + ", form " + id, comp));
        }
        this.addFormLoadBindings0(comp, id, loadExpr, beforeCmds, afterCmds, bindingArgs);
    }

    @Override
    public void addFormSaveBindings(Component comp, String id, String saveExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        this.checkInit();
        if (Strings.isBlank((String)id)) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("form id is blank", comp));
        }
        if (saveExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("saveExpr is null for component " + comp + ", form " + id, comp));
        }
        this.addFormSaveBindings0(comp, id, saveExpr, beforeCmds, afterCmds, bindingArgs, validatorExpr, validatorArgs);
    }

    private void addFormLoadBindings0(Component comp, String formId, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs) {
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        String attr = formId;
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (prompt) {
            LoadFormBinding binding = this.newLoadFormBinding(comp, formId, loadExpr, ConditionType.PROMPT, null, bindingArgs);
            this.addBinding(comp, attr, binding);
            BindingKey bkey = this.getBindingKey(comp, attr);
            this._formBindingHandler.addLoadPromptBinding(bkey, binding);
            if (collector != null) {
                collector.addInfo(new AddBindingInfo("form-load", comp, null, binding.getPropertyString(), formId, bindingArgs, null));
            }
        } else {
            LoadFormBinding binding;
            if (beforeCmds != null && beforeCmds.length > 0) {
                for (String cmd : beforeCmds) {
                    binding = this.newLoadFormBinding(comp, formId, loadExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add before command-load-form-binding: comp=[{}],attr=[{}],expr=[{}],command=[{}]", new Object[]{comp, attr, loadExpr, cmd});
                    }
                    this._formBindingHandler.addLoadBeforeBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("form-load", comp, "before = '" + cmd + "'", binding.getPropertyString(), formId, bindingArgs, null));
                }
            }
            if (afterCmds != null && afterCmds.length > 0) {
                for (String cmd : afterCmds) {
                    binding = this.newLoadFormBinding(comp, formId, loadExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add after command-load-form-binding: comp=[{}],attr=[{}],expr=[{}],command=[{}]", new Object[]{comp, attr, loadExpr, cmd});
                    }
                    this._formBindingHandler.addLoadAfterBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("form-load", comp, "after = '" + cmd + "'", binding.getPropertyString(), formId, bindingArgs, null));
                }
            }
        }
    }

    private void addFormSaveBindings0(Component comp, String formId, String saveExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        BindingKey bkey;
        SaveFormBinding binding;
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        if (prompt) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("a save-form-binding have to set with a before|after command condition", comp));
        }
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (beforeCmds != null && beforeCmds.length > 0) {
            for (String cmd : beforeCmds) {
                binding = this.newSaveFormBinding(comp, formId, saveExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs, validatorExpr, validatorArgs);
                this.addBinding(comp, formId, binding);
                if (_log.isDebugEnabled()) {
                    _log.debug("add before command-save-form-binding: comp=[{}],attr=[{}],expr=[{}],command=[{}]", new Object[]{comp, formId, saveExpr, cmd});
                }
                this._formBindingHandler.addSaveBeforeBinding(cmd, binding);
                if (collector == null) continue;
                collector.addInfo(new AddBindingInfo("form-save", comp, "before = '" + cmd + "'", formId, binding.getPropertyString(), bindingArgs, null));
            }
        }
        if (afterCmds != null && afterCmds.length > 0) {
            for (String cmd : afterCmds) {
                binding = this.newSaveFormBinding(comp, formId, saveExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs, validatorExpr, validatorArgs);
                this.addBinding(comp, formId, binding);
                if (_log.isDebugEnabled()) {
                    _log.debug("add after command-save-form-binding: comp=[{}],attr=[{}],expr=[{}],command=[{}]", new Object[]{comp, formId, saveExpr, cmd});
                }
                this._formBindingHandler.addSaveAfterBinding(cmd, binding);
                if (collector == null) continue;
                collector.addInfo(new AddBindingInfo("form-save", comp, "after = '" + cmd + "'", formId, binding.getPropertyString(), bindingArgs, null));
            }
        }
        if (validatorExpr != null && !this._hasValidators.contains(bkey = this.getBindingKey(comp, formId))) {
            this._hasValidators.add(bkey);
        }
    }

    @Override
    public void addPropertyInitBinding(Component comp, String attr, String initExpr, Map<String, Object> initArgs, String converterExpr, Map<String, Object> converterArgs) {
        this.checkInit();
        if (initExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("initExpr is null for " + attr + " of " + comp, comp));
        }
        if (Strings.isBlank((String)converterExpr) && (converterExpr = this.getSystemConverter(comp, attr)) != null) {
            converterExpr = "'" + (String)converterExpr + "'";
        }
        this.addPropertyInitBinding0(comp, attr, initExpr, initArgs, (String)converterExpr, converterArgs);
        this.initRendererIfAny(comp, attr);
    }

    @Override
    public void addPropertyLoadBindings(Component comp, String attr, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        this.checkInit();
        if (loadExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("loadExpr is null for component " + comp + ", attr " + attr, comp));
        }
        if (Strings.isBlank((String)converterExpr) && (converterExpr = this.getSystemConverter(comp, attr)) != null) {
            converterExpr = "'" + (String)converterExpr + "'";
        }
        this.addPropertyLoadBindings0(comp, attr, loadExpr, beforeCmds, afterCmds, bindingArgs, (String)converterExpr, converterArgs);
        this.initRendererIfAny(comp, attr);
    }

    @Override
    public void addPropertySaveBindings(Component comp, String attr, String saveExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        this.checkInit();
        if (saveExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("saveExpr is null for component " + comp + ", attr " + attr, comp));
        }
        if (Strings.isBlank((String)converterExpr) && (converterExpr = this.getSystemConverter(comp, attr)) != null) {
            converterExpr = "'" + (String)converterExpr + "'";
        }
        if (Strings.isBlank((String)validatorExpr) && (validatorExpr = this.getSystemValidator(comp, attr)) != null) {
            validatorExpr = "'" + (String)validatorExpr + "'";
        }
        this.addPropertySaveBindings0(comp, attr, saveExpr, beforeCmds, afterCmds, bindingArgs, (String)converterExpr, converterArgs, (String)validatorExpr, validatorArgs);
    }

    private void addPropertyInitBinding0(Component comp, String attr, String initExpr, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getSystemAnnotation(compCtrl, attr);
        String loadrep = null;
        Class attrType = null;
        if (ann != null) {
            Map attrs = ann.getAttributes();
            loadrep = AnnotationUtil.testString((String[])attrs.get("LOAD_REPLACEMENT"), ann);
            String type = AnnotationUtil.testString((String[])attrs.get("LOAD_TYPE"), ann);
            if (type != null) {
                try {
                    attrType = Classes.forNameByThread((String)type);
                }
                catch (ClassNotFoundException e) {
                    throw UiException.Aide.wrap((Throwable)e, (String)e.getMessage());
                }
            }
        }
        String string = loadrep = loadrep == null ? attr : loadrep;
        if (_log.isDebugEnabled()) {
            _log.debug("add init-binding: comp=[{}],attr=[{}],expr=[{}],converter=[{}]", new Object[]{comp, attr, initExpr, converterArgs});
        }
        InitPropertyBinding binding = this.newInitPropertyBinding(comp, attr, loadrep, attrType, initExpr, bindingArgs, converterExpr, converterArgs);
        this.addBinding(comp, attr, binding);
        BindingKey bkey = this.getBindingKey(comp, attr);
        this._propertyBindingHandler.addInitBinding(bkey, binding);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new AddBindingInfo("prop-init", comp, null, binding.getPropertyString(), binding.getFieldName(), bindingArgs, null));
        }
    }

    private String getSystemConverter(Component comp, String attr) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getSystemAnnotation(compCtrl, attr);
        if (ann != null) {
            Map attrs = ann.getAttributes();
            return AnnotationUtil.testString((String[])attrs.get("CONVERTER"), ann);
        }
        return null;
    }

    private String getSystemValidator(Component comp, String attr) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getSystemAnnotation(compCtrl, attr);
        if (ann != null) {
            Map attrs = ann.getAttributes();
            return AnnotationUtil.testString((String[])attrs.get("VALIDATOR"), ann);
        }
        return null;
    }

    private void initRendererIfAny(Component comp, String attr) {
        String rendererName;
        Object installed = comp.getAttribute("$RENDERER_INSTALLED$");
        if (installed != null) {
            return;
        }
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getSystemAnnotation(compCtrl, null);
        Map attrs = ann != null ? ann.getAttributes() : null;
        String installAttr = "model";
        if (attrs != null && "model".equals(attr) && (rendererName = AnnotationUtil.testString((String[])attrs.get("RENDERER"), ann)) != null) {
            String[] values = null;
            values = rendererName.indexOf("=") != -1 ? rendererName.split("=", 2) : rendererName.split(":", 2);
            if (values != null) {
                Object renderer = this.getRenderer(values[1]);
                Object old = null;
                try {
                    old = Fields.get((Object)comp, (String)values[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (old == null) {
                    try {
                        Fields.set((Object)comp, (String)values[0], (Object)renderer, (boolean)false);
                    }
                    catch (Exception e) {
                        throw UiException.Aide.wrap((Throwable)e, (String)e.getMessage());
                    }
                    if (renderer instanceof TemplateRendererCtrl) {
                        ((TemplateRendererCtrl)renderer).setAttributeName(attr);
                    }
                }
                comp.setAttribute("$RENDERER_INSTALLED$", (Object)"");
            }
        }
    }

    protected LoadPropertyBinding newLoadPropertyBinding(Component comp, String attr, String loadAttr, Class<?> attrType, String loadExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        return new LoadPropertyBindingImpl(this, comp, attr, loadAttr, attrType, loadExpr, conditionType, command, bindingArgs, converterExpr, converterArgs);
    }

    protected SavePropertyBinding newSavePropertyBinding(Component comp, String attr, String saveAttr, String saveExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        return new SavePropertyBindingImpl(this, comp, attr, saveAttr, saveExpr, conditionType, command, bindingArgs, converterExpr, converterArgs, validatorExpr, validatorArgs);
    }

    protected InitPropertyBinding newInitPropertyBinding(Component comp, String attr, String loadAttr, Class<?> attrType, String initExpr, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        return new InitPropertyBindingImpl(this, comp, attr, loadAttr, attrType, initExpr, bindingArgs, converterExpr, converterArgs);
    }

    protected InitChildrenBinding newInitChildrenBinding(Component comp, String initExpr, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        return new InitChildrenBindingImpl(this, comp, initExpr, bindingArgs, converterExpr, converterArgs);
    }

    protected LoadChildrenBinding newLoadChildrenBinding(Component comp, String loadExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        return new LoadChildrenBindingImpl(this, comp, loadExpr, conditionType, command, bindingArgs, converterExpr, converterArgs);
    }

    protected CommandBinding newCommandBinding(Component comp, String evtnm, String cmdScript, Map<String, Object> args) {
        return new CommandBindingImpl(this, comp, evtnm, cmdScript, args);
    }

    protected InitFormBinding newInitFormBinding(Component comp, String formId, String initExpr, Map<String, Object> bindingArgs) {
        return new InitFormBindingImpl(this, comp, formId, initExpr, bindingArgs);
    }

    protected LoadFormBinding newLoadFormBinding(Component comp, String formId, String loadExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs) {
        return new LoadFormBindingImpl(this, comp, formId, loadExpr, conditionType, command, bindingArgs);
    }

    protected SaveFormBinding newSaveFormBinding(Component comp, String formId, String saveExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        return new SaveFormBindingImpl(this, comp, formId, saveExpr, conditionType, command, bindingArgs, validatorExpr, validatorArgs);
    }

    private void addPropertyLoadBindings0(Component comp, String attr, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getSystemAnnotation(compCtrl, attr);
        String evtnm = null;
        String loadRep = null;
        Class attrType = null;
        if (ann != null) {
            Map attrs = ann.getAttributes();
            String rw = AnnotationUtil.testString((String[])attrs.get("ACCESS"), ann);
            if (rw != null && !"both".equals(rw) && !"load".equals(rw)) {
                return;
            }
            evtnm = AnnotationUtil.testString((String[])attrs.get("LOAD_EVENT"), ann);
            loadRep = AnnotationUtil.testString((String[])attrs.get("LOAD_REPLACEMENT"), ann);
            String type = AnnotationUtil.testString((String[])attrs.get("LOAD_TYPE"), ann);
            if (type != null) {
                try {
                    attrType = Classes.forNameByThread((String)type);
                }
                catch (ClassNotFoundException e) {
                    throw UiException.Aide.wrap((Throwable)e, (String)e.getMessage());
                }
            }
        }
        String string = loadRep = loadRep == null ? attr : loadRep;
        if (prompt) {
            BindingKey bkey;
            if (_log.isDebugEnabled()) {
                _log.debug("add event(prompt)-load-binding: comp=[{}],attr=[{}],expr=[{}],evtnm=[{}],converter=[{}]", new Object[]{comp, attr, loadExpr, evtnm, converterArgs});
            }
            LoadPropertyBinding binding = this.newLoadPropertyBinding(comp, attr, loadRep, attrType, loadExpr, ConditionType.PROMPT, null, bindingArgs, converterExpr, converterArgs);
            this.addBinding(comp, attr, binding);
            if (evtnm != null) {
                this.registerCommandEventListener(comp, evtnm);
                this.addBinding(comp, evtnm, binding);
                bkey = this.getBindingKey(comp, evtnm);
                this._propertyBindingHandler.addLoadEventBinding(comp, bkey, binding);
            }
            bkey = this.getBindingKey(comp, attr);
            this._propertyBindingHandler.addLoadPromptBinding(comp, bkey, binding);
            if (collector != null) {
                collector.addInfo(new AddBindingInfo("prop-load", comp, evtnm, binding.getPropertyString(), binding.getFieldName(), bindingArgs, null));
            }
        } else {
            LoadPropertyBinding binding;
            if (beforeCmds != null && beforeCmds.length > 0) {
                for (String cmd : beforeCmds) {
                    binding = this.newLoadPropertyBinding(comp, attr, loadRep, attrType, loadExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs, converterExpr, converterArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add before command-load-binding: comp=[{}],att=r[{}],expr=[{}],converter=[{}]", new Object[]{comp, attr, loadExpr, converterExpr});
                    }
                    this._propertyBindingHandler.addLoadBeforeBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("prop-load", comp, "before = '" + cmd + "'", binding.getPropertyString(), binding.getFieldName(), bindingArgs, null));
                }
            }
            if (afterCmds != null && afterCmds.length > 0) {
                for (String cmd : afterCmds) {
                    binding = this.newLoadPropertyBinding(comp, attr, loadRep, attrType, loadExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs, converterExpr, converterArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add after command-load-binding: comp=[{}],att=r[{}],expr=[{}],converter=[{}]", new Object[]{comp, attr, loadExpr, converterExpr});
                    }
                    this._propertyBindingHandler.addLoadAfterBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("prop-load", comp, "after = '" + cmd + "'", binding.getPropertyString(), binding.getFieldName(), bindingArgs, null));
                }
            }
        }
    }

    private void addPropertySaveBindings0(Component comp, String attr, String saveExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        BindingKey bkey;
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = AnnotationUtil.getSystemAnnotation(compCtrl, attr);
        String evtnm = null;
        String saveRep = null;
        if (ann != null) {
            Map attrs = ann.getAttributes();
            String rw = AnnotationUtil.testString((String[])attrs.get("ACCESS"), ann);
            if (!"both".equals(rw) && !"save".equals(rw)) {
                if (BinderUtil.hasContext() && BinderUtil.getContext().isIgnoreAccessCreationWarn()) {
                    return;
                }
                _log.warn(MiscUtil.formatLocationMessage("component " + comp + " doesn't support to save attribute " + attr, comp));
                return;
            }
            evtnm = AnnotationUtil.testString((String[])attrs.get("SAVE_EVENT"), ann);
            saveRep = AnnotationUtil.testString((String[])attrs.get("SAVE_REPLACEMENT"), ann);
        }
        if (evtnm == null) {
            if (BinderUtil.hasContext() && BinderUtil.getContext().isIgnoreAccessCreationWarn()) {
                return;
            }
            _log.warn(MiscUtil.formatLocationMessage("component " + comp + " doesn't has event to save attribute " + attr, comp));
            return;
        }
        String string = saveRep = saveRep == null ? attr : saveRep;
        if (prompt) {
            SavePropertyBinding binding = this.newSavePropertyBinding(comp, attr, saveRep, saveExpr, ConditionType.PROMPT, null, bindingArgs, converterExpr, converterArgs, validatorExpr, validatorArgs);
            this.addBinding(comp, attr, binding);
            if (_log.isDebugEnabled()) {
                _log.debug("add event(prompt)-save-binding: comp=[{}],attr=[{}],expr=[{}],evtnm=[{}],converter=[{}],validate=[{}]", new Object[]{comp, attr, saveExpr, evtnm, converterExpr, validatorExpr});
            }
            this.registerCommandEventListener(comp, evtnm);
            this.addBinding(comp, evtnm, binding);
            BindingKey bkey2 = this.getBindingKey(comp, evtnm);
            this._propertyBindingHandler.addSavePromptBinding(comp, bkey2, binding);
            if (collector != null) {
                collector.addInfo(new AddBindingInfo("prop-save", comp, null, binding.getFieldName(), binding.getPropertyString(), bindingArgs, null));
            }
        } else {
            SavePropertyBinding binding;
            if (beforeCmds != null && beforeCmds.length > 0) {
                for (String cmd : beforeCmds) {
                    binding = this.newSavePropertyBinding(comp, attr, saveRep, saveExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs, converterExpr, converterArgs, validatorExpr, validatorArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add before command-save-binding: comp=[{}],att=r[{}],expr=[{}],converter=[{}],validator=[{}]", new Object[]{comp, attr, saveExpr, converterExpr, validatorExpr});
                    }
                    this._propertyBindingHandler.addSaveBeforeBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("prop-save", comp, "before = '" + cmd + "'", binding.getFieldName(), binding.getPropertyString(), bindingArgs, null));
                }
            }
            if (afterCmds != null && afterCmds.length > 0) {
                for (String cmd : afterCmds) {
                    binding = this.newSavePropertyBinding(comp, attr, saveRep, saveExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs, converterExpr, converterArgs, validatorExpr, validatorArgs);
                    this.addBinding(comp, attr, binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add after command-save-binding: comp=[{}],att=r[{}],expr=[{}],converter=[{}],validator=[{}]", new Object[]{comp, attr, saveExpr, converterExpr, validatorExpr});
                    }
                    this._propertyBindingHandler.addSaveAfterBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("prop-save", comp, "after = '" + cmd + "'", binding.getFieldName(), binding.getPropertyString(), bindingArgs, null));
                }
            }
        }
        if (validatorExpr != null && !this._hasValidators.contains(bkey = this.getBindingKey(comp, attr))) {
            this._hasValidators.add(bkey);
        }
    }

    @Override
    public void addChildrenInitBinding(Component comp, String initExpr, Map<String, Object> initArgs, String converterExpr, Map<String, Object> converterArgs) {
        this.checkInit();
        if (initExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("initExpr is null for children of " + comp, comp));
        }
        this.addChildrenInitBinding0(comp, initExpr, initArgs, converterExpr, converterArgs);
    }

    @Override
    public void addChildrenLoadBindings(Component comp, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        this.checkInit();
        if (loadExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("loadExpr is null for children of " + comp, comp));
        }
        this.addChildrenLoadBindings0(comp, loadExpr, beforeCmds, afterCmds, bindingArgs, converterExpr, converterArgs);
    }

    private void addChildrenInitBinding0(Component comp, String initExpr, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        if (_log.isDebugEnabled()) {
            _log.debug("add children-init-binding: comp=[{}],expr=[{}]", (Object)comp, (Object)initExpr);
        }
        InitChildrenBinding binding = this.newInitChildrenBinding(comp, initExpr, bindingArgs, converterExpr, converterArgs);
        this.addBinding(comp, "$CHILDREN$", binding);
        BindingKey bkey = this.getBindingKey(comp, "$CHILDREN$");
        this._childrenBindingHandler.addInitBinding(bkey, binding);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new AddBindingInfo("children-init", comp, null, binding.getPropertyString(), null, bindingArgs, null));
        }
    }

    private void addChildrenLoadBindings0(Component comp, String loadExpr, String[] beforeCmds, String[] afterCmds, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        boolean prompt = this.isPrompt(beforeCmds, afterCmds);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (prompt) {
            if (_log.isDebugEnabled()) {
                _log.debug("add event(prompt)-children-load-binding: comp=[{}],expr=[{}]", (Object)comp, (Object)loadExpr);
            }
            LoadChildrenBindingImpl binding = new LoadChildrenBindingImpl(this, comp, loadExpr, ConditionType.PROMPT, null, bindingArgs, converterExpr, converterArgs);
            this.addBinding(comp, "$CHILDREN$", binding);
            BindingKey bkey = this.getBindingKey(comp, "$CHILDREN$");
            this._childrenBindingHandler.addLoadPromptBinding(comp, bkey, binding);
            if (collector != null) {
                collector.addInfo(new AddBindingInfo("children-load", comp, null, binding.getPropertyString(), null, bindingArgs, null));
            }
        } else {
            LoadChildrenBindingImpl binding;
            if (beforeCmds != null && beforeCmds.length > 0) {
                for (String cmd : beforeCmds) {
                    binding = new LoadChildrenBindingImpl(this, comp, loadExpr, ConditionType.BEFORE_COMMAND, cmd, bindingArgs, converterExpr, converterArgs);
                    this.addBinding(comp, "$CHILDREN$", binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add before command children-load-binding: comp=[{}],expr=[{}],cmd=[{}]", new Object[]{comp, loadExpr, cmd});
                    }
                    this._childrenBindingHandler.addLoadBeforeBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("children-load", comp, "before = '" + cmd + "'", binding.getPropertyString(), null, bindingArgs, null));
                }
            }
            if (afterCmds != null && afterCmds.length > 0) {
                for (String cmd : afterCmds) {
                    binding = new LoadChildrenBindingImpl(this, comp, loadExpr, ConditionType.AFTER_COMMAND, cmd, bindingArgs, converterExpr, converterArgs);
                    this.addBinding(comp, "$CHILDREN$", binding);
                    if (_log.isDebugEnabled()) {
                        _log.debug("add after command children-load-binding: comp=[{}],expr=[{}],cmd=[{}]", new Object[]{comp, loadExpr, cmd});
                    }
                    this._childrenBindingHandler.addLoadAfterBinding(cmd, binding);
                    if (collector == null) continue;
                    collector.addInfo(new AddBindingInfo("children-load", comp, "after = '" + cmd + "'", binding.getPropertyString(), null, bindingArgs, null));
                }
            }
        }
    }

    @Override
    public void addReferenceBinding(Component comp, String attr, String loadExpr, Map<String, Object> bindingArgs) {
        this.checkInit();
        if (loadExpr == null) {
            throw new IllegalArgumentException(MiscUtil.formatLocationMessage("loadExpr is null for reference of " + comp, comp));
        }
        this.addReferenceBinding0(comp, attr, loadExpr, bindingArgs);
    }

    private void addReferenceBinding0(Component comp, String attr, String loadExpr, Map<String, Object> bindingArgs) {
        if (_log.isDebugEnabled()) {
            _log.debug("add reference-binding: comp=[{}],attr=[{}],expr=[{}]", new Object[]{comp, attr, loadExpr});
        }
        ReferenceBindingImpl binding = new ReferenceBindingImpl(this, comp, attr, loadExpr);
        if (this._refBindingHandler == null) {
            throw new UiException(MiscUtil.formatLocationMessage("ref binding handler is not supported in current runtime.", comp));
        }
        this._refBindingHandler.addReferenceBinding(comp, attr, binding);
        this.addBinding(comp, attr, binding);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new AddBindingInfo("reference", comp, null, binding.getPropertyString(), "self." + attr, bindingArgs, null));
        }
    }

    private boolean isPrompt(String[] beforeCmds, String[] afterCmds) {
        return !(beforeCmds != null && beforeCmds.length != 0 || afterCmds != null && afterCmds.length != 0);
    }

    @Override
    public void addCommandBinding(Component comp, String evtnm, String commandExpr, Map<String, Object> args) {
        this.checkInit();
        CommandBinding binding = this.newCommandBinding(comp, evtnm, commandExpr, args);
        this.addBinding(comp, evtnm, binding);
        this.registerCommandEventListener(comp, evtnm, binding, false);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new AddCommandBindingInfo("viewmodel", comp, evtnm, binding.getCommandString(), args, null));
        }
    }

    @Override
    public void addGlobalCommandBinding(Component comp, String evtnm, String commandExpr, Map<String, Object> args) {
        this.checkInit();
        CommandBinding binding = this.newCommandBinding(comp, evtnm, commandExpr, args);
        this.addBinding(comp, evtnm, binding);
        this.registerCommandEventListener(comp, evtnm, binding, true);
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new AddCommandBindingInfo("global", comp, evtnm, binding.getCommandString(), args, null));
        }
    }

    private void registerCommandEventListener(Component comp, String evtnm, CommandBinding command, boolean global) {
        CommandEventListener listener = this.getCommandEventListener(comp, evtnm);
        if (global) {
            listener.setGlobalCommand(command);
        } else {
            listener.setCommand(command);
        }
    }

    private void registerCommandEventListener(Component comp, String evtnm) {
        CommandEventListener listener = this.getCommandEventListener(comp, evtnm);
        listener.setPrompt(true);
    }

    private CommandEventListener getCommandEventListener(Component comp, String evtnm) {
        BindingKey bkey = this.getBindingKey(comp, evtnm);
        CommandEventListener listener = this._listenerMap.get(bkey);
        if (listener == null) {
            listener = new CommandEventListener(comp);
            comp.addEventListener(evtnm, (EventListener)listener);
            this._listenerMap.put(bkey, listener);
        }
        return listener;
    }

    private void removeEventCommandListenerIfExists(Component comp, String evtnm) {
        BindingKey bkey = this.getBindingKey(comp, evtnm);
        CommandEventListener listener = this._listenerMap.remove(bkey);
        if (listener != null) {
            comp.removeEventListener(evtnm, (EventListener)listener);
        }
    }

    @Override
    public boolean isActivating() {
        return this._activating;
    }

    private void notifyVMsgsChanged() {
        if (this._validationMessages != null) {
            Events.postEvent((int)-1, (Component)this._dummyTarget, (Event)new Event(ON_VMSGS_CHANGED));
        }
    }

    @Override
    public int sendCommand(String command, Map<String, Object> args) {
        int result;
        this.checkInit();
        HashSet<Property> notifys = new HashSet<Property>();
        Event evt = null;
        if (args != null) {
            if (args.containsKey("$ZKCLIENTINFO$")) {
                HashMap<String, Object> inf = new HashMap<String, Object>();
                inf.put("", args.get("$ZKCLIENTINFO$"));
                evt = ClientInfoEvent.getClientInfoEvent((AuRequest)new AuRequest(this._rootComp.getDesktop(), command, inf));
            } else {
                Event uploadInfoEvt = (Event)args.get("$ZKCLIENTUPLOADINFO$");
                if (uploadInfoEvt != null) {
                    evt = uploadInfoEvt;
                }
            }
        }
        if ((result = this.doCommand(this._rootComp, null, command, evt, args, notifys)) == 1 && this._validationMessages != null) {
            notifys.add(new PropertyImpl(this._validationMessages, ".", null));
        }
        this.fireNotifyChanges(notifys);
        return result;
    }

    protected void fireNotifyChanges(Set<Property> notifys) {
        for (Property prop : notifys) {
            this.notifyChange(prop.getBase(), prop.getProperty());
        }
    }

    @Override
    public void postCommand(String command, Map<String, Object> args) {
        this.checkInit();
        Event evt = new Event(ON_POST_COMMAND, this._dummyTarget, (Object)new Object[]{command, args});
        Events.postEvent((Event)evt);
    }

    private int doCommand(Component comp, CommandBinding commandBinding, String command, Event evt, Map<String, Object> commandArgs, Set<Property> notifys) {
        String evtnm = evt == null ? null : evt.getName();
        String debugInfo = MessageFormat.format("doCommand comp=[{0}],command=[{1}],evtnm=[{2}]", comp, command, evtnm);
        if (_log.isDebugEnabled()) {
            _log.debug("Start {}", (Object)debugInfo);
        }
        BindContext ctx = BindContextUtil.newBindContext(this, commandBinding, false, command, comp, evt);
        BindContextUtil.setCommandArgs(this, comp, ctx, commandArgs);
        try {
            this.doPrePhase(Phase.COMMAND, ctx);
            boolean success = true;
            BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
            if (collector != null) {
                collector.addInfo(new CommandInfo("on-command", comp, evtnm, commandBinding == null ? null : BindEvaluatorXUtil.getExpressionString(((CommandBindingImpl)commandBinding).getCommand()), command, commandArgs, null));
            }
            if (!(success = this.doValidate(comp, command, evt, ctx, notifys))) {
                int n = 1;
                return n;
            }
            this.doSaveBefore(comp, command, evt, ctx, notifys);
            this.doLoadBefore(comp, command, ctx);
            this.doExecute(comp, command, commandArgs, ctx, notifys);
            this.doSaveAfter(comp, command, evt, ctx, notifys);
            this.doLoadAfter(comp, command, ctx);
            if (_log.isDebugEnabled()) {
                _log.debug("End doCommand");
            }
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            throw new RuntimeException(debugInfo, ex);
        }
        finally {
            this.doPostPhase(Phase.COMMAND, ctx);
        }
    }

    private void doGlobalCommand(Component comp, String command, Event evt, Map<String, Object> commandArgs, Set<Property> notifys) {
        String debugInfo = MessageFormat.format("doGlobalCommand comp=[{0}],command=[{1}]", comp, command);
        if (_log.isDebugEnabled()) {
            _log.debug("Start {}", (Object)debugInfo);
        }
        BindContext ctx = BindContextUtil.newBindContext(this, null, false, command, comp, evt);
        BindContextUtil.setCommandArgs(this, comp, ctx, commandArgs);
        try {
            this.doPrePhase(Phase.GLOBAL_COMMAND, ctx);
            BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
            if (collector != null) {
                collector.addInfo(new CommandInfo("on-command-global", comp, null, null, command, commandArgs, null));
            }
            this.doGlobalCommandExecute(comp, command, commandArgs, ctx, notifys);
        }
        catch (Exception ex) {
            throw new RuntimeException(debugInfo, ex);
        }
        finally {
            this.doPostPhase(Phase.GLOBAL_COMMAND, ctx);
        }
    }

    private void doGlobalCommandExecute(Component comp, String command, Map<String, Object> commandArgs, BindContext ctx, Set<Property> notifys) {
        Object debugInfo = MessageFormat.format("doGlobalCommandExecute comp=[{0}],command=[{1}]", comp, command);
        try {
            if (_log.isDebugEnabled()) {
                _log.debug("before {}", debugInfo);
            }
            this.doPrePhase(Phase.EXECUTE, ctx);
            Object viewModel = this.getViewModelInView();
            Method method = this.getCommandMethod(BindUtils.getViewModelClass(viewModel), command, _globalCommandMethodInfoProvider, _globalCommandMethodCache, commandArgs != null ? commandArgs.size() : 0, true);
            if (method != null) {
                BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
                if (collector != null) {
                    collector.addInfo(new CommandInfo("execute-global", comp, null, null, command, commandArgs, method.toString()));
                }
                ParamCall parCall = this.createParamCall(ctx);
                if (commandArgs != null) {
                    parCall.setBindingArgs(commandArgs);
                }
                BinderImpl.handleNotifyChange(ctx, viewModel, method, parCall, notifys);
            } else {
                if (_log.isDebugEnabled()) {
                    _log.debug("no global command method in [{}]", viewModel);
                }
                debugInfo = (String)debugInfo + MessageFormat.format(",no global command method in viewModel=[{0}]", viewModel);
            }
            if (_log.isDebugEnabled()) {
                _log.debug("after doGlobalCommandExecute notifys=[{}]", notifys);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException((String)debugInfo, ex);
        }
        finally {
            this.doPostPhase(Phase.EXECUTE, ctx);
        }
    }

    static void handleNotifyChange(BindContext ctx, Object viewModel, Method method, ParamCall parCall, Set<Property> notifys) {
        SmartNotifyChange sannt = ViewModelAnnotationResolvers.getAnnotation(method, SmartNotifyChange.class);
        Object originViewModel = BinderImpl.getOriginViewModel(viewModel);
        if (sannt != null) {
            LinkedHashSet<Property> properties = new LinkedHashSet<Property>(5);
            properties.addAll(BindELContext.getNotifys(method, originViewModel, null, null, ctx));
            parCall.call(viewModel, method);
            Iterator it = properties.iterator();
            while (it.hasNext()) {
                Property prop = (Property)it.next();
                Object result = null;
                try {
                    result = Fields.get((Object)prop.getBase(), (String)prop.getProperty());
                    if (!Objects.equals((Object)result, (Object)prop.getValue())) continue;
                    it.remove();
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            notifys.addAll(properties);
        } else {
            parCall.call(viewModel, method);
            notifys.addAll(BindELContext.getNotifys(method, originViewModel, null, null, ctx));
        }
    }

    void doPrePhase(Phase phase, BindContext ctx) {
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.pushStack(phase.name());
        }
        for (PhaseListener listener : this.getPhaseListeners()) {
            if (listener == null) continue;
            listener.prePhase(phase, ctx);
        }
    }

    void doPostPhase(Phase phase, BindContext ctx) {
        for (PhaseListener listener : this.getPhaseListeners()) {
            if (listener == null) continue;
            listener.postPhase(phase, ctx);
        }
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.popStack();
        }
    }

    private boolean doSaveEvent(Component comp, Event evt, Set<Property> notifys) {
        String evtnm;
        String string = evtnm = evt == null ? null : evt.getName();
        if (_log.isDebugEnabled()) {
            _log.debug("doSaveEvent comp=[{}],evtnm=[{}],notifys=[{}]", new Object[]{comp, evtnm, notifys});
        }
        BindingKey bkey = this.getBindingKey(comp, evtnm);
        return this._propertyBindingHandler.doSaveEvent(bkey, comp, evt, notifys);
    }

    private void doLoadEvent(Component comp, Event evt) {
        if (_log.isDebugEnabled()) {
            _log.debug("doLoadEvent comp=[{}],evtnm=[{}]", (Object)comp, (Object)evt.getName());
        }
        BindingKey bkey = this.getBindingKey(comp, evt.getName());
        this._propertyBindingHandler.doLoadEvent(bkey, comp, evt);
    }

    protected boolean doValidate(Component comp, String command, Event evt, BindContext ctx, Set<Property> notifys) {
        HashSet<Property> validates = new HashSet<Property>();
        try {
            if (_log.isDebugEnabled()) {
                _log.debug("doValidate  comp=[{}],command=[{}],evt=[{}],context=[{}]", new Object[]{comp, command, evt, ctx});
            }
            this.doPrePhase(Phase.VALIDATE, ctx);
            ValidationHelper vHelper = new ValidationHelper(this, new ValidationHelper.InfoProvider(){

                @Override
                public Map<String, List<SaveFormBinding>> getSaveFormBeforeBindings() {
                    return BinderImpl.this._formBindingHandler.getSaveFormBeforeBindings();
                }

                @Override
                public Map<String, List<SaveFormBinding>> getSaveFormAfterBindings() {
                    return BinderImpl.this._formBindingHandler.getSaveFormAfterBindings();
                }

                @Override
                public Map<String, List<SavePropertyBinding>> getSaveBeforeBindings() {
                    return BinderImpl.this._propertyBindingHandler.getSaveBeforeBindings();
                }

                @Override
                public Map<String, List<SavePropertyBinding>> getSaveAfterBindings() {
                    return BinderImpl.this._propertyBindingHandler.getSaveAfterBindings();
                }

                @Override
                public BindingKey getBindingKey(Component comp, String attr) {
                    return BinderImpl.this.getBindingKey(comp, attr);
                }
            });
            vHelper.collectSaveBefore(comp, command, evt, validates);
            vHelper.collectSaveAfter(comp, command, evt, validates);
            if (validates.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("doValidate validates=[{}]", validates);
            }
            boolean valid = true;
            for (Property p : validates) {
                if (!(p instanceof WrongValuePropertyImpl)) continue;
                for (WrongValueException wve : ((WrongValuePropertyImpl)p).getWrongValueExceptions()) {
                    Component wvc = wve.getComponent();
                    if (wvc == null || (wve = ((ComponentCtrl)wvc).onWrongValue(wve)) == null) continue;
                    Component c = wve.getComponent();
                    if (c == null) {
                        c = wvc;
                    }
                    Clients.wrongValue((Component)c, (String)wve.getMessage());
                }
                valid = false;
            }
            Map<String, Property[]> properties = this._propertyBindingHandler.toCollectedProperties(validates);
            valid &= vHelper.validateSaveBefore(comp, command, properties, valid, notifys);
            valid &= vHelper.validateSaveAfter(comp, command, properties, valid, notifys);
            boolean bl = valid;
            return bl;
        }
        catch (Exception e) {
            _log.error("doValidate  comp=[{}],command=[{}],evt=[{}],context=[{}],validates=[{}]", new Object[]{comp, command, evt, ctx, validates, e});
            throw UiException.Aide.wrap((Throwable)e, (String)e.getMessage());
        }
        finally {
            this.doPostPhase(Phase.VALIDATE, ctx);
        }
    }

    protected ParamCall createParamCall(BindContext ctx) {
        Execution exec;
        ParamCall call = new ParamCall();
        call.setBinder(this);
        call.setBindContext(ctx);
        Component comp = ctx.getComponent();
        if (comp != null) {
            call.setComponent(comp);
        }
        if ((exec = Executions.getCurrent()) != null) {
            call.setExecution(exec);
        }
        return call;
    }

    protected void doExecute(Component comp, String command, Map<String, Object> commandArgs, BindContext ctx, Set<Property> notifys) {
        try {
            Matcher matcher = CALL_OTHER_VM_COMMAND_PATTERN.matcher(command);
            if (matcher.find()) {
                String vmId = matcher.group(1);
                Map vmIdBinderMap = (Map)comp.getDesktop().getAttribute("org.zkoss.bind.vmId_binder");
                Binder targetBinder = (Binder)vmIdBinderMap.get(vmId);
                if (targetBinder != null) {
                    ((BinderImpl)targetBinder).doExecute(comp, command.replace("$" + vmId + ".", ""), commandArgs, ctx, notifys);
                    return;
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug("before doExecute comp=[{}],command=[{}],notifys=[{}]", new Object[]{comp, command, notifys});
            }
            this.doPrePhase(Phase.EXECUTE, ctx);
            Object viewModel = this.getViewModelInView();
            Class<?> viewModelClass = BindUtils.getViewModelClass(viewModel);
            Method method = this.getCommandMethod(viewModelClass, command, _commandMethodInfoProvider, _commandMethodCache, commandArgs != null ? commandArgs.values().size() : 0, false);
            if (method != null) {
                BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
                if (collector != null) {
                    collector.addInfo(new CommandInfo("execute", comp, null, null, command, commandArgs, method.toString()));
                }
                ParamCall parCall = this.createParamCall(ctx);
                if (commandArgs != null) {
                    parCall.setBindingArgs(commandArgs);
                }
                BinderImpl.handleNotifyChange(ctx, viewModel, method, parCall, notifys);
            } else if (!(this._notifyCommands != null && this._notifyCommands.containsKey(command) || command.startsWith(":") || command.startsWith("/"))) {
                throw new UiException(MiscUtil.formatLocationMessage("cannot find any method that is annotated for the command " + command + " with @Command in " + viewModel, comp));
            }
            if (_log.isDebugEnabled()) {
                _log.debug("after doExecute notifys=[{}]", notifys);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(MessageFormat.format("doExecute comp=[{0}],command=[{1}],notifys=[{2}]", comp, command, notifys), ex);
        }
        finally {
            this.doPostPhase(Phase.EXECUTE, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getCommandMethod(Class<?> clz, String command, CommandMethodInfoProvider cmdInfo, Map<Class<?>, Map<String, CachedItem<Method>>> cache, int commandParamCount, boolean isGlobal) {
        Method matchedMethodWithoutAnno = null;
        CachedItem method = null;
        Map<Class<?>, Map<String, CachedItem<Method>>> map = cache == _commandMethodCache ? _commandMethodCache : _globalCommandMethodCache;
        synchronized (map) {
            Map methods = cache.computeIfAbsent(clz, k -> new HashMap());
            method = (CachedItem)methods.get(command);
            boolean inited = false;
            if (method != null) {
                return (Method)method.value;
            }
            if (methods.get(COMMAND_METHOD_MAP_INIT) != null) {
                inited = true;
            }
            for (Method m : clz.getMethods()) {
                String[] vals;
                if (m.isBridge()) continue;
                String mName = m.getName();
                if (!isGlobal && mName.equals(command) && m.getParameterTypes().length == commandParamCount) {
                    matchedMethodWithoutAnno = m;
                }
                if (inited) continue;
                if (cmdInfo.isDefaultMethod(m)) {
                    if (methods.get(COMMAND_METHOD_DEFAULT) != null) {
                        throw new UiException("there are more than one " + cmdInfo.getDefaultAnnotationName() + " method in " + clz + ", " + ((CachedItem)methods.get((Object)COMMAND_METHOD_DEFAULT)).value + " and " + m);
                    }
                    methods.put(COMMAND_METHOD_DEFAULT, new CachedItem<Method>(m));
                }
                if ((vals = cmdInfo.getCommandName(m)) == null) continue;
                if (vals.length == 0) {
                    vals = new String[]{mName};
                }
                for (String val : vals) {
                    if (methods.get(val = val.trim()) != null) {
                        throw new UiException("there are more than one " + cmdInfo.getAnnotationName() + " method " + val + " in " + clz + ", " + ((CachedItem)methods.get((Object)val)).value + " and " + m);
                    }
                    methods.put(val, new CachedItem<Method>(m));
                }
            }
            if (!inited) {
                if (this._matchMediaValues != null) {
                    for (Map.Entry entry : this._matchMediaValues.entrySet()) {
                        methods.put((String)entry.getKey(), new CachedItem<Method>((Method)entry.getValue()));
                    }
                }
                methods.put(COMMAND_METHOD_MAP_INIT, NULL_METHOD);
            }
            if ((method = (CachedItem)methods.get(command)) == null) {
                if (matchedMethodWithoutAnno != null) {
                    method = new CachedItem(matchedMethodWithoutAnno);
                    methods.put(command, method);
                } else {
                    method = (CachedItem)methods.get(COMMAND_METHOD_DEFAULT);
                    if (method != null) {
                        methods.put(command, method);
                    }
                }
            }
        }
        return method == null ? null : (Method)method.value;
    }

    protected void doSaveBefore(Component comp, String command, Event evt, BindContext ctx, Set<Property> notifys) {
        if (_log.isDebugEnabled()) {
            _log.debug("doSaveBefore comp=[{}],command=[{}],evt=[{}],notifys=[{}]", new Object[]{comp, command, evt, notifys});
        }
        try {
            this.doPrePhase(Phase.SAVE_BEFORE, ctx);
            this._propertyBindingHandler.doSaveBefore(comp, command, evt, notifys);
            this._formBindingHandler.doSaveBefore(comp, command, evt, notifys);
        }
        catch (Exception ex) {
            throw new RuntimeException(MessageFormat.format("doSaveBefore comp=[{0}],command=[{1}],evt=[{2}],notifys=[{3}]", comp, command, evt, notifys), ex);
        }
        finally {
            this.doPostPhase(Phase.SAVE_BEFORE, ctx);
        }
    }

    protected void doSaveAfter(Component comp, String command, Event evt, BindContext ctx, Set<Property> notifys) {
        if (_log.isDebugEnabled()) {
            _log.debug("doSaveAfter comp=[{}],command=[{}],evt=[{}],notifys=[{}]", new Object[]{comp, command, evt, notifys});
        }
        try {
            this.doPrePhase(Phase.SAVE_AFTER, ctx);
            this._propertyBindingHandler.doSaveAfter(comp, command, evt, notifys);
            this._formBindingHandler.doSaveAfter(comp, command, evt, notifys);
        }
        catch (Exception ex) {
            throw new RuntimeException(MessageFormat.format("doSaveAfter comp=[{0}],command=[{1}],evt=[{2}],notifys=[{3}]", comp, command, evt, notifys), ex);
        }
        finally {
            this.doPostPhase(Phase.SAVE_AFTER, ctx);
        }
    }

    protected void doLoadBefore(Component comp, String command, BindContext ctx) {
        if (_log.isDebugEnabled()) {
            _log.debug("doLoadBefore comp=[{}],command=[{}]", (Object)comp, (Object)command);
        }
        try {
            this.doPrePhase(Phase.LOAD_BEFORE, ctx);
            this._propertyBindingHandler.doLoadBefore(comp, command);
            this._formBindingHandler.doLoadBefore(comp, command);
            this._childrenBindingHandler.doLoadBefore(comp, command);
        }
        catch (Exception ex) {
            throw new RuntimeException(MessageFormat.format("doLoadBefore comp=[{0}],command=[{1}]", comp, command), ex);
        }
        finally {
            this.doPostPhase(Phase.LOAD_BEFORE, ctx);
        }
    }

    protected void doLoadAfter(Component comp, String command, BindContext ctx) {
        if (_log.isDebugEnabled()) {
            _log.debug("doLoadAfter comp=[{}],command=[{}]", (Object)comp, (Object)command);
        }
        try {
            this.doPrePhase(Phase.LOAD_AFTER, ctx);
            this._propertyBindingHandler.doLoadAfter(comp, command);
            this._formBindingHandler.doLoadAfter(comp, command);
            this._childrenBindingHandler.doLoadAfter(comp, command);
        }
        catch (Exception ex) {
            throw new RuntimeException(MessageFormat.format("doLoadAfter comp=[{0}],command=[{1}]", comp, command), ex);
        }
        finally {
            this.doPostPhase(Phase.LOAD_AFTER, ctx);
        }
    }

    @Override
    public void removeBindings(Set<Component> comps) {
        for (Component comp : comps) {
            this.removeBindings0(comp);
        }
        TrackerImpl tracker = (TrackerImpl)this.getTracker();
        tracker.removeTrackings(comps);
    }

    @Override
    public void removeBindings(Component comp) {
        this.removeBindings0(comp);
        TrackerImpl tracker = (TrackerImpl)this.getTracker();
        tracker.removeTrackings(comp);
    }

    private void removeBindings(Collection<Binding> removed, Component comp) {
        this._formBindingHandler.removeBindings(removed);
        this._propertyBindingHandler.removeBindings(removed);
        this._childrenBindingHandler.removeBindings(removed);
    }

    @Override
    public void removeBindings(Component comp, String key) {
        this.checkInit();
        this.removeEventCommandListenerIfExists(comp, key);
        BindingKey bkey = this.getBindingKey(comp, key);
        HashSet<Binding> removed = new HashSet<Binding>();
        this._formBindingHandler.removeBindings(bkey, removed);
        this._propertyBindingHandler.removeBindings(bkey, removed);
        this._childrenBindingHandler.removeBindings(bkey, removed);
        if (this._validationMessages != null) {
            this._validationMessages.clearMessages(comp, key);
        }
        this._hasValidators.remove(bkey);
        this.removeTemplateResolver(comp, key);
        if (this._refBindingHandler != null) {
            this._refBindingHandler.removeReferenceBinding(comp, key);
        }
        this.removeBindings(removed, comp);
    }

    private void removeBindings0(Component comp) {
        Map<String, List<Binding>> attrMap;
        this.checkInit();
        if (this._rootComp == comp) {
            this.unsubscribeQueue(this._quename, this._quescope, this._queueListener);
            this._rootComp.removeAttribute("$ACTIVATOR$");
        }
        if (this._validationMessages != null) {
            this._validationMessages.clearMessages(comp);
        }
        if ((attrMap = this._bindings.remove(comp)) != null) {
            HashSet<Binding> removed = new HashSet<Binding>();
            for (Map.Entry<String, List<Binding>> entry : attrMap.entrySet()) {
                String key = entry.getKey();
                this.removeBindings(comp, key);
                removed.addAll((Collection<Binding>)entry.getValue());
            }
            if (!removed.isEmpty()) {
                this.removeBindings(removed, comp);
            }
        }
        this.removeFormAssociatedSaveBinding(comp);
        this.removeForm(comp);
        this.removeTemplateResolver(comp);
        if (this._refBindingHandler != null) {
            this._refBindingHandler.removeReferenceBinding(comp);
        }
        BinderUtil.unmarkHandling(comp);
        if (comp.hasAttribute("$BINDER_ID$")) {
            comp.setAttribute("$REMOVE_BINDINGS$", (Object)Boolean.TRUE);
        }
    }

    @Override
    public List<Binding> getLoadPromptBindings(Component comp, String attr) {
        List<LoadChildrenBinding> childrenLoadBindings;
        this.checkInit();
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        BindingKey bkey = this.getBindingKey(comp, attr);
        List<LoadPropertyBinding> loadBindings = this._propertyBindingHandler.getLoadPromptBindings(bkey);
        if (loadBindings != null && loadBindings.size() > 0) {
            bindings.addAll(loadBindings);
        }
        if (bindings.size() == 0 && (childrenLoadBindings = this._childrenBindingHandler.getLoadPromptBindings(bkey)) != null && childrenLoadBindings.size() > 0) {
            bindings.addAll(childrenLoadBindings);
        }
        return bindings;
    }

    private void addBinding(Component comp, String attr, Binding binding) {
        Map<String, List<Binding>> attrMap = this._bindings.get(comp);
        List<Binding> bindings = attrMap == null ? null : attrMap.get(attr);
        bindings = AllocUtil.inst.addList(bindings, binding);
        attrMap = AllocUtil.inst.putLinkedHashMap(attrMap, attr, bindings);
        this._bindings.put(comp, attrMap);
        BinderUtil.markHandling(comp, this);
    }

    @Override
    public void setTemplate(Component comp, String attr, String templateExpr, Map<String, Object> templateArgs) {
        Map<String, TemplateResolver> resolvers = this._templateResolvers.get(comp);
        if (resolvers == null) {
            resolvers = new HashMap<String, TemplateResolver>();
            this._templateResolvers.put(comp, resolvers);
        }
        resolvers.put(attr, this.newTemplateResolverImpl(this, comp, attr, templateExpr, templateArgs));
    }

    private TemplateResolver newTemplateResolverImpl(BinderImpl binderImpl, Component comp, String attr, String templateExpr, Map<String, Object> templateArgs) {
        String clznm = Library.getProperty((String)"org.zkoss.bind.TemplateResolver.class", (String)TemplateResolverImpl.class.getName());
        try {
            Class clz = Classes.forNameByThread((String)clznm);
            Constructor c = clz.getDeclaredConstructor(Binder.class, Component.class, String.class, String.class, Map.class);
            TemplateResolver resolver = (TemplateResolver)c.newInstance(binderImpl, comp, attr, templateExpr, templateArgs);
            return resolver;
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e, (String)"Can't initialize template resolver ");
        }
    }

    @Override
    public TemplateResolver getTemplateResolver(Component comp, String attr) {
        Map<String, TemplateResolver> resolvers = this._templateResolvers.get(comp);
        return resolvers == null ? null : resolvers.get(attr);
    }

    private void removeTemplateResolver(Component comp, String attr) {
        Map<String, TemplateResolver> resolvers = this._templateResolvers.get(comp);
        if (resolvers != null) {
            resolvers.remove(attr);
        }
    }

    private void removeTemplateResolver(Component comp) {
        this._templateResolvers.remove(comp);
    }

    @Override
    public Tracker getTracker() {
        if (this._tracker == null) {
            String clznm = Library.getProperty((String)"org.zkoss.bind.Tracker.class");
            if (clznm != null) {
                try {
                    Class clz = Classes.forNameByThread((String)clznm);
                    this._tracker = (Tracker)clz.newInstance();
                }
                catch (Exception e) {
                    throw UiException.Aide.wrap((Throwable)e, (String)"Can't initialize tracker");
                }
            } else {
                this._tracker = new TrackerImpl();
            }
        }
        return this._tracker;
    }

    @Override
    public void loadComponent(Component comp, boolean loadinit) {
        this.loadComponent0(comp, loadinit);
        if (comp == this.getView() && this._notifyCommands != null) {
            this.initNotifyCommands(comp);
        }
    }

    private void initNotifyCommands(Component comp) {
        for (Map.Entry<String, NotifyCommand> me : this._notifyCommands.entrySet()) {
            this.addPropertyLoadBindings4Command(comp, me.getValue().onChange(), me.getKey());
        }
    }

    public Map<String, Object> getDynamicAttrs() {
        return this._dynamicAttrs;
    }

    public void setDynamicAttrs(String command, Object value) {
        this._dynamicAttrs.put(command, value);
    }

    private void addPropertyLoadBindings4Command(Component comp, String loadExpr, String command) {
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        String attr = "dynamicAttrs['" + command + "']";
        String vmname = (String)comp.getAttribute("$VM_ID$");
        if (vmname != null) {
            loadExpr = loadExpr.replaceAll("_vm_", vmname);
        }
        String loadAttr = "attributes['$BINDER$']." + attr;
        LoadPropertyBinding binding = this.newLoadPropertyBinding(comp, attr, loadAttr, null, loadExpr, ConditionType.PROMPT, null, null, null, null);
        this.addBinding(comp, attr, binding);
        BindingKey bkey = this.getBindingKey(comp, attr);
        this._propertyBindingHandler.addLoadPromptBinding(comp, bkey, binding);
        if (collector != null) {
            collector.addInfo(new AddBindingInfo("prop-load", comp, "", binding.getPropertyString(), binding.getFieldName(), null, null));
        }
        this._propertyBindingHandler.doLoad(comp, bkey);
    }

    protected void loadComponent0(Component comp, boolean loadinit) {
        this.loadComponentProperties0(comp, loadinit);
        Map<String, List<Binding>> compBindings = this._bindings.get(comp);
        if (this._activating || compBindings == null || !compBindings.keySet().contains("$CHILDREN$")) {
            for (Component kid = comp.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                this.loadComponent0(kid, loadinit);
            }
            if (comp instanceof ComponentCtrl) {
                for (ShadowElement se : ((ComponentCtrl)comp).getShadowRoots()) {
                    this.loadComponent0((Component)se, loadinit);
                }
            }
        }
    }

    private void loadComponentProperties0(Component comp, boolean loadinit) {
        Map<String, List<Binding>> compBindings = this._bindings.get(comp);
        if (compBindings != null) {
            BindingKey bkey;
            for (String key : compBindings.keySet()) {
                bkey = this.getBindingKey(comp, key);
                if (loadinit) {
                    this._formBindingHandler.doInit(comp, bkey);
                }
                this._formBindingHandler.doLoad(comp, bkey);
            }
            for (String key : compBindings.keySet()) {
                bkey = this.getBindingKey(comp, key);
                if (loadinit) {
                    this._propertyBindingHandler.doInit(comp, bkey);
                }
                this._propertyBindingHandler.doLoad(comp, bkey);
            }
            for (String key : compBindings.keySet()) {
                bkey = this.getBindingKey(comp, key);
                if (loadinit) {
                    this._childrenBindingHandler.doInit(comp, bkey);
                }
                this._childrenBindingHandler.doLoad(comp, bkey);
            }
        }
    }

    @Override
    public void notifyChange(Object base, String attr) {
        this.checkInit();
        if (_log.isDebugEnabled()) {
            _log.debug("notifyChange base=[{}],attr=[{}]", base, (Object)attr);
        }
        this.getEventQueue().publish((Event)new PropertyChangeEvent(this._rootComp, base, attr));
    }

    private void postGlobalCommand(Component comp, CommandBinding commandBinding, String command, Event evt, Map<String, Object> args) {
        if (_log.isDebugEnabled()) {
            _log.debug("postGlobalCommand command=[{}],args=[{}]", (Object)command, args);
        }
        BindingExecutionInfoCollector collector = this.getBindingExecutionInfoCollector();
        try {
            if (collector != null) {
                collector.pushStack("POST_GLOBAL_COMMAND");
                collector.addInfo(new CommandInfo("post-global", comp, evt == null ? null : evt.getName(), BindEvaluatorXUtil.getExpressionString(((CommandBindingImpl)commandBinding).getCommand()), command, args, null));
            }
            this.getEventQueue().publish((Event)new GlobalCommandEvent(this._rootComp, command, args, evt));
        }
        catch (Exception ex) {
            throw new RuntimeException(MessageFormat.format("postGlobalCommand command=[{0}],args=[{1}]", command, args), ex);
        }
        finally {
            if (collector != null) {
                collector.popStack();
            }
        }
    }

    @Override
    public void setPhaseListener(PhaseListener listener) {
        this.addPhaseListener(listener);
    }

    @Override
    public void addPhaseListener(PhaseListener listener) {
        this._phaseListeners.add(listener);
    }

    public PhaseListener getPhaseListener() {
        List<PhaseListener> list = this.getPhaseListeners();
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<PhaseListener> getPhaseListeners() {
        return this._phaseListeners;
    }

    private void subscribeQueue(String quename, String quescope, EventListener<Event> listener) {
        EventQueue que = EventQueues.lookup((String)quename, (String)quescope, (boolean)true);
        que.subscribe(listener);
    }

    private void unsubscribeQueue(String quename, String quescope, EventListener<Event> listener) {
        EventQueue que = EventQueues.lookup((String)quename, (String)quescope, (boolean)false);
        if (que != null) {
            que.unsubscribe(listener);
        }
    }

    private boolean isSubscribed(String quename, String quescope, EventListener<Event> listener) {
        EventQueue que = EventQueues.lookup((String)quename, (String)quescope, (boolean)false);
        return que == null ? false : que.isSubscribed(listener);
    }

    protected EventQueue<Event> getEventQueue() {
        return EventQueues.lookup((String)this._quename, (String)this._quescope, (boolean)true);
    }

    private BindingKey getBindingKey(Component comp, String attr) {
        return new BindingKey(comp, attr);
    }

    private void removeFormAssociatedSaveBinding(Component comp) {
        this._assocFormSaveBindings.remove(comp);
        Map<SaveBinding, Set<SaveBinding>> associated = this._reversedAssocFormSaveBindings.remove(comp);
        if (associated != null) {
            Set<Map.Entry<SaveBinding, Set<SaveBinding>>> entries = associated.entrySet();
            for (Map.Entry<SaveBinding, Set<SaveBinding>> entry : entries) {
                entry.getValue().remove(entry.getKey());
            }
        }
    }

    @Override
    public void addFormAssociatedSaveBinding(Component associatedComp, String formId, SaveBinding saveBinding, String fieldName) {
        this.checkInit();
        Component formComp = this.lookupAssociatedFormComponent(formId, associatedComp);
        if (formComp == null) {
            throw new UiException("cannot find any form " + formId + " with " + associatedComp);
        }
        Binder saveCompBinder = saveBinding.getBinder();
        boolean isSameBinder = this.equals(saveCompBinder);
        LinkedHashSet bindings = null;
        LinkedHashSet originalBindings = this._assocFormSaveBindings.get(formComp);
        if (!isSameBinder) {
            bindings = ((BinderImpl)saveCompBinder)._assocFormSaveBindings.get(formComp);
            if (bindings == null) {
                bindings = new LinkedHashSet();
                ((BinderImpl)saveCompBinder)._assocFormSaveBindings.put(formComp, bindings);
            }
            if (originalBindings != null) {
                bindings.addAll(originalBindings);
            }
        } else if (bindings == null) {
            bindings = originalBindings != null ? originalBindings : new LinkedHashSet();
        }
        this._assocFormSaveBindings.put(formComp, bindings);
        bindings.add(saveBinding);
        HashMap reverseMap = null;
        HashMap originalReverseMap = this._reversedAssocFormSaveBindings.get(associatedComp);
        if (!isSameBinder) {
            reverseMap = ((BinderImpl)saveCompBinder)._reversedAssocFormSaveBindings.get(associatedComp);
            if (reverseMap == null) {
                reverseMap = new HashMap();
                ((BinderImpl)saveCompBinder)._reversedAssocFormSaveBindings.put(associatedComp, reverseMap);
            }
            if (originalReverseMap != null) {
                ((Set)reverseMap.get(saveBinding)).addAll((Collection)originalReverseMap.get(saveBinding));
            }
        } else if (reverseMap == null) {
            reverseMap = originalReverseMap != null ? originalReverseMap : new HashMap();
        }
        this._reversedAssocFormSaveBindings.put(associatedComp, reverseMap);
        reverseMap.put(saveBinding, bindings);
        ((SavePropertyBindingImpl)saveBinding).setFormFieldInfo(formComp, formId, fieldName);
    }

    private Component lookupAssociatedFormComponent(String formId, Component associatedComp) {
        Component p;
        String fid = null;
        for (p = associatedComp; !(p == null || (fid = (String)p.getAttribute("$FORM_ID$")) != null && fid.equals(formId)); p = p.getParent()) {
        }
        return p;
    }

    @Override
    public Set<SaveBinding> getFormAssociatedSaveBindings(Component comp) {
        this.checkInit();
        Set<SaveBinding> bindings = this._assocFormSaveBindings.get(comp);
        if (bindings == null) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<SaveBinding>(bindings);
    }

    @Override
    public boolean hasValidator(Component comp, String attr) {
        BindingKey bkey = this.getBindingKey(comp, attr);
        return this._hasValidators.contains(bkey);
    }

    @Override
    public Component getView() {
        this.checkInit();
        return this._rootComp;
    }

    @Override
    public ValidationMessages getValidationMessages() {
        return this._validationMessages;
    }

    @Override
    public void setValidationMessages(ValidationMessages messages) {
        this._validationMessages = messages;
    }

    private void didActivate() {
        this._activating = true;
        try {
            if (_log.isDebugEnabled()) {
                _log.debug("didActivate : [{}]", (Object)this);
            }
            this.loadComponent(this._rootComp, false);
        }
        finally {
            this._activating = false;
        }
    }

    @Override
    public BindingExecutionInfoCollector getBindingExecutionInfoCollector() {
        DebuggerFactory factory = DebuggerFactory.getInstance();
        if (factory == null) {
            return null;
        }
        BindingExecutionInfoCollector collector = factory.getExecutionInfoCollector();
        if (collector instanceof DefaultExecutionInfoCollector) {
            Class<?> vmClass = BindUtils.getViewModelClass(this.getViewModelInView());
            ((DefaultExecutionInfoCollector)collector).setViewModelClass(vmClass);
        }
        return collector;
    }

    @Override
    public BindingAnnotationInfoChecker getBindingAnnotationInfoChecker() {
        DebuggerFactory factory = DebuggerFactory.getInstance();
        if (factory == null) {
            return null;
        }
        BindingAnnotationInfoChecker checker = factory.getAnnotationInfoChecker();
        if (checker instanceof DefaultAnnotationInfoChecker) {
            Class<?> vmClass = BindUtils.getViewModelClass(this.getViewModelInView());
            ((DefaultAnnotationInfoChecker)checker).setViewModelClass(vmClass);
        }
        return checker;
    }

    @Override
    public String getQueueName() {
        return this._quename;
    }

    @Override
    public String getQueueScope() {
        return this._quescope;
    }

    @Override
    public Map<String, Method> getMatchMediaValue() {
        if (this._matchMediaValues == null) {
            this._matchMediaValues = this.initMatchMediaValues(this.getViewModel());
        }
        return Collections.unmodifiableMap(this._matchMediaValues);
    }

    private Map<Object, Set<String>> initSaveFormMap() {
        if (this._saveFormFields == null) {
            this._saveFormFields = new HashMap<Object, Set<String>>(4);
        }
        return this._saveFormFields;
    }

    @Override
    public void addSaveFormFieldName(Form form, String fieldName) {
        Set<String> fields = this.initSaveFormMap().get(form);
        if (fields == null) {
            fields = new HashSet<String>(16);
            this._saveFormFields.put(form, fields);
        }
        fields.add(fieldName);
    }

    @Override
    public void addSaveFormFieldName(Form form, Set<String> fieldNames) {
        Set<String> fields = this.initSaveFormMap().get(form);
        if (fields == null) {
            fields = new HashSet<String>(16);
            this._saveFormFields.put(form, fields);
        }
        fields.addAll(fieldNames);
    }

    @Override
    public Set<String> removeSaveFormFieldNames(Form self) {
        Set<String> result = this.initSaveFormMap().remove(self);
        if (result == null) {
            return Collections.EMPTY_SET;
        }
        return result;
    }

    @Override
    public Set<String> getSaveFormFieldNames(Form form) {
        Set<String> result = this.initSaveFormMap().get(form);
        if (result == null) {
            return Collections.EMPTY_SET;
        }
        return result;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
    }

    @Override
    public void initQueue() {
        if (!this.isSubscribed(this._quename, this._quescope, this._queueListener)) {
            this.subscribeQueue(this._quename, this._quescope, this._queueListener);
        }
    }

    @Override
    public void initActivator() {
        if (this._rootComp != null && !this._rootComp.hasAttribute("$ACTIVATOR$")) {
            this._rootComp.setAttribute("$ACTIVATOR$", (Object)new Activator());
        }
    }

    private class DeferredActivator
    implements ExecutionInit,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DeferredActivator() {
        }

        public void init(Execution exec, Execution parent) throws Exception {
            Desktop desktop = exec.getDesktop();
            desktop.removeListener((Object)BinderImpl.this._deferredActivator);
            BinderImpl.this.didActivate();
        }
    }

    private class Activator
    implements ComponentActivationListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Activator() {
        }

        public void didActivate(Component comp) {
            if (BinderImpl.this._rootComp.equals(comp)) {
                BinderImpl.this.initQueue();
                if (BinderImpl.this._deferredActivator == null) {
                    BinderImpl.this._deferredActivator = new DeferredActivator();
                    comp.getDesktop().addListener((Object)BinderImpl.this._deferredActivator);
                }
            }
        }

        public void willPassivate(Component comp) {
        }
    }

    private static class CachedItem<T> {
        final T value;

        public CachedItem(T value) {
            this.value = value;
        }
    }

    private class PostCommandListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PostCommandListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (BinderImpl.this._rootComp.getDesktop() != null) {
                Object[] data = (Object[])event.getData();
                String command = (String)data[0];
                Map args = (Map)data[1];
                BinderImpl.this.sendCommand(command, args);
            }
        }
    }

    private static interface CommandMethodInfoProvider {
        public String getAnnotationName();

        public String getDefaultAnnotationName();

        public String[] getCommandName(Method var1);

        public boolean isDefaultMethod(Method var1);
    }

    private class VMsgsChangedListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private VMsgsChangedListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (BinderImpl.this._validationMessages != null && BinderImpl.this._rootComp.getDesktop() != null) {
                HashSet<Property> notify = new HashSet<Property>();
                notify.add(new PropertyImpl(BinderImpl.this._validationMessages, ".", null));
                BinderImpl.this.fireNotifyChanges(notify);
            }
        }
    }

    private class CommandEventListener
    implements EventListener<Event>,
    Serializable,
    Deferrable {
        private static final long serialVersionUID = 1L;
        private boolean _prompt = false;
        private CommandBinding _commandBinding;
        private CommandBinding _globalCommandBinding;
        private final Component _target;

        CommandEventListener(Component target) {
            this._target = target;
        }

        private void setCommand(CommandBinding command) {
            this._commandBinding = command;
        }

        private void setGlobalCommand(CommandBinding command) {
            this._globalCommandBinding = command;
        }

        private void setPrompt(boolean prompt) {
            this._prompt = prompt;
        }

        public void onEvent(Event event) throws Exception {
            BindingExecutionInfoCollector collector = BinderImpl.this.getBindingExecutionInfoCollector();
            try {
                if (collector != null) {
                    collector.pushStack("ON_EVENT");
                    collector.addInfo(new EventInfo(event.getTarget(), event.getName(), null));
                }
                this.onEvent0(event);
            }
            catch (Exception x) {
                _log.error(x.getMessage(), (Throwable)x);
                throw x;
            }
            finally {
                if (collector != null) {
                    collector.popStack();
                }
            }
        }

        private void onEvent0(Event event) throws Exception {
            Map<String, Object> implicit;
            BindEvaluatorX eval;
            Component comp = this._target;
            String evtnm = event.getName();
            LinkedHashSet<Property> notifys = new LinkedHashSet<Property>();
            int cmdResult = 0;
            boolean promptResult = true;
            String command = null;
            if (_log.isDebugEnabled()) {
                _log.debug("====Start command event [{}]", (Object)event);
            }
            if (this._prompt) {
                promptResult = BinderImpl.this.doSaveEvent(comp, event, notifys);
            }
            if (this._commandBinding != null) {
                eval = BinderImpl.this.getEvaluatorX();
                implicit = BinderImpl.this._implicitContributor.contirbuteCommandObject(BinderImpl.this, this._commandBinding, event);
                BindContextImpl ctx = new BindContextImpl(null, null, false, null, comp, null);
                ctx.setAttribute("$IMPLICIT_OBJECTS$", implicit);
                command = (String)eval.getValue(ctx, comp, ((CommandBindingImpl)this._commandBinding).getCommand());
                if (!Strings.isEmpty((String)command)) {
                    Map<String, Object> args = BindEvaluatorXUtil.evalArgs(eval, comp, this._commandBinding.getArgs(), implicit);
                    cmdResult = BinderImpl.this.doCommand(comp, this._commandBinding, command, event, args, notifys);
                }
            }
            if (this._prompt && promptResult) {
                if (_log.isDebugEnabled()) {
                    _log.debug("This is a prompt command");
                }
                BinderImpl.this.doLoadEvent(comp, event);
            }
            BinderImpl.this.notifyVMsgsChanged();
            if (_log.isDebugEnabled()) {
                _log.debug("There are [{}] property need to be notify after event = [{}], command = [{}]", new Object[]{notifys.size(), evtnm, command});
            }
            BinderImpl.this.fireNotifyChanges(notifys);
            if (cmdResult == 0 && this._globalCommandBinding != null && !Strings.isEmpty((String)(command = (String)(eval = BinderImpl.this.getEvaluatorX()).getValue(null, comp, ((CommandBindingImpl)this._globalCommandBinding).getCommand())))) {
                implicit = null;
                if (BinderImpl.this._implicitContributor != null) {
                    implicit = BinderImpl.this._implicitContributor.contirbuteCommandObject(BinderImpl.this, this._commandBinding, event);
                }
                Map<String, Object> args = BindEvaluatorXUtil.evalArgs(eval, comp, this._globalCommandBinding.getArgs(), implicit);
                BinderImpl.this.postGlobalCommand(comp, this._globalCommandBinding, command, event, args);
            }
            if (_log.isDebugEnabled()) {
                _log.debug("====End command event [{}]", (Object)event);
            }
        }

        public boolean isDeferrable() {
            return "true".equals(this._target.getAttribute("org.zkoss.bind.event.deferPost"));
        }
    }

    private class QueueListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private QueueListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (event instanceof PropertyChangeEvent) {
                PropertyChangeEvent evt = (PropertyChangeEvent)event;
                BinderImpl.this.doPropertyChange(evt.getBase(), evt.getProperty());
            } else if (event instanceof GlobalCommandEvent) {
                GlobalCommandEvent evt = (GlobalCommandEvent)event;
                LinkedHashSet<Property> notifys = new LinkedHashSet<Property>();
                BinderImpl.this.doGlobalCommand(BinderImpl.this._rootComp, evt.getCommand(), evt.getTriggerEvent(), evt.getArgs(), notifys);
                BinderImpl.this.fireNotifyChanges(notifys);
                BinderImpl.this.notifyVMsgsChanged();
            }
        }
    }
}

