/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./extends.js":
/*!********************!*\
  !*** ./extends.js ***!
  \********************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
/* extends.js

    Purpose:

    Description:

    History:
        1:02 PM 2023/8/21, Created by jumperchen

Copyright (C) 2023 Potix Corporation. All Rights Reserved.
*/
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return extendStatics(d, b);
};
// refer tslib#__extends
function default_1(d, b) {
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  d.prototype._$super = d.name == '$subclass$' && b.prototype._$super ? b.prototype._$super : b.prototype; // Potix: Jumper Chen adds to support `$supers(foo.Bar, 'bind_')`
}
exports["default"] = default_1;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/Bandbox.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/Bandbox.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.Bandbox_) window.zul.inp.Bandbox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Bandbox = void 0;
/* Bandbox.ts

    Purpose:

    Description:

    History:
        Tue Mar 31 14:17:28     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A band box. A bank box consists of an input box ({@link Textbox} and
 * a popup window {@link Bandpopup}.
 * It is similar to {@link Combobox} except the popup window could have
 * any kind of children. For example, you could place a textbox in
 * the popup to let user search particular items.
 *
 * @defaultValue {@link getZclass}: z-bandbox.
 */
var Bandbox = /** @class */function (_super) {
  __extends(Bandbox, _super);
  function Bandbox() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._iconSclass = 'z-icon-search';
    return _this;
  }
  //super
  /** @internal */
  Bandbox.prototype.getPopupSize_ = function (pp) {
    var bp = this.firstChild,
      //bandpopup
      w,
      h;
    if (bp) {
      w = bp._hflex == 'min' && bp._hflexsz ? jq.px0(bp._hflexsz + zk(pp).padBorderWidth()) : bp.getWidth();
      h = bp._vflex == 'min' && bp._vflexsz ? jq.px0(bp._vflexsz + zk(pp).padBorderHeight()) : bp.getHeight();
    }
    return [w || 'auto', h || 'auto'];
  };
  Bandbox.prototype.getCaveNode = function () {
    var _a;
    return (_a = this.$n('pp')) !== null && _a !== void 0 ? _a : this.$n();
  };
  /** @internal */
  Bandbox.prototype.redrawpp_ = function (out) {
    var fc = this.firstChild;
    out.push('<div id="', this.uuid, '-pp" class="', this.$s('popup'),
    // tabindex=0 to prevent a11y scrollable popup issue, see https://dequeuniversity.com/rules/axe/3.5/scrollable-region-focusable?application=AxeChrome
    '" style="display:none" role="dialog" aria-labelledby="' + (fc ? /*safe*/fc.uuid : '') + '" tabindex="0">');
    for (var w = fc; w; w = w.nextSibling) w.redraw(out);
    out.push('</div>');
  };
  Bandbox.prototype.open = function (opts) {
    if (!this.firstChild) {
      // ignore when <bandpopup> is absent, but event is still fired
      if (opts && opts.sendOnOpen) this.fire('onOpen', {
        open: true,
        value: this.getInputNode().value
      }, {
        rtags: {
          onOpen: 1
        }
      });
      return;
    }
    _super.prototype.open.call(this, opts);
  };
  /** @internal */
  Bandbox.prototype.presize_ = function () {
    var bp = this.firstChild;
    if (bp && (bp._hflex == 'min' || bp._vflex == 'min')) {
      zWatch.fireDown('onFitSize', bp, {
        reverse: true
      });
      return true;
    }
    return false;
  };
  /** @internal */
  Bandbox.prototype.enterPressed_ = function (evt) {
    //bug 3280506: do not close when children press enter.
    if (evt.domTarget == this.getInputNode()) _super.prototype.enterPressed_.call(this, evt);
  };
  /** @internal */
  Bandbox.prototype.doKeyUp_ = function (evt) {
    //bug 3287082: do not fire onChanging when children typing.
    if (evt.domTarget == this.getInputNode()) _super.prototype.doKeyUp_.call(this, evt);
  };
  /** @internal */
  Bandbox.prototype._fixsz = function (ppofs) {
    _super.prototype._fixsz.call(this, ppofs);
    var pp = this.getPopupNode_(),
      zkpp = zk(pp),
      ppfc = pp.firstChild;
    if (ppofs[0].endsWith('%') || this.getPopupWidth()) {
      ppfc.style.width = '100%';
    } else if (ppofs[0] != 'auto') {
      pp.style.width = zkpp.revisedWidth(ppfc.offsetWidth + zkpp.padBorderWidth()) + 'px';
    }
  };
  /** @internal */
  Bandbox.prototype.doFocus_ = function (evt) {
    var target = evt.domTarget;
    if (!(target != this.getInputNode() && target != this.$n('btn'))) _super.prototype.doFocus_.call(this, evt);
  };
  Bandbox = __decorate([zk.WrapClass('zul.inp.Bandbox')], Bandbox);
  return Bandbox;
}(zul.inp.ComboWidget);
exports.Bandbox = Bandbox;
window.zul.inp.Bandbox_.Bandbox = Bandbox;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/Bandpopup.ts":
/*!************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/Bandpopup.ts ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.Bandpopup_) window.zul.inp.Bandpopup_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Bandpopup = void 0;
/* Bandpopup.ts

    Purpose:

    Description:

    History:
        Fri Apr  3 15:24:37     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * The popup that belongs to a {@link Bandbox} instance.
 *
 * <p>Developer usually listen to the onOpen event that is sent to
 * {@link Bandbox} and then creates proper components as children
 * of this component.
 *
 * <p>z-class: z-bandpopup
 */
var Bandpopup = /** @class */function (_super) {
  __extends(Bandpopup, _super);
  function Bandpopup() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /** @internal */
  Bandpopup.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    jq(this.$n()).on('focusin', this._focusin.bind(this)).on('focusout', this._focusout.bind(this));
  };
  /** @internal */
  Bandpopup.prototype.unbind_ = function (skipper, after, keepRod) {
    jq(this.$n()).off('focusout', this._focusout.bind(this)).off('focusin', this._focusin.bind(this));
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Bandpopup.prototype._focusin = function (e) {
    this._shallClosePopup = false;
  };
  /** @internal */
  Bandpopup.prototype._focusout = function (e) {
    var _this = this;
    var _a, _b;
    var bandbox = this.parent;
    if (e.relatedTarget) {
      if ((bandbox === null || bandbox === void 0 ? void 0 : bandbox.isOpen()) && !jq.isAncestor(bandbox.$n('pp'), e.relatedTarget)) bandbox.close();
    } else if ((_b = (_a = e.originalEvent) === null || _a === void 0 ? void 0 : _a.target) === null || _b === void 0 ? void 0 : _b.disabled) {
      // eslint-disable-line zk/noNull
      if (bandbox) {
        // ZK-5155: A focusout/blur event can be fired when an element is disabled. If a child of this Bandpopup
        // loses its focus due to being disabled, let the popup receive focus.
        var popup = bandbox.$n_('pp');
        popup.focus(); // The popup can receive focus because it has tabindex set.
        e.relatedTarget = popup;
      }
    } else {
      // for solving B96-ZK-4748, treechildren will rerender itself when clicking
      // the open icon, and JQ will simulate a fake focusout event without any relatedTarget.
      this._shallClosePopup = true;
      setTimeout(function () {
        var _a;
        if ((bandbox === null || bandbox === void 0 ? void 0 : bandbox.isOpen()) && _this._shallClosePopup && !jq.isAncestor(bandbox.$n('pp'), document.activeElement)) {
          var blurredElement = (_a = e.originalEvent) === null || _a === void 0 ? void 0 : _a.target;
          if (blurredElement && !document.body.contains(blurredElement)) {
            // ZK-5155: The focusout/blur event is due to unmounting the target from DOM. In this case, let the
            // bandpopup take focus, and don't close the bandpopup.
            var popup = bandbox.$n_('pp');
            popup.focus(); // The popup can receive focus because it has tabindex set.
            e.relatedTarget = popup;
          } else {
            bandbox.close();
          }
          _this._shallClosePopup = false;
        }
      });
    }
  };
  //super
  /** @internal */
  Bandpopup.prototype.afterChildrenMinFlex_ = function (orient) {
    var _a;
    if (orient == 'w') {
      var pp = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.$n('pp');
      if (pp) {
        // test case is B50-ZK-859.zul
        pp.style.width = jq.px0(this._hflexsz + zk(pp).padBorderWidth());
        zk(pp)._updateProp(['width']);
      }
    }
  };
  /** @internal */
  Bandpopup.prototype.doClick_ = function (evt, popupOnly) {
    if (evt.domTarget == this.$n()) this.parent.focus();
    _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  Bandpopup = __decorate([zk.WrapClass('zul.inp.Bandpopup')], Bandpopup);
  return Bandpopup;
}(zul.Widget);
exports.Bandpopup = Bandpopup;
window.zul.inp.Bandpopup_.Bandpopup = Bandpopup;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/ComboWidget.ts":
/*!**************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/ComboWidget.ts ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* ComboWidget.ts

    Purpose:

    Description:

    History:
        Tue Mar 31 14:15:39     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.ComboWidget_) window.zul.inp.ComboWidget_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ComboWidget = void 0;
/**
 * A skeletal implementation for a combo widget.
 */
var ComboWidget = /** @class */function (_super) {
  __extends(ComboWidget, _super);
  function ComboWidget() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._buttonVisible = true;
    return _this;
  }
  ComboWidget_1 = ComboWidget;
  /**
   * @returns whether the button (on the right of the textbox) is visible.
   * @defaultValue `true`.
   */
  ComboWidget.prototype.isButtonVisible = function () {
    return this._buttonVisible;
  };
  /**
   * Sets whether the button (on the right of the textbox) is visible.
   */
  ComboWidget.prototype.setButtonVisible = function (buttonVisible, opts) {
    var o = this._buttonVisible;
    this._buttonVisible = buttonVisible;
    if (o !== buttonVisible || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      zul.inp.RoundUtl.buttonVisible(this, buttonVisible);
    }
    return this;
  };
  /**
   * @returns whether to automatically drop the list if users is changing
   * this text box.
   * @defaultValue `false`.
   */
  ComboWidget.prototype.isAutodrop = function () {
    return !!this._autodrop;
  };
  /**
   * Sets whether to automatically drop the list if users is changing
   * this text box.
   */
  ComboWidget.prototype.setAutodrop = function (autodrop) {
    this._autodrop = autodrop;
    return this;
  };
  /**
   * @returns the width of the popup of this component.
   * @since 8.0.3
   */
  ComboWidget.prototype.getPopupWidth = function () {
    return this._popupWidth;
  };
  /**
   * Sets the width of the popup of this component
   * If the input is a percentage, the popup width will be calculated by multiplying the width of this component with the percentage.
   * (e.g. if the input string is 130%, and the width of this component is 300px, the popup width will be 390px = 300px * 130%)
   * Others will be set directly.
   * @param popupWidth - of the popup of this component
   * @since 8.0.3
   */
  ComboWidget.prototype.setPopupWidth = function (popupWidth, opts) {
    var o = this._popupWidth;
    this._popupWidth = popupWidth;
    if (o !== popupWidth || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this._open) {
        var pp = this.getPopupNode_(),
          pp2 = this.getPopupNode_(true);
        if (!pp) return this;
        var ppofs = this._getPopupSize(pp, pp2);
        this._fixsz(ppofs);
        this._checkPopupSpaceAndPosition(pp, this.$n_());
        this._fixFfWhileBothScrollbar(pp, pp2);
      }
    }
    return this;
  };
  /**
   * @returns the type.
   * @defaultValue text.
   */
  ComboWidget.prototype.getType = function () {
    return this._type;
  };
  /**
   * Sets the type.
   * @param type - the type. Acceptable values are "text" and "password".
   * Unlike XUL, "timed" is redudant because it is enabled as long as
   * onChanging is added.
   * @since 8.5.0
   */
  ComboWidget.prototype.setType = function (type, opts) {
    var o = this._type;
    this._type = type;
    if (o !== type || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var inp = this.getInputNode();
      if (inp) inp.type = type;
    }
    return this;
  };
  /**
   * @returns the iconSclass name of this ComboWidget.
   */
  ComboWidget.prototype.getIconSclass = function () {
    return this._iconSclass;
  };
  /**
   * Sets the iconSclass name of this ComboWidget.
   * @since 8.6.2
   */
  ComboWidget.prototype.setIconSclass = function (iconSclass, opts) {
    var o = this._iconSclass;
    this._iconSclass = iconSclass;
    if (o !== iconSclass || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var icon = this.$n('icon');
      if (this.desktop && icon) icon.className = this.$s('icon') + ' ' + iconSclass;
    }
    return this;
  };
  ComboWidget.prototype.setWidth = function (width) {
    _super.prototype.setWidth.call(this, width);
    if (this.desktop) {
      this.onSize();
    }
    return this;
  };
  /**
   * For internal use only.
   * Update the value of the input element in this component
   */
  ComboWidget.prototype.setRepos = function (repos) {
    if (!this._repos && repos) {
      if (this.desktop) {
        this._shallFixPopupDimension = true;
      }
      this._repos = false;
    }
    return this;
  };
  ComboWidget.prototype.onSize = function () {
    if (this._open) {
      var pp = this.getPopupNode_();
      if (pp) this._checkPopupSpaceAndPosition(pp, this.$n_());
    }
  };
  ComboWidget.prototype.onFloatUp = function (ctl) {
    var _a;
    if (!this._inplace && !this.isOpen() || jq(this.getPopupNode_()).is(':animated')) return;
    var wgt = ctl.origin;
    if (!zUtl.isAncestor(this, wgt)) {
      if (this.isOpen()) this.close({
        sendOnOpen: true
      });
      if (this._inplace) {
        var n = this.$n(),
          inplace = this.getInplaceCSS();
        if (jq(n).hasClass(inplace)) return;
        n.style.width = jq.px0(zk(n).revisedWidth(n.offsetWidth));
        jq(this.getInputNode()).addClass(inplace);
        jq(n).addClass(inplace);
        this.onSize();
        n.style.width = (_a = this.getWidth()) !== null && _a !== void 0 ? _a : '';
      }
    }
  };
  ComboWidget.prototype.onResponse = function (ctl, opts) {
    var _this = this;
    if ((this._shallFixPopupDimension || opts.rtags.onOpen || opts.rtags.onChanging) && this.isOpen()) {
      // ZK-2192: Only need to determine if popup is animating
      if (jq(this.getPopupNode_()).is(':animated')) {
        setTimeout(function () {
          if (_this.desktop) _this.onResponse(ctl, opts);
        }, 50);
        return;
      }
      this.fixPopupDimension_();
    }
  };
  ComboWidget.prototype.fixPopupDimension_ = function () {
    var _a, _b;
    this._shallFixPopupDimension = false;
    var pp = this.getPopupNode_(),
      pz = this.getPopupSize_(pp),
      scrollPos = {}; // Bug ZK-2294
    try {
      scrollPos.left = pp.scrollLeft;
      scrollPos.Top = pp.scrollTop;
      pp.style.height = 'auto'; // ZK-2086: BandBox popup invalid render if ON_OPEN event listener is attached
      this._fixsz(pz);
    } finally {
      // Bug ZK-2294, restore the scroll position
      pp.scrollTop = (_a = scrollPos.Top) !== null && _a !== void 0 ? _a : 0;
      pp.scrollLeft = (_b = scrollPos.left) !== null && _b !== void 0 ? _b : 0;
    }
  };
  ComboWidget.prototype.onScroll = function (wgt) {
    if (this.isOpen()) {
      // ZK-1552: fix the position of popup when scroll
      if (wgt) {
        var inp = this.getInputNode();
        // ZK-2211: should close when the input is out of view
        if (inp && zul.inp.InputWidget._isInView(this)) zk(this.getPopupNode_()).position(inp, 'after_start');else this.close({
          sendOnOpen: true
        });
      }
    }
  };
  /**
   * Drops down or closes the list of combo items ({@link Comboitem}.
   * @param opts - the options.
   * @see {@link open}
   * @see {@link close}
   */
  ComboWidget.prototype.setOpen = function (open, opts) {
    var _this = this;
    if (this.desktop) {
      if (this.isRealVisible()) {
        if (open) this.open(opts);else this.close(opts);
      }
    } else {
      zk.afterMount(function () {
        return _this.setOpen(open, opts);
      });
    }
    return this;
  };
  /**
   * @returns whether the list of combo items is open
   */
  ComboWidget.prototype.isOpen = function () {
    return !!this._open;
  };
  /**
   * Drops down the list of combo items ({@link Comboitem}.
   * It is the same as setOpen(true).
   * @param opts - the options.
   */
  ComboWidget.prototype.open = function (opts) {
    if (this._open) return;
    if (this._inplace) this._inplaceIgnore = true;
    this._open = true;
    if (opts && opts.focus) this.focus();
    var pp = this.getPopupNode_(),
      inp = this.getInputNode(),
      pp2 = this.getPopupNode_(true);
    if (!pp) return;
    this.setFloating_(true, {
      node: pp
    });
    zWatch.fire('onFloatUp', this); //notify all
    var topZIndex = this.setTopmost(),
      /*safe*/sclass = this.getSclass();
    pp.className = this.$s('popup') + (sclass ? ' ' + sclass : ''); // ZK-4234: updated sclass on combobox doesn't update popup
    pp.style.zIndex = topZIndex > 0 ? topZIndex : 1; //on-top of everything
    pp.style.position = 'absolute'; //just in case
    pp.style.display = 'block';
    var ppofs = this._getPopupSize(pp, pp2);
    // throw out
    pp.style.visibility = 'hidden';
    pp.style.left = '-10000px';
    //FF: Bug 1486840
    //IE: Bug 1766244 (after specifying position:relative to grid/tree/listbox)
    //NOTE: since the parent/child relation is changed, new listitem
    //must be inserted into the popup (by use of uuid!child) rather
    //than invalidate!!
    var $pp = zk(pp);
    $pp.makeVParent();
    zWatch.fireDown('onVParent', this);
    this._fixsz(ppofs);
    // throw in
    pp.style.left = '';
    var n = this.$n(),
      jqn = jq(n),
      jqpp = jq(pp);
    this._checkPopupSpaceAndPosition(pp, n);
    this._shallSyncPopupPosition = false;
    var pptop = jqpp.offset().top;
    pp.style.display = 'none';
    pp.style.visibility = '';
    if (jqn.offset().top > pptop) this.slideDown_(pp, 'b');else this.slideDown_(pp);
    this._fixFfWhileBothScrollbar(pp, pp2);
    if (!this._shadow) this._shadow = new zk.eff.Shadow(pp, {
      left: -4,
      right: 4,
      top: -2,
      bottom: 3
    });
    if (opts && opts.sendOnOpen) this.fire('onOpen', {
      open: true,
      value: inp.value
    }, {
      rtags: {
        onOpen: 1
      }
    });
    //add extra CSS class for easy customize
    var openClass = this.$s('open');
    jqn.addClass(openClass);
    jqpp.addClass(openClass);
  };
  /** @internal */
  ComboWidget.prototype._getPopupSize = function (pp, pp2) {
    var ppofs = this.getPopupSize_(pp);
    pp.style.width = ppofs[0];
    pp.style.height = 'auto';
    if (pp2) pp2.style.width = pp2.style.height = 'auto';
    // B50-ZK-859: need to carry out min size here
    if (this.presize_()) ppofs = this.getPopupSize_(pp);
    return ppofs;
  };
  /** @internal */
  ComboWidget.prototype._checkPopupSpaceAndPosition = function (pp, inp) {
    //B80-ZK-3051
    //check the popup space before position()
    var $pp = zk(pp),
      ppHeight = $pp.dimension().height,
      ppWidth = $pp.dimension().width,
      inpDim = zk(inp).dimension(true),
      inpTop = inpDim.top,
      inpLeft = inpDim.left,
      inpHeight = inpDim.height,
      btn = this.$n('btn'),
      inpWidth = inpDim.width - (btn ? btn.offsetWidth : 0),
      screenX = jq.innerX(),
      screenY = jq.innerY(),
      screenHeight = jq.innerHeight(),
      screenWidth = jq.innerWidth(),
      hPosition = 'start',
      vPosition = 'after',
      opts;
    if (screenX + screenWidth - inpLeft - inpWidth > ppWidth) {
      hPosition = 'start';
    } else if (inpLeft - screenX > ppWidth) {
      hPosition = 'end';
    } else {
      opts = {
        overflow: true
      };
    }
    if (screenY + screenHeight - inpTop - inpHeight > ppHeight) {
      vPosition = 'after';
    } else if (inpTop - screenY > ppHeight) {
      vPosition = 'before';
    } else {
      opts = {
        overflow: true
      };
    }
    $pp.position(inp, vPosition + '_' + hPosition, opts);
  };
  /** @internal */
  ComboWidget.prototype._fixFfWhileBothScrollbar = function (pp, pp2) {
    //FF issue:
    //If both horz and vert scrollbar are visible:
    //a row might be hidden by the horz bar.
    if (zk.gecko) {
      var rows = pp2 ? pp2.rows : undefined;
      if (rows) {
        var gap = pp.offsetHeight - pp.clientHeight;
        if (gap > 10 && pp.offsetHeight < 150) {
          //scrollbar
          var hgh = 0;
          for (var j = rows.length; j--;) hgh += rows[j].offsetHeight;
          pp.style.height = jq.px0(hgh + 20);
          //add the height of scrollbar (18 is an experimental number)
        }
      }
    }
  };
  /** @internal */
  ComboWidget.prototype._checkPopupPosition = function () {
    var pp = this.getPopupNode_(),
      $pp = zk(pp),
      inp = this.getInputNode(),
      ppDim = $pp.dimension(true),
      inpDim = zk(inp).dimension(true),
      ppBottom = ppDim.top + ppDim.height,
      ppRight = ppDim.left + ppDim.width,
      ppRelativeBottom = ppBottom - $pp.scrollOffset()[1],
      //minus scroll offset
      inpBottom = inpDim.top + inpDim.height,
      inpRight = inpDim.left + inpDim.width;
    if (ppRelativeBottom >= jq.innerHeight() || ppDim.top < inpDim.top && ppBottom < inpDim.top || ppDim.left < inpRight && ppRight > inpDim.left && ppBottom > inpDim.top && ppDim.top < inpBottom) {
      return this._shallSyncPopupPosition = true;
    }
    return false;
  };
  /**
   * Extra handling for min size of popup widget. Return true if size is affected.
   * @internal
   */
  ComboWidget.prototype.presize_ = function () {
    return false;
  };
  /**
   * Slides down the drop-down list.
   * @defaultValue `zk(pp).slideDown(this, {afterAnima: this._afterSlideDown});`
   * @param pp - the DOM element of the drop-down list.
   * @since 5.0.4
   * @internal
   */
  ComboWidget.prototype.slideDown_ = function (pp, anchor) {
    zk(pp).slideDown(this, {
      afterAnima: this._afterSlideDown,
      duration: 100,
      anchor: anchor
    });
  };
  /**
   * Slides up the drop-down list.
   * @defaultValue `pp.style.display = "none";`<br/>
   * In other words, it just hides it without any animation effect.
   * @param pp - the DOM element of the drop-down list.
   * @since 5.0.4
   * @internal
   */
  ComboWidget.prototype.slideUp_ = function (pp) {
    pp.style.display = 'none';
  };
  ComboWidget.prototype.zsync = function (opts) {
    _super.prototype.zsync.call(this, opts);
    if (!zk.css3 && this.isOpen() && this._shadow) this._shadow.sync();
  };
  /** @internal */
  ComboWidget.prototype._afterSlideDown = function (n) {
    if (!this.desktop) {
      //Bug 3035847: close (called by unbind) won't remove popup when animating
      zk(n).undoVParent(); //no need to fire onVParent since it will be removed
      jq(n).remove();
    }
    if (this._shadow) this._shadow.sync();
  };
  /**
   * @returns the DOM element of the popup.
   * @defaultValue `inner ? this.$n("cave"): this.$n("pp")`.
   * Override it if it is not the case.
   * @param inner - whether to return the inner popup.
   * ComboWidget assumes there is at least one popup and returned by
   * `getPopupNode_()`, and there might be an inner DOM element
   * returned by `getPopupNode_(true)`.
   * @since 5.0.4
   * @internal
   */
  ComboWidget.prototype.getPopupNode_ = function (inner) {
    return inner ? this.$n('cave') : this.$n('pp');
  };
  /**
   * Closes the list of combo items ({@link Comboitem} if it was
   * dropped down.
   * It is the same as setOpen(false).
   * @param opts - the options.
   */
  ComboWidget.prototype.close = function (opts) {
    if (!this._open) return;
    if (this._inplace) this._inplaceIgnore = false;
    var self = this;
    // ZK-2192: Only need to determine if popup is animating
    if (jq(this.getPopupNode_()).is(':animated')) {
      setTimeout(function () {
        if (self.desktop) self.close(opts);
      }, 50);
      return;
    }
    this._open = false;
    if (opts && opts.focus) {
      this.focus();
    }
    var pp = this.getPopupNode_();
    if (!pp) return;
    this.setFloating_(false);
    zWatch.fireDown('onHide', this);
    this.slideUp_(pp);
    zk.afterAnimate(function () {
      zk(pp).undoVParent();
      zWatch.fireDown('onVParent', self);
    }, -1);
    if (this._shadow) {
      this._shadow.destroy();
      this._shadow = undefined;
    }
    if (opts && opts.sendOnOpen) this.fire('onOpen', {
      open: false,
      value: this.getInputNode().value
    }, {
      rtags: {
        onOpen: 1
      }
    });
    //remove extra CSS class
    var openClass = this.$s('open');
    jq(this.$n()).removeClass(openClass);
    jq(pp).removeClass(openClass);
  };
  /** @internal */
  ComboWidget.prototype._fixsz = function (ppofs) {
    var pp = this.getPopupNode_();
    if (!pp) return;
    var pp2 = this.getPopupNode_(true);
    if (ppofs[1] == 'auto' && pp.offsetHeight > 350) {
      pp.style.height = '350px';
    } else if (pp.offsetHeight < 10) {
      // B65-ZK-2021: Only need to manually sync shadow when there is no item matched.
      if (this._shadow) this._shadow.sync();
    }
    var cb = this.$n(),
      i;
    if (i = this.getPopupWidth()) {
      if (i.endsWith('%')) {
        pp.style.width = jq.px0(cb.offsetWidth * parseFloat(i) / 100.0);
      } else {
        pp.style.width = i;
      }
      return;
    }
    if (ppofs[0] == 'auto') {
      if (pp.offsetWidth <= cb.offsetWidth) {
        pp.style.width = jq.px0(zk(pp).revisedWidth(cb.offsetWidth));
        if (pp2) pp2.style.width = '100%';
        //Note: we have to set width to auto and then 100%
        //Otherwise, the width is too wide in IE
      } else {
        var wd = jq.innerWidth() - 20;
        if (wd < cb.offsetWidth) wd = cb.offsetWidth;
        if (pp.offsetWidth > wd) pp.style.width = jq.px0(wd);
      }
    }
  };
  ComboWidget.prototype.dnPressed_ = function (evt) {
    // empty on purpose
  };
  ComboWidget.prototype.upPressed_ = function (evt) {
    // empty on purpose
  };
  ComboWidget.prototype.otherPressed_ = function (evt) {
    // empty on purpose
  };
  /**
   * Called when the user presses enter when this widget has the focus ({@link focus}).
   * <p>call the close function
   * @param evt - the widget event.
   * The original DOM event and target can be retrieved by {@link zk.Event#domEvent} and {@link zk.Event#domTarget}
   * @see {@link close}
   */
  ComboWidget.prototype.enterPressed_ = function (evt) {
    this.close({
      sendOnOpen: true
    });
    this.updateChange_();
    evt.stop();
  };
  /**
   * Called when the user presses escape key when this widget has the focus ({@link focus}).
   * <p>call the close function
   * @param evt - the widget event.
   * The original DOM event and target can be retrieved by {@link zk.Event#domEvent} and {@link zk.Event#domTarget}
   * @see {@link close}
   */
  ComboWidget.prototype.escPressed_ = function (evt) {
    this.close({
      sendOnOpen: true
    });
    evt.stop();
  };
  /**
   * @returns [width, height] for the popup if specified by user.
   * @defaultValue ['auto', 'auto']
   */
  ComboWidget.prototype.getPopupSize_ = function (pp) {
    return ['auto', 'auto'];
  };
  /**
   * Called by {@link redraw_} to redraw popup.
   * @defaultValue does nothing
   *  @param out - an array of HTML fragments.
   */
  ComboWidget.prototype.redrawpp_ = function (out) {
    // empty on purpose
  };
  /** @internal */
  ComboWidget.prototype.afterKeyDown_ = function (evt, simulated) {
    if (!simulated && this._inplace) jq(this.$n_()).toggleClass(this.getInplaceCSS(), evt.keyCode == 13);
    return _super.prototype.afterKeyDown_.call(this, evt, simulated);
  };
  /** @internal */
  ComboWidget.prototype._dnInputOpen = function () {
    if (this._autodrop && !this._open) this.open({
      sendOnOpen: true
    });
  };
  /** @internal */
  ComboWidget.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var btn;
    if (btn = this.$n('btn')) {
      this.domListen_(btn, 'onClick', '_doBtnClick');
      if (this._inplace) this.domListen_(btn, 'onMouseDown', '_doBtnMouseDown');
    }
    this.domListen_(this.$n('real'), 'onInput', '_dnInputOpen');
    zWatch.listen({
      onSize: this,
      onFloatUp: this,
      onResponse: this,
      onScroll: this
    });
    if (!zk.css3) jq.onzsync(this);
  };
  /** @internal */
  ComboWidget.prototype.unbind_ = function (skipper, after, keepRod) {
    this.close();
    var btn = this.$n('btn');
    if (btn) {
      this.domUnlisten_(btn, 'onClick', '_doBtnClick');
      if (this._inplace) this.domUnlisten_(btn, 'onMouseDown', '_doBtnMouseDown');
    }
    zWatch.unlisten({
      onSize: this,
      onFloatUp: this,
      onResponse: this,
      onScroll: this
    });
    if (!zk.css3) jq.unzsync(this);
    this.domUnlisten_(this.$n('real'), 'onInput', '_dnInputOpen');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  ComboWidget.prototype.inRoundedMold = function () {
    return true;
  };
  /** @internal */
  ComboWidget.prototype._doBtnClick = function (evt) {
    this._inplaceIgnore = false;
    if (!this._buttonVisible) return;
    // ZK-2192: Only need to determine if popup is animating
    if (!this._disabled && !jq(this.getPopupNode_()).is(':animated')) {
      if (this._open) this.close({
        focus: zul.inp.InputCtrl.isPreservedFocus(this),
        sendOnOpen: true
      });else this.open({
        focus: zul.inp.InputCtrl.isPreservedFocus(this),
        sendOnOpen: true
      });
    }
    if (zk.ios) {
      //Bug ZK-1313: keep window offset information before virtual keyboard opened on ipad
      this._windowX = window.pageXOffset;
      this._windowY = window.pageYOffset;
    }
    // Bug ZK-2544, B70-ZK-2849
    evt.stop(this._open ? {
      propagation: 1
    } : undefined);
  };
  /** @internal */
  ComboWidget.prototype._doBtnMouseDown = function (evt) {
    this._inplaceIgnore = true;
  };
  /** @internal */
  ComboWidget.prototype.doKeyDown_ = function (evt) {
    if (!this._disabled) {
      this._doKeyDown(evt);
      if (!evt.stopped) _super.prototype.doKeyDown_.call(this, evt);
    }
  };
  /** @internal */
  ComboWidget.prototype.doKeyUp_ = function (evt) {
    this._updateValue();
    _super.prototype.doKeyUp_.call(this, evt);
  };
  /** @internal */
  ComboWidget.prototype.doClick_ = function (evt, popupOnly) {
    if (!this._disabled) {
      if (evt.domTarget == this.getPopupNode_()) this.close({
        focus: zul.inp.InputCtrl.isPreservedFocus(this),
        sendOnOpen: true
      });else if (this._readonly && !this.isOpen() && this._buttonVisible) this.open({
        focus: zul.inp.InputCtrl.isPreservedFocus(this),
        sendOnOpen: true
      });
      _super.prototype.doClick_.call(this, evt, popupOnly);
    }
  };
  /** @internal */
  ComboWidget.prototype._doKeyDown = function (evt) {
    var keyCode = evt.keyCode,
      bOpen = this._open;
    // Bug ZK-475, ZK-3635
    if (evt.target == this && keyCode == 9) {
      //TAB or SHIFT-TAB
      if (bOpen) this.close({
        sendOnOpen: true
      });
      return;
    }
    if (evt.altKey && (keyCode == 38 || keyCode == 40)) {
      //UP/DN
      if (bOpen) this.close({
        sendOnOpen: true
      });else this.open({
        sendOnOpen: true
      });
      //FF: if we eat UP/DN, Alt+UP degenerate to Alt (select menubar)
      var opts = {
        propagation: true
      };
      evt.stop(opts);
      return;
    }
    //Request 1537962: better responsive
    if (bOpen && (keyCode == 13 || keyCode == 27)) {
      //ENTER or ESC
      if (keyCode == 13) this.enterPressed_(evt);else this.escPressed_(evt);
      return;
    }
    if (keyCode == 38) this.upPressed_(evt);else if (keyCode == 40) this.dnPressed_(evt);else this.otherPressed_(evt);
  };
  /* B65-ZK-2021: Too many unnecessary shadow sync calls.
  onChildAdded_: _zkf = function (child) {
      if (this._shadow) this._shadow.sync();
  },
  onChildRemoved_: _zkf,
  onChildVisible_: _zkf,
  */
  /**
   * Utility to implement {@link redraw}.
   * @param out - an array of HTML fragments.
   * @internal
   */
  ComboWidget.prototype.redraw_ = function (out) {
    var uuidHTML = this.uuid,
      isButtonVisible = this._buttonVisible;
    out.push('<span', this.domAttrs_({
      text: true,
      tabindex: true
    }), ' role="combobox" aria-expanded="false" aria-owns="', uuidHTML, '-pp" aria-haspopup="dialog"><input id="', uuidHTML, '-real" class="', this.$s('input'));
    if (!isButtonVisible) out.push(' ', this.$s('input-full'));
    out.push('" autocomplete="off" aria-autocomplete="none" aria-controls="', uuidHTML, '-pp"', /*safe*/this.textAttrs_(), '/><a id="', uuidHTML, '-btn" tabindex="-1" role="button" aria-label="', /*safe*/msgzul.PANEL_EXPAND, '" class="', this.$s('button'));
    if (!isButtonVisible) out.push(' ', this.$s('disabled'));
    out.push('" aria-hidden="true"><i id="', /*safe*/uuidHTML, '-icon" class="', this.$s('icon'), ' ', /*safe*/this.getIconSclass(), '"></i></a>');
    this.redrawpp_(out);
    out.push('</span>');
  };
  var ComboWidget_1;
  ComboWidget.$redraw = ComboWidget_1.prototype.redraw_;
  ComboWidget = ComboWidget_1 = __decorate([zk.WrapClass('zul.inp.ComboWidget')], ComboWidget);
  return ComboWidget;
}(zul.inp.InputWidget);
exports.ComboWidget = ComboWidget;
window.zul.inp.ComboWidget_.ComboWidget = ComboWidget;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/Combobox.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/Combobox.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.Combobox_) window.zul.inp.Combobox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Combobox = void 0;
/* Combobox.ts

    Purpose:

    Description:

    History:
        Sun Mar 29 20:52:45     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A combobox.
 *
 * <p>Non-XUL extension. It is used to replace XUL menulist. This class
 * is more flexible than menulist, such as {@link setAutocomplete}
 * {@link setAutodrop}.
 *
 * @defaultValue {@link getZclass}: z-combobox.
 *
 * <p>Like {@link zul.db.Datebox},
 * the value of a read-only comobobox ({@link isReadonly}) can be changed
 * by dropping down the list and selecting an combo item
 * (though users cannot type anything in the input box).
 *
 * @see Comboitem
 */
var Combobox = /** @class */function (_super) {
  __extends(Combobox, _super);
  function Combobox() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._autocomplete = true;
    /** @internal */
    _this._instantSelect = true;
    /** @internal */
    _this._iconSclass = 'z-icon-caret-down';
    /** @internal */
    _this._shallRedoCss = false;
    /** @internal */
    _this._isOnChanging = false;
    /** @internal */
    _this._autoCompleteSuppressed = false;
    /** @internal */
    _this._bDel = false;
    return _this;
  }
  /**
   * @returns whether to automatically complete this text box
   * by matching the nearest item ({@link Comboitem}.
   * It is also known as auto-type-ahead.
   *
   * @defaultValue `true`
   *
   * <p>If true, the nearest item will be searched and the text box is
   * updated automatically.
   * If false, user has to click the item or use the DOWN or UP keys to
   * select it back.
   *
   * <p>Don't confuse it with the auto-completion feature mentioned by
   * other framework. Such kind of auto-completion is supported well
   * by listening to the onChanging event.
   */
  Combobox.prototype.isAutocomplete = function () {
    return this._autocomplete;
  };
  /**
   * Sets whether to automatically complete this text box
   * by matching the nearest item ({@link Comboitem}.
   */
  Combobox.prototype.setAutocomplete = function (autocomplete) {
    this._autocomplete = autocomplete;
    return this;
  };
  /**
   * @returns the message to display when no matching results was found
   * @since 8.5.1
   */
  Combobox.prototype.getEmptySearchMessage = function () {
    return this._emptySearchMessage;
  };
  /**
   * Sets the message to display when no matching results was found
   * @since 8.5.1
   */
  Combobox.prototype.setEmptySearchMessage = function (emptySearchMessage, opts) {
    var o = this._emptySearchMessage;
    this._emptySearchMessage = emptySearchMessage;
    if (o !== emptySearchMessage || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var msg = this.$n('empty-search-message');
      if (emptySearchMessage && msg && emptySearchMessage != jq(msg).text()) {
        jq(msg).text(emptySearchMessage);
      }
    }
    return this;
  };
  /**
   * @returns true if onSelect event is sent as soon as user selects using keyboard navigation.
   * @defaultValue `true`
   * @since 8.6.1
   */
  Combobox.prototype.isInstantSelect = function () {
    return this._instantSelect;
  };
  /**
   * Sets the instantSelect attribute. When the attribute is true, onSelect event
   * will be fired as soon as user selects using keyboard navigation.
   *
   * If the attribute is false, user needs to press Enter key to finish the selection using keyboard navigation.
   * @since 8.6.1
   */
  Combobox.prototype.setInstantSelect = function (instantSelect) {
    this._instantSelect = instantSelect;
    return this;
  };
  /**
   * Returns the selected item if any.
   * @since 10.0.0
   */
  Combobox.prototype.getSelectedItem = function () {
    return this._sel;
  };
  Combobox.prototype.onResponse = function (ctl, opts) {
    var _this = this;
    // Bug ZK-2960: need to wait until the animation is finished before calling super
    if (this.isOpen() && jq(this.getPopupNode_()).is(':animated')) {
      setTimeout(function () {
        if (_this.desktop) _this.onResponse(ctl, opts);
      }, 50);
      return;
    }
    _super.prototype.onResponse.call(this, ctl, opts);
    if (opts && opts.rtags && opts.rtags.onChanging && this.isOpen()) {
      this._isOnChanging = true;
    }
    this.fixPopupDimension_();
  };
  /** @internal */
  Combobox.prototype.fixPopupDimension_ = function () {
    _super.prototype.fixPopupDimension_.call(this);
    if (this._shallRedoCss) {
      //fix in case
      zk(this.getPopupNode_()).redoCSS(-1);
      this._shallRedoCss = false;
    }
    //ZK-3204 check popup position after onChanging
    if (this._isOnChanging && this.isOpen()) {
      this._isOnChanging = false;
      this._checkPopupPosition();
      // F85-ZK-3827: Combobox empty search message
      this._fixEmptySearchMessage();
    }
    // B65-ZK-1990: Fix position of popup when it appears above the input, aligned to the left
    if (this.isOpen() && this._shallSyncPopupPosition) {
      zk(this.getPopupNode_()).position(this.getInputNode(), 'before_start');
      this._shallSyncPopupPosition = false;
    }
  };
  /** @internal */
  Combobox.prototype.setSelectedItemUuid_ = function (selectedItemUuid) {
    if (this.desktop) {
      if (!this._sel || selectedItemUuid != this._sel.uuid) {
        var oldSel = this._sel,
          sel;
        this._sel = this._lastsel = undefined;
        var w = zk.$(selectedItemUuid);
        if (w) sel = w;
        this._hiliteOpt(oldSel, this._sel = sel);
        this._lastsel = sel;
      }
    } else this._initSelUuid = selectedItemUuid;
  };
  // since 10.0.0 for Client Bind to use
  /** @internal */
  Combobox.prototype.setSelectedIndex_ = function (selectedIndex) {
    if (selectedIndex >= 0) {
      if (this.desktop) {
        var selectedItem = this.getChildAt(selectedIndex);
        this.setSelectedItemUuid_(selectedItem.uuid);
      } else {
        this._initSelIndex = selectedIndex;
      }
    }
  };
  /**
   * For internal use only.
   * Update the value of the input element in this component
   */
  Combobox.prototype.setRepos = function (repos) {
    if (!this._repos && repos) {
      _super.prototype.setRepos.call(this, repos);
      if (this.desktop) {
        this._typeahead(this._bDel);
        this._bDel = false;
        //Fixed bug 3290858: combobox with autodrop and setModel in onChanging
        var pp = this.getPopupNode_();
        //will update it later in onResponse with _fixsz
        if (pp) {
          pp.style.width = 'auto';
          if (zk.webkit) this._shallRedoCss = true;
        }
      }
    }
    return this;
  };
  Combobox.prototype.setValue = function (value, fromServer) {
    _super.prototype.setValue.call(this, value, fromServer);
    this._reIndex();
    this.valueEnter_ = undefined; // reset bug #3014660
    this._lastsel = this._sel; // ZK-1256, ZK-1276: set initial selected item
    return this;
  };
  /** @internal */
  Combobox.prototype._reIndex = function () {
    var value = this.getValue();
    if (!this._sel || value != this._sel.getLabel()) {
      if (this._sel) {
        var n = this._sel.$n();
        if (n) jq(n).removeClass(this._sel.$s('selected'));
      }
      this._sel = this._lastsel = undefined;
      for (var w = this.firstChild; w; w = w.nextSibling) {
        if (value == w.getLabel()) {
          this._sel = w;
          break;
        }
      }
    }
  };
  /**
   * Called by SimpleConstraint
   * @param val - the name of flag, such as "no positive".
   */
  Combobox.prototype.validateStrict = function (val) {
    var cst = this._cst;
    return this._findItem(val, true) ? undefined : (cst ? cst._errmsg.STRICT ? cst._errmsg.STRICT : '' : '') || msgzul.VALUE_NOT_MATCHED;
  };
  /** @internal */
  Combobox.prototype._findItem = function (val, strict) {
    return this._findItem0(val, strict);
  };
  /** @internal */
  Combobox.prototype._findItem0 = function (val, strict, startswith, excluding) {
    var fchild = this.firstChild;
    if (fchild && val) {
      val = val.toLowerCase();
      var sel = this._sel;
      if (!sel || sel.parent != this) sel = fchild;
      for (var item = excluding ? sel.nextSibling ? sel.nextSibling : fchild : sel;;) {
        if ((!strict || !item.isDisabled()) && item.isVisible() && (startswith ? item.getLabel().toLowerCase().startsWith(val) : val == item.getLabel().toLowerCase())) return item;
        if (!(item = item.nextSibling)) item = fchild;
        if (item == sel) break;
      }
    }
  };
  /** @internal */
  Combobox.prototype._hilite = function (opts) {
    this._hilite2(this._findItem(this.valueEnter_ = this.getInputNode().value, this._isStrict() || (opts === null || opts === void 0 ? void 0 : opts.strict)), opts);
  };
  /** @internal */
  Combobox.prototype._hilite2 = function (sel, opts) {
    opts = opts !== null && opts !== void 0 ? opts : {};
    var oldsel = this._sel;
    this._sel = sel;
    this._hiliteOpt(oldsel, sel);
    if (opts.sendOnSelect && this._lastsel != sel) {
      if (sel) {
        //set back since _findItem ignores cases
        var inp = this.getInputNode(),
          val = sel.getLabel(),
          selectionRange;
        this.valueEnter_ = inp.value = val;
        if (selectionRange) inp.setSelectionRange(selectionRange[0], selectionRange[1]);
        //Bug 3058028
        // ZK-518
        if (!opts.noSelectRange) {
          if (zk.gecko) inp.select();else zk(inp).setSelectionRange(0, val.length);
        }
      }
      if (opts.sendOnChange) _super.prototype.updateChange_.call(this);
      this.fire('onSelect', {
        items: sel ? [sel] : [],
        reference: sel,
        prevSeld: oldsel
      });
      this._lastsel = sel;
      //spec change (diff from zk 3): onSelect fired after onChange
      //purpose: onSelect can retrieve the value correctly
      //If we want to change this spec, we have to modify Combobox.java about _lastCkVal
    } else if (opts.sendOnChange)
      // The value still didn't match any item, but onChange is still needed.
      _super.prototype.updateChange_.call(this);
  };
  /** @internal */
  Combobox.prototype._hiliteOpt = function (oldTarget, newTarget) {
    if (oldTarget && oldTarget.parent == this) {
      var n = oldTarget.$n();
      if (n) jq(n).removeClass(oldTarget.$s('selected'));
    }
    if (newTarget && !newTarget.isDisabled()) jq(newTarget.$n()).addClass(newTarget.$s('selected'));
  };
  /** @internal */
  Combobox.prototype._isStrict = function () {
    var _a;
    var strict = this.getConstraint();
    return !!((_a = strict === null || strict === void 0 ? void 0 : strict._flags) === null || _a === void 0 ? void 0 : _a.STRICT);
  };
  //super
  Combobox.prototype.open = function (opts) {
    _super.prototype.open.call(this, opts);
    this._hilite(); //after _open is set
  };
  /** @internal */
  Combobox.prototype.dnPressed_ = function (evt) {
    this._updnSel(evt);
  };
  /** @internal */
  Combobox.prototype.upPressed_ = function (evt) {
    this._updnSel(evt, true);
  };
  /** @internal */
  Combobox.prototype._updnSel = function (evt, bUp) {
    var inp = this.getInputNode(),
      val = inp.value,
      sel,
      looseSel;
    // ZK-2200: the empty combo item should work
    if (val || this._sel) {
      val = val.toLowerCase();
      var beg = this._sel;
      if (!beg || beg.parent != this) {
        beg = this._next(undefined, !bUp);
      }
      if (!beg) {
        evt.stop();
        return; //ignore it
      }
      //Note: we always assume strict when handling up/dn
      for (var item = beg;;) {
        if (!item.isDisabled() && item.isVisible()) {
          var label = item.getLabel().toLowerCase();
          if (val == label) {
            sel = item;
            break;
          } else if (!looseSel && label.startsWith(val)) {
            looseSel = item;
            break;
          }
        }
        var nextitem = this._next(item, bUp);
        if (item == nextitem) break; //prevent infinite loop
        if ((item = nextitem) == beg) break;
      }
      if (!sel) sel = looseSel;
      if (sel) {
        //exact match
        var ofs = zk(inp).getSelectionRange();
        if (ofs[0] == 0 && ofs[1] == val.length) {
          //full selected
          sel = this._next(sel, bUp); //next
        }
      } else {
        sel = this._next(undefined, !bUp);
      }
    } else {
      sel = this._next(undefined, true);
    }
    if (sel) zk(sel).scrollIntoView(this.$n('pp'));
    //B70-ZK-2548: fire onChange event to notify server the current value
    var highlightOnly = !this._instantSelect && this._open;
    this._select(sel, highlightOnly ? {} : {
      sendOnSelect: true,
      sendOnChange: true
    });
    evt.stop();
  };
  /** @internal */
  Combobox.prototype._next = function (item, bUp) {
    function getVisibleItemOnly(item, bUp, including) {
      var next = bUp ? 'previousSibling' : 'nextSibling';
      for (var n = including ? item : item[next]; n; n = n[next]) if (!n.isDisabled() && n.isVisible())
        // ZK-1728: check if the item is visible
        return n;
      return undefined;
    }
    if (item) item = getVisibleItemOnly(item, bUp);
    return item ? item : getVisibleItemOnly(bUp ? this.firstChild : this.lastChild, !bUp, true);
  };
  /** @internal */
  Combobox.prototype._select = function (sel, opts) {
    var inp = this.getInputNode(),
      val = inp.value = sel ? sel.getLabel() : '';
    this.valueSel_ = val;
    this._hilite2(sel, opts);
    // Fixed IE/Safari/Chrome
    // ZK-518: Selected value in combobox is right aligned in FF5+ if width is smaller than selected option
    // setSelectionRange of FF5 or up will set the position to end,
    // call select() of input element for select all
    if (val) {
      if (zk.gecko) inp.select();else zk(inp).setSelectionRange(0, val.length);
    }
  };
  /** @internal */
  Combobox.prototype.otherPressed_ = function (evt) {
    var keyCode = evt.keyCode;
    this._bDel = keyCode == 8 /*BS*/ || keyCode == 46; /*DEL*/
    if (this._readonly) switch (keyCode) {
      case 35: //End
      case 36:
        //Home
        this._hilite2();
        this.getInputNode().value = '';
      //fall through
      case 37: //Left
      case 39:
        //Right
        this._updnSel(evt, keyCode == 37 || keyCode == 35);
        break;
      case 8:
        //Backspace
        evt.stop();
        break;
      default:
        //B70-ZK-2590: dealing with numpad keyDown, only 0~9
        if (keyCode >= 96 && keyCode <= 105) keyCode -= 48;
        var v = String.fromCharCode(keyCode);
        var sel = this._findItem0(v, true, true, !!this._sel);
        if (sel) this._select(sel, {
          sendOnSelect: true
        });
    }
  };
  /** @internal */
  Combobox.prototype.escPressed_ = function (evt) {
    var highlightOnly = !this._instantSelect && this._open;
    if (highlightOnly && this._lastsel != this._sel) {
      this._hilite2(this._lastsel);
      var lastVal = this._lastsel ? this._lastsel.getLabel() : '';
      this.valueSel_ = this.valueEnter_ = this.getInputNode().value = lastVal;
    }
    _super.prototype.escPressed_.call(this, evt);
  };
  /** @internal */
  Combobox.prototype.doKeyUp_ = function (evt) {
    if (!this._disabled) {
      if (!this._readonly && !this._autoCompleteSuppressed) {
        var keyCode = evt.keyCode,
          bDel = keyCode == 8 /*BS*/ || keyCode == 46; /*DEL*/
        // ZK-3607: The value is not ready in onKeyDown, but is ready in onKeyUp
        this._typeahead(bDel);
      }
      _super.prototype.doKeyUp_.call(this, evt);
    }
  };
  /** @internal */
  Combobox.prototype._typeahead = function (bDel) {
    if (zk.currentFocus != this) return;
    var inp = this.getInputNode(),
      val = inp.value,
      ofs = zk(inp).getSelectionRange(),
      fchild = this.firstChild;
    this.valueEnter_ = val;
    if (!val || !fchild || ofs[0] != val.length || ofs[0] != ofs[1])
      //not at end
      return this._hilite({
        strict: true
      });
    var sel = this._findItem(val, true);
    if (sel || bDel || !this._autocomplete) {
      // ZK-2024: the value should have same case with selected label if autocomplete is enabled
      if ((sel === null || sel === void 0 ? void 0 : sel.getLabel().toLowerCase().startsWith(val.toLowerCase())) && this._autocomplete) inp.value = sel.getLabel();
      return this._hilite2(sel);
    }
    //autocomplete
    val = val.toLowerCase();
    sel = this._sel;
    if (!sel || sel.parent != this) sel = fchild;
    for (var item = sel;;) {
      if (!item.isDisabled() && item.isVisible() && item.getLabel().toLowerCase().startsWith(val)) {
        inp.value = item.getLabel();
        zk(inp).setSelectionRange(val.length, inp.value.length);
        this._hilite2(item);
        return;
      }
      if (!(item = item.nextSibling)) item = fchild;
      if (item == sel) {
        this._hilite2(); //not found
        return;
      }
    }
  };
  /** @internal */
  Combobox.prototype.updateChange_ = function () {
    var chng = this._value != this.getInputNode().value; // B50-ZK-297
    if (chng) {
      this._hilite({
        sendOnSelect: true,
        sendOnChange: true,
        noSelectRange: true
      });
      return true;
    }
    this.valueEnter_ = undefined;
    return false;
  };
  /** @internal */
  Combobox.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    // Bug ZK-403
    if (this.isListen('onOpen')) this.listen({
      onChanging: zk.$void
    }, -1000);
    // Bug ZK-1256, ZK-1276: set initial selected item
    if (this._initSelUuid) {
      this.setSelectedItemUuid_(this._initSelUuid);
      this._initSelUuid = undefined;
    } else if (this._initSelIndex >= 0) {
      // for stateless to use
      this.setSelectedIndex_(this._initSelIndex);
      this._initSelIndex = undefined;
    }
    var input = this.getInputNode();
    this.domListen_(input, 'onCompositionstart', '_doCompositionstart').domListen_(input, 'onCompositionend', '_doCompositionend');
  };
  /** @internal */
  Combobox.prototype.unbind_ = function (skipper, after, keepRod) {
    this._hilite2();
    this._sel = this._lastsel = undefined;
    var input = this.getInputNode();
    this.domUnlisten_(input, 'onCompositionend', '_doCompositionend').domUnlisten_(input, 'onCompositionstart', '_doCompositionstart');
    // Bug ZK-403
    if (this.isListen('onOpen')) this.unlisten({
      onChanging: zk.$void
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Combobox.prototype._doCompositionstart = function () {
    this._autoCompleteSuppressed = true;
  };
  /** @internal */
  Combobox.prototype._doCompositionend = function () {
    this._autoCompleteSuppressed = false;
    if (!this._disabled && !this._readonly) this._typeahead(false);
  };
  /** @internal */
  Combobox.prototype.redrawpp_ = function (out) {
    var uuid = this.uuid,
      msg = this._emptySearchMessage;
    out.push('<div id="', /*safe*/uuid, '-pp" class="', this.$s('popup'),
    // tabindex=0 to prevent a11y scrollable popup issue, see https://dequeuniversity.com/rules/axe/3.5/scrollable-region-focusable?application=AxeChrome
    ' ', zUtl.encodeXML(this.getSclass()), '" style="display:none" tabindex="0">');
    // F85-ZK-3827: Combobox empty search message
    if (msg) {
      out.push('<div id="', /*safe*/uuid, '-empty-search-message" class="', this.$s('empty-search-message'), ' ', this.$s('empty-search-message-hidden'), '">', zUtl.encodeXML(msg), '</div>');
    }
    out.push('<ul id="', /*safe*/uuid, '-cave" class="', this.$s('content'), '" >');
    for (var w = this.firstChild; w; w = w.nextSibling) w.redraw(out);
    out.push('</ul></div>');
  };
  /** @internal */
  Combobox.prototype.afterAnima_ = function (visible) {
    // B50-ZK-568: Combobox does not scroll to selected item
    // shall do after slide down
    if (visible && this._lastsel) zk(this._lastsel).scrollIntoView(this.$n('pp'));
    _super.prototype.afterAnima_.call(this, visible);
  };
  /** @internal */
  Combobox.prototype._fixsz = function (ppofs) {
    var pp = this.getPopupNode_();
    pp.style.width = 'auto';
    _super.prototype._fixsz.call(this, ppofs);
    if (zk(pp).hasVScroll() && !this.getPopupWidth()) {
      pp.style.width = jq.px(pp.offsetWidth + jq.scrollbarWidth());
    }
  };
  /** @internal */
  Combobox.prototype._fixEmptySearchMessage = function () {
    if (this._emptySearchMessage) {
      jq(this.$n('empty-search-message')).toggleClass(this.$s('empty-search-message-hidden'), this.nChildren > 0);
    }
  };
  // ZK-5044 (touch enable)
  /** @internal */
  Combobox.prototype.getChildMinSize_ = function (attr, wgt) {
    var result = _super.prototype.getChildMinSize_.call(this, attr, wgt);
    if (attr == 'w' && result == 0) {
      // use label instead
      var zkn = zk(wgt.$n());
      return zkn.textWidth(wgt.getLabel()) + zkn.padBorderWidth();
    }
    return result;
  };
  Combobox = __decorate([zk.WrapClass('zul.inp.Combobox')], Combobox);
  return Combobox;
}(zul.inp.ComboWidget);
exports.Combobox = Combobox;
window.zul.inp.Combobox_.Combobox = Combobox;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/Comboitem.ts":
/*!************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/Comboitem.ts ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.Comboitem_) window.zul.inp.Comboitem_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Comboitem = void 0;
/* Comboitem.ts

    Purpose:

    Description:

    History:
        Sun Mar 29 20:53:45     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * An item of a combo box.
 *
 * <p>Non-XUL extension. Refer to {@link Combobox}.
 *
 * @defaultValue {@link getZclass}: z-comboitem.
 *
 * @see Combobox
 */
var Comboitem = /** @class */function (_super) {
  __extends(Comboitem, _super);
  function Comboitem() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._maxFlexWidth = true; //ZK-5044
    /** @internal */
    _this._disabled = false;
    return _this;
  }
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   */
  Comboitem.prototype.isDisabled = function () {
    return this._disabled;
  };
  /**
   * Sets whether it is disabled.
   */
  Comboitem.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) {
        var disd = this.$s('disabled');
        disabled ? jq(n).addClass(disd) : jq(n).removeClass(disd);
      }
    }
    return this;
  };
  /**
   * @returns the description (never null).
   * The description is used to provide extra information such that
   * users is easy to make a selection.
   * @defaultValue `""`.
   * <p>Deriving class can override it to return whatever it wants
   * other than null.
   */
  Comboitem.prototype.getDescription = function () {
    return this._description;
  };
  /**
   * Sets the description.
   */
  Comboitem.prototype.setDescription = function (description, opts) {
    var o = this._description;
    this._description = description;
    if (o !== description || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the embedded content (i.e., HTML tags) that is
   * shown as part of the description.
   *
   * <p>It is useful to show the description in more versatile way.
   *
   * @defaultValue empty ("").
   *
   * <p>Deriving class can override it to return whatever it wants
   * other than null.
   * @see {@link getDescription}
   */
  Comboitem.prototype.getContent = function () {
    return this._content;
  };
  /**
   * Sets the embedded content (i.e., HTML tags) that is
   * shown as part of the description.
   *
   * <p>It is useful to show the description in more versatile way.
   * @see {@link setDescription}
   */
  Comboitem.prototype.setContent = function (content, opts) {
    var o = this._content;
    this._content = content;
    if (o !== content || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  // since 10.0.0 for Client Bind to use
  Comboitem.prototype.setValue = function (value) {
    this._value = value;
    return this;
  };
  // since 10.0.0 for Client Bind to use
  Comboitem.prototype.getValue = function () {
    return this._value;
  };
  //super
  /** @internal */
  Comboitem.prototype.domLabel_ = function () {
    return zUtl.encodeXML(this.getLabel(), {
      pre: true
    });
  };
  /** @internal */
  Comboitem.prototype.doClick_ = function (evt, popupOnly) {
    if (!this._disabled) {
      var cb = this.parent;
      cb._select(this, {
        sendOnSelect: true,
        sendOnChange: true
      });
      this._updateHoverImage();
      cb.close({
        sendOnOpen: true,
        focus: true
      });
      // Fixed the onFocus event is triggered too late in IE.
      cb._shallClose = true;
      if (zul.inp.InputCtrl.isPreservedFocus(this)) zk(cb.getInputNode()).focus();
      evt.stop();
    }
  };
  /** @internal */
  Comboitem.prototype.domClass_ = function (no) {
    var /*safe*/scls = _super.prototype.domClass_.call(this, no);
    if (this._disabled && (!no || !no.zclass)) {
      scls += ' ' + this.$s('disabled');
    }
    return scls;
  };
  /** @internal */
  Comboitem.prototype.deferRedrawHTML_ = function (out) {
    out.push('<li', this.domAttrs_({
      domClass: true
    }), ' class="z-renderdefer"></li>');
  };
  Comboitem = __decorate([zk.WrapClass('zul.inp.Comboitem')], Comboitem);
  return Comboitem;
}(zul.LabelImageWidget);
exports.Comboitem = Comboitem;
window.zul.inp.Comboitem_.Comboitem = Comboitem;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/Decimalbox.ts":
/*!*************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/Decimalbox.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.Decimalbox_) window.zul.inp.Decimalbox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Decimalbox = void 0;
/* Decimalbox.ts

    Purpose:

    Description:

    History:
        Fri June 11 13:35:32     2009, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * An edit box for holding BigDecimal.
 * @defaultValue {@link getZclass}: z-decimalbox.
 */
var Decimalbox = /** @class */function (_super) {
  __extends(Decimalbox, _super);
  function Decimalbox() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  Decimalbox.prototype.setScale = function (scale) {
    this._scale = scale;
    return this;
  };
  /**
   * @returns the precision scale.
   */
  Decimalbox.prototype.getScale = function () {
    return this._scale;
  };
  /** @internal */
  Decimalbox.prototype.coerceFromString_ = function (value) {
    if (!value) return undefined;
    var info = zk.fmt.Number.unformat(this._format, value, false, this._localizedSymbols),
      val = new zk.BigDecimal(info.raw),
      sval = val.$toString();
    if (info.raw != sval && info.raw != '-' + sval)
      //1e2 not supported (unlike Doublebox)
      return {
        error: zk.fmt.Text.format(msgzul.NUMBER_REQUIRED, value)
      };
    if (this._rounding == 7 && (this._errmsg /*server has to clean up*/ || zk.fmt.Number.isRoundingRequired(value, this.getFormat(), this._localizedSymbols))) return {
      server: true
    };
    if (info.divscale) val.setPrecision(val.getPrecision() + info.divscale);
    if (this._scale > 0)
      //bug #3089502: setScale in decimalbox not working
      val = zk.fmt.Number.setScale(val, this._scale, this._rounding);
    return val;
  };
  /** @internal */
  Decimalbox.prototype.coerceToString_ = function (value) {
    var fmt = this._format;
    return value != null ? typeof value == 'string' ? value : fmt ? zk.fmt.Number.format(fmt, value.$toString(), this._rounding, this._localizedSymbols) : value.$toLocaleString() : '';
  };
  /** @internal */
  Decimalbox.prototype.marshall_ = function (val) {
    return val ? val.$toString() : val;
  };
  /** @internal */
  Decimalbox.prototype.unmarshall_ = function (val) {
    return val ? new zk.BigDecimal(val) : val;
  };
  /** @internal */
  Decimalbox.prototype.getAllowedKeys_ = function () {
    var symbols = this._localizedSymbols;
    return _super.prototype.getAllowedKeys_.call(this) + (symbols ? symbols : zk).DECIMAL; //not support scientific expression
  };
  Decimalbox = __decorate([zk.WrapClass('zul.inp.Decimalbox')], Decimalbox);
  return Decimalbox;
}(zul.inp.NumberInputWidget);
exports.Decimalbox = Decimalbox;
window.zul.inp.Decimalbox_.Decimalbox = Decimalbox;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/Doublebox.ts":
/*!************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/Doublebox.ts ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.Doublebox_) window.zul.inp.Doublebox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Doublebox = void 0;
/* Doublebox.ts

    Purpose:

    Description:

    History:
        Fri Jan 16 13:35:32     2009, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * An edit box for holding an float point value (double).
 * @defaultValue {@link getZclass}: z-doublebox.
 */
var Doublebox = /** @class */function (_super) {
  __extends(Doublebox, _super);
  function Doublebox() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /** @internal */
  Doublebox.prototype.coerceFromString_ = function (value) {
    if (!value) return undefined;
    var info = zk.fmt.Number.unformat(this._format, value, false, this._localizedSymbols),
      raw = info.raw,
      val = parseFloat(raw),
      valstr = '' + val,
      valind = valstr.indexOf('.'),
      rawind = raw.indexOf('.');
    if (isNaN(val) || !valstr.includes('e')) {
      if (rawind == 0) {
        raw = '0' + raw;
        ++rawind;
      }
      if (rawind >= 0 && raw.substring(raw.substring(rawind + 1)) && valind < 0) {
        valind = valstr.length;
        valstr += '.';
      }
      var len = raw.length,
        vallen = valstr.length;
      //pre zeros
      if (valind >= 0 && valind < rawind) {
        vallen -= valind;
        len -= rawind;
        for (var zerolen = rawind - valind; zerolen-- > 0;) valstr = '0' + valstr;
      }
      //post zeros
      if (vallen < len) {
        for (var zerolen = len - vallen; zerolen-- > 0;) valstr += '0';
      }
      if (isNaN(val) || raw != valstr && raw != '-' + valstr && !raw.includes('e')) {
        //1e2: assumes OK
        if (!isNaN(val) && raw != valstr)
          //Bug ZK-1218: show Illegal value instead if input is number but too long
          return {
            error: zk.fmt.Text.format(msgzul.ILLEGAL_VALUE)
          };
        return {
          error: zk.fmt.Text.format(msgzul.NUMBER_REQUIRED, value)
        };
      }
    }
    if (this._rounding == 7 && (this._errmsg /*server has to clean up*/ || zk.fmt.Number.isRoundingRequired(value, this.getFormat(), this._localizedSymbols))) return {
      server: true
    };
    if (info.divscale) val = val / Math.pow(10, info.divscale);
    return val;
  };
  /** @internal */
  Doublebox.prototype._allzero = function (val) {
    for (var len = val.length; len-- > 0;) if (val.charAt(len) != '0') return false;
    return true;
  };
  /** @internal */
  Doublebox.prototype.coerceToString_ = function (value) {
    var fmt = this._format,
      symbols = this._localizedSymbols,
      DECIMAL = (symbols ? symbols : zk).DECIMAL;
    return value == null ? '' : fmt ? zk.fmt.Number.format(fmt, value, this._rounding, symbols) : DECIMAL == '.' ? '' + value : ('' + value).replace('.', DECIMAL);
  };
  /** @internal */
  Doublebox.prototype.getAllowedKeys_ = function () {
    var symbols = this._localizedSymbols;
    return _super.prototype.getAllowedKeys_.call(this) + (symbols ? symbols : zk).DECIMAL + 'e';
    //supports scientific expression such as 1e2
  };
  Doublebox = __decorate([zk.WrapClass('zul.inp.Doublebox')], Doublebox);
  return Doublebox;
}(zul.inp.NumberInputWidget);
exports.Doublebox = Doublebox;
window.zul.inp.Doublebox_.Doublebox = Doublebox;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/Doublespinner.ts":
/*!****************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/Doublespinner.ts ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.Doublespinner_) window.zul.inp.Doublespinner_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Doublespinner = void 0;
/* Dooublespinner.ts

    Purpose:

    Description:

    History:
        Mon Dec 20 10:17:24     2010, Created by jumperchen

Copyright (C) 2010 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
window.zul.inp.Doublespinner_._digitsAfterDecimal = function (v, DECIMAL) {
  var vs = '' + v,
    i = vs.indexOf(DECIMAL);
  return i < 0 ? 0 : vs.length - i - 1;
};
window.zul.inp.Doublespinner_._shiftedSum = function (v1, v2, exp, asc) {
  var mul;
  if (exp) {
    mul = Math.pow(10, exp);
    v1 *= mul;
    v2 *= mul;
    v1 = Math.round(v1);
    v2 = Math.round(v2);
  }
  var res = asc ? v1 + v2 : v1 - v2;
  if (exp) res /= mul;
  return res;
};
window.zul.inp.Doublespinner_._updateFixedDigits = function (wgt, val) {
  var decimal = wgt._localizedSymbols ? wgt._localizedSymbols.DECIMAL : zk.DECIMAL,
    stepd = window.zul.inp.Doublespinner_._digitsAfterDecimal(wgt._step, decimal),
    vald = window.zul.inp.Doublespinner_._digitsAfterDecimal(val || wgt._value, decimal);
  wgt._fixedDigits = Math.max(stepd, vald);
};
/**
 * An edit box for holding a constrained double.
 *
 * @defaultValue {@link getZclass}: z-doublespinner.
 * @since 5.0.6
 */
var Doublespinner = /** @class */function (_super) {
  __extends(Doublespinner, _super);
  function Doublespinner() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._step = 1;
    /** @internal */
    _this._buttonVisible = true;
    _this.onHide = undefined; // FIXME: requires further observation
    _this.validate = undefined; // FIXME: requires further observation
    return _this;
  }
  /**
   * @returns the step of double spinner
   */
  Doublespinner.prototype.getStep = function () {
    return this._step;
  };
  /**
   * Set the step of dobule spinner
   */
  Doublespinner.prototype.setStep = function (step, opts) {
    var o = this._step;
    this._step = step;
    if (o !== step || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      window.zul.inp.Doublespinner_._updateFixedDigits(this);
    }
    return this;
  };
  /**
   * @returns whether the button (on the right of the textbox) is visible.
   * @defaultValue `true`.
   */
  Doublespinner.prototype.isButtonVisible = function () {
    return this._buttonVisible;
  };
  /**
   * Sets whether the button (on the right of the textbox) is visible.
   */
  Doublespinner.prototype.setButtonVisible = function (buttonVisible, opts) {
    var o = this._buttonVisible;
    this._buttonVisible = buttonVisible;
    if (o !== buttonVisible || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      zul.inp.RoundUtl.buttonVisible(this, buttonVisible);
    }
    return this;
  };
  Doublespinner.prototype.inRoundedMold = function () {
    return true;
  };
  /**
   * @returns the value in double. If null, zero is returned.
   */
  Doublespinner.prototype.doubleValue = function () {
    return _super.prototype.getValue.call(this);
  };
  Doublespinner.prototype.setConstraint = function (constraint) {
    if (typeof constraint == 'string' && !constraint.startsWith('[') /*by server*/) {
      var simpleDoubleSpinnerConstraint = new zul.inp.SimpleDoubleSpinnerConstraint(constraint);
      this._min = simpleDoubleSpinnerConstraint._min;
      this._max = simpleDoubleSpinnerConstraint._max;
      _super.prototype.setConstraint.call(this, simpleDoubleSpinnerConstraint);
    } else _super.prototype.setConstraint.call(this, constraint);
    return this;
  };
  /** @internal */
  Doublespinner.prototype.coerceFromString_ = function (value) {
    // B50-3322816
    if (!value) return undefined;
    var info = zk.fmt.Number.unformat(this._format, value, false, this._localizedSymbols),
      raw = info.raw,
      val = parseFloat(raw),
      valstr = '' + val,
      valind = valstr.indexOf('.'),
      rawind = raw.indexOf('.');
    if (isNaN(val) || !valstr.includes('e')) {
      if (rawind == 0) {
        raw = '0' + raw;
        ++rawind;
      }
      if (rawind >= 0 && raw.substring(raw.substring(rawind + 1)) && valind < 0) {
        valind = valstr.length;
        valstr += '.';
      }
      var len = raw.length,
        vallen = valstr.length;
      //pre zeros
      if (valind >= 0 && valind < rawind) {
        vallen -= valind;
        len -= rawind;
        for (var zerolen = rawind - valind; zerolen-- > 0;) valstr = '0' + valstr;
      }
      //post zeros
      if (vallen < len) {
        for (var zerolen = len - vallen; zerolen-- > 0;) valstr += '0';
      }
      if (isNaN(val) || raw != valstr && raw != '-' + valstr && !raw.includes('e')) {
        //1e2: assumes OK
        if (!isNaN(val) && raw != valstr)
          //Bug ZK-1218: show Illegal value instead if input is number but too long
          return {
            error: zk.fmt.Text.format(msgzul.ILLEGAL_VALUE)
          };
        return {
          error: zk.fmt.Text.format(msgzul.NUMBER_REQUIRED, value)
        };
      }
    }
    if (info.divscale) val = val / Math.pow(10, info.divscale);
    // B50-3322795
    window.zul.inp.Doublespinner_._updateFixedDigits(this, val);
    return val;
  };
  /** @internal */
  Doublespinner.prototype.coerceToString_ = function (value) {
    var fmt = this._format,
      DECIMAL = this._localizedSymbols ? this._localizedSymbols.DECIMAL : zk.DECIMAL;
    // ZK-2084: fix display for different step
    if (typeof value === 'number' && value % 1 == 0) {
      // is integer
      var precision = 1,
        decimal;
      if (this._step && (decimal = (this._step + '').split('.')[1])) {
        precision = decimal.length;
      }
      value = parseFloat(value).toFixed(precision);
    }
    return value == null ? '' : fmt ? zk.fmt.Number.format(fmt, parseFloat(value), this._rounding, this._localizedSymbols) : DECIMAL == '.' ? '' + value : ('' + value).replace('.', DECIMAL);
  };
  /** @internal */
  Doublespinner.prototype.doKeyDown_ = function (evt) {
    var inp = this.getInputNode();
    if (inp.disabled || inp.readOnly) return;
    switch (evt.keyCode) {
      case 38:
        //up
        this.checkValue();
        this._increase(true);
        evt.stop();
        return;
      case 40:
        //down
        this.checkValue();
        this._increase(false);
        evt.stop();
        return;
    }
    _super.prototype.doKeyDown_.call(this, evt);
  };
  /** @internal */
  Doublespinner.prototype._ondropbtnup = function (evt) {
    this.domUnlisten_(document.body, 'onZMouseup', '_ondropbtnup');
    this._stopAutoIncProc();
    this._currentbtn = undefined;
  };
  /** @internal */
  Doublespinner.prototype._btnDown = function (evt) {
    if (!this._buttonVisible || this._disabled) return;
    var btn = this.$n('btn');
    if (!zk.dragging) {
      if (this._currentbtn)
        // just in case
        this._ondropbtnup(evt);
      this.domListen_(document.body, 'onZMouseup', '_ondropbtnup');
      this._currentbtn = btn;
    }
    this.checkValue();
    var ofs = zk(btn).revisedOffset(),
      isOverUpBtn = evt.pageY - ofs[1] < btn.offsetHeight / 2;
    if (isOverUpBtn) {
      //up
      this._increase(true);
      this._startAutoIncProc(true);
    } else {
      // down
      this._increase(false);
      this._startAutoIncProc(false);
    }
    // disable browser's text selection
    evt.stop();
  };
  /**
   * Sets bound value if the value out of range
   */
  Doublespinner.prototype.checkValue = function () {
    var inp = this.getInputNode(),
      min = this._min,
      max = this._max;
    if (!inp.value) {
      if (min && max) inp.value = min <= 0 && 0 <= max ? 0 : min;else if (min) inp.value = min <= 0 ? 0 : min;else if (max) inp.value = 0 <= max ? 0 : max;else inp.value = 0;
    }
  };
  /** @internal */
  Doublespinner.prototype._btnUp = function (evt) {
    if (!this._buttonVisible || this._disabled || zk.dragging) return;
    this._onChanging();
    this._stopAutoIncProc();
    var inp = this.getInputNode();
    inp.focus();
  };
  /** @internal */
  Doublespinner.prototype._increase = function (asc) {
    var inp = this.getInputNode(),
      value = this.coerceFromString_(inp.value);
    if (value && value.error) return; //nothing to do if error happens
    var shiftLen = Math.max(window.zul.inp.Doublespinner_._digitsAfterDecimal(value), this._fixedDigits),
      result = window.zul.inp.Doublespinner_._shiftedSum(value, this._step, shiftLen, asc); // B50-3301517
    // control overflow
    if (result > Math.pow(2, 63) - 1) result = Math.pow(2, 63) - 1;else if (result < -Math.pow(2, 63)) result = -Math.pow(2, 63);
    //over bound shall restore value
    if (this._max != null && result > this._max) result = value;else if (this._min != null && result < this._min) result = value;
    inp.value = this.coerceToString_(result);
    this._onChanging();
  };
  /** @internal */
  Doublespinner.prototype._clearValue = function () {
    this.getInputNode().value = this._defRawVal = '';
    return true;
  };
  /** @internal */
  Doublespinner.prototype._startAutoIncProc = function (isup) {
    var widget = this;
    if (this.timerId) clearInterval(this.timerId);
    this.timerId = setInterval(function () {
      widget._increase(isup);
    }, 200);
    jq(this.$n('btn-' + (isup ? 'up' : 'down'))).addClass(this.$s('active'));
  };
  /** @internal */
  Doublespinner.prototype._stopAutoIncProc = function () {
    if (this.timerId) clearTimeout(this.timerId);
    this.timerId = undefined;
    jq('.' + this.$s('icon'), this.$n('btn')).removeClass(this.$s('active'));
  };
  /** @internal */
  Doublespinner.prototype.doFocus_ = function (evt) {
    _super.prototype.doFocus_.call(this, evt);
    zul.inp.RoundUtl.doFocus_(this);
  };
  /** @internal */
  Doublespinner.prototype.doBlur_ = function (evt) {
    _super.prototype.doBlur_.call(this, evt);
    zul.inp.RoundUtl.doBlur_(this);
  };
  /** @internal */
  Doublespinner.prototype.afterKeyDown_ = function (evt, simulated) {
    if (!simulated && this._inplace) jq(this.$n()).toggleClass(this.getInplaceCSS(), evt.keyCode == 13);
    return _super.prototype.afterKeyDown_.call(this, evt, simulated);
  };
  /** @internal */
  Doublespinner.prototype.getAllowedKeys_ = function () {
    var symbols = this._localizedSymbols;
    return _super.prototype.getAllowedKeys_.call(this) + (symbols ? symbols : zk).DECIMAL + 'e';
    //supports scientific expression such as 1e2
  };
  /** @internal */
  Doublespinner.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var btn;
    if (btn = this.$n('btn')) this.domListen_(btn, 'onZMouseDown', '_btnDown').domListen_(btn, 'onZMouseUp', '_btnUp');
    zWatch.listen({
      onSize: this
    });
  };
  /** @internal */
  Doublespinner.prototype.unbind_ = function (skipper, after, keepRod) {
    if (this.timerId) {
      clearTimeout(this.timerId);
      this.timerId = undefined;
    }
    zWatch.unlisten({
      onSize: this
    });
    var btn = this.$n('btn');
    if (btn) this.domUnlisten_(btn, 'onZMouseDown', '_btnDown').domUnlisten_(btn, 'onZMouseUp', '_btnUp');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Doublespinner.prototype.getBtnUpIconClass_ = function () {
    return 'z-icon-angle-up';
  };
  /** @internal */
  Doublespinner.prototype.getBtnDownIconClass_ = function () {
    return 'z-icon-angle-down';
  };
  Doublespinner = __decorate([zk.WrapClass('zul.inp.Doublespinner')], Doublespinner);
  return Doublespinner;
}(zul.inp.NumberInputWidget);
exports.Doublespinner = Doublespinner;
window.zul.inp.Doublespinner_.Doublespinner = Doublespinner;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/Errorbox.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/Errorbox.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Errorbox.ts

    Purpose:

    Description:

    History:
        Sun Jan 11 21:17:56     2009, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.Errorbox_) window.zul.inp.Errorbox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Errorbox = void 0;
var _dirMap = {
  'u': 'up',
  'd': 'down',
  'l': 'left',
  'r': 'right'
};
/**
 * A error message box that is displayed as a popup.
 */
var Errorbox = /** @class */function (_super) {
  __extends(Errorbox, _super);
  function Errorbox(owner, msg) {
    var _this = _super.call(this, msg, {
      ref: owner
    }) || this;
    /** @internal */
    _this._defaultPos = 'end_before';
    _this.parent = owner;
    _this.parent.__ebox = _this;
    _this.msg = msg;
    _this.sclass = owner._errorboxSclass;
    _this.iconSclass = owner._errorboxIconSclass || 'z-icon-exclamation-triangle';
    return _this;
  }
  Errorbox_1 = Errorbox;
  /** @internal */
  Errorbox.prototype.domClass_ = function (no) {
    var sclass = this.sclass,
      /*safe*/s = _super.prototype.domClass_.call(this, no);
    if (sclass) s += ' ' + sclass;
    return s;
  };
  /**
   * Opens the popup.
   * @see {@link zul.wgt.Popup.open}
   */
  Errorbox.prototype.show = function () {
    var _this = this;
    if (!this.$n()) jq(document.body).append(this);
    // Fixed IE6/7 issue in B50-2941554.zul
    var cstp = this.parent._cst && this.parent._cst._pos;
    // ZK-2069: show only if is in view //B85-ZK-3321
    if (this.parent.isRealVisible()) {
      setTimeout(function () {
        if (_this.parent && zul.inp.InputWidget._isInView(_this))
          //Bug #3067998: if
          _this.open(_this.parent, undefined, cstp || _this._defaultPos, {
            dodgeRef: !cstp
          });
      }, 50); // B36-2935398: add time
    }
    zWatch.listen({
      onHide: [this.parent, this.onParentHide]
    });
    return this;
  };
  /**
   * Destroys the errorbox
   */
  Errorbox.prototype.destroy = function () {
    if (this.parent) {
      zWatch.unlisten({
        onHide: [this.parent, this.onParentHide]
      });
      delete this.parent.__ebox;
    }
    this.close();
    this.unbind();
    jq(this).remove();
    this.parent = undefined;
  };
  Errorbox.prototype.onParentHide = function () {
    if (this.__ebox) {
      this.__ebox.setFloating_(false);
      this.__ebox.close();
    }
  };
  /** @internal */
  Errorbox.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    this._drag = new zk.Draggable(this, undefined, {
      starteffect: zk.$void,
      endeffect: Errorbox_1._enddrag,
      ignoredrag: Errorbox_1._ignoredrag,
      change: Errorbox_1._change
    });
    zWatch.listen({
      onMove: this
    });
  };
  /** @internal */
  Errorbox.prototype.unbind_ = function (skipper, after, keepRod) {
    // bug ZK-1143
    var drag = this._drag;
    this._drag = undefined;
    if (drag) drag.destroy();
    zWatch.unlisten({
      onMove: this
    });
    // just in case
    if (this.parent) zWatch.unlisten({
      onHide: [this.parent, this.onParentHide]
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  Errorbox.prototype.getInputNode = function () {
    return this.parent ? this.parent.$n() : undefined;
  };
  Errorbox.prototype.onMove = function () {
    if (this.isOpen()) {
      this.reposition(); //call reposition in super
      this._fixarrow();
    }
  };
  Errorbox.prototype.onSize = function () {
    _super.prototype.onSize.call(this);
    if (this.isOpen()) this._fixarrow();
  };
  /** @internal */
  Errorbox.prototype.setDomVisible_ = function (domVisible, visible, opts) {
    _super.prototype.setDomVisible_.call(this, domVisible, visible, opts);
    var stackup = this._stackup;
    if (stackup) stackup.style.display = visible ? '' : 'none';
  };
  /** @internal */
  Errorbox.prototype.doClick_ = function (evt, popupOnly) {
    var p = evt.domTarget;
    if (p == this.$n('cls') || p == this.$n('clsIcon')) {
      //may click on font-icon
      if ((p = this.parent) && p.clearErrorMessage) {
        p.clearErrorMessage(true, true);
        p.focus(0); // Bug #3159848
      } else zAu.wrongValue_(p, false);
    } else {
      _super.prototype.doClick_.call(this, evt, popupOnly);
      this.parent.focus(0);
    }
  };
  Errorbox.prototype.open = function (ref, offset, position, opts) {
    _super.prototype.open.call(this, ref, offset, position, opts);
    this.setTopmost();
    this._fixarrow();
  };
  /** @internal */
  Errorbox.prototype.afterCloseAnima_ = function (opts) {
    opts = zk.copy(opts, {
      keepVisible: true
    });
    _super.prototype.afterCloseAnima_.call(this, opts);
  };
  Errorbox.prototype.redraw = function (out) {
    var uuidHTML = this.uuid,
      icon = this.$s('icon'),
      iconSclass = this.iconSclass;
    out.push('<div', this.domAttrs_(), '><div id="', uuidHTML, '-p" class="', this.$s('pointer'), '"></div><i id="', uuidHTML, '-icon" class="',
    //ZK-2677 use either default or self-defined icon, do not rely on CSS overwrite
    /*safe*/
    icon, ' ', zUtl.encodeXML(iconSclass), '"></i><div id="', uuidHTML, '-cave" class="', this.$s('content'), '" title="', zUtl.encodeXML(msgzk.GOTO_ERROR_FIELD), '">', zUtl.encodeXML(this.msg, {
      multiline: true
    }), '</div><div id="', uuidHTML, '-cls" class="',
    // Bug ZK-2952: added missing id for the "x" icon
    this.$s('close'), '"><i id="', uuidHTML, '-clsIcon" class="', /*safe*/icon, ' z-icon-times"></i></div></div>');
  };
  Errorbox.prototype.onFloatUp = function (ctl) {
    var wgt = ctl.origin;
    if (wgt == this) {
      this.setTopmost();
      return;
    }
    if (!wgt || wgt == this.parent || !this.isVisible()) return;
    // eslint-disable-next-line @typescript-eslint/no-this-alias
    var top1 = this,
      top2 = wgt;
    while ((top1 = top1.parent) && !top1.isFloating_()) if (top1 == wgt)
      //wgt is parent
      return;
    for (; top2 && !top2.isFloating_(); top2 = top2.parent);
    if (top1 == top2) {
      //uncover if sibling
      var n = wgt.$n();
      if (n) this._uncover(n);
    }
  };
  /** @internal */
  Errorbox.prototype._uncover = function (el) {
    var elofs = zk(el).revisedOffset(),
      node = this.$n(),
      nodeofs = zk(node).cmOffset();
    if (jq.isOverlapped(elofs, [el.offsetWidth, el.offsetHeight], nodeofs, [node.offsetWidth, node.offsetHeight])) {
      var parent = this.parent.$n_(),
        ptofs = zk(parent).cmOffset(),
        pthgh = parent.offsetHeight,
        ptbtm = ptofs[1] + pthgh,
        y = elofs[1] + el.offsetHeight <= ptbtm ? ptbtm : ptofs[1] - node.offsetHeight,
        /* we compare bottom because default is located below */
        ofs = zk(node).toStyleOffset(0, y);
      node.style.top = "".concat(ofs[1], "px");
      this._fixarrow();
    }
  };
  /** @internal */
  Errorbox.prototype._fixarrow = function () {
    var parent = this.parent.$n(),
      node = this.$n(),
      pointer = this.$n('p'),
      ptofs = zk(parent).revisedOffset(),
      nodeofs = zk(node).revisedOffset(),
      dx = nodeofs[0] - ptofs[0],
      dy = nodeofs[1] - ptofs[1],
      dir,
      s = node.style,
      pw = 2 + zk(pointer).borderWidth() / 2 || 0,
      ph = 2 + zk(pointer).borderHeight() / 2 || 0;
    // conditions of direction
    if (dx >= parent.offsetWidth - pw) dir = dy < ph - node.offsetHeight ? 'ld' : dy >= parent.offsetHeight - ph ? 'lu' : 'l';else if (dx < pw - node.offsetWidth) dir = dy < ph - node.offsetHeight ? 'rd' : dy >= parent.offsetHeight - ph ? 'ru' : 'r';else dir = dy < 0 ? 'd' : 'u';
    node.style.padding = '0';
    // for setting the pointer position
    if (dir == 'd' || dir == 'u') {
      var md = (Math.max(dx, 0) + Math.min(node.offsetWidth + dx, parent.offsetWidth)) / 2 - dx - 6,
        mx = node.offsetWidth - 11;
      pointer.style.left = "".concat(md > mx ? mx : md < 1 ? 1 : md, "px");
      if (dir == 'd') {
        pointer.style.top = undefined;
        pointer.style.bottom = '-4px';
        s.paddingBottom = "".concat(ph, "px");
      } else {
        pointer.style.top = '-4px';
        s.paddingTop = "".concat(ph, "px");
      }
    } else if (dir == 'l' || dir == 'r') {
      var md = (Math.max(dy, 0) + Math.min(node.offsetHeight + dy, parent.offsetHeight)) / 2 - dy - 6,
        mx = node.offsetHeight - 11;
      pointer.style.top = "".concat(md > mx ? mx : md < 1 ? 1 : md, "px");
      if (dir == 'r') {
        pointer.style.left = undefined;
        pointer.style.right = '-4px';
        s.paddingRight = "".concat(pw, "px");
      } else {
        pointer.style.left = '-4px';
        s.paddingLeft = "".concat(pw, "px");
      }
    } else {
      var ps = pointer.style;
      ps.left = ps.top = ps.right = ps.bottom = undefined;
      switch (dir) {
        case 'lu':
          ps.left = '0px';
          ps.top = '-4px';
          s.paddingTop = "".concat(ph, "px");
          break;
        case 'ld':
          ps.left = '0px';
          ps.bottom = '-4px';
          s.paddingBottom = "".concat(ph, "px");
          break;
        case 'ru':
          ps.right = '0px';
          ps.top = '-4px';
          s.paddingTop = "".concat(ph, "px");
          break;
        case 'rd':
          ps.right = '0px';
          ps.bottom = '-4px';
          s.paddingBottom = "".concat(ph, "px");
          break;
      }
      dir = dir == 'ru' || dir == 'lu' ? 'u' : 'd';
    }
    pointer.className = this.$s('pointer') + (_dirMap[dir] ? ' ' + this.$s(_dirMap[dir]) : '');
    jq(pointer).show();
  };
  /** @internal */
  Errorbox.prototype.isInView_ = function () {
    return zul.inp.InputWidget._isInView(this);
  };
  /** @internal */
  Errorbox.prototype.getPositionArgs_ = function () {
    var p = this.parent,
      cstp = p ? p._cst && p._cst._pos : false;
    return [p, undefined, cstp || 'end_before', {
      dodgeRef: !cstp
    }];
  };
  /** @internal */
  Errorbox._enddrag = function (dg) {
    var errbox = dg.control;
    errbox.setTopmost();
    errbox._fixarrow();
  };
  /** @internal */
  Errorbox._ignoredrag = function (dg, pointer, evt) {
    return zul.inp.InputCtrl.isIgnoredDragForErrorbox(dg, pointer, evt);
  };
  /** @internal */
  Errorbox._change = function (dg) {
    var errbox = dg.control,
      stackup = errbox._stackup,
      el = errbox.$n();
    if (stackup) {
      stackup.style.top = el.style.top;
      stackup.style.left = el.style.left;
    }
    errbox._fixarrow();
    if (zk.mobile) zk(el).redoCSS();
  };
  var Errorbox_1;
  Errorbox = Errorbox_1 = __decorate([zk.WrapClass('zul.inp.Errorbox')], Errorbox);
  return Errorbox;
}(zul.wgt.Notification);
exports.Errorbox = Errorbox;
window.zul.inp.Errorbox_._dirMap = _dirMap;
window.zul.inp.Errorbox_.Errorbox = Errorbox;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/FormatWidget.ts":
/*!***************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/FormatWidget.ts ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.FormatWidget_) window.zul.inp.FormatWidget_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FormatWidget = void 0;
/* FormatWidget.ts

    Purpose:

    Description:

    History:
        Fri Jan 16 12:54:29     2009, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A skeletal implementation for an input box with format.
 */
var FormatWidget = /** @class */function (_super) {
  __extends(FormatWidget, _super);
  function FormatWidget() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  FormatWidget.prototype.setFormat = function (format, opts) {
    var o = this._format;
    this._format = format;
    if (o !== format || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var inp = this.getInputNode();
      if (inp) inp.value = this.coerceToString_(this._value);
    }
    return this;
  };
  /**
   * @returns the format.
   * Always return null when input type is number (including Intbox, Spinner, Doublebox, Doublespinner, Longbox and Decimalbox) on tablet device.
   * @defaultValue `null` (used what is defined in the format sheet).
   */
  FormatWidget.prototype.getFormat = function () {
    return this._format;
  };
  /** @internal */
  FormatWidget.prototype.doFocus_ = function (evt) {
    _super.prototype.doFocus_.call(this, evt);
    if (this._shortcut) this.getInputNode().value = this._shortcut;
  };
  /** @internal */
  FormatWidget.prototype.updateChange_ = function (clear) {
    var upd = _super.prototype.updateChange_.call(this);
    if (clear) delete this._shortcut;
    return upd;
  };
  FormatWidget = __decorate([zk.WrapClass('zul.inp.FormatWidget')], FormatWidget);
  return FormatWidget;
}(zul.inp.InputWidget);
exports.FormatWidget = FormatWidget;
window.zul.inp.FormatWidget_.FormatWidget = FormatWidget;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/InputWidget.ts":
/*!**************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/InputWidget.ts ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* InputWidget.ts

    Purpose:

    Description:

    History:
        Sat Dec 13 23:30:28     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/** The input related widgets, such as textbox and combobox.
 */
//zk.$package('zul.inp');
if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.InputWidget_) window.zul.inp.InputWidget_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.InputCtrl = exports.InputWidget = exports.RoundUtl = void 0;
var _keyIgnorable = zk.opera ? function (code) {
    return code == 32 || code > 46; //DEL
  } : function (code) {
    return code >= 32;
  },
  windowX = 0,
  windowY = 0;
/** @class zul.inp.RoundUtl
 * The RoundUtl used to adjust the display of the rounded input.
 * @since 5.0.7
 */
exports.RoundUtl = {
  // @since 7.0.0
  buttonVisible: function (wgt, v) {
    var n = wgt.$n('btn');
    if (n) {
      var fnm = v ? 'removeClass' : 'addClass';
      jq(n)[fnm](wgt.$s('disabled'));
      jq(wgt.getInputNode())[fnm](wgt.$s('input-full'));
    }
  },
  // @since 7.0.0
  /** @internal */
  doFocus_: function (wgt) {
    if (wgt._inplace) {
      if (wgt._inplaceTimerId != null) {
        clearTimeout(wgt._inplaceTimerId);
        wgt._inplaceTimerId = undefined;
      }
      wgt.onSize();
    }
  },
  /** @internal */
  doBlur_: function (wgt) {
    if (wgt._inplace) {
      var n = wgt.$n_();
      if (wgt._inplaceTimerId != null) {
        clearTimeout(wgt._inplaceTimerId);
        wgt._inplaceTimerId = undefined;
      }
      wgt._inplaceTimerId = setTimeout(function () {
        if (wgt.desktop) jq(wgt.$n()).addClass(wgt.getInplaceCSS());
      }, wgt._inplaceTimeout);
      wgt.onSize();
      // should not clear node width if hflex is true
      if (!wgt.getHflex()) n.style.width = wgt.getWidth() || '';
    }
  }
};
zul.inp.RoundUtl = exports.RoundUtl;
/**
 * A skeletal implementation for a input widget.
 *
 * <p>The delay to send the onChanging event is controlled by
 * {@link onChangingDelay}, which is default to 350.
 * To change it, you can specify the following in a ZUL file.
 * ```html
 * <script content="zk.afterLoad('zul.inp',function(){zul.inp.InputWidget.onChangingDelay=1000;})"?>
 * ```
 */
var InputWidget = /** @class */function (_super) {
  __extends(InputWidget, _super);
  function InputWidget() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._maxlength = 0;
    /** @internal */
    _this._cols = 0;
    //_tabindex: 0,
    /** @internal */
    _this._type = 'text';
    /** @internal */
    _this._inplaceTimeout = 150;
    /** @internal */
    _this._inplaceIgnore = false;
    /** @internal */
    _this._disabled = false;
    /** @internal */
    _this._readonly = false;
    return _this;
  }
  InputWidget_1 = InputWidget;
  /**
   * @returns the name of this component.
   * @defaultValue `null`.
   * <p>Don't use this method if your application is purely based
   * on ZK's event-driven model.
   * <p>The name is used only to work with "legacy" Web application that
   * handles user's request by servlets.
   * It works only with HTTP/HTML-based browsers. It doesn't work
   * with other kind of clients.
   */
  InputWidget.prototype.getName = function () {
    return this._name;
  };
  /**
   * Sets the name of this component.
   * <p>Don't use this method if your application is purely based
   * on ZK's event-driven model.
   * <p>The name is used only to work with "legacy" Web application that
   * handles user's request by servlets.
   * It works only with HTTP/HTML-based browsers. It doesn't work
   * with other kind of clients.
   *
   * @param name - the name of this component.
   */
  InputWidget.prototype.setName = function (name, opts) {
    var o = this._name;
    this._name = name;
    if (o !== name || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var inp = this.getInputNode();
      if (inp)
        //check if bind
        inp.name = name;
    }
    return this;
  };
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   */
  InputWidget.prototype.isDisabled = function () {
    return this._disabled;
  };
  /**
   * Sets whether it is disabled.
   */
  InputWidget.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var inp = this.getInputNode();
      if (inp) {
        //check if bind
        inp.disabled = disabled;
        var fnm = disabled ? 'addClass' : 'removeClass';
        jq(this.$n())[fnm](this.$s('disabled'));
      }
    }
    return this;
  };
  /**
   * @returns whether it is readonly.
   * @defaultValue `false`.
   */
  InputWidget.prototype.isReadonly = function () {
    return this._readonly;
  };
  /**
   * Sets whether it is readonly.
   */
  InputWidget.prototype.setReadonly = function (readonly, opts) {
    var o = this._readonly;
    this._readonly = readonly;
    if (o !== readonly || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var inp = this.getInputNode();
      if (inp) {
        var fnm = readonly ? 'addClass' : 'removeClass';
        inp.readOnly = readonly;
        jq(this.$n())[fnm](this.$s('readonly')); //Merge breeze
      }
    }
    return this;
  };
  /**
   * @returns the cols.
   * @defaultValue `0` (non-positive means the same as browser's default).
   */
  InputWidget.prototype.getCols = function () {
    return this._cols;
  };
  /**
   * Sets the cols.
   */
  InputWidget.prototype.setCols = function (cols, opts) {
    var o = this._cols;
    this._cols = cols;
    if (o !== cols || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var inp = this.getInputNode();
      if (inp) {
        if (cols != 0) {
          if (this.isMultiline()) inp.cols = cols;else inp.size = cols;
        } else {
          if (this.isMultiline()) inp.removeAttribute('cols');else inp.removeAttribute('size');
        }
      }
    }
    return this;
  };
  /**
   * @returns the maxlength.
   * @defaultValue `0` (non-postive means unlimited).
   */
  InputWidget.prototype.getMaxlength = function () {
    return this._maxlength;
  };
  /**
   * Sets the maxlength.
   */
  InputWidget.prototype.setMaxlength = function (maxlength, opts) {
    var o = this._maxlength;
    this._maxlength = maxlength;
    if (o !== maxlength || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var inp = this.getInputNode();
      if (inp && !this.isMultiline()) inp.maxLength = maxlength;
    }
    return this;
  };
  /**
   * @returns the tab order of this component.
   * @defaultValue `0` (means the same as browser's default).
   */
  InputWidget.prototype.getTabindex = function () {
    return this._tabindex;
  };
  /**
   * Sets the tab order of this component.
   */
  InputWidget.prototype.setTabindex = function (tabindex, opts) {
    var o = this._tabindex;
    this._tabindex = tabindex;
    if (o !== tabindex || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var inp = this.getInputNode();
      if (inp) {
        if (tabindex == null) inp.removeAttribute('tabindex');else inp.tabIndex = tabindex;
      }
    }
    return this;
  };
  /**
   * @returns whether enable the inplace-editing.
   * @defaultValue `false`.
   */
  InputWidget.prototype.isInplace = function () {
    return !!this._inplace;
  };
  /**
   * Sets to enable the inplace-editing function that the look and feel is
   * like a label.
   */
  InputWidget.prototype.setInplace = function (inplace, opts) {
    var o = this._inplace;
    this._inplace = inplace;
    if (o !== inplace || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the placeholder text
   * @since 6.5.0
   */
  InputWidget.prototype.getPlaceholder = function () {
    return this._placeholder;
  };
  /**
   * Sets the placeholder text that is displayed when input is empty.
   * Only works for browsers supporting HTML5.
   * @since 6.5.0
   */
  InputWidget.prototype.setPlaceholder = function (placeholder, opts) {
    var o = this._placeholder;
    this._placeholder = placeholder;
    if (o !== placeholder || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the additional attributes which is set by setinputAttributes(inputAttributes).
   * @since 8.6.1
   */
  InputWidget.prototype.getInputAttributes = function () {
    return this._inputAttributes;
  };
  /**
   * Sets some additional attributes to the input html tag in the component.
   * this will only reset the additional attributes that are set by this method.
   * @since 8.6.1
   */
  InputWidget.prototype.setInputAttributes = function (inputAttributes, opts) {
    var o = this._inputAttributes;
    this._inputAttributes = inputAttributes;
    if (o !== inputAttributes || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        var inpNode = this.getInputNode();
        for (var key in this._lastinputAttributes) {
          inpNode.removeAttribute(key);
        }
        for (var key in this._inputAttributes) {
          var val = this._inputAttributes[key];
          inpNode.setAttribute(key, val);
        }
      }
      this._lastinputAttributes = inputAttributes;
    }
    return this;
  };
  /**
   * @returns whether to send onChange event as soon as user types in the
   * input.
   * @defaultValue `false`.
   * @since 6.0.0
   */
  InputWidget.prototype.isInstant = function () {
    return !!this._instant;
  };
  /**
   * Sets whether to send onChange event as soon as user types in the input.
   * @since 6.0.0
   */
  InputWidget.prototype.setInstant = function (instant) {
    this._instant = instant;
    return this;
  };
  /**
   * @returns the custom style class name applied to the errorbox, if any.
   * @defaultValue `null`.
   * @since 8.0.1
   */
  InputWidget.prototype.getErrorboxSclass = function () {
    return this._errorboxSclass;
  };
  /**
   * Sets the custom style class name to be applied to the errorbox.
   * @since 8.0.1
   */
  InputWidget.prototype.setErrorboxSclass = function (errorboxSclass) {
    this._errorboxSclass = errorboxSclass;
    return this;
  };
  /**
   * @returns the custom style icon class name applied to the errorbox, if any.
   * @defaultValue `null`.
   * @since 8.0.1
   */
  InputWidget.prototype.getErrorboxIconSclass = function () {
    return this._errorboxIconSclass;
  };
  /**
   * Sets the custom style icon class name to be applied to the errorbox.
   * @since 8.0.1
   */
  InputWidget.prototype.setErrorboxIconSclass = function (errorboxIconSclass) {
    this._errorboxIconSclass = errorboxIconSclass;
    return this;
  };
  /**
   * @returns the CSS style of inplace if inplace is not null
   */
  InputWidget.prototype.getInplaceCSS = function () {
    return this._inplace ? this.$s('inplace') : '';
  };
  /**
   * Selects the whole text in this input.
   * @param start - the starting index of the selection range
   * @param end - the ending index of the selection range (excluding).
   * 		In other words, the text between start and (end-1) is selected.
   */
  InputWidget.prototype.select = function (start, end) {
    // bug ZK-1695: need to focus input and set selection range in Firefox
    var inpNode = this.getInputNode();
    if (inpNode) {
      // ZK-4538: can't be focused anyway unless rendered
      if (zk.currentFocus != inpNode)
        // FIXME: comparing a zk.Widget with a HTMLElement?
        this.focus_();
      if (start == null && end == null) inpNode.select();else zk(inpNode).setSelectionRange(start, end);
    }
  };
  /**
   * @returns the type.
   * @defaultValue text.
   */
  InputWidget.prototype.getType = function () {
    return this._type;
  };
  /**
   * @returns whether it is multiline.
   * @defaultValue `false`.
   */
  InputWidget.prototype.isMultiline = function () {
    return false;
  };
  /**
   * @returns whether is in rounded mold or not.
   * @defaultValue `false`, only combo component are true
   * @since 7.0.0
   */
  InputWidget.prototype.inRoundedMold = function () {
    return true;
  };
  /**
   * @returns the text representing the value in the given format,
   * or an empty etring if value is null
   * @since 5.0.5
   */
  InputWidget.prototype.getText = function () {
    return this.coerceToString_(this.getValue());
  };
  /**
   * Sets the text representing the value in the given format.
   * @param text - the text
   * @since 5.0.5
   */
  InputWidget.prototype.setText = function (text) {
    return this.setValue(this.coerceFromString_(text));
  };
  /**
   * @returns the value in the String format.
   */
  InputWidget.prototype.getValue = function () {
    return this._value;
  };
  /**
   * Sets the value in the String format(assumes no locale issue).
   * <p>Notice that the invocation of {@link getValue} won't fire
   * the onChange event. To fire it, you have to invoke {@link fireOnChange}
   * explicitly.
   * @param value - the value.
   * @param fromServer - whether it is called from the server.
   * The error message will be cleared if true
   */
  InputWidget.prototype.setValue = function (value, fromServer) {
    var vi;
    // for stateless to treat as "value" attribute from "_value" at client side
    if (typeof value == 'number' || typeof value == 'string') value = this.unmarshall_(value);
    if (fromServer) this.clearErrorMessage(this._cst != null);else {
      vi = this._validate(value);
      value = vi.value;
    }
    InputWidget_1._clearOnChanging(this);
    //Note: for performance reason, we don't send value back if
    //the validation shall be done at server, i.e., if (vi.server)
    if ((!vi || !vi.error) && (fromServer || !this._equalValue(this._value, value))) {
      this._value = value;
      var inp = this.getInputNode();
      if (inp)
        //check if bind
        this._defRawVal = this._lastChg = inp.value = value = this.coerceToString_(value);
    }
    return this;
  };
  //value object set from server(smartUpdate, renderProperites)
  // eslint-disable-next-line zk/javaStyleSetterSignature
  InputWidget.prototype.set_value = function (value, fromServer) {
    this.setValue(this.unmarshall_(value), fromServer);
  };
  /**
   * @returns the input node of this widget
   */
  InputWidget.prototype.getInputNode = function () {
    var _a;
    return (_a = this.$n('real')) !== null && _a !== void 0 ? _a : this.$n();
  };
  InputWidget.prototype.getTextNode = function () {
    return this.getInputNode();
  };
  /** @internal */
  InputWidget.prototype.domAttrs_ = function (no) {
    var attrHTML = _super.prototype.domAttrs_.call(this, no);
    if (!no || !no.text) attrHTML += /*safe*/this.textAttrs_();
    return attrHTML;
  };
  /**
   * Attributes for the text control.
   * Called automatically by {@link domAttrs_} unless `{text:true}` is specified
   * @returns String
   * @internal
   */
  InputWidget.prototype.textAttrs_ = function () {
    var html = '',
      vHTML;
    if (this.isMultiline()) {
      vHTML = /*safe*/this._cols;
      if (vHTML > 0) html += ' cols="' + vHTML + '"';
    } else {
      html += ' value="' + /*safe*/this._areaText() + '"';
      html += ' type="' + zUtl.encodeXML(this.getType()) + '"';
      vHTML = /*safe*/this._cols;
      if (vHTML > 0) html += ' size="' + vHTML + '"';
      vHTML = /*safe*/this._maxlength;
      if (vHTML > 0) html += ' maxlength="' + vHTML + '"';
    }
    vHTML = /*safe*/this._tabindex;
    if (vHTML != undefined) html += ' tabindex="' + vHTML + '"';
    vHTML = /*safe*/this._name;
    if (vHTML) html += ' name="' + zUtl.encodeXMLAttribute(vHTML) + '"';
    if (this._disabled) html += ' disabled="disabled"';
    if (this._readonly) html += ' readonly="readonly"';
    if (this._placeholder) html += ' placeholder="' + zUtl.encodeXML(this._placeholder) + '"';
    if (this._inputAttributes) {
      for (var key in this._inputAttributes) {
        var val = this._inputAttributes[key];
        html += ' ' + /*safe*/key + '="' + zUtl.encodeXMLAttribute(val) + '"';
      }
    }
    var /*safe*/s = jq.filterTextStyle(this.domStyle_({
      width: true,
      height: true,
      top: true,
      left: true
    }));
    if (s) html += ' style="' + /*safe*/s + '"';
    return html;
  };
  /** @internal */
  InputWidget.prototype._onChanging = function (timeout) {
    InputWidget_1._onChanging.call(this, timeout);
  };
  /** @internal */
  InputWidget.prototype._areaText = function () {
    return zUtl.encodeXML(this.coerceToString_(this._value));
  };
  /**
   * Sets the constraint.
   * @defaultValue `null` (means no constraint all all).
   */
  InputWidget.prototype.setConstraint = function (constraint) {
    if (typeof constraint == 'string' && !constraint.startsWith('[') /*by server*/) this._cst = new zul.inp.SimpleConstraint(constraint);else this._cst = constraint;
    if (this._cst) this._reVald = true; //revalidate required
    return this;
  };
  /**
   * @returns the constraint, or null if no constraint at all.
   */
  InputWidget.prototype.getConstraint = function () {
    return this._cst;
  };
  /** @internal */
  InputWidget.prototype.doFocus_ = function (evt) {
    _super.prototype.doFocus_.call(this, evt);
    var inp = this.getInputNode();
    this._lastChg = inp.value;
    if (evt.domTarget.tagName) {
      //Bug 2111900
      if (this._inplace) {
        jq(this.$n()).removeClass(this.getInplaceCSS());
        if (this._inplaceTimerId != null) {
          clearTimeout(this._inplaceTimerId);
          this._inplaceTimerId = undefined;
        }
      }
      // Bug #2280308
      if (this._errbox) {
        var self = this,
          cstp = self._cst && self._cst._pos;
        setTimeout(function () {
          if (self._errbox) self._errbox.open(self, undefined, cstp || self._errbox._defaultPos, {
            dodgeRef: !cstp
          }); // Bug 3251564
        });
      }
    }
  };
  /** @internal */
  InputWidget.prototype.doBlur_ = function (evt) {
    InputWidget_1._stopOnChanging(this, true);
    if (!zk.alerting && this.shallUpdate_(zk.currentFocus)) {
      this.updateChange_();
      _super.prototype.doBlur_.call(this, evt);
    }
    if (this._inplace) {
      InputWidget_1._clearInplaceTimeout(this);
      if (!this._inplaceIgnore) {
        var self = this;
        self._inplaceTimerId = setTimeout(function () {
          if (self.desktop) jq(self.$n()).addClass(self.getInplaceCSS());
        }, self._inplaceTimeout);
      }
    }
    //B65-ZK-1285: scroll window object back when virtual keyboard closed on ipad
    if (zk.ios && jq(this.$n()).data('fixscrollposition')) {
      //only scroll back when data-fixScrollPosition attribute is applied
      var x = window.pageXOffset,
        y = window.pageYOffset;
      if (x != windowX || y != windowY) window.scrollTo(windowX, windowY);
    }
    this._lastKeyDown = undefined;
  };
  /** @internal */
  InputWidget.prototype._doTouch = function (evt) {
    if (!zk.ios) {
      return;
    }
    //B65-ZK-1285: get window offset information before virtual keyboard opened on ipad
    windowX = window.pageXOffset;
    windowY = window.pageYOffset;
  };
  /** @internal */
  InputWidget.prototype._doSelect = function (evt) {
    if (this.isListen('onSelection')) {
      var inp = this.getInputNode(),
        sr = zk(inp).getSelectionRange(),
        b = sr[0],
        e = sr[1];
      this.fire('onSelection', {
        start: b,
        end: e,
        selected: inp.value.substring(b, e)
      });
    }
  };
  /** @internal */
  InputWidget.prototype._doMouseOver = function () {
    if (this._disabled) return;
    jq(this.getInputNode()).addClass(this.$s('hover'));
  };
  /** @internal */
  InputWidget.prototype._doMouseOut = function () {
    if (this._disabled) return;
    jq(this.getInputNode()).removeClass(this.$s('hover'));
  };
  /**
   * @returns shall be update or not
   * @internal
   */
  InputWidget.prototype.shallUpdate_ = function (focus) {
    return !focus || !zUtl.isAncestor(this, focus);
  };
  /**
   * @returns the error message that is caused when user entered invalid value,
   * or null if no error at all.
   *
   * <p>
   * The error message is set when user has entered a wrong value, or setValue
   * is called with a wrong value. It is cleared once a correct value is
   * assigned.
   *
   * <p>
   * If the error message is set, we say this input is in the error mode.
   * @deprecated use getErrorMessage() instead.
   */
  InputWidget.prototype.getErrorMesssage = function () {
    return this.getErrorMessage();
  };
  /**
   * @returns the error message that is caused when user entered invalid value,
   * or null if no error at all.
   *
   * <p>
   * The error message is set when user has entered a wrong value, or setValue
   * is called with a wrong value. It is cleared once a correct value is
   * assigned.
   *
   * <p>
   * If the error message is set, we say this input is in the error mode.
   */
  InputWidget.prototype.getErrorMessage = function () {
    return this._errmsg;
  };
  /**
   * Marks this widget's value is wrong and show the error message.
   * <p>It is usually called by {@link zk.AuCmd0#wrongValue} (from the sever)
   * @param msg - the error message
   */
  InputWidget.prototype.setErrorMessage = function (errorMessage) {
    this.clearErrorMessage(true, true);
    this._markError(errorMessage, undefined, true);
    return this;
  };
  /**
   * Clears the error message and the error status.
   * <p>It is also called by {@link zk.AuCmd0#clearWrongValue} (from the server).
   * @param revalidate - whether to re-validate the value next time
   * onblur occurs
   * @param remainError - whether the input widget remains in the
   * error status, if any, after the invocation.
   */
  InputWidget.prototype.clearErrorMessage = function (revalidate, remainError) {
    var w = this._errbox;
    if (w) {
      this._errbox = undefined;
      w.destroy();
    }
    if (!remainError) {
      this._errmsg = undefined;
      jq(this.getInputNode()).removeClass(this.$s('invalid'));
    }
    if (revalidate) this._reVald = true; //revalidate required
  };
  /**
   * Coerces the value passed to {@link setValue}.
   *
   * <p>Deriving note:<br>
   * If you want to store the value in other type, say BigDecimal,
   * you have to override {@link coerceToString_} and {@link coerceFromString_}
   * to convert between a string and your targeting type.
   *
   * <p>Moreover, when {@link zul.inp.Textbox} is called, it calls this method
   * with value = null. Derives shall handle this case properly.
   *
   * @param value - the string to coerce from
   * @returns String
   * @internal
   */
  InputWidget.prototype.coerceFromString_ = function (value) {
    return value;
  };
  /**
   * Coerces the value passed to {@link setValue}.
   *
   * @defaultValue convert null to an empty string.
   *
   * <p>Deriving note:<br>
   * If you want to store the value in other type, say BigDecimal,
   * you have to override {@link coerceToString_} and {@link coerceFromString_}
   * to convert between a string and your targeting type.
   * @param value - the value that will be coerced to a string
   * @returns String
   * @internal
   */
  InputWidget.prototype.coerceToString_ = function (value) {
    return value || '';
  };
  /** @internal */
  InputWidget.prototype._markError = function (msg, val, noOnError) {
    this._errmsg = msg;
    if (this.desktop) {
      //err not visible if not attached //B85-ZK-3321
      jq(this.getInputNode()).addClass(this.$s('invalid'));
      var cst = this._cst,
        errbox;
      if (cst != '[c') {
        if (cst && (errbox = cst.showCustomError)) errbox = errbox.call(cst, this, msg);
        if (!errbox) this._errbox = this.showError_(msg);
      }
      if (!noOnError) this.fire('onError', {
        value: val,
        message: msg
      });
    }
  };
  /**
   * Make the {@link zul.inp.SimpleConstraint} calls the validate for val,
   * if {@link zul.inp.SimpleConstraint} is exist
   * @param val - a String, a number, or a date,the number or name of flag,
   * such as 'no positive", 0x0001.
   * @internal
   */
  InputWidget.prototype.validate_ = function (val) {
    var cst;
    if (cst = this._cst) {
      if (typeof cst == 'string') return false; //by server
      var msg = cst.validate(this, val);
      if (!msg && cst.serverValidate) return false; //client + server
      return msg;
    }
  };
  /** @internal */
  InputWidget.prototype._validate = function (value) {
    zul.inp.validating = true;
    try {
      var val = value,
        msg;
      if (typeof val == 'string' || val == null) {
        val = this.coerceFromString_(val);
        if (val && ((msg = val.error) || val.server)) {
          this.clearErrorMessage(true);
          if (val.server || this._cst == '[c') {
            //CustomConstraint
            this._reVald = false;
            return {
              rawValue: value || '',
              server: true
            }; //let server to validate it
          }
          this._markError(msg, val);
          return val;
        }
      }
      //unlike server, validation occurs only if attached
      if (!this.desktop) this._errmsg = undefined;else {
        var em = this._errmsg;
        this.clearErrorMessage(true);
        msg = this.validate_(val);
        if (msg === false) {
          this._reVald = false;
          return {
            value: val,
            server: true
          }; //let server to validate it
        }
        if (msg) {
          this._markError(msg, val);
          return {
            error: msg
          };
        }
        this._reVald = false;
        if (em) this._sendClearingErrorEvent(val);
      }
      return {
        value: val
      };
    } finally {
      zul.inp.validating = false;
    }
  };
  /** @internal */
  InputWidget.prototype._sendClearingErrorEvent = function (val) {
    // ZK-4453 for easier overriding this behavior
    this.fire('onError', {
      value: val
    });
  };
  /** @internal */
  InputWidget.prototype._shallIgnore = function (evt, keys) {
    // ZK-1736 add metakey on mac
    if (zk.mac && evt.metaKey) return false;else {
      var code = zk.opera ? evt.keyCode : evt.charCode;
      if (!evt.altKey && !evt.ctrlKey && _keyIgnorable(code) && !keys.includes(String.fromCharCode(code))) {
        evt.stop();
        return true;
      }
    }
    return false;
  };
  /**
   * Create a {@link zul.inp.Errorbox} widget, and show the error message
   * @param msg - the error message
   * @see zul.inp.Errorbox#show
   * @internal
   */
  InputWidget.prototype.showError_ = function (msg) {
    var eb = new zul.inp.Errorbox(this, msg);
    eb.show();
    return eb;
  };
  InputWidget.prototype.onShow = function () {
    if (this.__ebox) {
      this.setFloating_(true);
      this.__ebox.show();
    }
  };
  /** @internal */
  InputWidget.prototype._equalValue = function (a, b) {
    return a == b || this.marshall_(a) == this.marshall_(b);
  };
  /** @internal */
  InputWidget.prototype.marshall_ = function (val) {
    return val;
  };
  /** @internal */
  InputWidget.prototype.unmarshall_ = function (val) {
    return val;
  };
  /**
   * Updates the change to server by firing onChange if necessary.
   * @returns boolean
   * @internal
   */
  InputWidget.prototype.updateChange_ = function () {
    if (zul.inp.validating) return false; //avoid deadloop (when both focus and blur fields invalid)
    var inp = this.getInputNode(),
      value = inp.value;
    if (!this._reVald && value == this._defRawVal /* ZK-658 */) return false; //not changed
    var wasErr = this._errmsg,
      vi = this._validate(value);
    if (!vi.error || vi.server) {
      var upd, data;
      if (vi.rawValue != null) {
        //coerce failed
        data = {
          rawValue: vi.rawValue
        };
      } else if (!vi.error) {
        /*
         * ZK-1220: with instant="true", inp.value = value will occur position error when change position.
         * Datebox, Timebox and FormatWidget which assign format can't avoid this issue.
         * Because they will change the "value" all the time.
         */
        value = this.coerceToString_(vi.value);
        if (inp.value !== value) {
          inp.value = value;
        }
        this._reVald = false;
        //reason to use this._defRawVal rather than this._value is
        //to save the trouble of coerceToString issue
        upd = wasErr || !this._equalValue(vi.value, this._value);
        if (upd) {
          this._value = vi.value; //vi - not coerced
          this._defRawVal = value;
        }
      }
      if (upd || vi.server) this.fire('onChange', InputWidget_1._onChangeData(this, data != null ? data : {
        value: this.marshall_(vi.value)
      }), vi.server ? {
        toServer: true
      } : undefined, 90);
    }
    return true;
  };
  /**
   * Fires the onChange event.
   * If the widget is created at the server, the event will be sent
   * to the server too.
   * @param opts - the options. Refer to {@link zk.Event#opts}
   * @since 5.0.5
   */
  InputWidget.prototype.fireOnChange = function (opts) {
    this.fire('onChange', InputWidget_1._onChangeData(this, {
      value: this.marshall_(this.getValue())
    }), opts);
  };
  /** @internal */
  InputWidget.prototype._resetForm = function () {
    var inp = this.getInputNode();
    if (inp.value != inp.defaultValue) {
      //test if it will be reset
      var wgt = this;
      setTimeout(function () {
        wgt.updateChange_();
      }, 0);
      //value not reset yet so wait a moment
    }
  };
  /** @internal */
  InputWidget.prototype.focus_ = function (timeout) {
    zk(this.getInputNode()).focus(timeout);
    return true;
  };
  /** @internal */
  InputWidget.prototype.domClass_ = function (no) {
    var /*safe*/sc = _super.prototype.domClass_.call(this, no);
    if ((!no || !no.zclass) && this._disabled) sc += ' ' + this.$s('disabled');
    if ((!no || !no.input) && this._inplace) sc += ' ' + this.getInplaceCSS();
    // Merge breeze
    if ((!no || !no.zclass) && this._readonly) sc += ' ' + this.$s('readonly');
    return sc;
  };
  /** @internal */
  InputWidget.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var n = this.getInputNode();
    this._lastChg = this._defRawVal = n.value;
    this.domListen_(n, 'onFocus', 'doFocus_').domListen_(n, 'onBlur', 'doBlur_').domListen_(n, 'onSelect').domListen_(n, 'onMouseOver').domListen_(n, 'onMouseOut').domListen_(n, 'onInput', 'doInput_');
    if (zk.ios) this.domListen_(n, 'onTouchStart', '_doTouch');
    if (n.form) jq(n.form).on('reset', this.proxy(this._resetForm));
    zWatch.listen({
      onShow: this
    });
  };
  /** @internal */
  InputWidget.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onShow: this
    });
    InputWidget_1._stopOnChanging(this);
    this.clearErrorMessage(true);
    var n = this.getInputNode();
    this.domUnlisten_(n, 'onFocus', 'doFocus_').domUnlisten_(n, 'onBlur', 'doBlur_').domUnlisten_(n, 'onSelect').domUnlisten_(n, 'onMouseOver').domUnlisten_(n, 'onMouseOut').domUnlisten_(n, 'onInput', 'doInput_');
    if (zk.ios) this.domUnlisten_(n, 'onTouchStart', '_doTouch');
    if (n.form) jq(n.form).off('reset', this.proxy(this._resetForm));
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  InputWidget.prototype.doInput_ = function (evt) {
    //ZK-2757, fire onChange when native drag'n' drop in different browsers
    var wgt = this;
    //in IE, current focus changes after onInput event
    setTimeout(function () {
      if (wgt && !zk.chrome && !wgt._lastKeyDown && zk.currentFocus != wgt) wgt.doBlur_(evt); //fire onBlur again
    }, 10);
    // ZK-4938: fire an onChanging event when users enter a predictive text
    this._updateValue();
  };
  /** @internal */
  InputWidget.prototype.resetSize_ = function (orient) {
    var n;
    if (this.$n() != (n = this.getInputNode())) n.style[orient == 'w' ? 'width' : 'height'] = '';
    _super.prototype.resetSize_.call(this, orient);
  };
  /** @internal */
  InputWidget.prototype.doKeyDown_ = function (evt) {
    var keyCode = evt.keyCode;
    this._lastKeyDown = keyCode;
    if (this._readonly && keyCode == 8 && evt.target == this) {
      evt.stop(); // Bug #2916146
      return;
    }
    if (keyCode == 9 && !evt.altKey && !evt.ctrlKey && !evt.shiftKey && this._tabbable) {
      var inp = this.getInputNode(),
        $inp = zk(inp),
        sr = $inp.getSelectionRange(),
        val = inp.value;
      val = val.substring(0, sr[0]) + '\t' + val.substring(sr[1]);
      inp.value = val;
      val = sr[0] + 1;
      $inp.setSelectionRange(val, val);
      evt.stop();
      return;
    }
    InputWidget_1._stopOnChanging(this); // wait for onInput
    _super.prototype.doKeyDown_.call(this, evt);
  };
  /** @internal */
  InputWidget.prototype._updateValue = function () {
    //Support maxlength for Textarea
    if (this.isMultiline()) {
      var maxlen = this._maxlength;
      if (maxlen > 0) {
        var inp = this.getInputNode(),
          val = inp.value;
        if (val != this._defRawVal && val.length > maxlen) {
          inp.value = val.substring(0, maxlen);
        }
      }
    }
    this._startOnChanging();
  };
  /** @internal */
  InputWidget.prototype._startOnChanging = function () {
    if (this.isListen('onChanging') || this._instant) InputWidget_1._startOnChanging(this);
  };
  /** @internal */
  InputWidget.prototype.afterKeyDown_ = function (evt, simulated) {
    if (!simulated && this._inplace) {
      if (!this._multiline && evt.keyCode == 13) {
        var $inp = jq(this.getInputNode()),
          inc = this.getInplaceCSS();
        if ($inp.toggleClass(inc).hasClass(inc)) $inp.zk.setSelectionRange(0, $inp[0].value.length);
      } else jq(this.getInputNode()).removeClass(this.getInplaceCSS());
    }
    if (evt.keyCode != 13 || !this.isMultiline()) return _super.prototype.afterKeyDown_.call(this, evt);
    return false;
  };
  /** @internal */
  InputWidget.prototype.beforeCtrlKeys_ = function (evt) {
    this.updateChange_();
  };
  /** @internal */
  InputWidget.prototype.shallIgnoreClick_ = function (evt) {
    return this.isDisabled();
  };
  /**
   * Inserts the text at the current cursor position.
   * It would trigger focus and change event.
   *
   * @param insertedText - the text to be inserted
   * @since 8.5.1
   */
  InputWidget.prototype.setInsertedText = function (insertedText) {
    if (insertedText) {
      var inp = this.getInputNode();
      if (inp) {
        var zkinp = zk(inp);
        // IE/Edge would get caretPos as 0 if not getting focus first
        if (zk.currentFocus != inp)
          // FIXME: comparing a zk.Widget with a HTMLElement?
          zkinp.focus();
        var caretPos = zkinp.getSelectionRange()[0],
          txt = this.getText(),
          before = txt.substring(0, caretPos),
          after = txt.substring(caretPos);
        caretPos += insertedText.length;
        this.setText(before + insertedText + after);
        this.select(caretPos, caretPos);
        this.fireOnChange();
      }
    }
    return this;
  };
  // for errorbox, datebox, combowidget
  /** @internal */
  InputWidget._isInView = function (wgt) {
    var n = wgt.getInputNode();
    return zk(n).isRealScrollIntoView(true);
  };
  /** @internal */
  InputWidget._onChanging = function (timeout) {
    //Note: "this" is available here
    if (this.desktop) {
      var inp = this.getInputNode(),
        val = this.valueEnter_ || inp.value;
      if (this._lastChg != val) {
        this._lastChg = val;
        var valsel = this.valueSel_;
        this.valueSel_ = undefined;
        if (this.isListen('onChanging')) this.fire('onChanging', zul.inp.InputWidget._onChangeData(this, {
          value: val
        }, valsel == val),
        //pass inp.value directly
        {
          ignorable: true,
          rtags: {
            onChanging: 1
          }
        }, timeout || 5);
        if (this._instant) this.updateChange_();
      }
    }
  };
  /** @internal */
  InputWidget._onChangeData = function (wgt, inf, selbk) {
    inf.start = zk(wgt.getInputNode()).getSelectionRange()[0];
    if (selbk) inf.bySelectBack = true;
    return inf;
  };
  /** @internal */
  InputWidget._startOnChanging = function (wgt) {
    InputWidget_1._stopOnChanging(wgt);
    wgt._tidChg = setTimeout(wgt.proxy(InputWidget_1._onChanging), InputWidget_1.onChangingDelay);
  };
  /** @internal */
  InputWidget._stopOnChanging = function (wgt, onBlur) {
    if (wgt._tidChg) {
      clearTimeout(wgt._tidChg);
      wgt._tidChg = undefined;
    }
    if (onBlur) {
      if (InputWidget_1.onChangingForced && wgt.isListen('onChanging') || wgt._instant) {
        InputWidget_1._onChanging.call(wgt, -1); //force
      }
      InputWidget_1._clearOnChanging(wgt);
    }
  };
  /** @internal */
  InputWidget._clearOnChanging = function (wgt) {
    wgt.valueEnter_ = wgt.valueSel_ = undefined;
  };
  /** @internal */
  InputWidget._clearInplaceTimeout = function (widget) {
    if (widget._inplaceTimerId) {
      clearTimeout(widget._inplaceTimerId);
      widget._inplaceTimerId = undefined;
    }
  };
  var InputWidget_1;
  /** The delay for sending the onChanging event (unit: milliseconds).
   * The onChanging event will be sent after the specified delay once
   * the user pressed a keystroke (and changed the value).
   * @defaultValue `350`
   * @since 5.0.1
   */
  InputWidget.onChangingDelay = 350;
  /** Whether to send at least one the onChanging event if it is listened
   * and the content is ever changed.
   * @defaultValue `true`
   * @since 5.0.1
   */
  InputWidget.onChangingForced = true;
  InputWidget = InputWidget_1 = __decorate([zk.WrapClass('zul.inp.InputWidget')], InputWidget);
  return InputWidget;
}(zul.Widget);
exports.InputWidget = InputWidget;
/** @class zul.inp.InputCtrl
 * @import zk.Widget
 * @import jq.Event
 * @import zk.Draggable
 * The extra control for the InputWidget.
 * It is designed to be overriden
 * @since 6.5.0
 */
exports.InputCtrl = {
  /**
   * @returns whether to preserve the focus state.
   * @param wgt - a widget
   */
  isPreservedFocus: function (wgt) {
    return true;
  },
  /**
   * @returns whether to preserve the mousemove state.
   * @param wgt - a widget
   */
  isPreservedMouseMove: function (wgt) {
    return true;
  },
  /**
   * @returns whether to ignore the dragdrop for errorbox
   * @param dg - the drag object
   */
  isIgnoredDragForErrorbox: function (dg, pointer, evt) {
    var c = dg.control.$n('c');
    return evt.domTarget == c && jq(c).hasClass('z-errbox-close-over');
  }
};
zul.inp.InputCtrl = exports.InputCtrl;
window.zul.inp.InputWidget_._keyIgnorable = _keyIgnorable;
window.zul.inp.InputWidget_.windowX = windowX;
window.zul.inp.InputWidget_.windowY = windowY;
window.zul.inp.InputWidget_.InputWidget = InputWidget;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/Intbox.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/Intbox.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.Intbox_) window.zul.inp.Intbox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Intbox = void 0;
/* Intbox.ts

    Purpose:

    Description:

    History:
        Fri Jan 16 12:33:22     2009, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * An edit box for holding an integer.
 * @defaultValue {@link getZclass}: z-intbox.
 *
 */
var Intbox = /** @class */function (_super) {
  __extends(Intbox, _super);
  function Intbox() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the value in int. If null, zero is returned.
   */
  Intbox.prototype.intValue = function () {
    return _super.prototype.getValue.call(this);
  };
  /** @internal */
  Intbox.prototype.coerceFromString_ = function (value) {
    if (!value) return undefined;
    var info = zk.fmt.Number.unformat(this._format, value, false, this._localizedSymbols),
      val = parseInt(info.raw, 10),
      sval;
    if (info.raw.length < 17) sval = val.toString();else sval = new zk.BigDecimal(info.raw).$toString(); // Parse raw input by big decimal to avoid scientific notation
    // B65-ZK-1907: Should compare raw input string instead of parsed number(may contain scientific notation)
    if (isNaN(val) || info.raw != sval && info.raw != '-' + sval) return {
      error: zk.fmt.Text.format(msgzul.INTEGER_REQUIRED, value)
    };
    if (val > 2147483647 || val < -2147483648) return {
      error: zk.fmt.Text.format(msgzul.OUT_OF_RANGE + '(−2147483648 - 2147483647)')
    };
    if (info.divscale) val = Math.round(val / Math.pow(10, info.divscale));
    return val;
  };
  /** @internal */
  Intbox.prototype.coerceToString_ = function (value) {
    var fmt = this._format;
    return fmt ? zk.fmt.Number.format(fmt, value, this._rounding, this._localizedSymbols) : value != null ? '' + String(value) : '';
  };
  Intbox = __decorate([zk.WrapClass('zul.inp.Intbox')], Intbox);
  return Intbox;
}(zul.inp.NumberInputWidget);
exports.Intbox = Intbox;
window.zul.inp.Intbox_.Intbox = Intbox;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/Longbox.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/Longbox.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.Longbox_) window.zul.inp.Longbox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Longbox = void 0;
/* Longbox.ts

    Purpose:

    Description:

    History:
        Sun Mar 29 20:43:22     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * An edit box for holding an integer.
 * @defaultValue {@link getZclass}: z-longbox.
 */
var Longbox = /** @class */function (_super) {
  __extends(Longbox, _super);
  function Longbox() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  //bug #2997037, cannot enter large long integer into longbox
  /** @internal */
  Longbox.prototype.coerceFromString_ = function (value) {
    if (!value) return undefined;
    var info = zk.fmt.Number.unformat(this._format, value, false, this._localizedSymbols),
      val = new zk.Long(info.raw),
      sval = val.$toString();
    if (info.raw != sval && info.raw != '-' + sval)
      //1e2 not supported (unlike Doublebox)
      return {
        error: zk.fmt.Text.format(msgzul.INTEGER_REQUIRED, value)
      };
    if (info.divscale) val.scale(-info.divscale);
    if (this._isOutRange(val.$toString())) return {
      error: zk.fmt.Text.format(msgzul.OUT_OF_RANGE + '(−9223372036854775808 - 9223372036854775807)')
    };
    return val;
  };
  /** @internal */
  Longbox.prototype.coerceToString_ = function (value) {
    var fmt = this._format;
    return value != null ? typeof value == 'string' ? value : fmt ? zk.fmt.Number.format(fmt, value.$toString(), this._rounding, this._localizedSymbols) : value.$toLocaleString() : '';
  };
  /** @internal */
  Longbox.prototype._isOutRange = function (val) {
    var negative = val.startsWith('-');
    if (negative) val = val.substring(1);
    if (val.length > 19) return true;
    if (val.length < 19) return false;
    var maxval = negative ? '9223372036854775808' : '9223372036854775807';
    for (var j = 0; j < 19; ++j) {
      if (val.charAt(j) > maxval.charAt(j)) return true;
      if (val.charAt(j) < maxval.charAt(j)) return false;
    }
    return false;
  };
  /** @internal */
  Longbox.prototype.marshall_ = function (val) {
    return val ? val.$toString() : val;
  };
  /** @internal */
  Longbox.prototype.unmarshall_ = function (val) {
    return val ? new zk.Long(val) : val;
  };
  Longbox = __decorate([zk.WrapClass('zul.inp.Longbox')], Longbox);
  return Longbox;
}(zul.inp.NumberInputWidget);
exports.Longbox = Longbox;
window.zul.inp.Longbox_.Longbox = Longbox;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/NumberInputWidget.ts":
/*!********************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/NumberInputWidget.ts ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* NumberInputWidget.ts

    Purpose:

    Description:

    History:
        Fri May 27 16:12:42 TST 2011, Created by jumperchen

Copyright (C) 2011 Potix Corporation. All Rights Reserved.

This program is distributed under GPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.NumberInputWidget_) window.zul.inp.NumberInputWidget_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.NumberInputWidget = void 0;
var _allowKeys,
  globallocalizedSymbols = {};
// Fixed merging JS issue
zk.load('zul.lang', function () {
  _allowKeys = '0123456789-' + zk.MINUS + zk.PERCENT + (zk.groupingDenied ? '' : zk.GROUPING);
});
/**
 * A skeletal implementation for number-type input box.
 * @since 5.0.8
 */
var NumberInputWidget = /** @class */function (_super) {
  __extends(NumberInputWidget, _super);
  function NumberInputWidget() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the rounding mode.
   * <ul>
   * <li>0: ROUND_UP</li>
   * <li>1: ROUND_DOWN</li>
   * <li>2: ROUND_CEILING</li>
   * <li>3: ROUND_FLOOR</li>
   * <li>4: ROUND_HALF_UP</li>
   * <li>5: ROUND_HALF_DOWN</li>
   * <li>6: ROUND_HALF_EVEN</li>
   * <li>7: ROUND_UNNECESSARY</li>
   * </ul>
   */
  NumberInputWidget.prototype.getRounding = function () {
    return this._rounding;
  };
  /**
   * Sets the rounding mode.
   * <ul>
   * <li>0: ROUND_UP</li>
   * <li>1: ROUND_DOWN</li>
   * <li>2: ROUND_CEILING</li>
   * <li>3: ROUND_FLOOR</li>
   * <li>4: ROUND_HALF_UP</li>
   * <li>5: ROUND_HALF_DOWN</li>
   * <li>6: ROUND_HALF_EVEN</li>
   * <li>7: ROUND_UNNECESSARY</li>
   * </ul>
   * @param rounding - mode
   */
  NumberInputWidget.prototype.setRounding = function (rounding) {
    this._rounding = rounding;
    return this;
  };
  NumberInputWidget.prototype.getLocalizedSymbols = function () {
    return this._localizedSymbols;
  };
  NumberInputWidget.prototype.setLocalizedSymbols = function (localizedSymbols, opts) {
    var o = this._localizedSymbols;
    if (localizedSymbols) {
      var ary = jq.evalJSON(localizedSymbols);
      if (!globallocalizedSymbols[ary[0]]) globallocalizedSymbols[ary[0]] = ary[1];
      this._localizedSymbols = globallocalizedSymbols[ary[0]];
    } else {
      this._localizedSymbols = localizedSymbols;
    }
    if (o !== localizedSymbols || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var symbols = this._localizedSymbols;
      this._allowKeys = symbols ? '0123456789' + symbols.MINUS + symbols.PERCENT + (zk.groupingDenied ? '' : symbols.GROUPING) : undefined;
      this.rerender();
    }
    return this;
  };
  /**
   * @returns a string of keystrokes that are allowed.
   * @since 5.0.8
   * @internal
   */
  NumberInputWidget.prototype.getAllowedKeys_ = function () {
    var _a;
    return (_a = this._allowKeys) !== null && _a !== void 0 ? _a : _allowKeys;
  };
  /** @internal */
  NumberInputWidget.prototype.doKeyPress_ = function (evt) {
    //Bug ZK-1373: ALTGR + 3 key in Spanish keyboard is a combination of Ctrl + Alt + 3 for € sign.
    if (evt.ctrlKey && evt.altKey) evt.stop();
    if (!this._shallIgnore(evt, this.getAllowedKeys_())) _super.prototype.doKeyPress_.call(this, evt);
  };
  /** @internal */
  NumberInputWidget.prototype.doPaste_ = function (evt) {
    //Bug ZK-3838: add a paste event dealer
    var inp = this.getInputNode(),
      val = evt.domEvent.originalEvent.clipboardData.getData('text').trim();
    if (new RegExp('^[' + this.getAllowedKeys_().replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&') + ']+$').test(val)) inp.value = val;
    evt.stop();
    _super.prototype.doPaste_.call(this, evt);
  };
  NumberInputWidget.prototype.getType = function () {
    return this._type;
  };
  /** @internal */
  NumberInputWidget.prototype.domAttrs_ = function (no) {
    var /*safe*/attr = _super.prototype.domAttrs_.call(this, no);
    if ((!no || !no.text) && zk.mobile) attr += ' inputmode="decimal"';
    return attr;
  };
  NumberInputWidget = __decorate([zk.WrapClass('zul.inp.NumberInputWidget')], NumberInputWidget);
  return NumberInputWidget;
}(zul.inp.FormatWidget);
exports.NumberInputWidget = NumberInputWidget;
window.zul.inp.NumberInputWidget_._allowKeys = _allowKeys;
window.zul.inp.NumberInputWidget_.globallocalizedSymbols = globallocalizedSymbols;
window.zul.inp.NumberInputWidget_.NumberInputWidget = NumberInputWidget;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/SimpleConstraint.ts":
/*!*******************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/SimpleConstraint.ts ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.SimpleConstraint_) window.zul.inp.SimpleConstraint_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SimpleConstraint = void 0;
/* constraint.ts

    Purpose:

    Description:

    History:
        Fri Jan  9 10:32:19     2009, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
var _posAllowed = ['before_start', 'before_end', 'end_before', 'end_after', 'after_end', 'after_start', 'start_after', 'start_before', 'overlap', 'overlap_end', 'overlap_before', 'overlap_after', 'at_pointer', 'after_pointer'],
  _baseConstraints = {
    'no positive': 'NO_POSITIVE',
    'no negative': 'NO_NEGATIVE',
    'no zero': 'NO_ZERO',
    'no empty': 'NO_EMPTY',
    'no future': 'NO_FUTURE',
    'no past': 'NO_PAST',
    'no today': 'NO_TODAY',
    'strict': 'STRICT',
    'server': 'SERVER'
  };
/**
 * The default constraint supporting no empty, regular expressions and so on.
 * <p>Depending on the component (such as {@link Intbox} and {@link zul.db.Datebox}).
 */
var SimpleConstraint = /** @class */function (_super) {
  __extends(SimpleConstraint, _super);
  /**
   * It can be String or number, the number or name of flag,
   * such as "no positive", 0x0001.
   * @param b - the regular expression
   * @param c - the error message
   */
  function SimpleConstraint(a, b, c) {
    var _this = _super.call(this) || this;
    /** @internal */
    _this._finishParseCst = true;
    if (typeof a == 'string') {
      _this._flags = {};
      _this._errmsg = {};
      _this._cstArr = [];
      _this._cst = a;
      _this._finishParseCst = false;
    } else {
      _this._flags = typeof a == 'number' ? _this._cvtNum(a) : a || {};
      _this._regex = typeof b == 'string' ? new RegExp(b, 'g') : b;
      _this._errmsg = {};
      if (_this._regex) {
        _this._errmsg.regex = c;
      }
      for (var flag in _this._flags) {
        _this._errmsg[flag] = c;
      }
      if (_this._flags.SERVER) _this.serverValidate = true;
    }
    return _this;
  }
  /** @internal */
  SimpleConstraint.prototype.afterCreated_ = function (a, b, c) {
    if (typeof a == 'string') {
      this._init(a);
    }
  };
  /** @internal */
  SimpleConstraint.prototype._init = function (cst) {
    l_out: for (var j = 0, k = 0, len = cst.length; k >= 0; j = k + 1) {
      for (;; ++j) {
        if (j >= len) return; //done
        var cc = cst.charAt(j);
        if (cc == '/') {
          var hasEndingSlash = false;
          for (k = ++j;; ++k) {
            //look for ending /
            if (k >= len) {
              //no ending /
              k = -1;
              break;
            }
            cc = cst.charAt(k);
            if (cc == '/') {
              hasEndingSlash = true;
              break; //ending / found
            }
            if (cc == '\\') ++k; //skip one
          }
          if (hasEndingSlash) {
            var restCst = cst.substring(k + 1),
              // match zero-or-more character, until reaching a comma or a semicolon or end of string.
              regexFlags = this._extractCst(restCst);
            if (regexFlags) {
              if (regexFlags.includes('d') || regexFlags.includes('y')) zk.error('unsupported regex flags in constraint: ' + cst);
              if (!regexFlags.includes('g')) regexFlags += 'g'; // always use global match
            }
          }
          try {
            this._regex = new RegExp(k >= 0 ? cst.substring(j, k) : cst.substring(j), regexFlags || 'g');
          } catch (e) {
            zk.error(e);
          }
          this._cstArr[this._cstArr.length] = 'regex';
          continue l_out;
        }
        if (cc == ':') {
          var leftBraceIdx = 0,
            rightBraceIdx = len;
          for (k = ++j;; ++k) {
            //look for ending
            if (k >= len) {
              //no ending
              k = -1;
              break;
            }
            cc = cst.charAt(k);
            if (cc == '{') {
              // ZK-2641: in order to support comma, enclose with curly braces
              leftBraceIdx = k + 1;
              for (++k;; ++k) {
                if (cst.charAt(k) == '}') {
                  //find enclosing '}'
                  rightBraceIdx = k;
                  break;
                }
              }
            } else if (cc == ',') break; //msg ending found
          }
          this._errmsg[this._cstArr[this._cstArr.length - 1]] = leftBraceIdx ? cst.substring(leftBraceIdx, rightBraceIdx).trim() : k >= 0 ? cst.substring(j, k).trim() : cst.substring(j).trim();
          continue l_out;
        }
        if (!zUtl.isChar(cc, {
          whitespace: 1
        })) break;
      }
      var s;
      for (k = j;; ++k) {
        if (k >= len) {
          s = cst.substring(j);
          k = -1;
          break;
        }
        var cc = cst.charAt(k);
        if (cc == ',' || cc == ':' || cc == ';' || cc == '/') {
          if (this._regex && j == k) {
            j++;
            continue;
          }
          s = cst.substring(j, k);
          if (cc == ':' || cc == '/') --k;
          break;
        }
      }
      this.parseConstraint_(s.trim().toLowerCase());
    }
  };
  /**
   * @returns the constraint flags Object which has many attribute about constraint,
   * For example, `f.NO_POSITIVE = true`.
   */
  SimpleConstraint.prototype.getFlags = function () {
    return this._flags;
  };
  /**
   * Parses a constraint into an Object attribute.
   * For example, "no positive" is parsed to f.NO_POSITIVE = true.
   *
   * <p>Deriving classes might override this to provide more constraints.
   * @internal
   */
  SimpleConstraint.prototype.parseConstraint_ = function (cst) {
    var f = this._flags,
      arr = this._cstArr,
      bsCst = _baseConstraints[cst];
    if (cst && bsCst) {
      if (cst == 'server') this.serverValidate = true;
      f[bsCst] = true;
      arr[arr.length] = bsCst;
    } else if (cst && _posAllowed.$contains(cst)) this._pos = cst;else if (!arr.length && zk.debugJS) zk.error('Unknown constraint: ' + cst);
  };
  /** @internal */
  SimpleConstraint.prototype._cvtNum = function (v) {
    var f = {};
    if (v & 1) f.NO_POSITIVE = f.NO_FUTURE = true;
    if (v & 2) f.NO_NEGATIVE = f.NO_PAST = true;
    if (v & 4) f.NO_ZERO = f.NO_TODAY = true;
    if (v & 0x100) f.NO_EMPTY = true;
    if (v & 0x200) f.STRICT = true;
    if (v = v & 0xf000) this._pos = _posAllowed[(v >> 12) - 1];
    return f;
  };
  /**
   * validation for flag, validate date if val is date
   * @param val - a String, a number, or a date, the number or name of flag,
   * such as "no positive", 0x0001.
   */
  SimpleConstraint.prototype.validate = function (wgt, val) {
    if (!this._finishParseCst) {
      this._cst && this._init(this._cst);
      this._finishParseCst = true;
    }
    var f = this._flags,
      msg = this._errmsg;
    if (val && val.$toNumber) val = val.$toNumber();
    switch (typeof val) {
      case 'string':
        if (f.NO_EMPTY && (!val || !val.trim())) return msg.NO_EMPTY || msgzul.EMPTY_NOT_ALLOWED;
        var regex = this._regex;
        if (regex) {
          // Bug 3214754
          var val2 = val.match(regex);
          if (!val2 || val2.join('') != val) return msg.regex || msgzul.ILLEGAL_VALUE;
        }
        if (f.STRICT && val && wgt.validateStrict) {
          var msg_1 = wgt.validateStrict(val);
          if (msg_1) return msg_1;
        }
        return;
      case 'number':
        if (val > 0) {
          if (f.NO_POSITIVE) return msg.NO_POSITIVE || this._msgNumDenied();
        } else if (val == 0) {
          if (f.NO_ZERO) return msg.NO_ZERO || this._msgNumDenied();
        } else if (f.NO_NEGATIVE) return msg.NO_NEGATIVE || this._msgNumDenied();
        return;
    }
    if (val && val.getFullYear) {
      var date = val,
        tz = date.getTimeZone(),
        today = zUtl.today(false, tz),
        date = window.Dates.newInstance([date.getFullYear(), date.getMonth(), date.getDate()], tz);
      if ((+today - +date) / 86400000 < 0) {
        if (f.NO_FUTURE) return msg.NO_FUTURE || this._msgDateDenied();
      } else if (+date - +today == 0) {
        if (f.NO_TODAY) return msg.NO_TODAY || this._msgDateDenied();
      } else if (f.NO_PAST) return msg.NO_PAST || this._msgDateDenied();
      return;
    }
    if (!val && f.NO_EMPTY) return msg.NO_EMPTY || msgzul.EMPTY_NOT_ALLOWED;
  };
  /** @internal */
  SimpleConstraint.prototype._msgNumDenied = function () {
    var f = this._flags,
      msg = this._errmsg;
    if (f.NO_POSITIVE) return msg.NO_POSITIVE || (f.NO_ZERO ? f.NO_NEGATIVE ? msgzul.NO_POSITIVE_NEGATIVE_ZERO : msgzul.NO_POSITIVE_ZERO : f.NO_NEGATIVE ? msgzul.NO_POSITIVE_NEGATIVE : msgzul.NO_POSITIVE);else if (f.NO_NEGATIVE) return msg.NO_NEGATIVE || (f.NO_ZERO ? msgzul.NO_NEGATIVE_ZERO : msgzul.NO_NEGATIVE);else if (f.NO_ZERO) return msg.NO_ZERO || msgzul.NO_ZERO;
    return msg || msgzul.ILLEGAL_VALUE;
  };
  /** @internal */
  SimpleConstraint.prototype._msgDateDenied = function () {
    var f = this._flags,
      msg = this._errmsg;
    if (f.NO_FUTURE) return msg.NO_FUTURE || (f.NO_TODAY ? f.NO_PAST ? msgzul.NO_FUTURE_PAST_TODAY : msgzul.NO_FUTURE_TODAY : f.NO_PAST ? msgzul.NO_FUTURE_PAST : msgzul.NO_FUTURE);else if (f.NO_PAST) return msg.NO_PAST || (f.NO_TODAY ? msgzul.NO_PAST_TODAY : msgzul.NO_PAST);else if (f.NO_TODAY) return msg.NO_TODAY || msgzul.NO_TODAY;
    return msg || msgzul.ILLEGAL_VALUE;
  };
  /** @internal */
  SimpleConstraint.prototype._extractCst = function (restCst) {
    for (var i = 0, n = restCst.length; i < n; i++) {
      var c = restCst.charAt(i);
      if (',' == c || ':' == c) {
        return restCst.substring(0, i).trim();
      }
    }
    return restCst.trim();
  };
  SimpleConstraint.prototype.reparseConstraint = function () {
    this._finishParseCst = false;
  };
  SimpleConstraint = __decorate([zk.WrapClass('zul.inp.SimpleConstraint')], SimpleConstraint);
  return SimpleConstraint;
}(zk.Object);
exports.SimpleConstraint = SimpleConstraint;
window.zul.inp.SimpleConstraint_._posAllowed = _posAllowed;
window.zul.inp.SimpleConstraint_._baseConstraints = _baseConstraints;
window.zul.inp.SimpleConstraint_.SimpleConstraint = SimpleConstraint;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/SimpleDateConstraint.ts":
/*!***********************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/SimpleDateConstraint.ts ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.SimpleDateConstraint_) window.zul.inp.SimpleDateConstraint_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SimpleDateConstraint = void 0;
/* SimpleDateConstraint.ts

    Purpose:

    Description:

    History:
        Thu Sep 10 10:09:47     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A simple date constraint.
 */
var SimpleDateConstraint = /** @class */function (_super) {
  __extends(SimpleDateConstraint, _super);
  /**
   * It can be String or number, the number or name of flag,
   * such as "no positive", 0x0001.
   * @param wgt - datebox
   * @since 5.0.8
   */
  function SimpleDateConstraint(a, wgt) {
    var _this = _super.call(this, a) || this;
    _this.format = 'yyyyMMdd';
    _this._wgt = wgt;
    _this._localizedSymbols = wgt._localizedSymbols;
    return _this;
  }
  /** @internal */
  SimpleDateConstraint.prototype.parseConstraint_ = function (constraint) {
    var len = this.format.length + 1,
      arr = this._cstArr,
      wgt = this._wgt,
      tz = wgt && wgt.getTimeZone && wgt.getTimeZone();
    if (constraint.startsWith('between')) {
      var j = constraint.indexOf('and', 7);
      if (j < 0 && zk.debugJS) zk.error('Unknown constraint: ' + constraint);
      this._beg = new zk.fmt.Calendar(undefined, this._localizedSymbols).parseDate(constraint.substring(7, j), this.format, undefined, undefined, undefined, tz);
      this._end = new zk.fmt.Calendar(undefined, this._localizedSymbols).parseDate(constraint.substring(j + 3, j + 3 + len), this.format, undefined, undefined, undefined, tz);
      if (this._beg.getTime() > this._end.getTime()) {
        var d = this._beg;
        this._beg = this._end;
        this._end = d;
      }
      this._beg.setHours(0, 0, 0, 0);
      this._end.setHours(0, 0, 0, 0);
      arr[arr.length] = 'between';
    } else if (constraint.startsWith('before') && !constraint.startsWith('before_')) {
      this._end = new zk.fmt.Calendar(undefined, this._localizedSymbols).parseDate(constraint.substring(6, 6 + len), this.format, undefined, undefined, undefined, tz);
      this._end.setHours(0, 0, 0, 0);
      arr[arr.length] = 'before';
    } else if (constraint.startsWith('after') && !constraint.startsWith('after_')) {
      this._beg = new zk.fmt.Calendar(undefined, this._localizedSymbols).parseDate(constraint.substring(5, 5 + len), this.format, undefined, undefined, undefined, tz);
      this._beg.setHours(0, 0, 0, 0);
      arr[arr.length] = 'after';
    }
    return _super.prototype.parseConstraint_.call(this, constraint);
  };
  SimpleDateConstraint.prototype.validate = function (wgt, val) {
    var result = _super.prototype.validate.call(this, wgt, val);
    if (val instanceof window.DateImpl) {
      var msg = this._errmsg,
        v = Dates.newInstance([val.getFullYear(), val.getMonth(), val.getDate()], val.getTimeZone());
      if (this._beg != null && this._beg.getTime() > v.getTime()) return msg.between || msg.after || this.outOfRangeValue();
      if (this._end != null && this._end.getTime() < v.getTime()) return msg.between || msg.before || this.outOfRangeValue();
    }
    return result;
  };
  /**
   * @returns the message about out of range value
   */
  SimpleDateConstraint.prototype.outOfRangeValue = function () {
    var format = this._wgt._format,
      separator = msgzul.OUT_OF_RANGE_SEPARATOR ? ' ' + msgzul.OUT_OF_RANGE_SEPARATOR + ' ' : ' ~ ';
    return msgzul.OUT_OF_RANGE + ': ' + (this._beg != null ? this._end != null ? new zk.fmt.Calendar(undefined, this._localizedSymbols).formatDate(this._beg, format) + separator + new zk.fmt.Calendar().formatDate(this._end, format) : '>= ' + new zk.fmt.Calendar().formatDate(this._beg, format) : '<= ' + new zk.fmt.Calendar().formatDate(this._end, format));
  };
  SimpleDateConstraint = __decorate([zk.WrapClass('zul.inp.SimpleDateConstraint')], SimpleDateConstraint);
  return SimpleDateConstraint;
}(zul.inp.SimpleConstraint);
exports.SimpleDateConstraint = SimpleDateConstraint;
window.zul.inp.SimpleDateConstraint_.SimpleDateConstraint = SimpleDateConstraint;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/SimpleDoubleSpinnerConstraint.ts":
/*!********************************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/SimpleDoubleSpinnerConstraint.ts ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.SimpleDoubleSpinnerConstraint_) window.zul.inp.SimpleDoubleSpinnerConstraint_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SimpleDoubleSpinnerConstraint = void 0;
/**
 * A simple double spinner constraint.
 */
var SimpleDoubleSpinnerConstraint = /** @class */function (_super) {
  __extends(SimpleDoubleSpinnerConstraint, _super);
  function SimpleDoubleSpinnerConstraint() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the minimum value.
   */
  SimpleDoubleSpinnerConstraint.prototype.getMin = function () {
    return this._min;
  };
  /**
   * Set the minimum value.
   */
  SimpleDoubleSpinnerConstraint.prototype.setMin = function (min) {
    this._min = min;
    return this;
  };
  /**
   * @returns the maximum value.
   */
  SimpleDoubleSpinnerConstraint.prototype.getMax = function () {
    return this._max;
  };
  /**
   * Set the maximum value.
   */
  SimpleDoubleSpinnerConstraint.prototype.setMax = function (max) {
    this._max = max;
    return this;
  };
  /** @internal */
  SimpleDoubleSpinnerConstraint.prototype.parseConstraint_ = function (cst) {
    var cstList = cst.replace(/ +/g, ' ').split(/[, ]/),
      len = cstList.length,
      isSpinner;
    for (var i = 0; i < len + 1; i++) {
      if (cstList[i] == 'min') {
        this._min = cstList[++i] * 1;
        isSpinner = true;
      } else if (cstList[i] == 'max') {
        this._max = cstList[++i] * 1;
        isSpinner = true;
      }
    }
    if (isSpinner) return;else return _super.prototype.parseConstraint_.call(this, cst);
  };
  SimpleDoubleSpinnerConstraint.prototype.validate = function (wgt, val) {
    var result = _super.prototype.validate.call(this, wgt, val);
    switch (typeof val) {
      case 'number':
        if (this._max && val > this._max || this._min && val < this._min) {
          var msg = msgzul.OUT_OF_RANGE + ': ';
          msg += '(' + (this._min != null ? this._max != null ? this._min + ' ~ ' + this._max : '>= ' + this._min : '<= ' + this._max) + ')';
        }
    }
    if (msg) return msg;else return result;
  };
  SimpleDoubleSpinnerConstraint = __decorate([zk.WrapClass('zul.inp.SimpleDoubleSpinnerConstraint')], SimpleDoubleSpinnerConstraint);
  return SimpleDoubleSpinnerConstraint;
}(zul.inp.SimpleConstraint);
exports.SimpleDoubleSpinnerConstraint = SimpleDoubleSpinnerConstraint;
window.zul.inp.SimpleDoubleSpinnerConstraint_.SimpleDoubleSpinnerConstraint = SimpleDoubleSpinnerConstraint;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/SimpleLocalTimeConstraint.ts":
/*!****************************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/SimpleLocalTimeConstraint.ts ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.SimpleLocalTimeConstraint_) window.zul.inp.SimpleLocalTimeConstraint_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SimpleLocalTimeConstraint = void 0;
/* SimpleLocalTimeConstraint.ts

    Purpose:

    Description:

    History:
        Wed Aug 14 15:01:24 CST 2019, Created by rudyhuang

Copyright (C) 2019 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A simple time constraint.
 * @since 9.0.0
 */
var SimpleLocalTimeConstraint = /** @class */function (_super) {
  __extends(SimpleLocalTimeConstraint, _super);
  /**
   * It can be String or number, the number or name of flag,
   * such as "no positive", 0x0001.
   * @param wgt - datebox
   */
  function SimpleLocalTimeConstraint(a, wgt) {
    var _this = _super.call(this, a) || this;
    _this.format = 'HHmmss';
    _this._wgt = wgt;
    _this._localizedSymbols = wgt._localizedSymbols;
    return _this;
  }
  /** @internal */
  SimpleLocalTimeConstraint.prototype.parseConstraint_ = function (constraint) {
    var len = this.format.length + 1,
      arr = this._cstArr,
      wgt = this._wgt,
      tz = wgt && wgt.getTimeZone && wgt.getTimeZone();
    if (constraint.startsWith('between')) {
      var j = constraint.indexOf('and', 7);
      if (j < 0 && zk.debugJS) zk.error('Unknown constraint: ' + constraint);
      this._beg = new zk.fmt.Calendar(undefined, this._localizedSymbols).parseDate(constraint.substring(7, j), this.format, undefined, undefined, undefined, tz);
      this._end = new zk.fmt.Calendar(undefined, this._localizedSymbols).parseDate(constraint.substring(j + 3, j + 3 + len), this.format, undefined, undefined, undefined, tz);
      if (this._beg.getTime() > this._end.getTime()) {
        var d = this._beg;
        this._beg = this._end;
        this._end = d;
      }
      arr[arr.length] = 'between';
    } else if (constraint.startsWith('before') && !constraint.startsWith('before_')) {
      this._end = new zk.fmt.Calendar(undefined, this._localizedSymbols).parseDate(constraint.substring(6, 6 + len), this.format, undefined, undefined, undefined, tz);
      arr[arr.length] = 'before';
    } else if (constraint.startsWith('after') && !constraint.startsWith('after_')) {
      this._beg = new zk.fmt.Calendar(undefined, this._localizedSymbols).parseDate(constraint.substring(5, 5 + len), this.format, undefined, undefined, undefined, tz);
      arr[arr.length] = 'after';
    }
    return _super.prototype.parseConstraint_.call(this, constraint);
  };
  SimpleLocalTimeConstraint.prototype.validate = function (wgt, val) {
    var result = _super.prototype.validate.call(this, wgt, val);
    if (val instanceof DateImpl) {
      var msg = this._errmsg,
        time = this._getTime(val);
      if (this._beg != null && this._getTime(this._beg) > time) return msg.between || msg.after || this.outOfRangeValue();
      if (this._end != null && this._getTime(this._end) < time) return msg.between || msg.before || this.outOfRangeValue();
    }
    return result;
  };
  /** @internal */
  SimpleLocalTimeConstraint.prototype._getTime = function (val) {
    return val.getSeconds() + val.getMinutes() * 60 + val.getHours() * 3600;
  };
  /**
   * @returns the message about out of range value
   */
  SimpleLocalTimeConstraint.prototype.outOfRangeValue = function () {
    var format = this._wgt._format,
      separator = msgzul.OUT_OF_RANGE_SEPARATOR ? ' ' + msgzul.OUT_OF_RANGE_SEPARATOR + ' ' : ' ~ ';
    return msgzul.OUT_OF_RANGE + ': ' + (this._beg != null ? this._end != null ? new zk.fmt.Calendar(undefined, this._localizedSymbols).formatDate(this._beg, format) + separator + new zk.fmt.Calendar().formatDate(this._end, format) : '>= ' + new zk.fmt.Calendar().formatDate(this._beg, format) : '<= ' + new zk.fmt.Calendar().formatDate(this._end, format));
  };
  SimpleLocalTimeConstraint = __decorate([zk.WrapClass('zul.inp.SimpleLocalTimeConstraint')], SimpleLocalTimeConstraint);
  return SimpleLocalTimeConstraint;
}(zul.inp.SimpleConstraint);
exports.SimpleLocalTimeConstraint = SimpleLocalTimeConstraint;
window.zul.inp.SimpleLocalTimeConstraint_.SimpleLocalTimeConstraint = SimpleLocalTimeConstraint;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/SimpleSpinnerConstraint.ts":
/*!**************************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/SimpleSpinnerConstraint.ts ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.SimpleSpinnerConstraint_) window.zul.inp.SimpleSpinnerConstraint_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SimpleSpinnerConstraint = void 0;
/**
 * A simple spinner constraint.
 */
var SimpleSpinnerConstraint = /** @class */function (_super) {
  __extends(SimpleSpinnerConstraint, _super);
  function SimpleSpinnerConstraint() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the minimum value.
   */
  SimpleSpinnerConstraint.prototype.getMin = function () {
    return this._min;
  };
  /**
   * Set the minimum value.
   */
  SimpleSpinnerConstraint.prototype.setMin = function (min) {
    this._min = min;
    return this;
  };
  /**
   * @returns the maximum value.
   */
  SimpleSpinnerConstraint.prototype.getMax = function () {
    return this._max;
  };
  /**
   * Set the maximum value.
   */
  SimpleSpinnerConstraint.prototype.setMax = function (max) {
    this._max = max;
    return this;
  };
  /** @internal */
  SimpleSpinnerConstraint.prototype.parseConstraint_ = function (cst) {
    var cstList = cst.replace(/ +/g, ' ').split(/[, ]/),
      len = cstList.length,
      isSpinner,
      arr = this._cstArr;
    if (cstList.$contains('max') && cstList.$contains('min')) {
      arr[arr.length] = 'maxmin';
      isSpinner = true;
    }
    for (var i = 0; i < len + 1; i++) {
      var csti = cstList[i];
      if (csti == 'min' || csti == 'max') {
        if (!isSpinner) {
          arr[arr.length] = csti;
          isSpinner = true;
        }
        this['_' + csti] = +cstList[++i];
      }
    }
    if (isSpinner) {
      return;
    } else return _super.prototype.parseConstraint_.call(this, cst);
  };
  SimpleSpinnerConstraint.prototype.validate = function (wgt, val) {
    var result = _super.prototype.validate.call(this, wgt, val);
    switch (typeof val) {
      case 'number':
        var maxErr = this._max && val > this._max,
          minErr = this._min && val < this._min;
        if (maxErr || minErr) {
          var maxminErrMsg = this._errmsg.maxmin,
            errmsg = maxminErrMsg ? maxminErrMsg : maxErr ? this._errmsg.max : this._errmsg.min,
            msg = errmsg ? errmsg : msgzul.OUT_OF_RANGE + ': ' + (this._min != null ? this._max != null ? this._min + ' - ' + this._max : '>= ' + this._min : '<= ' + this._max);
        }
    }
    return msg || result;
  };
  SimpleSpinnerConstraint = __decorate([zk.WrapClass('zul.inp.SimpleSpinnerConstraint')], SimpleSpinnerConstraint);
  return SimpleSpinnerConstraint;
}(zul.inp.SimpleConstraint);
exports.SimpleSpinnerConstraint = SimpleSpinnerConstraint;
window.zul.inp.SimpleSpinnerConstraint_.SimpleSpinnerConstraint = SimpleSpinnerConstraint;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/Slider.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/Slider.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Slider.ts

    Purpose:

    Description:

    History:
        Thu May 22 11:17:24     2009, Created by kindalu

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.Slider_) window.zul.inp.Slider_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Slider = void 0;
/**
 * A slider.
 * @defaultValue {@link getZclass}: z-slider.
 */
var Slider = /** @class */function (_super) {
  __extends(Slider, _super);
  function Slider() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._orient = 'horizontal';
    /** @internal */
    _this._curpos = 0;
    /** @internal */
    _this._minpos = 0;
    /** @internal */
    _this._maxpos = 100;
    /** @internal */
    _this._slidingtext = '{0}';
    /** @internal */
    _this._pageIncrement = -1;
    /** @internal */
    _this._step = -1;
    /** @internal */
    _this._mode = 'integer';
    return _this;
  }
  Slider_1 = Slider;
  /**
   * @returns the orient.
   * @defaultValue `"horizontal"`.
   */
  Slider.prototype.getOrient = function () {
    return this._orient;
  };
  /**
   * Sets the orient.
   * @defaultValue `"horizontal"`
   * @param orient - either "horizontal" or "vertical".
   */
  Slider.prototype.setOrient = function (orient, opts) {
    var o = this._orient;
    this._orient = orient;
    if (o !== orient || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the current position of the slider.
   * @defaultValue `0`.
   */
  Slider.prototype.getCurpos = function () {
    return this._curpos;
  };
  /**
   * Sets the current position of the slider.
   * If negative, 0 is assumed. If larger than {@link getMaxpos},
   * {@link getMaxpos} is assumed.
   */
  Slider.prototype.setCurpos = function (curpos, opts) {
    var o = this._curpos;
    this._curpos = curpos;
    if (o !== curpos || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        this._fixPos();
      }
    }
    return this;
  };
  /**
   * @returns the minimum position of the slider.
   * @defaultValue `0`.
   * @since 7.0.1
   */
  Slider.prototype.getMinpos = function () {
    return this._minpos;
  };
  /**
   * Sets the minimum position of the slider.
   * @since 7.0.1
   */
  Slider.prototype.setMinpos = function (minpos, opts) {
    var o = this._minpos;
    this._minpos = minpos;
    if (o !== minpos || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this._curpos < minpos) {
        this._curpos = minpos;
      }
      this._fixStep();
      if (this.desktop) this._fixPos();
    }
    return this;
  };
  /**
   * @returns the maximum position of the slider.
   * @defaultValue `100`.
   * @since 7.0.1
   */
  Slider.prototype.getMaxpos = function () {
    return this._maxpos;
  };
  /**
   * Sets the maximum position of the slider.
   * @since 7.0.1
   */
  Slider.prototype.setMaxpos = function (maxpos, opts) {
    var o = this._maxpos;
    this._maxpos = maxpos;
    if (o !== maxpos || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this._curpos > maxpos) {
        this._curpos = maxpos;
      }
      this._fixStep();
      if (this.desktop) this._fixPos();
    }
    return this;
  };
  /**
   * @returns the sliding text.
   * @defaultValue `"{0}"`
   */
  Slider.prototype.getSlidingtext = function () {
    return this._slidingtext;
  };
  /**
   * Sets the sliding text.
   * The syntax `"{0}"` will be replaced with the position at client side.
   */
  Slider.prototype.setSlidingtext = function (slidingtext) {
    this._slidingtext = slidingtext;
    return this;
  };
  /**
   * @returns the amount that the value of {@link getCurpos}
   * changes by when the tray of the scroll bar is clicked.
   *
   * @defaultValue -1 (means it will scroll to the position the user clicks).
   */
  Slider.prototype.setPageIncrement = function (pageIncrement) {
    this._pageIncrement = pageIncrement;
    return this;
  };
  /**
   * Sets the amount that the value of {@link getCurpos}
   * changes by when the tray of the scroll bar is clicked.
   * @defaultValue `-1` (means it will scroll to the position the user clicks).
   * @param pginc - the page increment. If negative, slider will scroll (since 7.0.1)
   * to the position that user clicks.
   */
  Slider.prototype.getPageIncrement = function () {
    return this._pageIncrement;
  };
  /**
   * @returns the step of slider
   * @since 7.0.1
   */
  Slider.prototype.getStep = function () {
    return this._step;
  };
  /**
   * Sets the step of slider
   * @defaultValue `-1` (means it will scroll to the position the user clicks).
   * <strong>Note:</strong> In "decimal" mode, the fraction part only contains one digit if step is -1.
   * @since 7.0.1
   */
  Slider.prototype.setStep = function (step, opts) {
    var o = this._step;
    this._step = step;
    if (o !== step || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this._fixStep();
    }
    return this;
  };
  /**
   * @returns the name of this component.
   * @defaultValue `null`.
   * <p>The name is used only to work with "legacy" Web application that
   * handles user's request by servlets.
   * It works only with HTTP/HTML-based browsers. It doesn't work
   * with other kind of clients.
   * <p>Don't use this method if your application is purely based
   * on ZK's event-driven model.
   */
  Slider.prototype.getName = function () {
    return this._name;
  };
  /**
   * Sets the name of this component.
   * <p>The name is used only to work with "legacy" Web application that
   * handles user's request by servlets.
   * It works only with HTTP/HTML-based browsers. It doesn't work
   * with other kind of clients.
   * <p>Don't use this method if your application is purely based
   * on ZK's event-driven model.
   *
   * @param name - the name of this component.
   */
  Slider.prototype.setName = function (name, opts) {
    var o = this._name;
    this._name = name;
    if (o !== name || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.efield) this.efield.name = this._name;
    }
    return this;
  };
  /**
   * @returns the current mode of slider. One of `"integer"`, `"decimal"`.
   * @defaultValue `"integer"`
   * @since 7.0.1
   */
  Slider.prototype.getMode = function () {
    return this._mode;
  };
  /**
   * Sets the mode to integer or decimal.
   *
   * @param mode - the mode which could be one of `"integer"`, `"decimal"`.
   * @since 7.0.1
   */
  Slider.prototype.setMode = function (mode, opts) {
    var o = this._mode;
    this._mode = mode;
    if (o !== mode || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this._fixStep();
      if (this.desktop) {
        this._fixPos();
      }
    }
    return this;
  };
  Slider.prototype.setWidth = function (width) {
    _super.prototype.setWidth.call(this, width);
    if (this.desktop && this._mold != 'knob') {
      this.onSize();
    }
    return this;
  };
  Slider.prototype.setHeight = function (height) {
    _super.prototype.setHeight.call(this, height);
    if (this.desktop && this._mold != 'knob') {
      this.onSize();
    }
    return this;
  };
  /** @internal */
  Slider.prototype.domClass_ = function (no) {
    var sclsHTML = _super.prototype.domClass_.call(this, no);
    if (this._mold == 'knob') return sclsHTML;
    var isVertical = this.isVertical();
    if (isVertical) sclsHTML += ' ' + this.$s('vertical');else sclsHTML += ' ' + this.$s('horizontal');
    if (this.inSphereMold()) sclsHTML += ' ' + this.$s('sphere');else if (this.inScaleMold() && !isVertical) sclsHTML += ' ' + this.$s('scale');
    return sclsHTML;
  };
  /** @internal */
  Slider.prototype.onup_ = function (evt) {
    var btn = zul.inp.Slider.down_btn,
      widget;
    if (btn) {
      widget = zk.Widget.$(btn);
    }
    zul.inp.Slider.down_btn = undefined;
    if (widget) jq(document).off('zmouseup', widget.onup_);
  };
  /** @internal */
  Slider.prototype.doMouseDown_ = function (evt) {
    if (this._mold == 'knob') {
      _super.prototype.doMouseDown_.call(this, evt);
      return;
    }
    jq(document).on('zmouseup', this.onup_);
    zul.inp.Slider.down_btn = this.$n('btn');
    _super.prototype.doMouseDown_.call(this, evt);
  };
  /** @internal */
  Slider.prototype.doClick_ = function (evt, popupOnly) {
    if (this._mold == 'knob') {
      _super.prototype.doClick_.call(this, evt, popupOnly);
      return;
    }
    var $btn = jq(this.$n_('btn')),
      pos = $btn.zk.revisedOffset(),
      wgt = this,
      pageIncrement = this._pageIncrement,
      moveToCursor = pageIncrement < 0 && Slider_1._getStep(this) < 0,
      isVertical = this.isVertical(),
      height = this._getHeight(),
      width = this._getWidth(),
      offset = isVertical ? evt.pageY - pos[1] : evt.pageX - pos[0];
    if (!$btn[0] || $btn.is(':animated')) return;
    if (!moveToCursor) {
      if (pageIncrement > 0) {
        var curpos = this._curpos + (offset > 0 ? pageIncrement : -pageIncrement);
        this._curpos = Slider_1._roundDecimal(this._constraintPos(curpos), Slider_1._digitsAfterDecimal(pageIncrement));
      } else {
        var total = isVertical ? height : width,
          to = offset / total * (this._maxpos - this._minpos);
        this._curpos = this._getSteppedPos(to + this._curpos);
      }
      offset = undefined; // update by _curpos
    }
    // B65-ZK-1884: Avoid button's animation out of range
    // B86-ZK-4125: Vertical slider area is not aligned with button
    if (offset != null) {
      var n = this.$n_(),
        sign = offset >= 0 ? 1 : -1,
        wgtDim = isVertical ? n.clientHeight : n.clientWidth,
        stepDim = wgtDim / (this._maxpos - this._minpos),
        stepOffset = Math.floor(Math.abs(offset / stepDim));
      if (stepOffset < 1) stepOffset = 1;
      offset = wgtDim ? stepOffset * stepDim * sign : 0;
    }
    var nextPos = Slider_1._getNextPos(this, offset),
      speed = $btn.zk.getAnimationSpeed('slow');
    if (isVertical && zk.parseInt(nextPos.top) > height) nextPos.top = jq.px0(height);
    if (!isVertical && zk.parseInt(nextPos.left) > width) nextPos.left = jq.px0(width);
    //ZK-2332 use the speed set in the client-attribute, use the default value 'slow'
    $btn.animate(nextPos, speed, function () {
      pos = moveToCursor ? wgt._realpos() : wgt._curpos;
      pos = wgt._constraintPos(pos);
      wgt.fire('onScroll', wgt.isDecimal() ? {
        decimal: pos
      } : pos);
    });
    jq(this.$n_('area')).animate(isVertical ? {
      height: nextPos.top
    } : {
      width: nextPos.left
    }, speed);
    _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  /** @internal */
  Slider.prototype._makeDraggable = function () {
    var opt = {
      constraint: this._orient || 'horizontal',
      starteffect: this._startDrag,
      change: this._dragging,
      endeffect: this._endDrag
    };
    if (Slider_1._getStep(this) > 0) opt.snap = this._getStepOffset();
    this._drag = new zk.Draggable(this, this.$n_('btn'), opt);
  };
  /** @internal */
  Slider.prototype._snap = function (x, y) {
    var btn = this.$n('btn'),
      ofs = zk(this.$n()).cmOffset();
    ofs = zk(btn).toStyleOffset(ofs[0], ofs[1]);
    if (x <= ofs[0]) {
      x = ofs[0];
    } else {
      var max = ofs[0] + this._getWidth();
      if (x > max) x = max;
    }
    if (y <= ofs[1]) {
      y = ofs[1];
    } else {
      var max = ofs[1] + this._getHeight();
      if (y > max) y = max;
    }
    return [x, y];
  };
  /** @internal */
  Slider.prototype._startDrag = function (dg) {
    var widget = dg.control,
      sclassHTML = widget.getSclass();
    widget.$n_('btn').title = ''; //to avoid annoying effect
    widget.slidepos = widget._curpos;
    jq(document.body).append( /*safe*/'<div id="zul_slidetip" class="' + widget.$s('popup') + (sclassHTML ? ' ' + sclassHTML + '">' : '">') + DOMPurify.sanitize(widget._slidingtext.replace(/\{0\}/g, widget.slidepos)) + '</div>');
    widget.slidetip = jq('#zul_slidetip')[0];
    if (widget.slidetip) {
      var slideStyle = widget.slidetip.style;
      if (zk.webkit) {
        //give initial position to avoid browser scrollbar
        slideStyle.top = '0px';
        slideStyle.left = '0px';
      }
    }
  };
  /** @internal */
  Slider.prototype._dragging = function (dg) {
    var widget = dg.control,
      isDecimal = widget.isDecimal(),
      pos = widget._realpos();
    if (pos != widget.slidepos) {
      widget.slidepos = widget._curpos = pos = widget._constraintPos(pos);
      var text = isDecimal ? pos.toFixed(Slider_1._digitsAfterDecimal(Slider_1._getStep(widget))) : pos;
      if (widget.slidetip)
        // B70-ZK-2081: Replace "{0}" with the position.
        // eslint-disable-next-line @microsoft/sdl/no-inner-html
        widget.slidetip.innerHTML = DOMPurify.sanitize(widget._slidingtext.replace(/\{0\}/g, text));
      widget.fire('onScrolling', isDecimal ? {
        decimal: pos
      } : pos);
    }
    widget._fixPos();
  };
  /** @internal */
  Slider.prototype._endDrag = function (dg) {
    var widget = dg.control,
      pos = widget._constraintPos(widget._realpos());
    widget.fire('onScroll', widget.isDecimal() ? {
      decimal: pos
    } : pos);
    widget._fixPos();
    jq(widget.slidetip).remove();
    widget.slidetip = undefined;
  };
  /** @internal */
  Slider.prototype._realpos = function (dg) {
    var btnofs = zk(this.$n('btn')).revisedOffset(),
      refofs = zk(this.$n()).revisedOffset(),
      maxpos = this._maxpos,
      minpos = this._minpos,
      step = Slider_1._getStep(this),
      pos;
    if (this.isVertical()) {
      var ht = this._getHeight();
      pos = ht ? (btnofs[1] - refofs[1]) * (maxpos - minpos) / ht : 0;
    } else {
      var wd = this._getWidth();
      pos = wd ? (btnofs[0] - refofs[0]) * (maxpos - minpos) / wd : 0;
    }
    if (!this.isDecimal()) pos = Math.round(pos);
    if (step > 0) {
      return this._curpos = pos > 0 ? Slider_1._roundDecimal(pos + minpos, Slider_1._digitsAfterDecimal(step)) : minpos;
    } else return this._curpos = (pos > 0 ? pos : 0) + minpos;
  };
  /** @internal */
  Slider.prototype._constraintPos = function (pos) {
    var step = Slider_1._getStep(this),
      max = this._maxpos;
    if (pos < max) {
      pos -= (pos - this._minpos) % step;
    } else {
      pos = max;
    }
    return pos;
  };
  /** @internal */
  Slider.prototype._getSteppedPos = function (pos) {
    var minpos = this._minpos,
      step = Slider_1._getStep(this),
      mul = 1,
      rmdPos;
    pos -= minpos;
    if (this.isDecimal()) {
      mul = Math.pow(10, Slider_1._digitsAfterDecimal(step));
      pos *= mul;
      step *= mul;
    }
    rmdPos = pos % step;
    return (pos - rmdPos + Math.round(rmdPos / step) * step) / mul + minpos;
  };
  /** @internal */
  Slider.prototype._getWidth = function () {
    return this.$n_().clientWidth - this.$n_('btn').offsetWidth;
  };
  /** @internal */
  Slider.prototype._getHeight = function () {
    return this.$n_().clientHeight - this.$n_('btn').offsetHeight;
  };
  /** @internal */
  Slider.prototype._getStepOffset = function () {
    var totalLen = this.isVertical() ? this._getHeight() : this._getWidth(),
      step = Slider_1._getStep(this),
      ofs = [0, 0];
    if (step) ofs[this.isVertical() ? 1 : 0] = totalLen > 0 ? totalLen * step / (this._maxpos - this._minpos) : 0;
    return ofs;
  };
  /** @internal */
  Slider.prototype._fixSize = function () {
    var n = this.$n_(),
      btn = this.$n_('btn'),
      inners = this.$n_('inner').style;
    if (this.isVertical()) {
      btn.style.top = '-' + btn.offsetHeight / 2 + 'px';
      var het = n.clientHeight;
      inners.height = jq.px0(het > 0 ? het : this._height - btn.offsetHeight);
    } else {
      btn.style.left = '-' + btn.offsetWidth / 2 + 'px';
      var wd = n.clientWidth;
      inners.width = jq.px0(wd > 0 ? wd : this._width - btn.offsetWidth);
    }
  };
  /** @internal */
  Slider.prototype._fixPos = function () {
    var btn = this.$n_('btn'),
      vert = this.isVertical(),
      newPos = jq.px0(Slider_1._getBtnNewPos(this));
    this.$n_('area').style[vert ? 'height' : 'width'] = newPos;
    btn.style[vert ? 'top' : 'left'] = newPos;
    if (this.slidetip) zk(this.slidetip).position(btn, vert ? 'end_before' : 'before_start');
  };
  /** @internal */
  Slider.prototype._fixStep = function () {
    var step = Slider_1._getStep(this);
    if (this._drag) {
      if (step <= 0) {
        if (this._drag.opts.snap) delete this._drag.opts.snap;
      } else this._drag.opts.snap = this._getStepOffset();
    }
  };
  Slider.prototype.onSize = function () {
    this._fixSize();
    this._fixPos();
  };
  /**
   * @returns whether this widget in scale mold
   */
  Slider.prototype.inScaleMold = function () {
    return this.getMold() == 'scale';
  };
  /**
   * @returns whether this widget in sphere mold
   */
  Slider.prototype.inSphereMold = function () {
    return this.getMold() == 'sphere';
  };
  /**
   * @returns whether it is a vertical slider.
   */
  Slider.prototype.isVertical = function () {
    return 'vertical' == this._orient;
  };
  /**
   * @returns whether it is a decimal slider.
   * @since 7.0.1
   */
  Slider.prototype.isDecimal = function () {
    return 'decimal' == this._mode;
  };
  Slider.prototype.updateFormData = function (val) {
    if (this._name) {
      val = val || 0;
      if (!this.efield) this.efield = jq.newHidden(this._name, val, this.$n_());else this.efield.value = val;
    }
  };
  Slider.prototype.onShow = function () {
    //B70-ZK-2438
    //retrieve snap again for whom is inside detail component
    if (!this._drag) {
      this._makeDraggable();
    }
  };
  /** @internal */
  Slider.prototype.setFlexSize_ = function (flexSize, isFlexMin) {
    _super.prototype.setFlexSize_.call(this, flexSize, isFlexMin);
    if (this._mold != 'knob') {
      this.onSize();
    }
  };
  /** @internal */
  Slider.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    if (this._mold == 'knob') return;
    this._fixSize();
    //fix B70-ZK-2438
    if (this.isRealVisible()) this._makeDraggable();
    zWatch.listen({
      onSize: this,
      //fix B70-ZK-2438
      onShow: this
    });
    this.updateFormData(this._curpos);
    this._fixPos();
  };
  /** @internal */
  Slider.prototype.unbind_ = function (skipper, after, keepRod) {
    if (this._mold == 'knob') {
      _super.prototype.unbind_.call(this, skipper, after, keepRod);
      return;
    }
    this.efield = undefined;
    if (this._drag) {
      this._drag.destroy();
      this._drag = undefined;
    }
    zWatch.unlisten({
      onSize: this,
      //fix B70-ZK-2438
      onShow: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Slider._digitsAfterDecimal = function (v) {
    var vs = '' + v,
      i = vs.indexOf('.');
    return i < 0 ? 0 : vs.length - i - 1;
  };
  /** @internal */
  Slider._roundDecimal = function (v, p) {
    var mul = Math.pow(10, p);
    return Math.round(v * mul) / mul;
  };
  /** @internal */
  Slider._getBtnNewPos = function (wgt) {
    var btn = wgt.$n_('btn'),
      curpos = wgt._curpos,
      isDecimal = wgt.isDecimal();
    btn.title = isDecimal ? curpos.toFixed(Slider_1._digitsAfterDecimal(Slider_1._getStep(wgt))) : curpos;
    wgt.updateFormData(curpos);
    var isVertical = wgt.isVertical(),
      ofs = zk(wgt.$n()).cmOffset(),
      totalLen = isVertical ? wgt._getHeight() : wgt._getWidth(),
      x = totalLen > 0 ? (curpos - wgt._minpos) * totalLen / (wgt._maxpos - wgt._minpos) : 0;
    if (!isDecimal) x = Math.round(x);
    ofs = zk(btn).toStyleOffset(ofs[0], ofs[1]);
    ofs = isVertical ? [0, ofs[1] + x] : [ofs[0] + x, 0];
    ofs = wgt._snap(ofs[0], ofs[1]);
    return ofs[isVertical ? 1 : 0];
  };
  /** @internal */
  Slider._getNextPos = function (wgt, offset) {
    var $btn = jq(wgt.$n_('btn')),
      fum = wgt.isVertical() ? ['top', 'height'] : ['left', 'width'],
      newPosition = {};
    newPosition[fum[0]] = jq.px0(offset ? offset + zk.parseInt($btn.css(fum[0])) - $btn[fum[1]]() / 2 : Slider_1._getBtnNewPos(wgt));
    return newPosition;
  };
  /** @internal */
  Slider._getStep = function (wgt) {
    var step = wgt._step;
    return !wgt.isDecimal() || step != -1 ? step : 0.1;
  };
  var Slider_1;
  Slider = Slider_1 = __decorate([zk.WrapClass('zul.inp.Slider')], Slider);
  return Slider;
}(zul.Widget);
exports.Slider = Slider;
window.zul.inp.Slider_.Slider = Slider;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/Spinner.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/Spinner.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.Spinner_) window.zul.inp.Spinner_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Spinner = void 0;
/* Spinner.ts

    Purpose:

    Description:

    History:
        Thu May 27 10:17:24     2009, Created by kindalu

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * An edit box for holding a constrained integer.
 *
 * @defaultValue {@link getZclass}: z-spinner.
 */
var Spinner = /** @class */function (_super) {
  __extends(Spinner, _super);
  function Spinner() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._step = 1;
    /** @internal */
    _this._buttonVisible = true;
    _this.onHide = undefined;
    _this.validate = undefined;
    return _this;
  }
  /**
   * @returns the step of spinner
   */
  Spinner.prototype.getStep = function () {
    return this._step;
  };
  /**
   * Set the step of spinner
   */
  Spinner.prototype.setStep = function (step, opts) {
    this._step = step;
    return this;
  };
  /**
   * @returns whether the button (on the right of the textbox) is visible.
   * @defaultValue `true`.
   */
  Spinner.prototype.isButtonVisible = function () {
    return this._buttonVisible;
  };
  /**
   * Sets whether the button (on the right of the textbox) is visible.
   */
  Spinner.prototype.setButtonVisible = function (buttonVisible, opts) {
    var o = this._buttonVisible;
    this._buttonVisible = buttonVisible;
    if (o !== buttonVisible || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      zul.inp.RoundUtl.buttonVisible(this, buttonVisible);
    }
    return this;
  };
  Spinner.prototype.inRoundedMold = function () {
    return true;
  };
  /**
   * @returns the value in int. If null, zero is returned.
   */
  Spinner.prototype.intValue = function () {
    return _super.prototype.getValue.call(this);
  };
  Spinner.prototype.setConstraint = function (constraint) {
    if (typeof constraint == 'string' && !constraint.startsWith('[') /*by server*/) {
      var spinnerConstraint = new zul.inp.SimpleSpinnerConstraint(constraint);
      this._min = spinnerConstraint._min;
      this._max = spinnerConstraint._max;
      _super.prototype.setConstraint.call(this, spinnerConstraint);
    } else _super.prototype.setConstraint.call(this, constraint);
    return this;
  };
  /** @internal */
  Spinner.prototype.coerceFromString_ = function (value) {
    if (!value) return undefined;
    var info = zk.fmt.Number.unformat(this._format, value, false, this._localizedSymbols),
      val = parseInt(info.raw, 10);
    if (isNaN(val) || info.raw != '' + val && info.raw != '-' + val) return {
      error: zk.fmt.Text.format(msgzul.INTEGER_REQUIRED, value)
    };
    if (val > 2147483647 || val < -2147483648) return {
      error: zk.fmt.Text.format(msgzul.OUT_OF_RANGE + '(−2147483648 - 2147483647)')
    };
    if (info.divscale) val = Math.round(val / Math.pow(10, info.divscale));
    return val;
  };
  /** @internal */
  Spinner.prototype.coerceToString_ = function (value) {
    var fmt = this._format;
    return fmt ? zk.fmt.Number.format(fmt, value, this._rounding, this._localizedSymbols) : value != null ? '' + String(value) : '';
  };
  /** @internal */
  Spinner.prototype.doKeyDown_ = function (evt) {
    var inp = this.getInputNode();
    if (inp.disabled || inp.readOnly) return;
    switch (evt.keyCode) {
      case 38:
        //up
        this.checkValue();
        this._increase(true);
        evt.stop();
        return;
      case 40:
        //down
        this.checkValue();
        this._increase(false);
        evt.stop();
        return;
    }
    _super.prototype.doKeyDown_.call(this, evt);
  };
  /** @internal */
  Spinner.prototype._ondropbtnup = function (evt) {
    this.domUnlisten_(document.body, 'onZMouseup', '_ondropbtnup');
    this._stopAutoIncProc();
    this._currentbtn = undefined;
  };
  /** @internal */
  Spinner.prototype._btnDown = function (evt) {
    if (!this._buttonVisible || this._disabled) return;
    var btn = this.$n_('btn');
    if (!zk.dragging) {
      if (this._currentbtn)
        // just in case
        this._ondropbtnup(evt);
      this.domListen_(document.body, 'onZMouseup', '_ondropbtnup');
      this._currentbtn = btn;
    }
    this.checkValue();
    var ofs = zk(btn).revisedOffset(),
      isOverUpBtn = evt.pageY - ofs[1] < btn.offsetHeight / 2;
    if (isOverUpBtn) {
      //up
      this._increase(true);
      this._startAutoIncProc(true);
    } else {
      // down
      this._increase(false);
      this._startAutoIncProc(false);
    }
    // disable browser's text selection
    evt.stop();
  };
  /**
   * Sets bound value if the value out of range
   */
  Spinner.prototype.checkValue = function () {
    var inp = this.getInputNode(),
      min = this._min,
      max = this._max;
    this._noPreviousValue = inp.value == '';
    if (!inp.value) {
      if (min && max) inp.value = min <= 0 && 0 <= max ? 0 : min;else if (min) inp.value = min <= 0 ? 0 : min;else if (max) inp.value = 0 <= max ? 0 : max;else inp.value = 0;
    }
  };
  /** @internal */
  Spinner.prototype._btnUp = function (evt) {
    if (!this._buttonVisible || this._disabled || zk.dragging) return;
    this._onChanging();
    this._stopAutoIncProc();
    var inp = this.getInputNode();
    inp.focus();
  };
  /** @internal */
  Spinner.prototype._increase = function (is_add) {
    var inp = this.getInputNode(),
      value = this.coerceFromString_(inp.value),
      //ZK-1851 convert input value using pattern
      result;
    if (value && value.error) return; //nothing to do if error happens
    if (this._noPreviousValue && (this._min > 0 || this._max < 0)) {
      result = value;
      this._noPreviousValue = false;
    } else {
      result = is_add ? value + this._step : value - this._step;
    }
    // control overflow
    if (result > Math.pow(2, 31) - 1) result = Math.pow(2, 31) - 1;else if (result < -Math.pow(2, 31)) result = -Math.pow(2, 31);
    //over bound shall restore value
    if (this._max != null && result > this._max) result = value;else if (this._min != null && result < this._min) result = value;
    inp.value = this.coerceToString_(result); //ZK-1851 convert result using pattern
    this._onChanging();
  };
  /** @internal */
  Spinner.prototype._clearValue = function () {
    this.getInputNode().value = this._defRawVal = '';
    return true;
  };
  /** @internal */
  Spinner.prototype._startAutoIncProc = function (isup) {
    var widget = this;
    if (this.timerId) clearInterval(this.timerId);
    this.timerId = setInterval(function () {
      widget._increase(isup);
    }, 200);
    jq(this.$n_('btn-' + (isup ? 'up' : 'down'))).addClass(this.$s('active'));
  };
  /** @internal */
  Spinner.prototype._stopAutoIncProc = function () {
    if (this.timerId) clearTimeout(this.timerId);
    this.timerId = undefined;
    jq('.' + this.$s('icon'), this.$n_('btn')).removeClass(this.$s('active'));
  };
  /** @internal */
  Spinner.prototype.doFocus_ = function (evt) {
    _super.prototype.doFocus_.call(this, evt);
    zul.inp.RoundUtl.doFocus_(this);
  };
  /** @internal */
  Spinner.prototype.doBlur_ = function (evt) {
    _super.prototype.doBlur_.call(this, evt);
    zul.inp.RoundUtl.doBlur_(this);
  };
  /** @internal */
  Spinner.prototype.afterKeyDown_ = function (evt, simulated) {
    if (!simulated && this._inplace) jq(this.$n_()).toggleClass(this.getInplaceCSS(), evt.keyCode == 13);
    return _super.prototype.afterKeyDown_.call(this, evt, simulated);
  };
  /** @internal */
  Spinner.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var btn;
    if (btn = this.$n('btn')) this.domListen_(btn, 'onZMouseDown', '_btnDown').domListen_(btn, 'onZMouseUp', '_btnUp');
    zWatch.listen({
      onSize: this
    });
  };
  /** @internal */
  Spinner.prototype.unbind_ = function (skipper, after, keepRod) {
    if (this.timerId) {
      clearTimeout(this.timerId);
      this.timerId = undefined;
    }
    zWatch.unlisten({
      onSize: this
    });
    var btn = this.$n('btn');
    if (btn) this.domUnlisten_(btn, 'onZMouseDown', '_btnDown').domUnlisten_(btn, 'onZMouseUp', '_btnUp');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Spinner.prototype.getBtnUpIconClass_ = function () {
    return 'z-icon-angle-up';
  };
  /** @internal */
  Spinner.prototype.getBtnDownIconClass_ = function () {
    return 'z-icon-angle-down';
  };
  Spinner = __decorate([zk.WrapClass('zul.inp.Spinner')], Spinner);
  return Spinner;
}(zul.inp.NumberInputWidget);
exports.Spinner = Spinner;
window.zul.inp.Spinner_.Spinner = Spinner;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/Textbox.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/Textbox.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.Textbox_) window.zul.inp.Textbox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Textbox = void 0;
/* Textbox.ts

    Purpose:

    Description:

    History:
        Sat Dec 13 23:30:38     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A textbox.
 * @defaultValue {@link getZclass}: z-textbox.
 */
var Textbox = /** @class */function (_super) {
  __extends(Textbox, _super);
  function Textbox() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._value = '';
    /** @internal */
    _this._rows = 1;
    return _this;
  }
  /**
   * @returns whether it is multiline.
   * @defaultValue `false`.
   */
  Textbox.prototype.isMultiline = function () {
    return !!this._multiline;
  };
  /**
   * Sets whether it is multiline.
   */
  Textbox.prototype.setMultiline = function (multiline, opts) {
    var o = this._multiline;
    this._multiline = multiline;
    if (o !== multiline || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns whether TAB is allowed.
   * If true, the user can enter TAB in the textbox, rather than change
   * focus.
   * @defaultValue `false`.
   */
  Textbox.prototype.isTabbable = function () {
    return !!this._tabbable;
  };
  /**
   * Sets whether TAB is allowed.
   * If true, the user can enter TAB in the textbox, rather than change
   * focus.
   * @defaultValue `false`.
   */
  Textbox.prototype.setTabbable = function (tabbable) {
    this._tabbable = tabbable;
    return this;
  };
  /**
   * @returns the rows.
   * @defaultValue `1`.
   */
  Textbox.prototype.getRows = function () {
    return this._rows;
  };
  /**
   * Sets the rows.
   */
  Textbox.prototype.setRows = function (rows, opts) {
    var o = this._rows;
    this._rows = rows;
    if (o !== rows || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      // FIXME: grid?
      var inp = this.getInputNode();
      if (inp && this.isMultiline()) inp.rows = rows;
    }
    return this;
  };
  /**
   * @returns the type.
   * @defaultValue text.
   */
  Textbox.prototype.getType = function () {
    return this._type;
  };
  /**
   * Sets the type.
   * @param type - the type. Acceptable values are "text" and "password".
   * Unlike XUL, "timed" is redudant because it is enabled as long as
   * onChanging is added.
   */
  Textbox.prototype.setType = function (type, opts) {
    var o = this._type;
    this._type = type;
    if (o !== type || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var inp = this.getInputNode();
      if (inp) inp.type = type;
    }
    return this;
  };
  /**
   * @returns whether it is submitByEnter.
   * @defaultValue `false`.
   */
  Textbox.prototype.isSubmitByEnter = function () {
    return !!this._submitByEnter;
  };
  /**
   * Sets whether it is submitByEnter.
   */
  Textbox.prototype.setSubmitByEnter = function (submitByEnter) {
    this._submitByEnter = submitByEnter;
    return this;
  };
  /** @internal */
  Textbox.prototype.textAttrs_ = function () {
    var html = /*safe*/_super.prototype.textAttrs_.call(this);
    if (this._multiline) html += ' rows="' + /*safe*/zk.parseInt(this._rows) + '"';
    return html;
  };
  /** @internal */
  Textbox.prototype.doKeyDown_ = function (evt) {
    if (evt.keyCode == 13 && this._submitByEnter && this._multiline && !evt.shiftKey) {
      evt.stop();
      this.fire('onOK');
    }
    _super.prototype.doKeyDown_.call(this, evt);
  };
  Textbox = __decorate([zk.WrapClass('zul.inp.Textbox')], Textbox);
  return Textbox;
}(zul.inp.InputWidget);
exports.Textbox = Textbox;
window.zul.inp.Textbox_.Textbox = Textbox;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/TimeboxInp.ts":
/*!*************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/TimeboxInp.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports) {



// Everything exported from this file must either be a "declared value" or a "type".
// They must be bundled in `zul/db` not `zul/inp`. The effect of this should be like
// the following commented piece of code except that values are "declared" not
// "defined". Typescript doesn't yet have syntax to "re-export as declaration", so we
// 1. export classes as types,
// 2. export classes as declared values whose types are "types of that in point 1".
// The current solution is very fragile as it repeats the same name 4 times each, which
// must be carefully checked.
/*
export {
    TimeHandler,
    HourInDayHandler,
    HourInDayHandler2,
    HourHandler,
    HourHandler2,
    MinuteHandler,
    SecondHandler,
    AMPMHandler,
} from '../db/Timebox';
*/
if (!window.zul) window.zul = {};
if (!window.zul.inp) window.zul.inp = {};
if (!window.zul.inp.TimeboxInp_) window.zul.inp.TimeboxInp_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/inp/index.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/inp/index.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __exportStar = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__exportStar"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = {};
__exportStar(__webpack_require__(/*! ./InputWidget */ "./zul/src/main/resources/web/js/zul/inp/InputWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./Errorbox */ "./zul/src/main/resources/web/js/zul/inp/Errorbox.ts"), exports);
__exportStar(__webpack_require__(/*! ./SimpleConstraint */ "./zul/src/main/resources/web/js/zul/inp/SimpleConstraint.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./SimpleSpinnerConstraint */ "./zul/src/main/resources/web/js/zul/inp/SimpleSpinnerConstraint.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./SimpleDoubleSpinnerConstraint */ "./zul/src/main/resources/web/js/zul/inp/SimpleDoubleSpinnerConstraint.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./SimpleDateConstraint */ "./zul/src/main/resources/web/js/zul/inp/SimpleDateConstraint.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./SimpleLocalTimeConstraint */ "./zul/src/main/resources/web/js/zul/inp/SimpleLocalTimeConstraint.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./Textbox */ "./zul/src/main/resources/web/js/zul/inp/Textbox.ts"), exports);
__exportStar(__webpack_require__(/*! ./FormatWidget */ "./zul/src/main/resources/web/js/zul/inp/FormatWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./NumberInputWidget */ "./zul/src/main/resources/web/js/zul/inp/NumberInputWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./Intbox */ "./zul/src/main/resources/web/js/zul/inp/Intbox.ts"), exports);
__exportStar(__webpack_require__(/*! ./Longbox */ "./zul/src/main/resources/web/js/zul/inp/Longbox.ts"), exports);
__exportStar(__webpack_require__(/*! ./Doublebox */ "./zul/src/main/resources/web/js/zul/inp/Doublebox.ts"), exports);
__exportStar(__webpack_require__(/*! ./Decimalbox */ "./zul/src/main/resources/web/js/zul/inp/Decimalbox.ts"), exports);
__exportStar(__webpack_require__(/*! ./ComboWidget */ "./zul/src/main/resources/web/js/zul/inp/ComboWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./Combobox */ "./zul/src/main/resources/web/js/zul/inp/Combobox.ts"), exports);
__exportStar(__webpack_require__(/*! ./Comboitem */ "./zul/src/main/resources/web/js/zul/inp/Comboitem.ts"), exports);
__exportStar(__webpack_require__(/*! ./Bandbox */ "./zul/src/main/resources/web/js/zul/inp/Bandbox.ts"), exports);
__exportStar(__webpack_require__(/*! ./Bandpopup */ "./zul/src/main/resources/web/js/zul/inp/Bandpopup.ts"), exports);
__exportStar(__webpack_require__(/*! ./Slider */ "./zul/src/main/resources/web/js/zul/inp/Slider.ts"), exports);
__exportStar(__webpack_require__(/*! ./Spinner */ "./zul/src/main/resources/web/js/zul/inp/Spinner.ts"), exports);
__exportStar(__webpack_require__(/*! ./Doublespinner */ "./zul/src/main/resources/web/js/zul/inp/Doublespinner.ts"), exports);
// Re-export classes in `zul/db/Timebox` under the name `zul.inp`.
__exportStar(__webpack_require__(/*! ./TimeboxInp */ "./zul/src/main/resources/web/js/zul/inp/TimeboxInp.ts"), exports);

/***/ }),

/***/ "./node_modules/tslib/tslib.es6.js":
/*!*****************************************!*\
  !*** ./node_modules/tslib/tslib.es6.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __addDisposableResource: function() { return /* binding */ __addDisposableResource; },
/* harmony export */   __assign: function() { return /* binding */ __assign; },
/* harmony export */   __asyncDelegator: function() { return /* binding */ __asyncDelegator; },
/* harmony export */   __asyncGenerator: function() { return /* binding */ __asyncGenerator; },
/* harmony export */   __asyncValues: function() { return /* binding */ __asyncValues; },
/* harmony export */   __await: function() { return /* binding */ __await; },
/* harmony export */   __awaiter: function() { return /* binding */ __awaiter; },
/* harmony export */   __classPrivateFieldGet: function() { return /* binding */ __classPrivateFieldGet; },
/* harmony export */   __classPrivateFieldIn: function() { return /* binding */ __classPrivateFieldIn; },
/* harmony export */   __classPrivateFieldSet: function() { return /* binding */ __classPrivateFieldSet; },
/* harmony export */   __createBinding: function() { return /* binding */ __createBinding; },
/* harmony export */   __decorate: function() { return /* binding */ __decorate; },
/* harmony export */   __disposeResources: function() { return /* binding */ __disposeResources; },
/* harmony export */   __esDecorate: function() { return /* binding */ __esDecorate; },
/* harmony export */   __exportStar: function() { return /* binding */ __exportStar; },
/* harmony export */   __extends: function() { return /* binding */ __extends; },
/* harmony export */   __generator: function() { return /* binding */ __generator; },
/* harmony export */   __importDefault: function() { return /* binding */ __importDefault; },
/* harmony export */   __importStar: function() { return /* binding */ __importStar; },
/* harmony export */   __makeTemplateObject: function() { return /* binding */ __makeTemplateObject; },
/* harmony export */   __metadata: function() { return /* binding */ __metadata; },
/* harmony export */   __param: function() { return /* binding */ __param; },
/* harmony export */   __propKey: function() { return /* binding */ __propKey; },
/* harmony export */   __read: function() { return /* binding */ __read; },
/* harmony export */   __rest: function() { return /* binding */ __rest; },
/* harmony export */   __runInitializers: function() { return /* binding */ __runInitializers; },
/* harmony export */   __setFunctionName: function() { return /* binding */ __setFunctionName; },
/* harmony export */   __spread: function() { return /* binding */ __spread; },
/* harmony export */   __spreadArray: function() { return /* binding */ __spreadArray; },
/* harmony export */   __spreadArrays: function() { return /* binding */ __spreadArrays; },
/* harmony export */   __values: function() { return /* binding */ __values; }
/* harmony export */ });
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

/* harmony default export */ __webpack_exports__["default"] = ({
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
});


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./zul/src/main/resources/web/js/zul/inp/index.ts");
/******/ 	var __webpack_export_target__ = window;
/******/ 	var __webpack_exports_export__ = __webpack_exports__["default"];
/******/ 	for(var i in __webpack_exports_export__) __webpack_export_target__[i] = __webpack_exports_export__[i];
/******/ 	if(__webpack_exports_export__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;