/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./extends.js":
/*!********************!*\
  !*** ./extends.js ***!
  \********************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
/* extends.js

    Purpose:

    Description:

    History:
        1:02 PM 2023/8/21, Created by jumperchen

Copyright (C) 2023 Potix Corporation. All Rights Reserved.
*/
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return extendStatics(d, b);
};
// refer tslib#__extends
function default_1(d, b) {
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  d.prototype._$super = d.name == '$subclass$' && b.prototype._$super ? b.prototype._$super : b.prototype; // Potix: Jumper Chen adds to support `$supers(foo.Bar, 'bind_')`
}
exports["default"] = default_1;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/mesh/Auxhead.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/mesh/Auxhead.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.mesh) window.zul.mesh = {};
if (!window.zul.mesh.Auxhead_) window.zul.mesh.Auxhead_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Auxhead = void 0;
/* Auxhead.ts

    Purpose:

    Description:

    History:
        Mon May  4 15:57:46     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * Used to define a collection of auxiliary headers ({@link Auxheader}).
 *
 * <p>Non XUL element.
 * @defaultValue {@link getZclass}: z-auxhead.
 */
var Auxhead = /** @class */function (_super) {
  __extends(Auxhead, _super);
  function Auxhead() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /** @internal */
  Auxhead.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    // B50-3306729: the first header should have border-left when the first column is covered with other header
    this.fixBorder_();
  };
  // B50-3306729: the first header should have border-left when the first column is covered with other header
  /** @internal */
  Auxhead.prototype.fixBorder_ = function () {
    var fc = jq(this).children(':first-child'),
      rspan = fc.attr('rowspan'),
      times = parseInt(rspan) - 1;
    if (rspan && times > 0) {
      for (var head = this.nextSibling; head && times != 0; head = head.nextSibling, times--) jq(head.firstChild).addClass(this.$s('border'));
    }
  };
  Auxhead = __decorate([zk.WrapClass('zul.mesh.Auxhead')], Auxhead);
  return Auxhead;
}(zul.mesh.HeadWidget);
exports.Auxhead = Auxhead;
window.zul.mesh.Auxhead_.Auxhead = Auxhead;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/mesh/Auxheader.ts":
/*!*************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/mesh/Auxheader.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.mesh) window.zul.mesh = {};
if (!window.zul.mesh.Auxheader_) window.zul.mesh.Auxheader_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Auxheader = void 0;
/* Auxheader.ts

    Purpose:

    Description:

    History:
        Mon May  4 17:00:30     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * An auxiliary header.
 * @defaultValue {@link getZclass}: z-auxheader.
 */
var Auxheader = /** @class */function (_super) {
  __extends(Auxheader, _super);
  function Auxheader() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._colspan = 1;
    /** @internal */
    _this._rowspan = 1;
    return _this;
  }
  /**
   * @returns number of columns to span this header.
   * @defaultValue `1`.
   */
  Auxheader.prototype.getColspan = function () {
    return this._colspan;
  };
  /**
   * Sets the number of columns to span this header.
   * <p>It is the same as the colspan attribute of HTML TD tag.
   */
  Auxheader.prototype.setColspan = function (colspan, opts) {
    var o = this._colspan;
    this._colspan = colspan;
    if (o !== colspan || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) {
        n.colSpan = colspan;
      }
    }
    return this;
  };
  /**
   * @returns number of rows to span this header.
   * @defaultValue `1`.
   */
  Auxheader.prototype.getRowspan = function () {
    return this._rowspan;
  };
  /**
   * Sets the number of rows to span this header.
   * <p>It is the same as the rowspan attribute of HTML TD tag.
   */
  Auxheader.prototype.setRowspan = function (rowspan, opts) {
    var o = this._rowspan;
    this._rowspan = rowspan;
    if (o !== rowspan || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) {
        n.rowSpan = rowspan;
      }
    }
    return this;
  };
  /** @internal */
  Auxheader.prototype.domAttrs_ = function (no) {
    var /*safe*/s = _super.prototype.domAttrs_.call(this, no);
    if (this._colspan != 1) s += " colspan=\"".concat(zUtl.encodeXMLAttribute(this._colspan), "\"");
    if (this._rowspan != 1) s += " rowspan=\"".concat(zUtl.encodeXMLAttribute(this._rowspan), "\"");
    return s;
  };
  Auxheader = __decorate([zk.WrapClass('zul.mesh.Auxheader')], Auxheader);
  return Auxheader;
}(zul.mesh.HeaderWidget);
exports.Auxheader = Auxheader;
window.zul.mesh.Auxheader_.Auxheader = Auxheader;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/mesh/ColumnMenuWidget.ts":
/*!********************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/mesh/ColumnMenuWidget.ts ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.mesh) window.zul.mesh = {};
if (!window.zul.mesh.ColumnMenuWidget_) window.zul.mesh.ColumnMenuWidget_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ColumnMenupopup = exports.ColumnMenuWidget = void 0;
/* ColumnMenuWidget.ts

    Purpose:

    Description:

    History:
        Thu, Jun 14, 2012 11:12:58 AM, Created by jumperchen

Copyright (C) 2012 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A skeletal implementation for a column menu widget.
 * @since 6.5.0
 */
var ColumnMenuWidget = /** @class */function (_super) {
  __extends(ColumnMenuWidget, _super);
  function ColumnMenuWidget() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._menupopup = 'none';
    /** @internal */
    _this._columnshide = true;
    /** @internal */
    _this._columnsgroup = true;
    return _this;
  }
  /**
   * @returns whether to enable hiding of the widget with the header context menu.
   * @defaultValue `true`.
   */
  ColumnMenuWidget.prototype.isColumnshide = function () {
    return this._columnshide;
  };
  /**
   * Sets whether to enable hiding of the widget with the header context menu.
   * <p>Note that it is only applied when {@link getMenupopup} is auto.
   */
  ColumnMenuWidget.prototype.setColumnshide = function (columnshide, opts) {
    var o = this._columnshide;
    this._columnshide = columnshide;
    if (o !== columnshide || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this._initColMenu();
    }
    return this;
  };
  /**
   * @returns whether to enable grouping of the widget with the header context menu.
   * @defaultValue `true`.
   */
  ColumnMenuWidget.prototype.isColumnsgroup = function () {
    return this._columnsgroup;
  };
  /**
   * Sets whether to enable grouping of the widget with the header context menu.
   * <p>Note that it is only applied when {@link getMenupopup} is auto.
   */
  ColumnMenuWidget.prototype.setColumnsgroup = function (columnsgroup, opts) {
    var o = this._columnsgroup;
    this._columnsgroup = columnsgroup;
    if (o !== columnsgroup || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this._initColMenu();
    }
    return this;
  };
  /**
   * @returns the ID of the Menupopup ({@link zul.menu.Menupopup}) that should appear
   * when the user clicks on the element.
   * @defaultValue none (a default menupoppup).
   */
  ColumnMenuWidget.prototype.getMenupopup = function () {
    return this._menupopup;
  };
  /**
   * Sets the ID of the menupopup ({@link zul.menu.Menupopup}) that should appear
   * when the user clicks on the element of each column.
   *
   * <p>An onOpen event is sent to the popup menu if it is going to
   * appear. Therefore, developers can manipulate it dynamically
   * (perhaps based on OpenEvent.getReference) by listening to the onOpen
   * event.
   *
   * <p>Note: To simplify the use, it ignores the ID space when locating
   * the component at the client. In other words, it searches for the
   * first component with the specified ID, no matter it is in
   * the same ID space or not.
   *
   * <p>If there are two components with the same ID (of course, in
   * different ID spaces), you can specify the UUID with the following
   * format:<br/>
   * `uuid(comp_uuid)`
   *
   * @param mpop - an ID of the menupopup component, "none", "auto" or "auto-keep".
   * 	"none" is assumed by default, "auto" means the menupopup component is
   *  created automatically, "auto-keep" means the menupopup component is
   *  created automatically and keep the menupopup open after setting column visibility.
   * @see {@link setMenupopup}
   */
  ColumnMenuWidget.prototype.setMenupopup = function (menupopup, opts) {
    var o = this._menupopup;
    this._menupopup = menupopup;
    if (o !== menupopup || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this._menupopup != 'auto' && this._menupopup != 'auto-keep') this._mpop = undefined;
      this.rerender();
    }
    return this;
  };
  /** @internal */
  ColumnMenuWidget.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onResponse: this
    });
    var w = this;
    if (this._menupopup == 'auto' || this._menupopup == 'auto-keep') {
      after.push(function () {
        w._initColMenu();
      });
    }
  };
  /** @internal */
  ColumnMenuWidget.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onResponse: this
    });
    if (this._mpop) {
      if (this._menupopup != 'auto-keep') this._mpop.parent.removeChild(this._mpop);
      this._shallColMenu = this._mpop = undefined;
    }
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  ColumnMenuWidget.prototype.onResponse = function () {
    if (this._shallColMenu) this.syncColMenu();
  };
  /** @internal */
  ColumnMenuWidget.prototype._syncColMenu = function () {
    this._shallColMenu = true;
  };
  /** @internal */
  ColumnMenuWidget.prototype._initColMenu = function () {
    if (this._mpop) this._mpop.parent.removeChild(this._mpop);
    this._mpop = new zul.mesh.ColumnMenupopup({
      columns: this
    });
    if (this._menupopup == 'auto-keep') this._mpop._keepOpen = true; //ZK-4059: prevent menupopup closed after menuitem doClick
  };
  /**
   * Synchronizes the menu of this widget.
   * This method is called automatically if the widget is created
   * at the server (i.e., {@link inServer} is true).
   * You have to invoke this method only if you create this widget
   * at client and change the content of the column's menu.
   */
  ColumnMenuWidget.prototype.syncColMenu = function () {
    this._shallColMenu = false;
    if (this._mpop)
      //it shall do even if !this.desktop
      this._mpop.syncColMenu();
  };
  /** @internal */
  ColumnMenuWidget.prototype._onColVisi = function (evt) {
    var item = evt.currentTarget,
      pp = item.parent;
    if (this._menupopup != 'auto-keep') pp.close({
      sendOnOpen: true
    });
    var checked = 0;
    for (var w = pp.firstChild; w; w = w.nextSibling) {
      if (w instanceof zul.menu.Menuitem && w.isChecked()) checked++;
    }
    if (checked == 0) item.setChecked(true);
    var col = zk.Widget.$(item._col);
    if (col && col.parent == this) {
      var mesh = this.getMeshWidget();
      if (mesh === null || mesh === void 0 ? void 0 : mesh.isSizedByContent()) mesh.clearCachedSize_(); //Bug ZK-1315: clear cached size before column show/hide
      col.setVisible(item.isChecked());
    }
  };
  /** @internal */
  ColumnMenuWidget.prototype._onGroup = function (evt) {
    var _a;
    (_a = evt.target.parent._ungroup) === null || _a === void 0 ? void 0 : _a.setVisible(true);
    //since 6.5.0 onGroup is not listened anymore, always fire event to server
    this._mref.fire('onGroup', 'ascending' != this._mref.getSortDirection(), {
      toServer: true
    });
  };
  /** @internal */
  ColumnMenuWidget.prototype._onUngroup = function (evt) {
    // Empty on purpose. To be overriden.
  };
  /** @internal */
  ColumnMenuWidget.prototype._onAsc = function (evt) {
    this._mref.fire('onSort', true); // B50-ZK-266, always fire
  };
  /** @internal */
  ColumnMenuWidget.prototype._onDesc = function (evt) {
    this._mref.fire('onSort', false); // B50-ZK-266, always fire
  };
  /** @internal */
  ColumnMenuWidget.prototype._onMenuPopup = function (evt) {
    var mref = this._mref;
    if (mref) jq(mref.$n_()).removeClass(mref.$s('visited')).removeClass(mref.$s('hover'));
    this._mref = evt.data.reference;
  };
  /** @internal */
  ColumnMenuWidget.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    this._syncColMenu();
    var mesh = this.getMeshWidget();
    if (mesh && mesh._syncEmpty) mesh._syncEmpty();
  };
  /** @internal */
  ColumnMenuWidget.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (!this.childReplacing_) this._syncColMenu();
    var mesh = this.getMeshWidget();
    if (mesh && mesh._syncEmpty) mesh._syncEmpty();
  };
  /** @internal */
  ColumnMenuWidget.prototype.getGroupPackage_ = function () {
    return '';
  };
  /** @internal */
  ColumnMenuWidget.prototype.domClass_ = function (no) {
    var cls = '';
    if (this._menupopup != 'none') cls += this.$s('menupopup') + ' ';
    return cls + _super.prototype.domClass_.call(this, no);
  };
  ColumnMenuWidget = __decorate([zk.WrapClass('zul.mesh.ColumnMenuWidget')], ColumnMenuWidget);
  return ColumnMenuWidget;
}(zul.mesh.HeadWidget);
exports.ColumnMenuWidget = ColumnMenuWidget;
/**
 * The Columns' Menu popup
 * @since 6.5.0
 */
var ColumnMenupopup = /** @class */function (_super) {
  __extends(ColumnMenupopup, _super);
  // eslint-disable-next-line @typescript-eslint/no-useless-constructor
  function ColumnMenupopup(opts) {
    return _super.call(this, opts) || this;
  }
  ColumnMenupopup.prototype.getColumns = function () {
    return this._columns;
  };
  ColumnMenupopup.prototype.setColumns = function (columns) {
    this._columns = columns;
    return this;
  };
  /** @internal */
  ColumnMenupopup.prototype.afterCreated_ = function (opts) {
    _super.prototype.afterCreated_.call(this, opts);
    this._init();
  };
  /**
   * @returns the menuitem with ascending label
   */
  ColumnMenupopup.prototype.getAscitem = function () {
    return this._asc;
  };
  /**
   * @returns the menuitem with descending label
   */
  ColumnMenupopup.prototype.getDescitem = function () {
    return this._desc;
  };
  /**
   * @returns the menuitem with group label
   */
  ColumnMenupopup.prototype.getGroupitem = function () {
    return this._group;
  };
  ColumnMenupopup.prototype.getUngroupitem = function () {
    return undefined;
  };
  /** @internal */
  ColumnMenupopup.prototype._init = function () {
    var w = this._columns;
    this.listen({
      onOpen: [w, w._onMenuPopup]
    });
    if (zk.feature.pe && w.isColumnsgroup()) {
      if (!zk.isLoaded(w.getGroupPackage_())) zk.load(w.getGroupPackage_());
      var group = new zul.menu.Menuitem({
        label: msgzul.GRID_GROUP,
        visible: false
      });
      group.setSclass(w.$s('menugrouping'));
      group.listen({
        onClick: [w, w._onGroup]
      });
      this.appendChild(group);
      this._group = group;
      if (zk.feature.ee) {
        var ungroup = new zul.menu.Menuitem({
          label: msgzul.GRID_UNGROUP,
          visible: false
        });
        ungroup.setSclass(w.$s('menuungrouping'));
        ungroup.listen({
          onClick: [w, w._onUngroup]
        });
        this.appendChild(ungroup);
        this._ungroup = ungroup;
      }
    }
    var asc = new zul.menu.Menuitem({
      label: msgzul.GRID_ASC
    });
    asc.setSclass(w.$s('menuascending'));
    asc.listen({
      onClick: [w, w._onAsc]
    });
    this._asc = asc;
    this.appendChild(asc);
    var desc = new zul.menu.Menuitem({
      label: msgzul.GRID_DESC
    });
    desc.setSclass(w.$s('menudescending'));
    desc.listen({
      onClick: [w, w._onDesc]
    });
    this._desc = desc;
    this.appendChild(desc);
    this.syncColMenu();
    w.getPage().appendChild(this);
  };
  /**
   * Synchronizes the menu
   */
  ColumnMenupopup.prototype.syncColMenu = function () {
    var w = this._columns;
    for (var c = this.lastChild, p; c != this._desc;) {
      p = c.previousSibling;
      this.removeChild(c);
      c = p;
    }
    if (w === null || w === void 0 ? void 0 : w.isColumnshide()) {
      var sep = new zul.menu.Menuseparator();
      this.appendChild(sep);
      for (var c_1 = w.firstChild; c_1; c_1 = c_1.nextSibling) {
        var item = new zul.menu.Menuitem({
          label: c_1.getLabel(),
          autocheck: true,
          checkmark: true,
          checked: c_1.isVisible()
        });
        item._col = c_1.uuid;
        item.listen({
          onClick: [w, w._onColVisi]
        });
        this.appendChild(item);
      }
    }
  };
  ColumnMenupopup = __decorate([zk.WrapClass('zul.mesh.ColumnMenupopup')], ColumnMenupopup);
  return ColumnMenupopup;
}(zul.menu.Menupopup);
exports.ColumnMenupopup = ColumnMenupopup;
window.zul.mesh.ColumnMenuWidget_.ColumnMenuWidget = ColumnMenuWidget;
window.zul.mesh.ColumnMenuWidget_.ColumnMenupopup = ColumnMenupopup;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/mesh/FooterWidget.ts":
/*!****************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/mesh/FooterWidget.ts ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.mesh) window.zul.mesh = {};
if (!window.zul.mesh.FooterWidget_) window.zul.mesh.FooterWidget_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FooterWidget = void 0;
/* FooterWidget.ts

    Purpose:

    Description:

    History:
        Tue Jul 27 09:24:17 TST 2010, Created by jimmy

Copyright (C) 2010 Potix Corporation. All Rights Reserved.

This program is distributed under GPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A skeletal implementation for a footer.
 */
var FooterWidget = /** @class */function (_super) {
  __extends(FooterWidget, _super);
  function FooterWidget() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._span = 1;
    return _this;
  }
  /**
   * @returns number of columns to span this footer.
   * @defaultValue `1`.
   */
  FooterWidget.prototype.getSpan = function () {
    return this._span;
  };
  /**
   * Sets the number of columns to span this footer.
   * <p>It is the same as the colspan attribute of HTML TD tag.
   */
  FooterWidget.prototype.setSpan = function (span, opts) {
    var o = this._span;
    this._span = span;
    if (o !== span || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.colSpan = span;
    }
    return this;
  };
  /**
   * @returns the horizontal alignment of this footer.
   * @defaultValue `null` (system default: left unless CSS specified).
   */
  FooterWidget.prototype.getAlign = function () {
    return this._align;
  };
  /**
   * Sets the horizontal alignment of this footer.
   */
  FooterWidget.prototype.setAlign = function (align, opts) {
    var o = this._align;
    this._align = align;
    if (o !== align || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.align = align;
    }
    return this;
  };
  /**
   * @returns the vertical alignment of this footer.
   * @defaultValue `null` (system default: top).
   */
  FooterWidget.prototype.getValign = function () {
    return this._valign;
  };
  /**
   * Sets the vertical alignment of this footer.
   */
  FooterWidget.prototype.setValign = function (valign, opts) {
    var o = this._valign;
    this._valign = valign;
    if (o !== valign || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.vAlign = valign;
    }
    return this;
  };
  /**
   * @returns the mesh widget that this belongs to.
   */
  FooterWidget.prototype.getMeshWidget = function () {
    return this.parent ? this.parent.parent : undefined;
  };
  /**
   * @returns the column that is in the same column as
   * this footer, or null if not available.
   */
  FooterWidget.prototype.getHeaderWidget = function () {
    var meshWidget = this.getMeshWidget();
    if (meshWidget) {
      var cs = meshWidget.getHeadWidget();
      if (cs) return cs.getChildAt(this.getChildIndex());
    }
    return undefined;
  };
  //super
  /** @internal */
  FooterWidget.prototype.domStyle_ = function (no) {
    var style = '',
      header = this.getHeaderWidget();
    if (this._align) style += 'text-align:' + this._align + ';';else if (header && header._align) style += 'text-align:' + header._align + ';';
    if (this._valign) style += 'vertical-align:' + this._align + ';';else if (header && header._valign) style += 'vertical-align:' + header._valign + ';';
    return _super.prototype.domStyle_.call(this, no) + style;
  };
  /** @internal */
  FooterWidget.prototype.domAttrs_ = function (no) {
    return _super.prototype.domAttrs_.call(this, no) + (this._span > 1 ? ' colspan="' + this._span + '"' : '');
  };
  /** @internal */
  FooterWidget.prototype.deferRedrawHTML_ = function (out) {
    out.push('<td', this.domAttrs_({
      domClass: true
    }), ' class="z-renderdefer"></td>');
  };
  FooterWidget = __decorate([zk.WrapClass('zul.mesh.FooterWidget')], FooterWidget);
  return FooterWidget;
}(zul.LabelImageWidget);
exports.FooterWidget = FooterWidget;
window.zul.mesh.FooterWidget_.FooterWidget = FooterWidget;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/mesh/Frozen.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/mesh/Frozen.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.mesh) window.zul.mesh = {};
if (!window.zul.mesh.Frozen_) window.zul.mesh.Frozen_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Frozen = void 0;
/* Frozen.ts

    Purpose:

    Description:

    History:
        Wed Sep  2 10:07:04     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
// Bug 3218078
window.zul.mesh.Frozen_._onSizeLater = function (wgt) {
  var parent = wgt.parent;
  // ZK-2130: should skip fake scroll bar
  if (parent.eheadtbl && parent._nativebar) {
    var cells = parent._getFirstRowCells(parent.eheadrows),
      head = parent.head,
      totalcols = cells.length - jq(head).find(head.$n_('bar')).length,
      columns = wgt._columns,
      leftWidth = 0;
    //B70-ZK-2553: one may specify frozen without any real column
    if (totalcols <= 0) {
      //no need to do the following computation since there is no any column
      return;
    }
    //ZK-2776: don't take hidden column, like setVisible(false), into account
    for (var header = parent.head.firstChild; header; header = header.nextSibling) {
      if (!header.isVisible()) totalcols -= 1;
    }
    for (var i = 0; i < columns; i++) leftWidth += cells[i].offsetWidth;
    parent._deleteFakeRow(parent.eheadrows);
    wgt.$n_('cave').style.width = jq.px0(leftWidth);
    var scroll = wgt.$n_('scrollX'),
      width = parent.$n_('body').offsetWidth;
    // B70-ZK-2074: Resize forzen's width as meshwidget's body.
    parent.$n_('frozen').style.width = jq.px0(width);
    width -= leftWidth;
    scroll.style.width = jq.px0(width);
    var scrollScale = totalcols - columns - 1;
    scroll.firstChild.style.width = jq.px0(width + 50 * scrollScale);
    wgt.syncScroll();
  }
};
/**
 * A frozen component to represent a frozen column or row in grid, like MS Excel.
 * @defaultValue {@link getZclass}: z-frozen.
 */
var Frozen = /** @class */function (_super) {
  __extends(Frozen, _super);
  function Frozen() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._start = 0;
    /** @internal */
    _this._scrollScale = 0;
    return _this;
  }
  /**
   * @returns the number of columns to freeze.
   * @defaultValue `0`
   */
  Frozen.prototype.getColumns = function () {
    return this._columns;
  };
  /**
   * Sets the number of columns to freeze.(from left to right)
   * @param columns - positive only
   */
  Frozen.prototype.setColumns = function (columns, opts) {
    var o = this._columns;
    columns = Math.max(0, columns);
    this._columns = columns;
    if (o !== columns || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this._columns) {
        if (this.desktop) {
          this.onSize();
          this.syncScroll();
        }
      } else this.rerender();
    }
    return this;
  };
  /**
   * @returns the start position of the scrollbar.
   * @defaultValue `0`
   */
  Frozen.prototype.getStart = function () {
    return this._start;
  };
  /**
   * Sets the start position of the scrollbar.
   * @defaultValue `0`
   * @param start - the column number
   */
  Frozen.prototype.setStart = function (start, opts) {
    var o = this._start;
    this._start = start;
    if (o !== start || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.syncScroll();
    }
    return this;
  };
  /**
   * Synchronizes the scrollbar according to {@link getStart}.
   */
  Frozen.prototype.syncScroll = function () {
    var _a;
    if ((_a = this.parent) === null || _a === void 0 ? void 0 : _a._nativebar) {
      var scroll = this.$n('scrollX');
      if (scroll) scroll.scrollLeft = this._start * 50;
    }
  };
  /**
   * Synchronizes the scrollbar according to parent ebody scrollleft.
   */
  Frozen.prototype.syncScrollByParentBody = function () {
    var p = this.parent,
      ebody,
      l;
    if ((p === null || p === void 0 ? void 0 : p._nativebar) && (ebody = p.ebody) && (l = ebody.scrollLeft) > 0) {
      var scroll = this.$n('scrollX');
      if (scroll) {
        var scrollScale = l / (ebody.scrollWidth - ebody.clientWidth);
        scroll.scrollLeft = Math.ceil(scrollScale * (scroll.scrollWidth - scroll.clientWidth));
      }
    }
  };
  /** @internal */
  Frozen.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var p = this.parent,
      body = p.$n('body'),
      foot = p.$n('foot');
    if (p._nativebar) {
      //B70-ZK-2130: No need to reset when beforeSize, ZK-343 with native bar works fine too.
      zWatch.listen({
        onSize: this
      });
      var scroll = this.$n_('scrollX'),
        scrollbarWidth = jq.scrollbarWidth();
      // ZK-2583: native IE bug, add 1px in scroll div's height for workaround
      this.$n_().style.height = this.$n_('cave').style.height = this.$n_('right').style.height = scroll.style.height = scroll.firstChild.style.height = jq.px0(scrollbarWidth);
      p._currentLeft = 0;
      this.domListen_(scroll, 'onScroll');
      var head = p.$n('head');
      if (head) this.domListen_(head, 'onScroll', '_doHeadScroll');
    } else {
      // Bug ZK-2264
      this._shallSyncScale = true;
    }
    // refix-ZK-3100455 : grid/listbox with frozen trigger "invalidate" should _syncFrozenNow
    zWatch.listen({
      onResponse: this
    });
    if (body) jq(body).addClass('z-word-nowrap');
    if (foot) jq(foot).addClass('z-word-nowrap');
  };
  /** @internal */
  Frozen.prototype.unbind_ = function (skipper, after, keepRod) {
    var p = this.parent,
      body = p.$n('body'),
      foot = p.$n('foot'),
      head = p.$n('head');
    if (p._nativebar) {
      this.domUnlisten_(this.$n_('scrollX'), 'onScroll');
      p.unlisten({
        onScroll: this.proxy(this._onScroll)
      });
      zWatch.unlisten({
        onSize: this
      });
      if (head) this.domUnlisten_(head, 'onScroll', '_doHeadScroll');
    } else {
      this._shallSyncScale = false;
    }
    // refix-ZK-3100455 : grid/listbox with frozen trigger "invalidate" should _syncFrozenNow
    zWatch.unlisten({
      onResponse: this
    });
    if (body) jq(body).removeClass('z-word-nowrap');
    if (foot) jq(foot).removeClass('z-word-nowrap');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  // Bug ZK-2264, we should resync the variable of _scrollScale, which do the same as HeadWidget.js
  Frozen.prototype.onResponse = function () {
    if (this.parent._nativebar) {
      // refix-ZK-3100455 : grid/listbox with frozen trigger "invalidate" should _syncFrozenNow
      this._syncFrozenNow();
    } else if (this._shallSyncScale) {
      var hdfaker = this.parent.ehdfaker;
      if (hdfaker) {
        this._scrollScale = hdfaker.childNodes.length - this._columns - 1;
      }
      this._shallSyncScale = false;
    }
  };
  Frozen.prototype.onSize = function () {
    var _this = this;
    if (!this._columns) return;
    this._syncFrozen(); // B65-ZK-1470
    //B70-ZK-2129: prevent height changed by scrolling
    var p = this.parent,
      phead = p.head,
      firstHdcell;
    if (p._nativebar && phead) {
      //B70-ZK-2558: frozen will onSize before other columns,
      //so there might be no any column in the beginning
      var n = phead.$n();
      firstHdcell = n ? n.cells ? n.cells[0] : undefined : undefined;
      //B70-ZK-2463: if firstHdcell is not undefined
      if (firstHdcell) {
        var fhcs = firstHdcell.style;
        if (!fhcs.height || n.cells[1]) {
          fhcs.height = jq.px0(Math.max(firstHdcell.offsetHeight, n.cells[1] ? n.cells[1].offsetHeight : 0));
        }
      }
    }
    // Bug 3218078, to do the sizing after the 'setAttr' command
    setTimeout(function () {
      window.zul.mesh.Frozen_._onSizeLater(_this);
      _this._syncFrozenNow();
    });
  };
  /** @internal */
  Frozen.prototype._syncFrozen = function () {
    this._shallSync = true;
  };
  /** @internal */
  Frozen.prototype._syncFrozenNow = function () {
    var num = this._start;
    if (this._shallSync && num) this._doScrollNow(num, true);
    this._shallSync = false;
  };
  /** @internal */
  Frozen.prototype.beforeParentChanged_ = function (p) {
    //bug B50-ZK-238
    //ZK-2651: JS Error showed when clear grid children component that include frozen
    if (this.desktop && this._lastScale)
      //if large then 0
      this._doScroll(0);
    _super.prototype.beforeParentChanged_.call(this, p);
  };
  /** @internal */
  Frozen.prototype._onScroll = function (evt) {
    var _this = this;
    if (!evt.data || !zk.currentFocus) return;
    var p = this.parent,
      td,
      fn = function () {
        var cf = zk.currentFocus;
        if (cf) {
          td = p.getFocusCell(cf.$n_());
          var index;
          if (td && (index = td.cellIndex - _this._columns) >= 0) {
            _this.setStart(index);
            p.ebody.scrollLeft = 0;
            if (p.ehead) p.ehead.scrollLeft = 0;
          }
        }
      };
    if (p) {
      fn();
    }
    evt.stop();
  };
  /** @internal */
  Frozen.prototype._doHeadScroll = function (evt) {
    var head = evt.domTarget,
      num = Math.ceil(head.scrollLeft / 50);
    // ignore scrollLeft is 0
    if (!head.scrollLeft || this._lastScale == num) return;
    evt.data = head.scrollLeft;
    this._onScroll(evt);
  };
  /** @internal */
  Frozen.prototype._doScroll = function (n) {
    var _this = this;
    var p = this.parent,
      num;
    if (p._nativebar) num = Math.ceil(this.$n_('scrollX').scrollLeft / 50);else num = Math.ceil(n);
    if (this._lastScale == num) return;
    if (this._delayedScroll) {
      clearTimeout(this._delayedScroll);
    }
    this._delayedScroll = setTimeout(function () {
      _this._lastScale = num;
      _this._doScrollNow(num);
      _this.smartUpdate('start', num);
      _this._start = num;
      _this._delayedScroll = undefined;
    }, 0);
  };
  /** @internal */
  Frozen.prototype._doScrollNow = function (num, force) {
    var totalWidth = 0,
      mesh = this.parent,
      cnt = num,
      c = this._columns,
      width0 = zul.mesh.MeshWidget.WIDTH0,
      hasVScroll = zk(mesh.ebody).hasVScroll(),
      scrollbarWidth = hasVScroll ? jq.scrollbarWidth() : 0;
    if (mesh.head) {
      // set fixed size
      var totalCols = mesh.head.nChildren,
        // B70-ZK-2071: Use mesh.head to get columns.
        hdcells = mesh.head.$n_().cells,
        hdcol = mesh.ehdfaker.firstChild,
        ftrows = mesh.foot ? mesh.efootrows : undefined,
        ftcells = ftrows ? ftrows.rows[0].cells : undefined;
      for (var faker, i = 0; hdcol && i < totalCols; hdcol = hdcol.nextSibling, i++) {
        if (!hdcol.style.width.includes('px')) {
          var sw = hdcol.style.width = jq.px0(hdcells[i].offsetWidth),
            wgt = zk.Widget.$(hdcol);
          if (!(wgt instanceof zul.mesh.HeadWidget)) {
            if (faker = wgt.$n('bdfaker')) faker.style.width = sw;
            if (faker = wgt.$n('ftfaker')) faker.style.width = sw;
          }
        }
      }
      var updateBatch = [],
        isVisible = false;
      // B70-ZK-2071: Use mesh.head to get column.
      for (var i = c, faker; i < totalCols; i++) {
        var n = hdcells[i],
          hdWgt = zk.Widget.$(n),
          shallUpdate = false,
          cellWidth;
        isVisible = hdWgt && hdWgt.isVisible();
        //ZK-2776, once a column is hidden, there is an additional style
        if (!hdWgt.isVisible()) continue; //skip column which is hide
        if (cnt-- <= 0) {
          //show
          var wd = isVisible ? n.offsetWidth // Bug ZK-2690
          : 0;
          // ZK-2071: nativebar behavior should be same as fakebar
          // ZK-4762: cellWidth should update while scroll into view
          if (force || wd < 2) {
            cellWidth = hdWgt._origWd || jq.px(wd);
            // ZK-2772: consider faker's width first for layout consistent
            // if the column is visible.
            if (wd > 1 && (faker = jq('#' + n.id + '-hdfaker')[0]) && faker.style.width) cellWidth = faker.style.width;
            hdWgt._origWd = undefined;
            shallUpdate = true;
          }
        } else if (force ||
        // Bug ZK-2690
        n.offsetWidth != 0) {
          //hide
          faker = jq('#' + n.id + '-hdfaker')[0];
          //ZK-2776: consider faker's width first for layout consistent
          if (faker.style.width && zk.parseInt(faker.style.width) > 1) hdWgt._origWd = faker.style.width;
          cellWidth = width0;
          shallUpdate = true;
        }
        if (force || shallUpdate) {
          updateBatch.push({
            node: n,
            index: i,
            width: cellWidth
          });
        }
      }
      //hide the element without losing focus
      jq(mesh).css({
        position: 'absolute',
        left: -9999
      });
      var update;
      while (update = updateBatch.shift()) {
        var n_1 = update.node,
          cellWidth_1 = update.width,
          i_1 = update.index;
        if (faker = jq('#' + n_1.id + '-hdfaker')[0]) faker.style.width = cellWidth_1;
        if ((faker = jq('#' + n_1.id + '-bdfaker')[0]) && isVisible) faker.style.width = cellWidth_1;
        if (faker = jq('#' + n_1.id + '-ftfaker')[0]) faker.style.width = cellWidth_1;
        // ZK-2071: display causes wrong in colspan case
        hdcells[i_1].style.width = cellWidth_1;
        // foot
        if (ftcells) {
          // ZK-2071: display causes wrong in colspan case
          if (ftcells.length > i_1) ftcells[i_1].style.width = cellWidth_1;
        }
      }
      hdcol = mesh.ehdfaker.firstChild;
      for (var i = 0; hdcol && i < totalCols; hdcol = hdcol.nextSibling, i++) {
        if (hdcol.style.display != 'none') totalWidth += zk.parseInt(hdcol.style.width);
      }
      totalWidth += scrollbarWidth;
      //hide the element without losing focus
      jq(mesh).css({
        position: '',
        left: ''
      });
    }
    // NOTE: Set style width to table to avoid colgroup width not working
    // because of width attribute (width="100%") on table
    var eheadtbl = mesh.eheadtbl,
      ebodytbl = mesh.ebodytbl,
      efoottbl = mesh.efoottbl;
    if (eheadtbl) eheadtbl.style.width = jq.px(totalWidth);
    if (ebodytbl) ebodytbl.style.width = jq.px(totalWidth - scrollbarWidth);
    if (efoottbl) efoottbl.style.width = jq.px(totalWidth);
    mesh._restoreFocus();
  };
  Frozen = __decorate([zk.WrapClass('zul.mesh.Frozen')], Frozen);
  return Frozen;
}(zul.Widget);
exports.Frozen = Frozen;
window.zul.mesh.Frozen_.Frozen = Frozen;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/mesh/HeadWidget.ts":
/*!**************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/mesh/HeadWidget.ts ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.mesh) window.zul.mesh = {};
if (!window.zul.mesh.HeadWidget_) window.zul.mesh.HeadWidget_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.HeadWidget = void 0;
/* HeadWidget.ts

    Purpose:

    Description:

    History:
        Mon Dec 29 17:15:38     2008, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
//Bug 1926480: opera failed to add listheader dynamically (since hdfakerflex introduced)
var _fixOnChildChanged = zk.opera ? function (head) {
  return !!(head.parent && head.parent.rerender()); //later
} : zk.$void;
window.zul.mesh.HeadWidget_._syncFrozen = function (wgt) {
  var mesh = wgt.getMeshWidget(),
    frozen;
  if (mesh && (frozen = mesh.frozen)) {
    var hdfaker;
    if (mesh._nativebar) {
      frozen._syncFrozen();
    } else if (hdfaker = mesh.ehdfaker) {
      //_scrollScale is used in Scrollbar.js
      frozen._scrollScale = hdfaker.childNodes.length - frozen._columns - 1;
      // Bug ZK-2264
      frozen._shallSyncScale = false;
    }
  }
};
var HeadWidget = /** @class */function (_super) {
  __extends(HeadWidget, _super);
  function HeadWidget() {
    var _this = _super.call(this) || this; // FIXME: reconsider constructor params
    _this.listen({
      onColSize: _this
    }, -1000);
    return _this;
  }
  /**
   * @returns whether the width of the child column is sizable.
   */
  HeadWidget.prototype.isSizable = function () {
    return !!this._sizable;
  };
  /**
   * Sets whether the width of the child column is sizable.
   * If true, an user can drag the border between two columns (e.g.,
   * {@link HeaderWidget})
   * to change the widths of adjacent columns.
   * @defaultValue `false`.
   */
  HeadWidget.prototype.setSizable = function (sizable, opts) {
    var o = this._sizable;
    this._sizable = sizable;
    if (o !== sizable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  HeadWidget.prototype.isVisible = function () {
    return this._visible;
  };
  HeadWidget.prototype.setVisible = function (visible, opts) {
    var o = this._visible;
    this._visible = visible;
    if (o !== visible || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
      var mesh = this.getMeshWidget();
      setTimeout(function () {
        // ZK-2217: fix height if mesh.desktop exists
        if (mesh && mesh.desktop) {
          // ZK-2130: should fix ebody height
          // ZK-2217: should contain foot and paging
          var foot = mesh.$n('foot'),
            pgib = mesh.$n('pgib'),
            hgh = zk(mesh).contentHeight() - mesh.$n_('head').offsetHeight - (foot ? foot.offsetHeight : 0) - (pgib ? pgib.offsetHeight : 0) - (mesh._nativebar && mesh.frozen ? mesh.frozen.$n_().offsetHeight : 0);
          mesh.ebody.style.height = jq.px0(hgh);
        }
      }, 0);
    }
    return this;
  };
  /** @internal */
  HeadWidget.prototype.removeChildHTML_ = function (child, ignoreDom) {
    _super.prototype.removeChildHTML_.call(this, child, ignoreDom);
    if (!(this instanceof zul.mesh.Auxhead)) for (var fs = zul.mesh.HeaderWidget._faker, i = fs.length; i--;) jq(child.uuid + '-' + fs[i], zk).remove();
  };
  //bug #3014664
  HeadWidget.prototype.setVflex = function (vflex) {
    return _super.prototype.setVflex.call(this, false);
  };
  //bug #3014664
  HeadWidget.prototype.setHflex = function (hflex) {
    return _super.prototype.setHflex.call(this, false);
  };
  /**
   * @returns the mesh widget that this belongs to.
   * @since 5.0.5
   */
  HeadWidget.prototype.getMeshWidget = function () {
    return this.parent;
  };
  HeadWidget.prototype.onColSize = function (evt) {
    var owner = this.parent,
      widths = evt.widths,
      headWidth = 0;
    if (widths) {
      for (var i = 0; i < widths.length; i++) headWidth += parseInt(widths[i]);
      if (headWidth != 0) headWidth = jq.px0(headWidth);
    }
    owner._innerWidth = headWidth || owner.eheadtbl.width || owner.eheadtbl.style.width;
    owner.fire('onInnerWidth', owner._innerWidth);
    owner.fireOnRender(zk.gecko ? 200 : 60);
    owner.disableAutoSizing_(); // clear span and sizedByContent without rerender
  };
  /** @internal */
  HeadWidget.prototype.bind_ = function (desktop, skipper, after) {
    var _this = this;
    _super.prototype.bind_.call(this, desktop, skipper, after);
    after.push(function () {
      window.zul.mesh.HeadWidget_._syncFrozen(_this);
    });
  };
  /** @internal */
  HeadWidget.prototype.unbind_ = function (skipper, after, keepRod) {
    jq(this.hdfaker).remove();
    jq(this.bdfaker).remove();
    jq(this.ftfaker).remove();
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  HeadWidget.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (this.desktop) {
      var _getWidth = zul.mesh.MeshWidget._getWidth,
        mesh = this.getMeshWidget();
      if (!_fixOnChildChanged(this) && mesh && mesh._fixHeaders()) {
        // refix-ZK-2466 : grid dynamic add childern should 'syncSize' at the end (instead of 'add one and trigger one's onSize')
        mesh._syncSize(true);
      }
      window.zul.mesh.HeadWidget_._syncFrozen(this);
      mesh._minWd = undefined;
      var frozen = mesh.frozen;
      if (frozen) frozen.onSize();
      // B70-ZK-2128: Auxhead doesn't have to add faker.
      if (this instanceof zul.mesh.Auxhead) return;
      // ZK-2098: recovery the header faker if not exists
      var head = this,
        fakers = ['hdfaker', 'bdfaker', 'ftfaker'];
      // B30-1926480: ie8 does not support array.forEach
      // eslint-disable-next-line @typescript-eslint/prefer-for-of
      for (var i = 0; i < fakers.length; i++) {
        var faker = fakers[i],
          $faker = jq(mesh['e' + faker]);
        // ZK-3643: Handle fakerbar/bar even if the faker exists
        if ($faker[0] != null) {
          //B70-ZK-2130: virtual bar doesn't have to add fakerbar
          //fkaker bar need recover if native bar has vscrollbar
          var $bar = jq(mesh).find('.' + head.$s('bar')),
            // head.$n('bar') still exists after remove
            bar = $bar[0],
            $hdfakerbar = jq(head.$n_('hdfaker')).find('[id*=hdfaker-bar]'),
            hdfakerbar = $hdfakerbar[0],
            barstyle = '',
            hdfakerbarstyle = '';
          // ZK-2096, ZK-2124: should refresh this.$n('bar') if children change with databinding
          // B30-1926480: the bar should be removed
          if (faker == 'hdfaker' && bar) {
            var s;
            if (s = bar.style) {
              // ZK-2114: should not store display
              // barstyle = s.display ? 'display:' + s.display + ';' : '';
              barstyle += s.width ? 'width:' + s.width + ';' : '';
            }
            $bar.remove();
            delete this._subnodes.bar;
            if (hdfakerbar && (s = hdfakerbar.style)) {
              hdfakerbarstyle = s.display ? 'display:' + s.display + ';' : '';
              hdfakerbarstyle += s.width ? 'width:' + s.width + ';' : '';
            }
            $hdfakerbar.remove();
            delete this._subnodes['hdfaker-bar'];
          }
          if (!$faker.find(child.$n_(faker)).length) {
            var wd = _getWidth(child, child._hflexWidth ? child._hflexWidth + 'px' : child.getWidth());
            wd = wd ? 'width:' + wd + ';' : '';
            var html = '<col id="' + /*safe*/child.uuid + '-' + /*safe*/faker + '" style="' + /*safe*/wd + '"></col>',
              index = child.getChildIndex();
            // B30-1926480: child can be added after any brother node
            if (index > 0) jq($faker.find('col')[index - 1]).after( /*safe*/html);else $faker.append( /*safe*/html);
          }
          // resync var
          $bar = jq(mesh).find('.' + head.$s('bar'));
          bar = $bar[0];
          $hdfakerbar = jq(head.$n_('hdfaker')).find('[id*=hdfaker-bar]');
          hdfakerbar = $hdfakerbar[0];
          if (faker == 'hdfaker' && !bar) {
            if (!hdfakerbar) jq(head.$n_('hdfaker')).append( /*safe*/'<col id="' + /*safe*/head.uuid + '-hdfaker-bar" style="' + hdfakerbarstyle + '" ></col>');
            jq(head).append( /*safe*/'<th id="' + /*safe*/head.uuid + '-bar" class="' + head.$s('bar') + '" style="' + /*safe*/barstyle + '" ></th>');
          }
        }
      }
    }
  };
  /** @internal */
  HeadWidget.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (this.desktop) {
      if (!_fixOnChildChanged(this) && !this.childReplacing_ && this.parent._fixHeaders()) this.parent.onSize();
      this.parent._minWd = undefined;
      // Fix IE, FF for the issue B30-1926480-1.zul and B30-1926480.zul
      var mesh = this.getMeshWidget();
      mesh.rerender(1);
    }
  };
  /** @internal */
  HeadWidget.prototype.beforeChildrenFlex_ = function (hwgt) {
    if (hwgt && !hwgt._flexFixed) {
      //bug #3033010
      //clear associated hdfaker and bdfaker
      var wgt = this.parent,
        hdfaker = wgt.ehdfaker,
        bdfaker = wgt.ebdfaker,
        hdf = hdfaker ? hdfaker.firstChild : undefined,
        bdf = bdfaker ? bdfaker.firstChild : undefined;
      for (var h = this.firstChild; h; h = h.nextSibling) {
        // B70-ZK-2036: Do not adjust widget's width if it is not visible.
        if (h.isVisible() && h._nhflex > 0) {
          //not min or undefined
          if (hdf) hdf.style.width = '';
          if (bdf) bdf.style.width = '';
        }
        if (hdf) hdf = hdf.nextSibling;
        if (bdf) bdf = bdf.nextSibling;
      }
    }
    return true;
  };
  /** @internal */
  HeadWidget.prototype.afterChildrenFlex_ = function (hwgt) {
    var wgt = this.parent,
      ebody = wgt.ebody,
      ehead = wgt.ehead,
      efoot = wgt.efoot,
      currentLeft = wgt._currentLeft;
    if (wgt) {
      if (wgt._cssflex && wgt.isChildrenFlex()) {
        var minWd = wgt._calcMinWds(),
          wds = minWd.wds,
          isFlex = false,
          emptyHead = true;
        // reset display
        ehead.style.display = '';
        var tblWidth = 0,
          sizedByContent = wgt.isSizedByContent();
        for (var i = 0, wd_1 = -1, hwgt_1 = this.firstChild; hwgt_1; hwgt_1 = hwgt_1.nextSibling, i++) {
          var nhwgt = hwgt_1.$n_();
          if (hwgt_1._hflex == 'min' || !hwgt_1._nhflex && sizedByContent) wd_1 = wds[i];else if (hwgt_1._width) wd_1 = parseInt(hwgt_1._width);else if (hwgt_1._nhflex > 0) isFlex = true;
          if (!hwgt_1.isVisible()) nhwgt.style.display = 'none';
          if (wd_1 >= 0) {
            nhwgt.style.flex = '0 0 ' + jq.px(wd_1);
            if (!isFlex) tblWidth += wd_1;
            wd_1 = -1; //reset
          }
          //check empty head
          if (hwgt_1.getLabel() || hwgt_1.getImage() || hwgt_1.nChildren) emptyHead = false;
        }
        //set table width
        var hdtbl = wgt.eheadtbl,
          bdtbl = wgt.ebodytbl,
          fttbl = wgt.efoottbl,
          tblWidthPx = jq.px0(tblWidth);
        if (hdtbl) {
          hdtbl.style.width = isFlex ? '100%' : tblWidthPx;
          if (bdtbl) bdtbl.style.width = isFlex ? '100%' : tblWidthPx;
          if (fttbl) fttbl.style.width = isFlex ? '100%' : tblWidthPx;
        }
        //set body column/footer column width
        var bdfaker = wgt.ebdfaker,
          ftfaker = wgt.eftfaker,
          bdcol = bdfaker.firstChild,
          // eslint-disable-next-line zk/noNull
          ftcol,
          width0 = zul.mesh.MeshWidget.WIDTH0;
        if (ftfaker) ftcol = ftfaker.firstChild;
        wds = {};
        for (var hwgt_2 = this.firstChild; hwgt_2 && bdcol; hwgt_2 = hwgt_2.nextSibling) {
          wds[hwgt_2.uuid] = hwgt_2.$n_().getBoundingClientRect().width;
          bdcol = bdcol.nextSibling;
        }
        bdcol = bdfaker.firstChild;
        for (var hwgt_3 = this.firstChild; hwgt_3 && bdcol; hwgt_3 = hwgt_3.nextSibling) {
          var wd = wds[hwgt_3.uuid],
            wdpx = jq.px0(wd);
          if (hwgt_3.isVisible() && wdpx !== undefined) {
            bdcol.style.width = wdpx;
            if (ftcol) ftcol.style.width = wdpx;
          } else {
            bdcol.style.width = width0;
            if (ftcol) ftcol.style.width = width0;
          }
          bdcol = bdcol.nextSibling;
          if (ftcol) ftcol = ftcol.nextSibling;
        }
        ehead.style.display = emptyHead ? 'none' : '';
        // css flex doesn't need 'bar' style, because 'colgroup' is disabled.
        var bar = this.$n('bar');
        if (bar && !bar.style.cssText) bar.style.display = 'none';
      } else {
        wgt._adjFlexWd();
        wgt._adjSpanWd(); //if there is span and shall span the column width for extra space
        // ZK-2772 Misaligned Grid columns
        if (wgt.frozen && !wgt._isAllWidths()) {
          wgt._calcSize(); // yes, we need to do it again.
        }
        // ZK-2551: need to restore scroll pos after flexs are fixed
        if (ebody.scrollWidth > ebody.clientWidth && currentLeft != ebody.scrollLeft) {
          ebody.scrollLeft = currentLeft;
          if (ehead) ehead.scrollLeft = currentLeft;
          if (efoot) efoot.scrollLeft = currentLeft;
        }
      }
    }
  };
  /** @internal */
  HeadWidget.prototype.deferRedrawHTML_ = function (out) {
    out.push('<tr', this.domAttrs_({
      domClass: true
    }), ' class="z-renderdefer"></tr>');
  };
  /** @internal */
  HeadWidget.prototype.getFlexDirection_ = function () {
    return 'row';
  };
  /** @internal */
  HeadWidget.prototype.afterClearFlex_ = function () {
    var mesh = this.parent;
    if (mesh._cssflex) mesh.ehdfaker.style.display = '';
  };
  HeadWidget.redraw = function (out) {
    out.push('<tr', this.domAttrs_(), ' style="text-align: left;">');
    for (var w = this.firstChild; w; w = w.nextSibling) w.redraw(out);
    var mesh = this.getMeshWidget();
    if (mesh && mesh._nativebar) out.push('<th id="', this.uuid, '-bar" class="', this.$s('bar'), '" ></th>');
    out.push('</tr>');
  };
  HeadWidget = __decorate([zk.WrapClass('zul.mesh.HeadWidget')], HeadWidget);
  return HeadWidget;
}(zul.Widget);
exports.HeadWidget = HeadWidget;
window.zul.mesh.HeadWidget_._fixOnChildChanged = _fixOnChildChanged;
window.zul.mesh.HeadWidget_.HeadWidget = HeadWidget;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/mesh/HeaderWidget.ts":
/*!****************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/mesh/HeaderWidget.ts ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.mesh) window.zul.mesh = {};
if (!window.zul.mesh.HeaderWidget_) window.zul.mesh.HeaderWidget_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.HeaderWidget = void 0;
/**
 * A skeletal implementation for a header.
 */
var HeaderWidget = /** @class */function (_super) {
  __extends(HeaderWidget, _super);
  function HeaderWidget() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._sumWidth = true; // FIXME: never used
    return _this;
  }
  HeaderWidget_1 = HeaderWidget;
  /**
   * @returns the horizontal alignment of this column.
   * @defaultValue `null` (system default: left unless CSS specified).
   */
  HeaderWidget.prototype.getAlign = function () {
    return this._align;
  };
  /**
   * Sets the horizontal alignment of this column.
   */
  HeaderWidget.prototype.setAlign = function (align, opts) {
    var o = this._align;
    this._align = align;
    if (o !== align || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.adjustDOMAlign_('align', align);
    }
    return this;
  };
  /**
   * @returns the vertical alignment of this grid.
   * @defaultValue `null` (system default: top).
   */
  HeaderWidget.prototype.getValign = function () {
    return this._valign;
  };
  /**
   * Sets the vertical alignment of this grid.
   */
  HeaderWidget.prototype.setValign = function (valign, opts) {
    var o = this._valign;
    this._valign = valign;
    if (o !== valign || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.adjustDOMAlign_('valign', valign);
    }
    return this;
  };
  HeaderWidget.prototype.getHeight = function () {
    return this._height;
  };
  HeaderWidget.prototype.setHeight = function (height, opts) {
    var o = this._height;
    this._height = height;
    if (o !== height || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.updateMesh_();
    }
    return this;
  };
  HeaderWidget.prototype.getWidth = function () {
    // NOTE: Returning 0 is currently the intended behavior. A return value of 0 from getWidth is acceptable
    // in two current use cases.
    // 1. `'width:' + wd + ';'` where `wd` is assigned the return value of `getWidth` (could be indirectly
    //     achieved with nested function calls, e.g., `wd = f()` where `f(){return getWidth();}`).
    // 2. Asserting truthiness of the return value of `getWidth`.
    // FIXME: `0 as never` is a hack.
    // TODO:
    // 1. Find a way to embed return type 0 cleanly. One could try `getWidth(): string | null | undefined | 0`,
    //     but it requires a lot of code change from other places. However, it might turn out that incorporating
    //     the "0 literal type" into the return type union is the most robust solution, albeit cumbersome.
    // 2. Return something else instead of 0. Returning null seems feasible, but `'width:' + wd + ';'` will break.
    return this.isVisible() ? this._width : 0;
  };
  HeaderWidget.prototype.setWidth = function (width) {
    this._width = width;
    this.updateMesh_();
    return this;
  };
  // Bug ZK-2401
  /** @internal */
  HeaderWidget.prototype.doFocus_ = function (evt) {
    _super.prototype.doFocus_.call(this, evt);
    //sync frozen
    var box, node;
    if ((box = this.getMeshWidget()) && box.efrozen && zk.Widget.$(box.efrozen.firstChild) && (node = this.$n())) {
      box._moveToHidingFocusCell(node.cellIndex);
    }
  };
  /**
   * Updates the whole mesh widget.
   * @internal
   */
  HeaderWidget.prototype.updateMesh_ = function (nm, val) {
    if (this.desktop) {
      var mesh = this.getMeshWidget();
      if (mesh) {
        var minWds;
        if (nm == 'visible' && val && this._width == '-1')
          //sizable + visible false -> true
          minWds = mesh._calcMinWds();
        // B70-ZK-2036: Clear min width cache before rerender.
        mesh._minWd = undefined;
        mesh.rerender();
        if (minWds) {
          var parent = this.parent;
          for (var w = parent.firstChild, i = 0; w; w = w.nextSibling, i++) {
            if (w == this) {
              this._width = jq.px0(minWds.wds[i]);
              break;
            }
          }
          zUtl.fireSized(mesh, -1);
        }
      }
    }
  };
  /** @internal */
  HeaderWidget.prototype.adjustDOMAlign_ = function (direction, value) {
    var n = this.$n();
    if (n) {
      if (direction == 'align') {
        n.style.textAlign = value;
      } else if (direction == 'valign') {
        n.style.verticalAlign = value;
      }
    }
  };
  /** @internal */
  HeaderWidget.prototype.setFlexSize_ = function (flexSize, isFlexMin) {
    if (this._cssflex && this.parent.getFlexContainer_() != null && !isFlexMin) return;
    if (flexSize.width !== undefined && flexSize.width != 'auto' && flexSize.width != '' || flexSize.width == 0) {
      //JavaScript deems 0 == ''
      //remember the value in _hflexWidth and use it when rerender(@see #domStyle_)
      //for faker column, so don't use revisedWidth().
      //updated: need to concern inner padding due to wgt.getContentEdgeWidth_()
      //spec in flex.js
      var rvw = this._hflex == 'min' && this.firstChild && this.isRealVisible() ?
      // B50-ZK-394
      zk(this.$n('cave')).revisedWidth(flexSize.width) : flexSize.width;
      this._hflexWidth = rvw;
    } else _super.prototype.setFlexSize_.call(this, flexSize, isFlexMin);
  };
  /** @internal */
  HeaderWidget.prototype.getContentEdgeHeight_ = function () {
    return zk(this).sumStyles('tb', jq.margins);
  };
  /** @internal */
  HeaderWidget.prototype.getContentEdgeWidth_ = function () {
    return zk(this).sumStyles('lr', jq.margins);
  };
  /** @internal */
  HeaderWidget.prototype.domStyle_ = function (no) {
    var style = '';
    if (this._hflexWidth) {
      //handle hflex
      style = "width: ".concat(this._hflexWidth, "px;");
      if (no) no.width = true;else no = {
        width: true
      };
    }
    if (this._align) style += 'text-align:' + this._align + ';';
    if (this._valign) style += 'vertical-align:' + this._valign + ';';
    return style + _super.prototype.domStyle_.call(this, no);
  };
  /**
   * @returns the mesh widget that this belongs to.
   */
  HeaderWidget.prototype.getMeshWidget = function () {
    return this.parent ? this.parent.parent : undefined;
  };
  /**
   * @returns whether the widget is sortable or not.
   * @defaultValue `false`.
   * @internal
   */
  HeaderWidget.prototype.isSortable_ = function () {
    return false;
  };
  HeaderWidget.prototype.setVisible = function (visible) {
    if (this.isVisible() != visible) {
      _super.prototype.setVisible.call(this, visible);
      this.updateMesh_('visible', visible);
      //ZK-3332 update server side component width
      var mesh = this.getMeshWidget();
      if ((mesh === null || mesh === void 0 ? void 0 : mesh.desktop) && !this._hflexWidth && this.getWidth()) this.parent.fire('onColSize', {
        index: zk(this.$n()).cellIndex(),
        column: this,
        width: this.isVisible() ? this._width : '-1'
      }, undefined, 0);
    }
    return this;
  };
  HeaderWidget.prototype.getTextNode = function () {
    return jq(this.$n_()).find('>div:first')[0];
  };
  /** @internal */
  HeaderWidget.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    if (this.parent.isSizable()) this._initsz();
    var mesh = this.getMeshWidget(),
      width0 = zul.mesh.MeshWidget.WIDTH0;
    if (mesh) {
      var $n = jq(this.$n()),
        $faker = jq(this.$n('hdfaker')),
        // `this.$n('hdfaker')` can be null. Musn't use `this.$n_('hdfaker')`.
        w = this.getWidth();
      if (mesh._cssflex && mesh.isChildrenFlex && mesh.isChildrenFlex()) {
        //skip not MeshWidget
        if (!this.isVisible()) {
          $n.css('display', 'none');
        } else {
          $n.css('display', '');
        }
      } else {
        if (!this.isVisible()) {
          $faker.css('display', '');
          $faker.css('visibility', 'collapse');
          $faker.css('width', width0);
          if (mesh._cssflex && this._nhflex > 0) {
            $n.css('display', 'none');
          } else {
            $n.css('display', '');
          }
        } else {
          $faker.css('visibility', '');
          // B70-ZK-2036: Check if header has hflex width first.
          if (!this._hflexWidth && w) {
            $faker.css('width', w);
          }
        }
      }
    }
    this.fixFaker_();
  };
  /** @internal */
  HeaderWidget.prototype.unbind_ = function (skipper, after, keepRod) {
    if (this._dragsz) {
      this._dragsz.destroy();
      this._dragsz = undefined;
    }
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  HeaderWidget.prototype._initsz = function () {
    var n = this.$n();
    if (n && !this._dragsz) {
      this._dragsz = new zk.Draggable(this, undefined, {
        revert: true,
        constraint: 'horizontal',
        ghosting: HeaderWidget_1._ghostsizing,
        endghosting: HeaderWidget_1._endghostsizing,
        snap: HeaderWidget_1._snapsizing,
        ignoredrag: HeaderWidget_1._ignoresizing,
        zIndex: '99999',
        // Bug: B50-3285153
        endeffect: HeaderWidget_1._aftersizing
      });
    }
  };
  /**
   * Fixes the faker (an visible row for adjusting column), if any.
   * @internal
   */
  HeaderWidget.prototype.fixFaker_ = function () {
    var n = this.$n();
    if (!(this.parent instanceof zul.mesh.Auxhead) && n) {
      var index = zk(n).cellIndex(),
        owner = this.getMeshWidget();
      for (var faker, fs = HeaderWidget_1._faker, i = fs.length; i--;) {
        faker = owner['e' + fs[i]]; // internal element
        if (faker && !this.$n(fs[i])) {
          faker[faker.childNodes.length > index ? 'insertBefore' : 'appendChild'](this._createFaker(n, fs[i]), faker.childNodes[index]);
          this._subnodes[fs[i]] = undefined; // clear inner cache
        }
      }
    }
  };
  /** @internal */
  HeaderWidget.prototype._createFaker = function (n, postfix) {
    var _getWidth = zul.mesh.MeshWidget._getWidth,
      wd = _getWidth(this, this._hflexWidth ? "".concat(this._hflexWidth, "px") : this.getWidth()),
      t = document.createElement('col'),
      frozen = this.getMeshWidget().frozen;
    wd = wd ? 'width: ' + wd + ';' : '';
    if (!wd && frozen && !frozen._smooth) wd = this._calcFakerWidth(postfix);
    t.id = n.id + '-' + postfix;
    t.style.cssText = wd;
    return t;
  };
  /** @internal */
  HeaderWidget.prototype._calcFakerWidth = function (postfix) {
    var parent = this.parent,
      child = parent.firstChild,
      totalWidth = 0,
      fakerCount = 1;
    while (child) {
      if (!child.getWidth() && !child.getHflex() && child != this) {
        var fakerWidth = child.$n_(postfix).style.width;
        if (fakerWidth == '') break;
        if (fakerWidth == zul.mesh.MeshWidget.WIDTH0) totalWidth += parseFloat(child._origWd);else totalWidth += parseFloat(fakerWidth);
        fakerCount++;
      }
      child = child.nextSibling;
    }
    if (totalWidth == 0) return '';else {
      var eachWidth = jq.px0(totalWidth / fakerCount);
      this._syncFakerWidth(eachWidth, postfix);
      return 'width: ' + eachWidth;
    }
  };
  /** @internal */
  HeaderWidget.prototype._syncFakerWidth = function (width, postfix) {
    var parent = this.parent,
      child = parent.firstChild;
    while (child) {
      if (!child.getWidth() && !child.getHflex() && child != this) {
        var faker = child.$n_(postfix);
        if (faker.style.width == zul.mesh.MeshWidget.WIDTH0) {
          if (postfix == 'hdfaker') child._origWd = width;
        } else faker.style.width = width;
      }
      child = child.nextSibling;
    }
  };
  /** @internal */
  HeaderWidget.prototype.doClick_ = function (evt, popupOnly) {
    var tg = evt.domTarget,
      wgt = zk.Widget.$(tg),
      n = this.$n(),
      ofs = this._dragsz ? zk(n).revisedOffset() : false;
    if (!zk.dragging && (wgt == this || wgt instanceof zul.wgt.Label) && this.isSortable_() && !jq.nodeName(tg, 'input') && (!this._dragsz || !this._insizer(evt.pageX - ofs[0]))) {
      this.fire('onSort', 'ascending' != this.getSortDirection()); // B50-ZK-266
      evt.stop();
    } else {
      if (jq.nodeName(tg, 'input')) evt.stop({
        propagation: true
      });
      _super.prototype.doClick_.call(this, evt, popupOnly);
    }
  };
  /** @internal */
  HeaderWidget.prototype.doDoubleClick_ = function (evt) {
    if (this._dragsz) {
      var n = this.$n(),
        $n = zk(n),
        ofs = $n.revisedOffset();
      if (this._insizer(evt.pageX - ofs[0])) {
        var mesh = this.getMeshWidget(),
          cIndex = $n.cellIndex();
        mesh.clearCachedSize_();
        mesh._calcMinWds();
        var sz = mesh._minWd.wds[cIndex];
        // NOTE: `{control: this, _zszofs: sz}` has intended behavior but is a poor hack.
        // TODO: Should refactor `{control: this, _zszofs: sz}` to match `zk.Draggable`.
        HeaderWidget_1._aftersizing({
          control: this,
          _zszofs: sz
        }, evt);
      } else _super.prototype.doDoubleClick_.call(this, evt);
    } else _super.prototype.doDoubleClick_.call(this, evt);
  };
  /** @internal */
  HeaderWidget.prototype.doMouseMove_ = function (evt) {
    if (zk.dragging || !this.parent.isSizable()) return;
    var n = this.$n_(),
      ofs = zk(n).revisedOffset(); // Bug #1812154
    if (this._insizer(evt.pageX - ofs[0])) {
      jq(n).addClass(this.$s('sizing'));
    } else {
      jq(n).removeClass(this.$s('sizing'));
    }
  };
  /** @internal */
  HeaderWidget.prototype.doMouseOut_ = function (evt) {
    if (this.parent.isSizable()) {
      var n = this.$n_();
      jq(n).removeClass(this.$s('sizing'));
    }
    _super.prototype.doMouseOut_.call(this, evt);
  };
  /** @internal */
  HeaderWidget.prototype.ignoreDrag_ = function (pt) {
    if (this.parent.isSizable()) {
      var n = this.$n(),
        ofs = zk(n).revisedOffset();
      return this._insizer(pt[0] - ofs[0]);
    }
    return false;
  };
  //@Override to avoid add child offset
  /** @internal */
  HeaderWidget.prototype.ignoreChildNodeOffset_ = function (attr) {
    return true;
  };
  /** @internal */
  HeaderWidget.prototype.listenOnFitSize_ = function () {
    return;
  }; // skip flex
  /** @internal */
  HeaderWidget.prototype.unlistenOnFitSize_ = function () {
    return;
  };
  //@Override to find the minimum width of listheader
  /** @internal */
  HeaderWidget.prototype.beforeMinFlex_ = function (o) {
    if (o == 'w') {
      var wgt = this.getMeshWidget();
      if (wgt) {
        wgt._calcMinWds();
        if (wgt._minWd) {
          var n = this.$n(),
            zkn = zk(n),
            cidx = zkn.cellIndex();
          return zkn.revisedWidth(wgt._minWd.wds[cidx]);
        }
      }
    }
    return undefined;
  };
  /** @internal */
  HeaderWidget.prototype.clearCachedSize_ = function () {
    var _a;
    _super.prototype.clearCachedSize_.call(this);
    (_a = this.getMeshWidget()) === null || _a === void 0 ? void 0 : _a._clearCachedSize();
  };
  //@Override to get width/height of MeshWidget
  /** @internal */
  HeaderWidget.prototype.getParentSize_ = function () {
    //to be overridden
    var mw = this.getMeshWidget(),
      p = mw.$n(),
      zkp = p ? zk(p) : undefined;
    if (zkp) {
      return {
        height: zkp.contentHeight(),
        width: zkp.contentWidth()
      };
    }
    // NOTE: originally `{}`
    return {
      height: 0,
      width: 0
    };
  };
  /** @internal */
  HeaderWidget.prototype.isWatchable_ = function (name, p, cache) {
    //Bug 3164504: Hflex will not recalculate when the colum without label
    //Cause: DIV (parent of HeadWidget) is invisible if all columns have no label
    var wp;
    return !!(this._visible && (wp = this.parent) && wp._visible //check this and HeadWidget
    && (wp = wp.parent) && wp.isWatchable_(name, p, cache)); //then MeshWidget.isWatchable_
  };
  /** @internal */
  HeaderWidget.prototype._insizer = function (x) {
    return x >= this.$n_().offsetWidth - 8;
  };
  /** @internal */
  HeaderWidget.prototype.deferRedrawHTML_ = function (out) {
    out.push('<th', this.domAttrs_({
      domClass: true
    }), ' class="z-renderdefer"></th>');
  };
  /** @internal */
  HeaderWidget.prototype.afterClearFlex_ = function () {
    this.parent.afterClearFlex_();
  };
  /** @internal */
  HeaderWidget.prototype.getContentWidth_ = function () {
    var $cv = zk(this.$n('cave')),
      isTextOnly = !this.nChildren && !this._iconSclass,
      contentWidth = isTextOnly ? $cv.textWidth() : $cv.textSize()[0];
    return Math.ceil(contentWidth + $cv.padBorderWidth() + zk(this.$n()).padBorderWidth());
  };
  //drag
  /** @internal */
  HeaderWidget._ghostsizing = function (dg, ofs, evt) {
    var wgt = dg.control,
      el = wgt.getMeshWidget().eheadtbl,
      of = zk(el).revisedOffset(),
      n = wgt.$n();
    ofs[1] = of[1];
    ofs[0] += zk(n).offsetWidth();
    jq(document.body).append( /*safe*/'<div id="zk_hdghost" style="position:absolute;top:' + jq.px(ofs[1]) + ';left:' + jq.px(ofs[0]) + ';width:3px;height:' + jq.px(zk(el.parentNode.parentNode).offsetHeight()) + ';background:darkgray"></div>');
    return jq('#zk_hdghost')[0];
  };
  /** @internal */
  HeaderWidget._endghostsizing = function (dg, origin) {
    dg._zszofs = zk(dg.node).revisedOffset()[0] - zk(origin).revisedOffset()[0];
  };
  /** @internal */
  HeaderWidget._snapsizing = function (dg, pointer) {
    var n = dg.control.$n(),
      $n = zk(n),
      ofs = $n.viewportOffset(),
      sofs = $n.scrollOffset(),
      min = ofs[0] + sofs[0] + dg._zmin;
    pointer[0] += $n.offsetWidth();
    if (pointer[0] < min) pointer[0] = min;
    return pointer;
  };
  /** @internal */
  HeaderWidget._ignoresizing = function (dg, pointer, evt) {
    var wgt = dg.control,
      n = wgt.$n(),
      $n = zk(n),
      ofs = $n.revisedOffset(); // Bug #1812154
    if (wgt._insizer(pointer[0] - ofs[0])) {
      dg._zmin = 10 + $n.padBorderWidth();
      return false;
    }
    return true;
  };
  /** @internal */
  HeaderWidget._aftersizing = function (dg, evt) {
    var wgt = dg.control,
      mesh = wgt.getMeshWidget(),
      wd = jq.px(dg._zszofs),
      hdfaker = mesh.ehdfaker,
      bdfaker = mesh.ebdfaker,
      ftfaker = mesh.eftfaker,
      cidx = zk(wgt.$n()).cellIndex(),
      hdcols = hdfaker.childNodes,
      bdcols = bdfaker.childNodes,
      ftcols = ftfaker ? ftfaker.childNodes : undefined,
      wds = [],
      shallResyncColumns = [],
      // if cssflex, the fixed size should resync its body col size.
      cssflex = mesh._cssflex && mesh.isChildrenFlex();
    //1. store resized width
    // B70-ZK-2199: convert percent width to fixed width
    for (var w = mesh.head.firstChild, i = 0; w; w = w.nextSibling, i++) {
      var stylew = hdcols[i].style.width,
        origWd = w._origWd,
        // ZK-1022: get original width if it is shrinked by Frozen.js#_doScrollNow
        isFixedWidth = stylew && !stylew.includes('%');
      if (origWd) {
        if (isFixedWidth && zk.parseFloat(stylew) > 1) {
          origWd = stylew; // use the latest one;
        }
        w._width = wds[i] = origWd;
      } else {
        wds[i] = isFixedWidth ? stylew : jq.px0(w.$n_().offsetWidth);
        if (w.isVisible()) w._width = wds[i];else if (!w._width && !w._hflex)
          //invisible and no width
          w._width = '-1';
      }
      if (!isFixedWidth) {
        hdcols[i].style.width = bdcols[i].style.width = wds[i];
        if (ftcols)
          //ZK-2769: Listfooter is not aligned with listhead on changing width
          ftcols[i].style.width = wds[i];
      }
      // reset hflex, Bug ZK-2772 - Misaligned Grid columns
      var wdInt = zk.parseInt(wds[i]);
      if (cssflex) {
        zFlex.clearCSSFlex(w, 'h', true);
        // reset display:none and flex for ZK-5030
        var wns = w.$n_().style;
        if (wns.flex) {
          shallResyncColumns.push(i);
          wns.flex = '';
        }
        wns.display = '';
      } else if (w._hflexWidth) {
        w.setHflex_();
        w._hflexWidth = undefined;
      }
      if (mesh._minWd) {
        mesh._minWd.wds[i] = wdInt;
      }
    }
    if (cssflex) {
      // re-enable head's colgruop and head-bar
      mesh.head.$n_('hdfaker').style.display = mesh.head.$n_('bar').style.display = '';
    }
    //2. set resized width to colgroup col
    if (!wgt._origWd)
      // NOTE: originally, `if(!wgt.origWd)` which was wrong.
      wgt._width = wds[cidx] = wd;
    hdcols[cidx].style.width = bdcols[cidx].style.width = wd;
    if (ftcols)
      //ZK-2769: Listfooter is not aligned with listhead on changing width
      ftcols[cidx].style.width = wd;
    // resync
    while (shallResyncColumns.length) {
      var ci = shallResyncColumns.shift();
      hdcols[ci].style.width = bdcols[ci].style.width = wds[ci];
    }
    //3. clear width=100% setting, otherwise it will try to expand to whole width
    mesh.eheadtbl.width = '';
    mesh.ebodytbl.width = '';
    if (mesh.efoottbl) mesh.efoottbl.width = '';
    delete mesh._span; //no span!
    delete mesh._sizedByContent; //no sizedByContent!
    for (var w = mesh.head.firstChild; w; w = w.nextSibling) w.setHflex_(); //has side effect of setting w.$n().style.width of w._width
    wgt.parent.fire('onColSize', zk.copy({
      index: cidx,
      column: wgt,
      width: wd,
      widths: wds
    }, evt.data), undefined, 0);
    // bug #2799258 in IE, we have to force to recalculate the size.
    mesh.$n_()._lastsz = undefined;
    // for the test case of B70-ZK-2290.zul, we need to put the width back.
    if (!zk.webkit) {
      mesh.eheadtbl.width = '100%';
      mesh.ebodytbl.width = '100%';
      if (mesh.efoottbl) mesh.efoottbl.width = '100%';
    }
    // bug #2799258
    zUtl.fireSized(mesh, -1); //no beforeSize
  };
  HeaderWidget.redraw = function (out) {
    var uuidHTML = this.uuid,
      /*safe*/label = this.domContent_();
    out.push('<th', this.domAttrs_({
      width: true
    }), ' role="columnheader"><div id="', uuidHTML, '-cave" class="', this.$s('content'), '"', this.domTextStyleAttr_(), '><div class="', this.$s('sorticon'), '"><i id="', uuidHTML, '-sort-icon" aria-hidden="true"></i></div>', !this.firstChild && label == '' ? '&nbsp;' : /*safe*/label); //ZK-805 MenuPopup without columns issue
    if (this.parent._menupopup && this.parent._menupopup != 'none') out.push('<div id="', uuidHTML, '-btn" class="', this.$s('button'), '" tabindex="-1" aria-hidden="true"><i class="z-icon-caret-down"></i></div>');
    for (var w = this.firstChild; w; w = w.nextSibling) w.redraw(out);
    out.push('</div></th>');
  };
  var HeaderWidget_1;
  /** @internal */
  HeaderWidget._faker = ['hdfaker', 'bdfaker', 'ftfaker'];
  HeaderWidget = HeaderWidget_1 = __decorate([zk.WrapClass('zul.mesh.HeaderWidget')], HeaderWidget);
  return HeaderWidget;
}(zul.LabelImageWidget);
exports.HeaderWidget = HeaderWidget;
window.zul.mesh.HeaderWidget_.HeaderWidget = HeaderWidget;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/mesh/MeshWidget.ts":
/*!**************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/mesh/MeshWidget.ts ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.mesh) window.zul.mesh = {};
if (!window.zul.mesh.MeshWidget_) window.zul.mesh.MeshWidget_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Scrollbar = exports.MeshWidget = void 0;
var _shallFocusBack;
window.zul.mesh.MeshWidget_._calcMinWd = function (wgt) {
  var wgtn = wgt.$n(),
    ws = wgtn ? wgtn.style.whiteSpace : ''; //bug#3106514: sizedByContent with not visible columns
  if (wgtn) {
    wgtn.style.whiteSpace = 'nowrap'; // B50-3316030, B50-3346235: pre cause extra space
  }
  var eheadtblw,
    efoottblw,
    ebodytblw,
    eheadtblfix,
    efoottblfix,
    ebodytblfix,
    hdfaker = wgt.ehdfaker,
    bdfaker = wgt.ebdfaker,
    ftfaker = wgt.eftfaker,
    head = wgt.head,
    headn = head ? head.$n() : undefined,
    hdfakerws = [],
    bdfakerws = [],
    ftfakerws = [],
    hdws = [],
    hdcavews = [];
  if (wgt.eheadtbl && headn) {
    //clear and backup headers widths
    eheadtblw = wgt.getInnerWidth() || '';
    wgt.eheadtbl.width = '';
    wgt.eheadtbl.style.width = '';
    eheadtblfix = wgt.eheadtbl.style.tableLayout;
    wgt.eheadtbl.style.tableLayout = '';
    if (zk.chrome) wgt.ebodytbl.style.display = 'block';
    var headcol = hdfaker.firstChild,
      headcell = headn.firstChild;
    for (var i = 0; headcol; headcol = headcol.nextSibling, i++) {
      var headcave = headcell ? headcell.firstChild : undefined;
      if (!headcave) continue;
      hdfakerws[i] = headcol.style.width;
      headcol.style.width = '';
      hdws[i] = headcell.style.width;
      headcell.style.width = '';
      hdcavews[i] = headcave.style.width;
      headcave.style.width = '';
      headcell = headcell.nextSibling;
    }
  }
  if (headn) headn.style.width = '';
  if (wgt.efoottbl) {
    //clear and backup footers widths
    efoottblw = eheadtblw || wgt.efoottbl.width;
    wgt.efoottbl.width = '';
    wgt.efoottbl.style.width = '';
    efoottblfix = wgt.efoottbl.style.tableLayout;
    wgt.efoottbl.style.tableLayout = '';
    if (zk.chrome) wgt.ebodytbl.style.display = 'block';
    if (ftfaker) {
      var footcol = ftfaker.firstChild,
        ftrows = wgt.efootrows,
        ftcells = ftrows ? ftrows.rows[0].cells : undefined;
      for (var i = 0; footcol; footcol = footcol.nextSibling) {
        if (ftcells === null || ftcells === void 0 ? void 0 : ftcells[i]) ftcells[i].style.width = ''; // reset it
        ftfakerws[i++] = footcol.style.width;
        footcol.style.width = '';
      }
    }
  }
  if (wgt.ebodytbl) {
    //clear and backup body faker widths
    ebodytblw = eheadtblw || wgt.ebodytbl.width;
    wgt.ebodytbl.width = '';
    wgt.ebodytbl.style.width = '';
    ebodytblfix = wgt.ebodytbl.style.tableLayout;
    wgt.ebodytbl.style.tableLayout = '';
    if (zk.chrome) wgt.ebodytbl.style.display = 'block';
    if (bdfaker) {
      var bodycol = bdfaker.firstChild;
      for (var i = 0; bodycol; bodycol = bodycol.nextSibling) {
        bdfakerws[i++] = bodycol.style.width;
        bodycol.style.width = '';
      }
    }
  }
  //calculate widths
  var wds = [],
    width = 0,
    len = head ? head.nChildren : 0,
    w = head ? head.firstChild : undefined,
    headWgt = wgt.getHeadWidget();
  if (bdfaker && w) {
    var bodycells = wgt._getFirstRowCells(wgt.ebodyrows),
      footcells = ftfaker ? wgt._getFirstRowCells(wgt.efootrows) : undefined;
    for (var i = 0; i < len; i++) {
      var wd = (bodycells === null || bodycells === void 0 ? void 0 : bodycells[i]) ? zk(bodycells[i]).offsetWidthCeil() : 0,
        ftwd = (footcells === null || footcells === void 0 ? void 0 : footcells[i]) && zk(footcells[i]).isVisible() ? footcells[i].offsetWidth : 0,
        hdwd = (w === null || w === void 0 ? void 0 : w.isVisible()) ? w.getContentWidth_() : 0,
        header;
      if ((header = headWgt.getChildAt(i)) && header.getWidth()) hdwd = Math.max(hdwd, ftwd);
      if (hdwd > wd) wd = hdwd;
      if (ftwd > wd) wd = ftwd;
      wds[i] = wd;
      // Bug ZK-2772 don't plus one when frozen exists.
      if (!wgt.frozen && (zk.ff > 4 || zk.safari))
        // firefox4 & IE9, 10, 11 & safari still cause break line in case B50-3147926 column 1
        ++wds[i];
      width += wds[i]; // using wds[i] instead of wd for B50-3183172.zul
      if (w) w = w.nextSibling;
    }
    wgt._deleteFakeRow(wgt.ebodyrows);
    if (ftfaker) wgt._deleteFakeRow(wgt.efootrows);
  } else {
    var tr = window.zul.mesh.MeshWidget_._getSigRow(wgt);
    if (tr) {
      for (var cells = tr.cells, i = cells.length; i--;) {
        var wd = cells[i].offsetWidth;
        wds[i] = wd;
        // Bug ZK-2772 don't plus one when frozen exists.
        if (!wgt.frozen && zk.ff > 4)
          // firefox4 & IE9, 10, 11 still cause break line in case B50-3147926 column 1
          ++wds[i];
        width += wds[i]; // using wds[i] instead of wd for B50-3183172.zul
      }
    }
  }
  // ZK-3313: The width of empty message counts
  var empty = wgt.$n('empty');
  if (empty && empty.style.display != 'none') {
    var emptyWidth = empty.offsetWidth;
    if (emptyWidth > width) width = emptyWidth;
  }
  if (wgt.eheadtbl && headn) {
    //restore headers widths
    if (!eheadtblw.includes('%')) {
      // once sized and consider faker bar
      var $hdfakerbar = jq(wgt.head.$n_('hdfaker')).find('[id*=hdfaker-bar]'),
        hdfakerbar = $hdfakerbar[0];
      if (hdfakerbar) eheadtblw = jq.px0(parseInt(eheadtblw) + parseInt(hdfakerbar.style.width));
      wgt.eheadtbl.style.width = eheadtblw;
    } else wgt.eheadtbl.width = eheadtblw !== null && eheadtblw !== void 0 ? eheadtblw : '';
    wgt.eheadtbl.style.tableLayout = eheadtblfix !== null && eheadtblfix !== void 0 ? eheadtblfix : '';
    if (zk.chrome) wgt.eheadtbl.style.display = '';
    var headcol = hdfaker.firstChild,
      headcell = headn.firstChild;
    for (var i = 0; headcol; headcol = headcol.nextSibling, i++) {
      var headcave = headcell ? headcell.firstChild : undefined;
      if (!headcave) continue;
      headcol.style.width = hdfakerws[i];
      headcell.style.width = hdws[i];
      headcave.style.width = hdcavews[i];
      headcell = headcell.nextSibling;
    }
  }
  if (wgt.efoottbl) {
    //restore footers widths
    wgt.efoottbl.width = efoottblw !== null && efoottblw !== void 0 ? efoottblw : '';
    wgt.efoottbl.style.tableLayout = efoottblfix !== null && efoottblfix !== void 0 ? efoottblfix : '';
    if (zk.chrome) wgt.efoottbl.style.display = '';
    if (ftfaker) {
      var footcol = ftfaker.firstChild;
      for (var i = 0; footcol; footcol = footcol.nextSibling) footcol.style.width = ftfakerws[i++];
    }
  }
  if (wgt.ebodytbl) {
    //restore body fakers widths
    wgt.ebodytbl.width = ebodytblw !== null && ebodytblw !== void 0 ? ebodytblw : '';
    wgt.ebodytbl.style.tableLayout = ebodytblfix !== null && ebodytblfix !== void 0 ? ebodytblfix : '';
    if (zk.chrome) wgt.ebodytbl.style.display = '';
    if (bdfaker) {
      var bodycol = bdfaker.firstChild;
      for (var i = 0; bodycol; bodycol = bodycol.nextSibling) bodycol.style.width = bdfakerws[i++];
    }
  }
  if (wgtn) wgtn.style.whiteSpace = ws;
  return {
    width: width,
    wds: wds
  };
};
window.zul.mesh.MeshWidget_._fixBodyMinWd = function (wgt, fixMesh) {
  // effective only when there is no header
  var sbc = wgt.isSizedByContent(),
    meshmin = wgt._hflex == 'min';
  if (!wgt.head && (meshmin || sbc)) {
    var bdw = zk(wgt.$n()).padBorderWidth(),
      wd = window.zul.mesh.MeshWidget_._getMinWd(wgt) + bdw,
      // has to call _getMinWd first so wgt._minWd will be available
      // eslint-disable-next-line zk/noNull
      tr = wgt.ebodytbl,
      wds = wgt._minWd.wds,
      wlen = wds.length;
    if (fixMesh && meshmin) wgt.setFlexSize_({
      width: wd
    }, true);
    if (!tr.firstChild || !(tr = tr.firstChild.firstChild)) return; // no first tr
    // eslint-disable-next-line zk/noNull
    for (var c = tr.firstChild, i = 0; c && i < wlen; c = c.nextSibling) c.style.width = jq.px(wds[i++]);
    if (sbc && !meshmin) {
      // add flex <td> if absent
      var bdfx = tr.lastChild,
        bdfxid = wgt.uuid + '-bdflex';
      if (!bdfx || bdfx.id != bdfxid) {
        jq(tr).append( /*safe*/'<td id="' + bdfxid + '"></td>');
        bdfx = tr.lastChild;
      }
    }
  }
};
window.zul.mesh.MeshWidget_._fixPageSize = function (wgt, rows) {
  var ebody = wgt.ebody;
  if (!ebody) return false; //not ready yet
  var max = ebody.offsetHeight;
  if (zk(ebody).hasHScroll())
    //with horizontal scrollbar
    max -= jq.scrollbarWidth();
  if (max == wgt._prehgh) return false; //same height, avoid fixing page size
  wgt._prehgh = max;
  var ebodytbl = wgt.ebodytbl,
    etbparent = ebodytbl.offsetParent,
    etbtop = ebodytbl.offsetTop,
    hgh = 0,
    row,
    j = 0;
  for (var it = wgt.getBodyWidgetIterator({
      skipHidden: true
    }), len = rows.length; it.next() && j < len; j++) {
    row = rows[j];
    var top = row.offsetTop - (row.offsetParent == etbparent ? etbtop : 0);
    if (top > max) {
      --j;
      break;
    }
    hgh = top;
  }
  if (row) {
    //there is row
    var pgib = wgt.$n('pgib'),
      pgibHgh = 0;
    if (pgib) pgibHgh = pgib.offsetHeight;
    var withPgibMax = max + pgibHgh;
    if (top <= withPgibMax) {
      //row not exceeds the height, estimate
      var paging = wgt.paging ? wgt.paging : wgt.getPaginal(),
        totalsz = paging.getTotalSize(),
        rowsHgh = hgh + row.offsetHeight,
        j1 = Math.floor(j * max / rowsHgh),
        j2 = Math.floor(j * withPgibMax / rowsHgh);
      if (totalsz > j2 || !paging.isAutohide()) j = j1;else j = j2;
    }
    //enforce pageSize change
    if (j == 0) j = 1; //at least one per page
    if (j != wgt.getPageSize()) {
      wgt.fire('onPageSize', {
        size: j
      });
      return true;
    }
  }
  return false;
};
window.zul.mesh.MeshWidget_._adjMinWd = function (wgt) {
  if (wgt._hflex == 'min') {
    var w = window.zul.mesh.MeshWidget_._getMinWd(wgt),
      n = wgt.$n_();
    wgt._hflexsz = w + zk(n).padBorderWidth(); //override
    n.style.width = jq.px0(wgt._hflexsz);
  }
};
window.zul.mesh.MeshWidget_._getMinWd = function (wgt) {
  wgt._calcMinWds();
  var bdfaker = wgt.ebdfaker,
    wd,
    wds = [],
    width,
    _minwds = wgt._minWd.wds;
  if (wgt.head && bdfaker) {
    width = 0;
    var w = wgt.head.firstChild,
      bdcol = bdfaker.firstChild;
    for (var i = 0; w; w = w.nextSibling) {
      if (w._hflex == 'min') wd = wds[i] = _minwds[i] + zk(w.$n()).padBorderWidth();else {
        if (w._width && w._width.indexOf('px') > 0) wd = wds[i] = zk.parseInt(w._width);else wd = wds[i] = zk.parseInt(bdcol.style.width);
      }
      // ZK-2130: should save the head width
      w._origWd = jq.px0(wd);
      width += wd;
      ++i;
      bdcol = bdcol.nextSibling;
    }
  } else width = wgt._minWd.width; // no header
  return width + (zk(wgt.ebody).hasVScroll() ? jq.scrollbarWidth() : 0);
};
window.zul.mesh.MeshWidget_._getSigRow = function (wgt) {
  // scan for tr with largest number of td children
  var rw = wgt.getBodyWidgetIterator().next(),
    // eslint-disable-next-line zk/noNull
    tr = rw ? rw.$n() : null;
  if (!tr) return;
  // eslint-disable-next-line zk/noNull
  for (var maxtr = tr, len, max = maxtr.cells.length; tr; tr = tr.nextSibling) if ((len = tr.cells.length) > max) {
    maxtr = tr;
    max = len;
  }
  return maxtr;
};
window.zul.mesh.MeshWidget_._cpCellWd = function (wgt) {
  var dst = wgt.efootrows.rows[0],
    srcrows = wgt.ebodyrows.rows;
  if (!dst || !srcrows || !srcrows.length || !dst.cells.length) return;
  var ncols = dst.cells.length,
    // eslint-disable-next-line zk/noNull
    src,
    maxnc = 0;
  for (var j = 0, it = wgt.getBodyWidgetIterator({
      skipHidden: true
    }), w; w = it.next();) {
    if (!w._loaded || w.z_rod) continue;
    var row = srcrows[j++],
      $row = zk(row),
      cells = row.cells,
      nc = $row.ncols(),
      valid = cells.length == nc && $row.isVisible();
    //skip with colspan and invisible
    if (valid && nc >= ncols) {
      maxnc = ncols;
      src = row;
      break;
    }
    if (nc > maxnc) {
      src = valid ? row : undefined;
      maxnc = nc;
    } else if (nc == maxnc && !src && valid) {
      src = row;
    }
  }
  if (!maxnc) return;
  var fakeRow = !src;
  if (fakeRow) {
    //the longest row containing colspan
    src = document.createElement('TR');
    src.style.height = '0px';
    //Note: we cannot use display="none" (offsetWidth won't be right)
    for (var j = 0; j < maxnc; ++j) src.appendChild(document.createElement('TD'));
    srcrows[0].parentNode.appendChild(src);
  }
  //we have to clean up first, since, in FF, if dst contains %
  //the copy might not be correct
  for (var j = maxnc; j--;) dst.cells[j].style.width = '';
  var sum = 0;
  for (var j = maxnc; j--;) {
    var d = dst.cells[j],
      s = src.cells[j];
    if (zk.opera) {
      sum += s.offsetWidth;
      d.style.width = zk(s).contentWidth();
    } else {
      d.style.width = "".concat(s.offsetWidth, "px");
      if (maxnc > 1) {
        //don't handle single cell case (bug 1729739)
        var v = s.offsetWidth - d.offsetWidth;
        if (v != 0) {
          v += s.offsetWidth;
          if (v < 0) v = 0;
          d.style.width = "".concat(v, "px");
        }
      }
    }
  }
  if (zk.opera && wgt.isSizedByContent()) dst.parentNode.parentNode.style.width = "".concat(sum, "px");
  if (fakeRow) src.parentNode.removeChild(src);
};
window.zul.mesh.MeshWidget_.listenOnFitSize = function (wgt) {
  if (wgt._rows && !wgt._rowsOnFitSize) {
    zWatch.listen({
      onFitSize: wgt
    });
    wgt._rowsOnFitSize = true;
  }
};
window.zul.mesh.MeshWidget_.unlistenOnFitSize = function (wgt) {
  if (wgt._rowsOnFitSize) {
    zWatch.unlisten({
      onFitSize: wgt
    });
    delete wgt._rowsOnFitSize;
  }
};
/**
 *  A skeletal implementation for a mesh widget.
 *  @see zul.grid.Grid
 *  @see zul.sel.Tree
 *  @see zul.sel.Listbox
 */
var MeshWidget = /** @class */function (_super) {
  __extends(MeshWidget, _super);
  function MeshWidget() {
    var _this = _super.call(this) || this; // FIXME: arguments?
    /** @internal */
    _this._rows = 0;
    /** @internal */
    _this._pagingPosition = 'bottom';
    /** @internal */
    _this._prehgh = -1;
    // `zul.mesh.prototype.HeadWidget.onColSize` could assign `_innerWidth` a number
    /** @internal */
    _this._innerWidth = '100%';
    /** @internal */
    _this._currentTop = 0;
    /** @internal */
    _this._currentLeft = 0;
    /** @internal */
    _this._nativebar = true;
    _this.heads = [];
    return _this;
  }
  MeshWidget_1 = MeshWidget;
  /** @internal */
  MeshWidget.prototype._syncEmpty = function () {
    // Empty on purpose. To be inherited.
  };
  /**
   * @returns (int) the rows. Zero means no limitation.
   * @defaultValue `0`.
   */
  MeshWidget.prototype.getRows = function () {
    return this._rows;
  };
  /**
   * Sets the rows.
   * <p>
   * Note: if both {@link setHeight} is specified with non-empty,
   * {@link setRows} is ignored
   */
  MeshWidget.prototype.setRows = function (rows, opts) {
    var o = this._rows;
    this._rows = rows;
    if (o !== rows || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      window.zul.mesh.MeshWidget_.listenOnFitSize(this);
      var n = this.$n();
      if (n) {
        n._lastsz = undefined;
        this.onSize();
      }
    }
    return this;
  };
  /**
   * @returns how to position the paging of the widget at the client screen.
   * It is meaningless if the mold is not in "paging".
   */
  MeshWidget.prototype.getPagingPosition = function () {
    return this._pagingPosition;
  };
  /**
   * Sets how to position the paging of the widget at the client screen.
   * It is meaningless if the mold is not in "paging".
   * @param pagingPosition - how to position. It can only be "bottom" (the default), or
   * "top", or "both".
   */
  MeshWidget.prototype.setPagingPosition = function (pagingPosition, opts) {
    var o = this._pagingPosition;
    this._pagingPosition = pagingPosition;
    if (o !== pagingPosition || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * Returns whether the paging component of this component is disabled
   * @since 10.0.0
   */
  MeshWidget.prototype.isPagingDisabled = function () {
    var _a;
    return !!((_a = this.getPagingChild()) === null || _a === void 0 ? void 0 : _a.isDisabled());
  };
  /**
   * Sets whether to disable the Paging component of this component
   * @since 10.0.0
   */
  MeshWidget.prototype.setPagingDisabled = function (pagingDisabled) {
    var _a;
    (_a = this.getPagingChild()) === null || _a === void 0 ? void 0 : _a.setDisabled(pagingDisabled);
    return this;
  };
  /**
   * @returns whether sizing the widget column width by its content. Default is false.
   * <p>Note: if the "sized-by-content" attribute of component is specified,
   * it's prior to the original value.
   * @see {@link setSizedByContent}
   */
  MeshWidget.prototype.isSizedByContent = function () {
    return !!this._sizedByContent;
  };
  /**
   * Sets whether sizing the widget column width by its content. Default is false, i.e.
   * the outline of the widget is dependent on browser. It means, we don't
   * calculate the width of each cell. If set to true, the outline will count on
   * the content of body. In other words, the outline of the widget will be like
   * ZK version 2.4.1 that the header's width is only for reference.
   *
   * <p> You can also specify the "sized-by-content" attribute of component in
   * lang-addon.xml directly, it will then take higher priority.
   */
  MeshWidget.prototype.setSizedByContent = function (sizedByContent, opts) {
    var o = this._sizedByContent;
    this._sizedByContent = sizedByContent;
    if (o !== sizedByContent || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns column span hint of this widget.
   * @defaultValue `null`
   * @since 5.0.6
   * @see {@link setSpan}
   */
  MeshWidget.prototype.getSpan = function () {
    return this._span;
  };
  MeshWidget.prototype.isSpan = function () {
    return this._span;
  };
  /**
   * Sets column span hint of this mesh widget.
   * <p>The parameter span is a number in String type indicating how this
   * component distributes remaining empty space to the
   * specified column(0-based). "0" means distribute remaining empty space to the 1st column; "1" means
   * distribute remaining empty space to the 2nd column, etc.. The spanning column will grow to
   * fit the extra remaining space.</p>
   * <p>Special span hint with "true" means span ALL columns proportionally per their
   * original widths while null or "false" means NOT spanning any column.</p>
   * @defaultValue `null`. That is, NOT span any column.</p>
   * <p>Note span is meaningful only if there is remaining empty space for columns.</p>
   *
   * @param span - the column span hint.
   * @since 5.0.6
   * @see {@link getSpan}
   */
  MeshWidget.prototype.setSpan = function (span, opts) {
    var o = this._span;
    this._span = span;
    if (o !== span || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      //ZK-2776: if span="false", !isSpan() will return false, because "false" is string not boolean
      var isTrue = true === span || 'true' == span,
        isFalse = false === span || 'false' == span;
      this._span = isTrue ? true : isFalse ? false : span;
      var x = isTrue ? -65500 : isFalse ? 0 : zk.parseInt(span) + 1;
      this._nspan = x < 0 && x != -65500 ? 0 : x;
      this.rerender();
    }
    return this;
  };
  /**
   * @returns whether turn on auto-paging facility when mold is
   * "paging". If it is set to true, the {@link setPageSize} is ignored;
   * rather, the page size(number of item count) is automatically determined by the
   * height of this widget dynamically.
   * @see {@link setAutopaging}
   */
  MeshWidget.prototype.isAutopaging = function () {
    return !!this._autopaging;
  };
  /**
   * Sets whether turn on auto-paging facility when mold is
   * "paging". If it is set to true, the {@link setPageSize} is ignored;
   * rather, the page size(number of item count) is automatically determined by the
   * height of this widget dynamically.
   */
  MeshWidget.prototype.setAutopaging = function (autopaging, opts) {
    var o = this._autopaging;
    this._autopaging = autopaging;
    if (o !== autopaging || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns whether the widget is in model mode or not.
   */
  MeshWidget.prototype.isModel = function () {
    return !!this._model;
  };
  // TODO: Used by grid. Should prefer the use of isModel
  MeshWidget.prototype.getModel = function () {
    return this._model; // it could be "group" for groups model
  };
  /**
   * Sets whether the widget is in model mode.
   */
  MeshWidget.prototype.setModel = function (model) {
    this._model = model;
    return this;
  };
  /**
   * @returns the inner width of this component.
   * The inner width is the width of the inner table.
   * @defaultValue `"100%"`
   * @see {@link setInnerWidth}
   */
  MeshWidget.prototype.getInnerWidth = function () {
    return this._innerWidth;
  };
  /**
   * Sets the inner width of this component.
   * The inner width is the width of the inner table.
   * By default, it is 100%. That is, it is the same as the width
   * of this component. However, it is changed when the user
   * is sizing the column's width.
   *
   * <p>Application developers rarely call this method, unless
   * they want to preserve the widths of sizable columns
   * changed by the user.
   * To preserve the widths, the developer have to store the widths of
   * all columns and the inner width ({@link getInnerWidth}),
   * and then restore them when re-creating this component.
   *
   * @param innerWidth - the inner width. If null, "100%" is assumed.
   */
  MeshWidget.prototype.setInnerWidth = function (innerWidth, opts) {
    var o = this._innerWidth;
    this._innerWidth = innerWidth;
    if (o !== innerWidth || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (innerWidth == null) this._innerWidth = innerWidth = '100%';
      if (this.eheadtbl) this.eheadtbl.style.width = innerWidth;
      if (this.ebodytbl) this.ebodytbl.style.width = innerWidth;
      if (this.efoottbl) this.efoottbl.style.width = innerWidth;
    }
    return this;
  };
  /**
   * @returns the external Paging widget, if any.
   */
  MeshWidget.prototype.getPaginal = function () {
    return this._paginal;
  };
  /**
   * Sets the external Paging widget.
   */
  MeshWidget.prototype.setPaginal = function (paginal) {
    var _a, _b;
    if (this._paginal != paginal) {
      (_a = this._paginal) === null || _a === void 0 ? void 0 : _a.setMeshWidget();
      this._paginal = paginal;
      (_b = this._paginal) === null || _b === void 0 ? void 0 : _b.setMeshWidget(this);
    }
    return this;
  };
  /**
   * @returns the page size, aka., the number rows per page.
   * @see {@link zul.mesh.Paging.getPageSize}
   */
  MeshWidget.prototype.getPageSize = function () {
    var _a, _b;
    return (_b = (_a = this.getPagingChild()) === null || _a === void 0 ? void 0 : _a.getPageSize()) !== null && _b !== void 0 ? _b : 0;
  };
  /**
   * Sets the page size, aka., the number rows per page.
   * @see {@link zul.mesh.Paging.setPageSize}
   */
  MeshWidget.prototype.setPageSize = function (pageSize) {
    var _a;
    (_a = this.getPagingChild()) === null || _a === void 0 ? void 0 : _a.setPageSize(pageSize);
    return this;
  };
  /**
   * @returns the number of pages.
   * Note: there is at least one page even no item at all.
   * @see {@link zul.mesh.Paging.getPageCount}
   */
  MeshWidget.prototype.getPageCount = function () {
    var _a, _b;
    return (_b = (_a = this.getPagingChild()) === null || _a === void 0 ? void 0 : _a.getPageCount()) !== null && _b !== void 0 ? _b : 1;
  };
  /**
   * @returns the active page (starting from 0).
   * @see {@link zul.mesh.Paging.getActivePage}
   */
  MeshWidget.prototype.getActivePage = function () {
    var _a, _b;
    return (_b = (_a = this.getPagingChild()) === null || _a === void 0 ? void 0 : _a.getActivePage()) !== null && _b !== void 0 ? _b : 0;
  };
  /**
   * Sets the active page (starting from 0).
   * @see {@link zul.mesh.Paging.setActivePage}
   */
  MeshWidget.prototype.setActivePage = function (activePage) {
    var _a;
    (_a = this.getPagingChild()) === null || _a === void 0 ? void 0 : _a.setActivePage(activePage);
    return this;
  };
  /**
   * @returns whether the widget is in paging mold.
   */
  MeshWidget.prototype.inPagingMold = function () {
    return 'paging' == this.getMold();
  };
  MeshWidget.prototype.getPagingChild = function () {
    var _a;
    return (_a = this.paging) !== null && _a !== void 0 ? _a : this.getPaginal();
  };
  MeshWidget.prototype.setHeight = function (height) {
    _super.prototype.setHeight.call(this, height);
    if (this.desktop) {
      this._setHgh(height);
      this.onSize();
    }
    return this;
  };
  MeshWidget.prototype.setWidth = function (width) {
    _super.prototype.setWidth.call(this, width);
    if (this.eheadtbl) this.eheadtbl.style.width = '';
    if (this.efoottbl) this.efoottbl.style.width = '';
    if (this.desktop) this.onSize();
    return this;
  };
  MeshWidget.prototype.setStyle = function (style) {
    if (this._style != style) {
      _super.prototype.setStyle.call(this, style);
      if (this.desktop) this.onSize();
    }
    return this;
  };
  /**
   * @returns the self's head widget.
   * @since 5.0.4
   */
  MeshWidget.prototype.getHeadWidget = function () {
    return this.head;
  };
  /**
   * @param el - the element got focus.
   * @returns the focused cell element.
   * @since 5.0.7
   */
  MeshWidget.prototype.getFocusCell = function (el) {
    var td;
    // Note: `jq.each` is in general not the same as `jq().each` although it is in this case.
    // But, only `jq.each` matches the definition in `jQuery.d.ts`.
    // See https://api.jquery.com/jquery.each/#:~:text=%24.each()%20function-,is%20not%20the%20same%20as,-%24(selector).each()
    jq.each([this.ebodytbl, this.eheadtbl, this.efoottbl], function (i) {
      if (this && jq.isAncestor(this, el)) {
        var tds = jq(el).parents(i == 1 ? 'th' : 'td'); // headtable uses TH, others uses TD
        for (var i = 0, j = tds.length; i < j; i++) {
          td = tds[i];
          if (jq(td).parents('table')[0] == this) {
            return false; // break the loop;
          }
        }
      }
    });
    return td;
  };
  /** @internal */
  MeshWidget.prototype._moveToHidingFocusCell = function (index, ignoreWidth, notFocusBack) {
    //B50-3178977 navigating the input in hiddin column.
    var td = this.ehdfaker ? this.ehdfaker.childNodes[index] : undefined,
      frozen = this.frozen;
    if (td && frozen && (ignoreWidth || zk.parseInt(td.style.width) == 0) && (index = index - frozen.getColumns()) >= 0) {
      var bar = this._scrollbar;
      if (this._nativebar) {
        frozen.setStart(index);
      } else if (bar) {
        frozen._doScrollNow(index);
        bar.setBarPosition(index);
      }
      _shallFocusBack = !notFocusBack;
    }
  };
  /** @internal */
  MeshWidget.prototype._restoreFocus = function () {
    if (_shallFocusBack && zk.currentFocus) {
      _shallFocusBack = false;
      zk.currentFocus.focus();
    }
  };
  /** @internal */
  MeshWidget.prototype.disableAutoSizing_ = function () {
    this._span = false;
    this._nspan = 0;
    this._sizedByContent = false;
  };
  /** @internal */
  MeshWidget.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    this._bindDomNode();
    if (this.frozen) this._cssflex = false; //force to use old flex
    if (this._cssflex && this.isChildrenFlex()) {
      //css flex
      this.ehdfaker.style.display = 'none';
    } else if (this._hflex != 'min') this._fixHeaders();
    if (this.ehead)
      //sync scroll for input tab key scroll
      this.domListen_(this.ehead, 'onScroll', '_doSyncScroll');
    var ebody = this.ebody;
    if (this._nativebar && ebody) {
      this.domListen_(ebody, 'onScroll', '_doScroll');
      ebody.style.overflow = 'auto';
      if (this.efrozen && !zk.mobile) jq(ebody).css('overflow-x', 'hidden'); // keep non line break
    }
    zWatch.listen({
      onSize: this,
      onResponse: this
    });
  };
  /** @internal */
  MeshWidget.prototype.unbind_ = function (skipper, after, keepRod) {
    window.zul.mesh.MeshWidget_.unlistenOnFitSize(this);
    zWatch.unlisten({
      onSize: this,
      onResponse: this
    });
    if (this.ehead)
      //sync scroll for input tab key scroll
      this.domUnlisten_(this.ehead, 'onScroll', '_doSyncScroll');
    var ebody = this.ebody;
    if (this._nativebar && ebody) {
      this.domUnlisten_(ebody, 'onScroll', '_doScroll');
      if (this.efrozen) jq(ebody).css('overflow-x', 'auto');
    }
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  MeshWidget.prototype.clearCache = function () {
    _super.prototype.clearCache.call(this);
    this.ebody = this.ehead = this.efoot = this.efrozen = this.ebodytbl = this.eheadtbl = this.efoottbl = this.ebodyrows = this.ehdfaker = this.ebdfaker = undefined;
  };
  /**
   * Synchronizes the size immediately.
   * This method is called automatically if the widget is created
   * at the server (i.e., {@link inServer} is true).
   * You have to invoke this method only if you create this widget
   * at client and add or remove children from this widget.
   * @since 5.0.8
   */
  MeshWidget.prototype.syncSize = function () {
    if (this.desktop) {
      this.clearCachedSize_();
      if (this._hflex == 'min') {
        zFlex.onFitSize.call(this);
      } else {
        this._fixHeaders();
      }
      zWatch.fireDown('onSize', this);
    }
  };
  // These paramters are not used. They exist for the sake of inheritance.
  MeshWidget.prototype.onResponse = function (ctl, opts) {
    if (this._shallSize) {
      if (this._shallClearTableWidth) {
        this._clearTableWidth();
        this._shallClearTableWidth = false;
      }
      this.syncSize();
      this._shallSize = false; // just in case
    }
  };
  /** @internal */
  MeshWidget.prototype._syncSize = function (shallClearTableWidth) {
    // fixed for F50-3025422.zul on ZTL
    if (this.desktop) {
      this._shallSize = true;
      this._shallClearTableWidth = !!shallClearTableWidth;
    }
  };
  /** @internal */
  MeshWidget.prototype._clearTableWidth = function () {
    if (this.desktop) {
      // clear table width
      var hdtbl = this.eheadtbl,
        bdtbl = this.ebodytbl,
        fttbl = this.efoottbl;
      if (hdtbl) hdtbl.style.width = '';
      if (bdtbl) bdtbl.style.width = '';
      if (fttbl) fttbl.style.width = '';
    }
  };
  /** @internal */
  MeshWidget.prototype._fixHeaders = function (force) {
    if (this.head && this.ehead) {
      if (this._cssflex && this.isChildrenFlex()) return false;
      var empty = true,
        flex = false,
        shouldFix = false,
        shouldCheckEmptyWidth = !this.frozen && this.eheadtbl && this.eheadtbl.style.width,
        hdsmin = this._hflex == 'min' || this.isSizedByContent();
      for (var i = this.heads.length; i-- > 0;) {
        var header = this.heads[i],
          emptyHeader = true,
          column = 0;
        for (var w = header.firstChild; w; w = w.nextSibling) {
          //B70-ZK-2559: when dynamic adding auxhead, there has already
          //been auxhead widget while dom element hasn't attached yet
          var childNode = this.ehdfaker.childNodes[column++];
          if (hdsmin && childNode && !childNode.style.width && !w._nhflex) {
            // B50-3357475: assume header hflex min if width/hflex unspecified
            w._hflex = 'min';
            w._nhflex = -65500; // min
            w._nhflexbak = true;
          }
          if (!flex && w._nhflex) flex = true;
          if (w.getLabel() || w.getImage() || w.nChildren) {
            emptyHeader = false;
            empty = false;
          }
          if (shouldCheckEmptyWidth && !w.getWidth()) {
            shouldFix = true;
          }
        }
        if (header._visible) {
          //B70-ZK-2559: description as mentioned
          var n = header.$n();
          if (n) n.style.display = emptyHeader ? 'none' : ''; // Bug ZK-2348
        }
      }
      var old = this.ehead.style.display,
        tofix = force && flex && this.isRealVisible(); //Bug ZK-1647: no need to consider empty header for flex calculation
      this.ehead.style.display = empty ? 'none' : '';
      //onSize is not fired to empty header when loading page, so we have to simulate it here
      for (var w = this.head.firstChild; w; w = w.nextSibling) {
        if (tofix && w._nhflex) w.fixFlex_();
        if (w._nhflexbak) {
          delete w._hflex;
          delete w._nhflex;
          delete w._nhflexbak;
        }
      }
      return shouldFix || old != this.ehead.style.display;
    }
    return false;
  };
  /** @internal */
  MeshWidget.prototype._adjFlexWd = function () {
    var head = this.head;
    if (head) {
      var hdfaker = this.ehdfaker,
        bdfaker = this.ebdfaker,
        hdcol = hdfaker.firstChild,
        bdcol = bdfaker.firstChild,
        ftfaker = this.eftfaker,
        // eslint-disable-next-line zk/noNull
        ftcol = null;
      if (ftfaker) ftcol = ftfaker.firstChild;
      //B70-ZK-2130: clean table width to prevent incorrect width
      this.eheadtbl.style.width = '';
      this.ebodytbl.style.width = '';
      //B70-ZK-2394: store total bdcol width
      var tblWidth = 0,
        cachedOffsetWidths = {};
      // ZK-2098: should skip if bdcol doesn't exist
      for (var w = head.firstChild; w && bdcol; w = w.nextSibling) {
        // ZK-2130: should save the header width
        // ZK-2071: use offsetWidth instead of style.width
        cachedOffsetWidths[w.uuid] = w.$n_().offsetWidth;
        bdcol = bdcol.nextSibling;
      }
      bdcol = bdfaker.firstChild;
      // ZK-4320: Do not adjust widget's width if smooth is false and frozen is scrolled
      var frozen = this.frozen;
      if (!(frozen && !frozen._smooth && frozen.getStart())) {
        for (var w = head.firstChild, wd; w && bdcol; w = w.nextSibling) {
          var wwd = cachedOffsetWidths[w.uuid];
          if (w.isVisible() && wwd > 0.1) w._origWd = jq.px0(wwd);
          // B70-ZK-2036: Do not adjust widget's width if it is not visible.
          if (w.isVisible() && (wd = w._hflexWidth) !== undefined) {
            var revisedWidth = zk(bdcol).revisedWidth(Math.round(wd)),
              revisedWidthPx = jq.px0(revisedWidth);
            //B70-ZK-2509: w.$n().offsetWidth is small when there are many columns at beginning, so save revised width if any
            w._origWd = revisedWidthPx;
            bdcol.style.width = revisedWidthPx;
            hdcol.style.width = revisedWidthPx;
            if (ftcol) ftcol.style.width = revisedWidthPx;
            //B70-ZK-2394: store total bdcol width
            tblWidth += revisedWidth;
          }
          bdcol = bdcol.nextSibling;
          hdcol = hdcol.nextSibling;
          if (ftcol) ftcol = ftcol.nextSibling;
        }
      }
      //B70-ZK-2394: sync width from colgroup to hdtbl, bdtbl, fttbl
      var allWidths = this._isAllWidths();
      if (allWidths) {
        var hdtbl = this.eheadtbl,
          bdtbl = this.ebodytbl,
          fttbl = this.efoottbl;
        if (hdtbl) {
          var tblWidthPx = jq.px0(tblWidth);
          hdtbl.style.width = tblWidthPx;
          if (bdtbl) bdtbl.style.width = tblWidthPx;
          if (fttbl) fttbl.style.width = tblWidthPx;
        }
      }
      window.zul.mesh.MeshWidget_._adjMinWd(this);
      this._afterCalcSize();
    }
  };
  /** @internal */
  MeshWidget.prototype._bindDomNode = function () {
    this.ehead = this.$n('head');
    this.eheadtbl = this.$n('headtbl');
    this.ebody = this.$n('body');
    this.ebodytbl = this.$n('cave');
    this.efoot = this.$n('foot');
    this.efoottbl = this.$n('foottbl');
    this.efrozen = this.$n('frozen');
    // Grid will bind ebodyrows in Rows widget
    var erows = this.$n('rows');
    if (this.ebody && erows) this.ebodyrows = erows;
    if (this.ehead) {
      this.eheadrows = this.$n('headrows');
      this.ehdfaker = this.head.$n('hdfaker');
      this.ebdfaker = this.head.$n('bdfaker');
      if (this.efoot) this.eftfaker = this.head.$n('ftfaker');
    }
    if (this.efoot) this.efootrows = this.$n('footrows');
  };
  MeshWidget.prototype.replaceHTML = function (n, desktop, skipper, _trim_, _callback_) {
    var old = this._syncingbodyrows;
    this._syncingbodyrows = true;
    try {
      //bug #2995434
      //20100503, Henri: cannot use $supers('replaceHTML') since it
      //will recursive back to this function via fire('onSize'). However,
      //ZK's $supers() is simulated and when we call $supers() again
      //here, the system thought it is calling from its super class rather
      //than this class and it will be wrong. Therefore, we are forced to
      //call super class's replaceHTML directly instead.
      //Therefore, we have to specify MeshWidget as follows
      _super.prototype.replaceHTML.call(this, n, desktop, skipper, _trim_, _callback_);
    } finally {
      this._syncingbodyrows = old;
    }
  };
  /** @internal */
  MeshWidget.prototype.replaceChildHTML_ = function (child, n, desktop, skipper, _trim_) {
    var old = this._syncingbodyrows;
    this._syncingbodyrows = true;
    try {
      _super.prototype.replaceChildHTML_.call(this, child, n, desktop, skipper, _trim_);
    } finally {
      this._syncingbodyrows = old;
    }
  };
  MeshWidget.prototype.fireOnRender = function (timeout) {
    if (!this._pendOnRender) {
      this._pendOnRender = true;
      setTimeout(this.proxy(this._onRender), timeout ? timeout : 100);
    }
  };
  /** @internal */
  MeshWidget.prototype._doScroll = function () {
    var t = zul.mesh.Scrollbar.getScrollPosV(this),
      l = zul.mesh.Scrollbar.getScrollPosH(this),
      hScrolled = l != this._currentLeft,
      scrolled = t != this._currentTop || hScrolled,
      ebody = this.ebody,
      ehead = this.ehead,
      efoot = this.efoot;
    // ZK-2069: fire onScroll if has scrollable property
    if (jq(this).data('scrollable')) {
      zWatch.fireDown('onScroll', this);
      zWatch.fire('_onSyncScroll', this); // ZK-4408: for Popup only
    }
    //B70-ZK-2070: if scrolled, the scrollbar need fire onScroll event.
    if (scrolled && !this.fire('onScroll', ebody.scrollLeft).stopped && this._nativebar) if (this._currentLeft != ebody.scrollLeft) {
      if (ehead) ehead.scrollLeft = ebody.scrollLeft;
      if (efoot) efoot.scrollLeft = ebody.scrollLeft;
    }
    // ZK-2046: should sync currentTop in rod mode see also Bug ZK-353
    if (scrolled /* && !this._listbox$rod && !this._grid$rod*/) this._currentTop = t;
    if (scrolled)
      // always sync for B30-1737660.zul
      this._currentLeft = l;
    if (!this.paging && !this._paginal) this.fireOnRender(zk.gecko ? 200 : 60);
    if (scrolled) this._fireOnScrollPos();
    if (this.frozen && hScrolled) this.frozen.syncScrollByParentBody();
  };
  /** @internal */
  MeshWidget.prototype._doSyncScroll = function () {
    var ehead = this.ehead,
      ebody = this.ebody,
      efoot = this.efoot;
    if (ehead && zk(ehead).isVisible()) {
      if (this._currentLeft != ehead.scrollLeft) {
        if (ebody) ebody.scrollLeft = ehead.scrollLeft;
        if (efoot) efoot.scrollLeft = ehead.scrollLeft;
      }
    }
  };
  /** @internal */
  MeshWidget.prototype._fireOnScrollPos = function (time, forceToScroll /* overriden in zkmax */) {
    clearTimeout(this._timeoutId);
    this._timeoutId = setTimeout(this._onScrollPos.bind(this), time >= 0 ? time : 300);
  };
  /** @internal */
  MeshWidget.prototype._onScrollPos = function () {
    // Bug ZK-414
    if (this.ebody) {
      this._currentTop = zul.mesh.Scrollbar.getScrollPosV(this);
      this._currentLeft = zul.mesh.Scrollbar.getScrollPosH(this);
      this.fire('onScrollPos', {
        top: this._currentTop,
        left: this._currentLeft
      });
    }
  };
  /** @internal */
  MeshWidget.prototype._onRender = function () {
    if (!this.$n()) return false; // the target may not exist. B50-ZK-963
    this._pendOnRender = false;
    if (this._syncingbodyrows || zAu.processing()) {
      //wait if busy (it might run outer)
      this.fireOnRender(zk.gecko ? 200 : 60); //is syncing rows, try it later
      return true;
    }
    var rows = this.ebodyrows ? this.ebodyrows.rows : undefined;
    if (this.inPagingMold() && this._autopaging && rows && rows.length) if (window.zul.mesh.MeshWidget_._fixPageSize(this, rows)) return false; //need to reload with new page size
    if (!this.desktop || !this._model || !rows || !rows.length) return false;
    //Note: we have to calculate from top to bottom because each row's
    //height might diff (due to different content)
    var items = [],
      min = zul.mesh.Scrollbar.getScrollPosV(this),
      max = min + this.ebody.offsetHeight;
    if (min == 0 && max == 0) return false; //ZK-2796: Uncessary onRender command triggered when setting tabbox's maximalHeight attribute to true
    for (var j = 0, it = this.getBodyWidgetIterator({
        skipHidden: true
      }), len = rows.length, w; (w = it.next()) && j < len; j++) {
      if (!w._loaded) {
        //B70-ZK-2589: w and rows[j] belongs to different widget,
        //w shouldn't depend on rows[j], origin -> row = rows[j];
        var row = w.$n();
        if (row == null) continue;
        var $row = zk(row),
          top = $row.offsetTop();
        if (top + $row.offsetHeight() < min) continue;
        if (top > max) break; //Bug 1822517
        items.push(w);
      }
    }
    if (items.length) {
      this.fire('onRender', {
        items: items
      }, {
        implicit: true
      });
    }
    return false;
  };
  MeshWidget.prototype.onSize = function () {
    var devicePixelRatio = zUtl.getDevicePixelRatio();
    if (this.isRealVisible()) {
      // sometimes the caller is not zWatch
      var n = this.$n_();
      if (n._lastsz && n._lastsz.height == n.offsetHeight && n._lastsz.width == n.offsetWidth && this._lastDevicePixelRatio == devicePixelRatio) {
        this.fireOnRender(155); // force to render while using live grouping
        return; // unchanged
      }
      this._lastDevicePixelRatio = devicePixelRatio;
      this._calcSize(); // Bug #1813722
      this.fireOnRender(155);
      if (this._nativebar) {
        // Bug ZK-355: keep scrollbar position
        var ebody = this.ebody;
        // ZK-3647: if Listbox enable ROD and need to init pad sizes, it will adjust scrollTop when _initPadSizes().
        if (ebody.scrollHeight >= this._currentTop && !this._adjustScrollTopLater) ebody.scrollTop = this._currentTop;
        if (ebody.scrollWidth >= this._currentLeft) {
          ebody.scrollLeft = this._currentLeft;
          if (this.ehead) this.ehead.scrollLeft = this._currentLeft;
          if (this.efoot) this.efoot.scrollLeft = this._currentLeft;
        }
      }
      this._shallSize = false;
      if (this._keepScroll) {
        this._scrollToIndex(this._targetIndex);
      }
    }
  };
  /** @internal */
  MeshWidget.prototype._vflexSize = function () {
    var n = this.$n(),
      pgHgh = 0;
    if (this.paging) {
      var pgit = this.$n('pgit'),
        pgib = this.$n('pgib');
      if (pgit) pgHgh += pgit.offsetHeight;
      if (pgib) pgHgh += pgib.offsetHeight;
    }
    // Bug #1815882 and Bug #1835369
    var hgh = zk(n).contentHeight() - (this.ehead ? this.ehead.offsetHeight : 0) - (this.efoot ? this.efoot.offsetHeight : 0) - pgHgh;
    return this.frozen && this._nativebar ? hgh - this.efrozen.offsetHeight : hgh;
  };
  /** @internal */
  MeshWidget.prototype.setFlexSize_ = function (flexSize, isFlexMin) {
    if (this._cssflex && this.parent.getFlexContainer_() != null && !isFlexMin) return;
    var n = this.$n_(),
      head = this.$n('head');
    if (flexSize.height !== undefined) {
      if (flexSize.height == 'auto') {
        n.style.height = '';
        if (head) head.style.height = '';
      } else {
        return _super.prototype.setFlexSize_.call(this, flexSize, isFlexMin);
      }
    }
    if (flexSize.width !== undefined) {
      if (flexSize.width == 'auto') {
        if (this._hflex != 'min') n.style.width = '';
        if (head) head.style.width = '';
      } else {
        return _super.prototype.setFlexSize_.call(this, flexSize, isFlexMin);
      }
    }
  };
  /* set the height. */
  /** @internal */
  MeshWidget.prototype._setHgh = function (hgh) {
    var n = this.$n_(),
      ebody = this.ebody,
      ebodyStyle = ebody.style;
    if (this.isVflex() || hgh && hgh != 'auto' && !hgh.includes('%')) {
      if (zk.webkit && ebodyStyle.height == jq.px(this._vflexSize())) return; // Bug ZK-417, ignore to set the same size
      ebodyStyle.height = ''; //allow browser adjusting to default size
      var h = this._vflexSize();
      if (h < 0) h = 0;
      if (this._vflex != 'min') ebodyStyle.height = "".concat(h, "px");
    } else {
      //Bug 1556099
      ebodyStyle.height = '';
      n.style.height = hgh;
    }
  };
  /** @internal */
  MeshWidget.prototype._ignoreHghExt = function () {
    return false;
  };
  /** Calculates the size. @internal */
  MeshWidget.prototype._calcSize = function () {
    this._beforeCalcSize();
    //Bug 1553937: wrong sibling location
    //Otherwise,
    //IE: element's width will be extended to fit body
    //note: we don't solve this bug for paging yet
    var n = this.$n_(),
      sizedByContent = this.isSizedByContent(),
      ehead = this.ehead,
      ebodyrows = this.ebodyrows,
      efoot = this.efoot,
      efootrows = this.efootrows;
    if (ehead) {
      if (sizedByContent && ebodyrows) this._adjHeadWd();
    } else if (efoot) {
      if (efootrows && ebodyrows) window.zul.mesh.MeshWidget_._cpCellWd(this);
    }
    //check if need to span width
    this._adjSpanWd();
    // no header case
    window.zul.mesh.MeshWidget_._fixBodyMinWd(this, true);
    // B50-ZK-543, B50-ZK-773
    // should re-calculate height because
    // the string height maybe changed after width changed.
    if (sizedByContent && this.getRows && this.getRows() > 1 && typeof this._calcHgh == 'function' && this.ebody.style.height) {
      // check only if height exists for F50-3000339.zul
      this._calcHgh(); // recalculate height again ZK-796
    }
    n._lastsz = {
      height: n.offsetHeight,
      width: n.offsetWidth
    }; // cache for the dirty resizing.
    this._afterCalcSize();
  };
  /** @internal */
  MeshWidget.prototype._beforeCalcSize = function () {
    var ebody = this.ebody;
    if (!this._nativebar && (ebody.scrollLeft || ebody.scrollTop)) {
      // ZK-2046: Keep ebody scroll position before calculated size, _setHgh would reset it to 0.
      this._ebodyScrollPos = {
        l: ebody.scrollLeft,
        t: ebody.scrollTop
      };
    }
    this._calcHgh();
  };
  /** @internal */
  MeshWidget.prototype._afterCalcSize = function () {
    // Fix B96-ZK-5247
    if (!this.isRealVisible()) return;
    var isCSSFlex = this._cssflex && this.isChildrenFlex();
    if (this._ebodyScrollPos) {
      // ZK-2046: Restore ebody scroll position after calculated size.
      this.ebody.scrollLeft = this._ebodyScrollPos.l;
      this.ebody.scrollTop = this._ebodyScrollPos.t;
      this._ebodyScrollPos = undefined;
    }
    // Set style width to table to avoid colgroup width not working
    // because of width attribute (width="100%") on table
    var allWidths = this._isAllWidths(),
      head = this.head,
      ebody = this.ebody,
      ebodyrows = this.ebodyrows,
      hdfakerbar = head ? head.$n('hdfaker-bar') : undefined,
      hdbar = head ? jq(this).find('.' + head.$s('bar'))[0] : undefined,
      ftfakerbar = this.eftfaker ? this.head.$n('ftfaker-bar') : undefined,
      scrollbarWidth = jq.scrollbarWidth(),
      hasVScroll = zk(ebody).hasVScroll(),
      hasHScroll = zk(ebody).hasHScroll();
    if (hasVScroll) {
      if (hdfakerbar) {
        if (isCSSFlex && hdbar) hdbar.style.flex = "0 1 ".concat(scrollbarWidth, "px");else hdfakerbar.style.width = "".concat(scrollbarWidth, "px");
      }
      if (ftfakerbar) ftfakerbar.style.width = "".concat(scrollbarWidth, "px");
    } else {
      var zero = MeshWidget_1.WIDTH0;
      //refix B70-ZK-2114: remove hdfakerbar when there is no native scrollbar
      if (hdfakerbar) {
        if (isCSSFlex && hdbar) hdbar.style.flex = '0 1 ' + zero + 'px';else hdfakerbar.style.width = zero;
      }
      if (ftfakerbar) ftfakerbar.style.width = zero;
    }
    if (hasHScroll && ebodyrows && this._vflex == 'min') {
      var ehead = this.ehead,
        efoot = this.efoot,
        hgh = jq(ebodyrows).height();
      hgh += scrollbarWidth;
      ebody.style.height = jq.px0(hgh);
      if (ehead) {
        hgh += ehead.offsetHeight;
      }
      if (efoot) {
        hgh += efoot.offsetHeight;
      }
      this.$n_().style.height = jq.px0(hgh);
    }
    if (isCSSFlex) {
      //update
      head.afterChildrenFlex_();
      return;
    }
    if (allWidths) {
      var hdtbl = this.eheadtbl,
        bdtbl = this.ebodytbl,
        fttbl = this.efoottbl;
      if (hdtbl) {
        var wd = 0;
        for (var w = this.ehdfaker.firstChild; w; w = w.nextSibling) {
          var n = w;
          if (n.style.display != 'none' && !n.id.endsWith('hdfaker-bar'))
            // B70-ZK-2307 and B70-ZK-2358
            wd += zk.parseInt(n.style.width);
        }
        if (wd > 0) {
          //ZK-2772, ZK-2903: only when hdfaker has width, set back to table
          //ZK-3938: only adjust width in Chrome (ZK-4219: and safari), but zk.chrome returns true in Edge, we need to check !zk.edge
          hdtbl.style.width = hdfakerbar && hasVScroll && (zk.chrome || zk.safari) && !zk.edge_legacy ? "".concat(wd + scrollbarWidth, "px") : "".concat(wd, "px");
          if (bdtbl) bdtbl.style.width = "".concat(wd, "px");
          if (fttbl) fttbl.style.width = "".concat(wd, "px");
        } else {
          var hideTable = false;
          for (var header = this.head.firstChild; header; header = header.nextSibling) {
            if (header.isVisible()) {
              hideTable = false;
              break;
            }
            hideTable = true;
          }
          if (hideTable) {
            hdtbl.style.visibility = 'hidden';
            if (bdtbl) bdtbl.style.visibility = 'hidden';
            if (fttbl) fttbl.style.visibility = 'hidden';
          }
        }
      }
    } else if (this.frozen) {
      //B70-ZK-2468: should sync ebody width with ebodytbl width
      var ehead = this.ehead,
        hdtbl = this.eheadtbl,
        ebody = this.ebody,
        bdtbl = this.ebodytbl,
        efoot = this.efoot,
        fttbl = this.efoottbl;
      if (ehead && hdtbl) hdtbl.style.width = jq.px0(ehead.clientWidth);
      if (ebody && bdtbl) bdtbl.style.width = jq.px0(ebody.clientWidth);
      if (efoot && fttbl) fttbl.style.width = jq.px0(efoot.clientWidth);
      if (!this.frozen._smooth) this._syncFaker();
    }
  };
  /** @internal */
  MeshWidget.prototype._syncFaker = function () {
    var head = this.head;
    if (!head || !this.desktop) return;
    var totalCols = head.nChildren,
      width0 = zul.mesh.MeshWidget.WIDTH0,
      newTotalWidth = this.ebodytbl.clientWidth,
      oldTotalWidth = 0,
      epsilon = 1;
    for (var i = 0, header = head.firstChild, hdcol = this.ehdfaker.firstChild; i < totalCols; header = header.nextSibling, hdcol = hdcol.nextSibling, i++) {
      var fakerStyleWidth = hdcol.style.width;
      if (fakerStyleWidth == '') return;
      var isHidden = fakerStyleWidth == width0,
        width = isHidden ? parseFloat(header._origWd) : parseFloat(fakerStyleWidth);
      if (header.getWidth() || header.getHflex()) newTotalWidth -= width;else oldTotalWidth += width;
    }
    if (Math.abs(newTotalWidth - oldTotalWidth) < epsilon) return;
    for (var i = 0, header = head.firstChild, hdcol = this.ehdfaker.firstChild; i < totalCols; header = header.nextSibling, hdcol = hdcol.nextSibling, i++) {
      if (header.getWidth() || header.getHflex()) continue;
      var fakerStyleWidth = hdcol.style.width,
        multiplier = newTotalWidth / oldTotalWidth,
        isHidden = fakerStyleWidth == width0;
      if (isHidden) header._origWd = jq.px0(parseFloat(header._origWd) * multiplier);else {
        var newStyleWidth = jq.px0(parseFloat(fakerStyleWidth) * multiplier),
          bdfaker = header.$n('bdfaker'),
          ftfaker = header.$n('ftfaker');
        hdcol.style.width = newStyleWidth;
        if (bdfaker) bdfaker.style.width = newStyleWidth;
        if (ftfaker) ftfaker.style.width = newStyleWidth;
      }
    }
  };
  //return if all widths of columns are fixed (directly or indirectly)
  /** @internal */
  MeshWidget.prototype._isAllWidths = function () {
    // ZK-2157: should skip if the mesh has no children
    if (this.isSizedByContent() && this.ebodyrows && this.ebodyrows.firstChild) return true;
    if (!this.head) return false;
    for (var w = this.head.firstChild; w; w = w.nextSibling) {
      if ((w._width == undefined || w._width.indexOf('px') <= 0) && (w._hflex != 'min' || w._hflexsz === undefined) && w.isVisible()) {
        return false;
      }
    }
    return true;
  };
  /** @internal */
  MeshWidget.prototype.domFaker_ = function (out, fakeId) {
    var head = this.head;
    out.push('<colgroup id="', /*safe*/head.uuid, /*safe*/fakeId, '">');
    for (var w = head.firstChild; w; w = w.nextSibling) {
      var wd = MeshWidget_1._getWidth(w, w._hflexWidth ? "".concat(w._hflexWidth, "px") : w.getWidth()),
        visibility = w.isVisible() ? '' : 'visibility: collapse;';
      // B70-ZK-2036: Style width should end with 'px'.
      wd = wd != null ? 'width: ' + wd + ';' : '';
      out.push('<col id="', /*safe*/w.uuid, /*safe*/fakeId, '" style="', /*safe*/wd, /*safe*/visibility, '"></col>');
    }
    if (fakeId.indexOf('hd') > 0 || fakeId.indexOf('ft') > 0) out.push('<col id="', /*safe*/head.uuid, /*safe*/fakeId, '-bar" style="width: 0px" ></col>');
    out.push('</colgroup>');
  };
  /** @internal */
  MeshWidget.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (child instanceof this.getHeadWidgetClass()) {
      this.head = child;
      this._minWd = undefined;
      // TODO: remove the type assertion below. Should be unnecessary, but tsc infers it
      // to be `never` which is not wrong.
    } else if (!(child instanceof zul.mesh.Auxhead)) return;
    var nsib = child.nextSibling;
    if (nsib) for (var hds = this.heads, j = 0, len = hds.length; j < len; ++j) if (hds[j] == nsib) {
      hds.splice(j, 0, child);
      return; //done
    }
    this.heads.push(child);
  };
  /** @internal */
  MeshWidget.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (child == this.head) {
      // If true, child is guaranteed to be a HeadWidget
      this._minWd = this.head = undefined;
      this.heads.$remove(child);
    } else if (child instanceof zul.mesh.Auxhead) this.heads.$remove(child);else if (child instanceof zul.mesh.Frozen) this.efrozen = undefined;
  };
  //bug# 3022669: listbox hflex="min" sizedByContent="true" not work
  /** @internal */
  MeshWidget.prototype.beforeMinFlex_ = function (orient) {
    if (this._hflexsz === undefined && orient == 'w' && this._width === undefined) {
      if (this.isSizedByContent()) this._calcSize();
      if (this.head) {
        this._fixHeaders(true); /* B50-3315594.zul */
        for (var w = this.head.firstChild; w; w = w.nextSibling) if (w._hflex == 'min' && w._hflexsz === undefined)
          //header hflex="min" not done yet!
          return undefined;
      }
      window.zul.mesh.MeshWidget_._fixBodyMinWd(this); // sized by content without header
      return window.zul.mesh.MeshWidget_._getMinWd(this); //grid.invalidate() with hflex="min" must maintain the width
    }
    return undefined;
  };
  // fixed for B50-3315594.zul
  /** @internal */
  MeshWidget.prototype.beforeParentMinFlex_ = function (orient) {
    if (orient == 'w') {
      if (this.isSizedByContent()) this._calcSize();
      if (this.head) this._fixHeaders();
    } else this._calcSize();
  };
  /** @internal */
  MeshWidget.prototype.clearCachedSize_ = function () {
    _super.prototype.clearCachedSize_.call(this);
    this._clearCachedSize();
    var tr;
    if (!this.ebdfaker && (tr = window.zul.mesh.MeshWidget_._getSigRow(this))) {
      //empty head case
      for (var cells = tr.cells, i = cells.length; i--;) cells[i].style.width = '';
    }
    var head = this.getHeadWidget();
    if (head) {
      for (var w = head.firstChild; w; w = w.nextSibling) delete w._hflexsz;
    }
  };
  /** @internal */
  MeshWidget.prototype._clearCachedSize = function () {
    var n = this.$n();
    if (n) n._lastsz = this._minWd = undefined;
  };
  /** @internal */
  MeshWidget.prototype._calcMinWds = function () {
    if (!this._minWd) this._minWd = window.zul.mesh.MeshWidget_._calcMinWd(this);
    return this._minWd;
  };
  /** @internal */
  MeshWidget.prototype._adjSpanWd = function () {
    var _a;
    if (!this._isAllWidths() || !this.isSpan()) return;
    var hdfaker = this.ehdfaker,
      bdfaker = this.ebdfaker,
      ftfaker = this.eftfaker;
    if (!hdfaker || !bdfaker) return;
    var head = this.head.$n();
    if (!head) return;
    this._calcMinWds();
    var wd,
      wds = [],
      width = 0,
      hdcol = hdfaker.firstChild,
      bdcol = bdfaker.firstChild,
      _minwds = this._minWd.wds,
      hdlen = this.head.nChildren;
    for (var temphdcol = hdcol, w = this.head.firstChild, i = 0; w; w = w.nextSibling, i++) {
      if (zk(temphdcol).isVisible(true)) {
        var wdh = w._width;
        if (w._hflex == 'min') wd = wds[i] = _minwds[i];else if (wdh === null || wdh === void 0 ? void 0 : wdh.endsWith('px')) wd = wds[i] = zk.parseInt(wdh);else wd = wds[i] = _minwds[i];
        width += wd;
      }
      temphdcol = temphdcol.nextSibling;
    }
    var ftcol = ftfaker === null || ftfaker === void 0 ? void 0 : ftfaker.firstChild,
      total = this.ebody.clientWidth,
      extSum = total - width,
      count = total,
      visj = -1,
      tblWidth = 0; //refix B70-ZK-2394: should sync colgroup width with table width
    //span to all columns
    if (this._nspan < 0) {
      var hasFrozenScrolled = (_a = this.frozen) === null || _a === void 0 ? void 0 : _a.getStart();
      for (var i = 0; hdcol && i < hdlen; hdcol = hdcol.nextSibling, i++) {
        // ZK-2222: should check visibility
        if (!zk(hdcol).isVisible(true)) {
          bdcol = bdcol.nextSibling;
          if (ftcol) ftcol = ftcol.nextSibling;
          continue;
        } else {
          // for bug ZK-2772, we don't span it when frozen column has scrolled.
          // Instead, we use its faker width.
          if (hasFrozenScrolled) {
            if (extSum <= 0) {
              wds[i] = wd = wds[i];
            } else {
              if (hdcol.style.width) {
                wds[i] = wd = zk.parseInt(hdcol.style.width);
              } else {
                wds[i] = wd = Math.round(wds[i] * total / width + 0.5 || 0);
              }
            }
          } else {
            wds[i] = wd = extSum <= 0 ? wds[i] : Math.round(wds[i] * total / width + 0.5 || 0);
          }
          var stylew = jq.px0(wd);
          count -= wd;
          visj = i;
          hdcol.style.width = stylew;
          bdcol.style.width = stylew;
          tblWidth += wd; //refix B70-ZK-2394: store each col's width
          bdcol = bdcol.nextSibling;
          if (ftcol) {
            ftcol.style.width = stylew;
            ftcol = ftcol.nextSibling;
          }
        }
      }
      //compensate calc error but excluding scrolled frozen column
      if (extSum > 0 && count != 0 && visj >= 0) {
        tblWidth -= wd; //refix B70-ZK-2394: subtract the last wd (visj is the last)
        wd = wds[visj] + count;
        var stylew = jq.px0(wd);
        tblWidth += wd; //refix B70-ZK-2394: and add new wd
        if (!hasFrozenScrolled) {
          bdfaker.childNodes[visj].style.width = stylew;
          hdfaker.childNodes[visj].style.width = stylew;
          if (ftfaker) ftfaker.childNodes[visj].style.width = stylew;
        }
      }
    } else {
      //feature#3184415: span to a specific column
      visj = this._nspan - 1;
      for (var i = 0; hdcol && i < hdlen; hdcol = hdcol.nextSibling, i++) {
        if (!zk(hdcol).isVisible(true)) {
          bdcol = bdcol.nextSibling;
          if (ftcol) ftcol = ftcol.nextSibling;
          continue;
        } else {
          wd = visj == i && extSum > 0 ? wds[visj] + extSum : wds[i];
          var stylew = jq.px0(wd);
          hdcol.style.width = stylew;
          bdcol.style.width = stylew;
          tblWidth += wd; //refix B70-ZK-2394: store each col's width
          bdcol = bdcol.nextSibling;
          if (ftcol) {
            ftcol.style.width = stylew;
            ftcol = ftcol.nextSibling;
          }
        }
      }
    }
    //refix B70-ZK-2394: sync colgroup width with (head, body, foot)table width
    var allWidths = this._isAllWidths();
    if (allWidths) {
      var hdtbl = this.eheadtbl,
        bdtbl = this.ebodytbl,
        fttbl = this.efoottbl;
      if (hdtbl) {
        hdtbl.style.width = "".concat(tblWidth, "px");
        if (bdtbl) bdtbl.style.width = "".concat(tblWidth, "px");
        if (fttbl) fttbl.style.width = "".concat(tblWidth, "px");
      }
    }
    //bug 3188738: Opera only. Grid/Listbox/Tree span="x" not working
    if (zk.opera) zk(this.$n()).redoCSS();
  };
  /** @internal */
  MeshWidget.prototype._adjHeadWd = function () {
    var hdfaker = this.ehdfaker,
      bdfaker = this.ebdfaker,
      ftfaker = this.eftfaker;
    if (!hdfaker || !bdfaker || !this.getBodyWidgetIterator().hasNext()) return;
    var hdtable = this.eheadtbl,
      head = this.head.$n();
    if (!head) return;
    // Bug #1886788 the size of these table must be specified a fixed size.
    var ebody = this.ebody,
      bdtable = this.ebodytbl,
      bdwd = ebody.offsetWidth,
      total = Math.max(hdtable.offsetWidth, bdtable.offsetWidth),
      tblwd = Math.min(bdwd, bdtable.offsetWidth);
    if (total == bdwd && bdwd > tblwd && bdwd - tblwd < 20) total = tblwd;
    var minWd = this._calcMinWds(),
      wds = minWd.wds,
      width = minWd.width,
      hdcol = hdfaker.firstChild,
      bdcol = bdfaker.firstChild,
      ftcol = ftfaker ? ftfaker.firstChild : undefined,
      hwgt = this.head.firstChild,
      notVisibleWidth = MeshWidget_1.WIDTH0;
    for (var i = 0; hwgt; hwgt = hwgt.nextSibling, i++) {
      if (hwgt.isVisible()) {
        // sizedByContent shall not override column width
        if (hwgt._width || wds[i] == 0) {
          if (wds[i] == 0) {
            hdcol.style.width = notVisibleWidth;
            bdcol.style.width = notVisibleWidth;
            if (ftcol) ftcol.style.width = notVisibleWidth;
          }
          hdcol = hdcol.nextSibling;
          bdcol = bdcol.nextSibling;
          if (ftcol) ftcol = ftcol.nextSibling;
        } else if (!this.frozen || !this.frozen.getStart() || hdcol.style.width === '') {
          var wd = jq.px(wds[i]);
          hdcol.style.width = bdcol.style.width = wd;
          hdcol = hdcol.nextSibling;
          bdcol = bdcol.nextSibling;
          if (ftcol) {
            ftcol.style.width = wd;
            ftcol = ftcol.nextSibling;
          }
        }
      } else {
        hdcol.style.width = notVisibleWidth;
        bdcol.style.width = notVisibleWidth;
        hdcol = hdcol.nextSibling;
        bdcol = bdcol.nextSibling;
        if (ftcol) {
          ftcol.style.width = notVisibleWidth;
          ftcol = ftcol.nextSibling;
        }
      }
    }
    hdtable.style.width = jq.px(width);
    bdtable.style.width = jq.px(width);
    if (ftfaker) this.efoottbl.style.width = jq.px(width);
    window.zul.mesh.MeshWidget_._adjMinWd(this);
  };
  /** @internal */
  MeshWidget.prototype._getFirstRowCells = function (tbody) {
    var rowsLength, tbodyrows;
    if (tbody && (tbodyrows = tbody.rows) && (rowsLength = tbodyrows.length)) {
      var cells = tbodyrows[0].cells,
        length = cells.length,
        ncols = 0;
      //ZK-2752: find the first visible row
      //keep the same behavior even there isn't any row visible to avoid other side effects
      if (tbody.offsetHeight > 0) {
        for (var i = 0; i < rowsLength; i++) {
          if (jq(tbodyrows[i]).css('display') != 'none') {
            cells = tbodyrows[i].cells;
            length = cells.length;
            break;
          }
        }
      }
      for (var i = 0; i < length; i++) {
        var span = cells[i].colSpan;
        ncols += span != 1 ? span : 1;
      }
      if (ncols == length) return cells;else {
        var outHTML = '';
        outHTML += '<tr id="' + /*safe*/tbody.id + '-fakeRow" style="visibility:hidden;height:0">';
        for (var i = 0; i < ncols; i++) outHTML += '<td></td>';
        outHTML += '</tr>';
        jq(tbodyrows[0]).before( /*safe*/outHTML);
        outHTML = undefined;
        return tbodyrows[0].cells;
      }
    }
  };
  /** @internal */
  MeshWidget.prototype._deleteFakeRow = function (tbody) {
    if (tbody) jq('#' + tbody.id + '-fakeRow').remove();
  }; // for Grid.js and Listbox.js
  /** @internal */
  MeshWidget.prototype.refreshBar_ = function (showBar, scrollToTop) {
    var bar = this._scrollbar;
    if (bar) {
      // ZK-355: Keep scroll position before sync scrollbar size
      var currentLeft = this._currentLeft,
        currentTop = this._currentTop;
      bar.syncSize(showBar || this._shallShowScrollbar);
      delete this._shallShowScrollbar; // use undefined rather false
      if (scrollToTop) bar.scrollTo(0, 0);else bar.scrollTo(currentLeft, currentTop);
      //sync frozen
      var frozen = this.frozen,
        start;
      if (frozen && (start = frozen._start) != 0) {
        frozen._doScrollNow(start);
        bar.setBarPosition(start);
      }
      this._afterCalcSize(); // for ZK-2370, we need to check the faker-bar again
    }
  };
  MeshWidget.prototype.onFitSize = function () {
    // B50-ZK-598: when having rows, height needs to be determined when onFitSize
    if (this._rows) this._calcHgh();
  };
  /** @internal */
  MeshWidget.prototype._calcHgh = function () {
    var rows = this.ebodyrows ? this.ebodyrows.rows : [],
      n = this.$n_(),
      hgh = n.style.height,
      isHgh = hgh && hgh != 'auto' && !hgh.includes('%');
    if (isHgh) {
      hgh = zk.parseInt(hgh) - zk(n).padBorderHeight();
      if (hgh) {
        hgh -= this._headHgh(0);
        if (hgh < 0) hgh = 0;
        var sz = 0;
        l_out: for (var h, j = 0, rl = rows.length; j < rl; ++sz, ++j) {
          //next visible row
          var r;
          for (;; ++j) {
            //no need to check length again
            if (j >= rl) break l_out;
            r = rows[j];
            if (zk(r).isVisible()) break;
          }
          var $r = zk(r);
          h = $r.offsetTop() + $r.offsetHeight();
          if (h >= hgh) {
            if (h > hgh + 2) ++sz; //experimental
            break;
          }
        }
        sz = Math.ceil(sz && h ? hgh * sz / h : hgh / this._headHgh(20));
        this._setOrGetVisibleRows(sz);
        hgh -= this.efoot ? this.efoot.offsetHeight : 0;
        //bug# 3036398: frozen scrollbar disappear when listbox with vflex="1"
        hgh -= this.efrozen && this._nativebar ? this.efrozen.offsetHeight : 0;
        this.ebody.style.height = "".concat(Math.max(hgh, 0), "px");
        return; //done
      }
    }
    var nVisiRows = 0,
      nRows = this.getRows(),
      lastVisiRow,
      firstVisiRow,
      midVisiRow;
    for (var j = 0, rl = rows.length; j < rl; ++j) {
      //tree might collapse some items
      var r = rows[j];
      if (zk(r).isVisible()) {
        ++nVisiRows;
        if (!firstVisiRow) firstVisiRow = r;
        if (nRows === nVisiRows) {
          midVisiRow = r;
          break;
          //nVisiRows and lastVisiRow useful only if nRows is larger,
          //so ok to break here
        }
        lastVisiRow = r;
      }
    }
    hgh = 0;
    var diff = 2; /*experiment*/
    if (!nRows) {
      if (this.isVflex()) {
        // Since ie6 support was dropped, the argument of _vflexSize is not used.
        // Some time later, the argument of _vflexSize is dropped from the signature,
        // but `this._vflexSize(n.style.height)` wasn't cleaned up until now.
        hgh = this._vflexSize();
        if (hgh < 25) hgh = 25;
        var rowhgh = firstVisiRow ? zk(firstVisiRow).offsetHeight() : undefined;
        if (!rowhgh) rowhgh = this._headHgh(20);
        nRows = Math.round((hgh - diff) / rowhgh);
      }
      this._setOrGetVisibleRows(nRows);
    }
    if (nRows) {
      if (!hgh) {
        if (!nVisiRows) {
          hgh = this._headHgh(20, true) * nRows;
        } else if (nRows <= nVisiRows) {
          var $midVisiRow = zk(midVisiRow);
          hgh = $midVisiRow.offsetTop() + $midVisiRow.offsetHeight();
        } else {
          var $lastVisiRow = zk(lastVisiRow);
          hgh = $lastVisiRow.offsetTop() + $lastVisiRow.offsetHeight();
          hgh = Math.ceil(nRows * hgh / nVisiRows);
        }
      }
      this.ebody.style.height = "".concat(hgh, "px");
    } else {
      this.ebody.style.height = '';
      var focusEL = this.$n('a');
      if (this.getPagingChild() && focusEL) focusEL.style.top = '0px'; // Bug ZK-1715: focus has no chance to sync if don't select item after changing page.
    }
  };
  /**
   * @returns the real # of rows (aka., real size).
   * @internal
   */
  MeshWidget.prototype._setOrGetVisibleRows = function (v) {
    if ('number' == typeof v) {
      this._visiRows = v;
    } else return this.getRows() || this._visiRows || 0;
  };
  /* Height of the head row. If no header, defval is returned. */
  /** @internal */
  MeshWidget.prototype._headHgh = function (defVal, isExcludeAuxhead) {
    var headWidget = this.getHeadWidget(),
      //Bug ZK-1297: get head height exclude auxhead
      head = this.ehead,
      hgh = isExcludeAuxhead ? headWidget ? headWidget.$n_().offsetHeight : 0 : head ? head.offsetHeight : 0;
    if (this.paging) {
      var pgit = this.$n('pgit'),
        pgib = this.$n('pgib');
      if (pgit) hgh += pgit.offsetHeight;
      if (pgib) hgh += pgib.offsetHeight;
    }
    return hgh ? hgh : defVal;
  };
  /**
   * Scroll to the specified item by the given index, used by Grid and Listbox,
   * this function could be invoked by server-side or client-side,
   * when invoked by client-side, scrollRatio will be undefined.
   * @param index - the index of item
   * @param scrollRatio - the scroll ratio
   * @internal
   */
  MeshWidget.prototype._scrollToIndex = function (index, scrollRatio) {
    // NOTE: _scrollToIndex will only be called by Grid and Listbox, and both of them
    // implements _getFirstItemIndex and _getLastItemIndex.
    // @ts-expect-error: calling `_getFirstItemIndex` is safe in `_scrollToIndex`
    // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment, @typescript-eslint/no-unsafe-call
    var firstItemIndex = this._getFirstItemIndex(),
      // @ts-expect-error: calling `_getLastItemIndex` is safe in `_scrollToIndex`
      // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment, @typescript-eslint/no-unsafe-call
      lastItemIndex = this._getLastItemIndex(),
      body = this.ebody;
    this._targetIndex = index;
    this._keepScroll = true;
    if (index >= firstItemIndex && index <= lastItemIndex) {
      var itemIterator = this.getBodyWidgetIterator();
      while (itemIterator.hasNext()) {
        var item = itemIterator.next();
        if (item._index == index) {
          item.$n_().scrollIntoView(true);
          this._keepScroll = false;
          this._topBoundary = this._bottomBoundary = undefined;
          return;
        }
      }
    } else if (scrollRatio != undefined) {
      body.scrollTop = body.scrollHeight * scrollRatio;
    } else if (index < firstItemIndex) {
      this._bottomBoundary = body.scrollTop;
      this._topBoundary = this._topBoundary == undefined ? 0 : this._topBoundary;
      body.scrollTop -= (body.scrollTop - this._topBoundary) / 2;
    } else if (index > lastItemIndex) {
      this._topBoundary = body.scrollTop;
      this._bottomBoundary = this._bottomBoundary == undefined ? body.scrollHeight : this._bottomBoundary;
      body.scrollTop += (this._bottomBoundary - body.scrollTop) / 2;
    }
  };
  /** @internal */
  MeshWidget.prototype.getContentEdgeHeight_ = function (height) {
    var height = _super.prototype.getContentEdgeHeight_.call(this, height),
      efoot = this.efoot;
    if (efoot) {
      var zkefoot = zk(efoot);
      height += zkefoot.padBorderHeight() + zkefoot.sumStyles('tb', jq.margins);
    }
    return height;
  };
  /** @internal */
  MeshWidget.prototype.afterChildrenMinFlex_ = function (o) {
    var n = this.$n_();
    if (o == 'h') {
      n.style.height = jq.px0(Math.ceil(this._vflexsz));
    }
  };
  //css flex
  MeshWidget.prototype.isChildrenFlex = function () {
    if (this.head && this.ehead) {
      for (var i = this.heads.length; i-- > 0;) {
        var header = this.heads[i];
        for (var w = header.firstChild; w; w = w.nextSibling) {
          if (w._hflex && w._hflex != 'min') {
            return true;
          }
        }
      }
    }
    return false;
  };
  /** @internal */
  MeshWidget.prototype.waitForRendered_ = function () {
    var _this = this;
    return new Promise(function (resolve) {
      var callback = function () {
        if (!_this._pendOnRender) return resolve();
        setTimeout(callback);
      };
      callback();
    });
  };
  // ZK-5028 for Treecols, Listhead, and Columns
  /** @internal */
  MeshWidget.prototype.shallFireSizedLaterWhenAddChd_ = function () {
    if (this.inRerendering_()) {
      zWatch.listen({
        onResponse: [this, this._fixFireSizedLaterWhenAddChd]
      });
      return true;
    }
    return false;
  };
  // ZK-5028 for Treecols, Listhead, and Columns
  /** @internal */
  MeshWidget.prototype._fixFireSizedLaterWhenAddChd = function () {
    zUtl.fireSized(this);
    zWatch.unlisten({
      onResponse: [this, this._fixFireSizedLaterWhenAddChd]
    });
  };
  /** @internal */
  MeshWidget._getWidth = function (wgt, width) {
    if (wgt.isVisible()) return width;
    return this.WIDTH0;
  };
  var MeshWidget_1;
  MeshWidget.WIDTH0 = zk.webkit ? '0.001px' : '0px';
  MeshWidget = MeshWidget_1 = __decorate([zk.WrapClass('zul.mesh.MeshWidget')], MeshWidget);
  return MeshWidget;
}(zul.Widget);
exports.MeshWidget = MeshWidget;
/** @class zul.mesh.Scrollbar
 * @import zk.Widget
 * The extra Scrollbar for the MeshWidget.
 * @since 6.5.0
 */
exports.Scrollbar = {
  /**
   * Initialize the scrollbar of MeshWidget.
   * @param wgt - a widget
   */
  init: function (wgt) {
    var embed = jq(wgt.$n_()).data('embedscrollbar') !== false,
      // change default value to true since 7.0.2
      frozen = wgt.frozen,
      startPositionX = 0;
    if (frozen) {
      var columns = frozen.getColumns();
      if (wgt.eheadtbl) {
        var cells = wgt._getFirstRowCells(wgt.eheadrows);
        if (cells) {
          for (var i = 0; i < columns; i++) startPositionX += cells[i].offsetWidth;
        }
        wgt._deleteFakeRow(wgt.eheadrows);
      }
    }
    return new zul.Scrollbar(wgt.ebody, wgt.ebodytbl, {
      embed: embed,
      startPositionX: startPositionX,
      onSyncPosition: function () {
        if (!this.frozen) {
          var pos = this.getCurrentPosition(),
            head = wgt.ehead,
            foot = wgt.efoot;
          if (pos && this.hasHScroll()) {
            if (head) head.scrollLeft = pos.x;
            if (foot) foot.scrollLeft = pos.x;
          }
        }
      },
      onScrollEnd: function () {
        wgt._doScroll();
      }
    });
  },
  /**
   * @returns the vertical scroll position of the body element of given MeshWidget.
   * @param wgt - the widget
   */
  getScrollPosV: function (wgt) {
    var bar = wgt._scrollbar;
    if (bar) return bar.getCurrentPosition().y;
    return wgt.ebody.scrollTop;
  },
  /**
   * @returns the horizontal scroll position of the body element of given MeshWidget.
   * @param wgt - the widget
   * @since 7.0.0
   */
  getScrollPosH: function (wgt) {
    var bar = wgt._scrollbar;
    if (bar) return bar.getCurrentPosition().x;
    return wgt.ebody.scrollLeft;
  }
};
zul.mesh.Scrollbar = exports.Scrollbar;
window.zul.mesh.MeshWidget_._shallFocusBack = _shallFocusBack;
window.zul.mesh.MeshWidget_.MeshWidget = MeshWidget;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/mesh/Paging.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/mesh/Paging.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.mesh) window.zul.mesh = {};
if (!window.zul.mesh.Paging_) window.zul.mesh.Paging_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Paging = void 0;
/* Paging.ts

    Purpose:

    Description:

    History:
        Fri Jan 23 15:00:58     2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
window.zul.mesh.Paging_._rerenderIfBothPaging = function (wgt) {
  if (wgt.isBothPaging()) {
    wgt.parent.rerender();
    return true;
  }
}; //Returns whether the string is integer or not
window.zul.mesh.Paging_._isUnsignedInteger = function (s) {
  return s.toString().search(/^[0-9]+$/) == 0;
};
/**
 * Paging of long content.
 * @defaultValue {@link getZclass}: z-paging.
 */
var Paging = /** @class */function (_super) {
  __extends(Paging, _super);
  function Paging() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._pageSize = 20;
    /** @internal */
    _this._totalSize = 0;
    /** @internal */
    _this._pageCount = 1;
    /** @internal */
    _this._activePage = 0;
    /** @internal */
    _this._pageIncrement = zk.mobile ? 5 : 10;
    /** @internal */
    _this._showFirstLast = true;
    /** @internal */
    _this._detailed = false;
    return _this;
  }
  Paging_1 = Paging;
  /**
   * Sets the total number of items.
   */
  Paging.prototype.setTotalSize = function (totalSize, opts) {
    var o = this._totalSize;
    this._totalSize = totalSize;
    if (o !== totalSize || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this._updatePageNum();
      if (this._detailed) {
        if (!window.zul.mesh.Paging_._rerenderIfBothPaging(this)) {
          var info = this.$n('info');
          if (info) {
            info.textContent = this.infoText_();
          } else if (this._totalSize) {
            this.rerender(); // recreate infoTag
          }
        }
      }
    }
    return this;
  };
  /**
   * @returns the total number of items.
   */
  Paging.prototype.getTotalSize = function () {
    return this._totalSize;
  };
  /**
   * @returns the number of page anchors shall appear at the client.
   * @defaultValue `10`.
   */
  Paging.prototype.getPageIncrement = function () {
    return this._pageIncrement;
  };
  /**
   * Sets the number of page anchors shall appear at the client.
   */
  Paging.prototype.setPageIncrement = function (pageIncrement, opts) {
    var o = this._pageIncrement;
    this._pageIncrement = pageIncrement;
    if (o !== pageIncrement || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns whether to show the detailed info, such as {@link getTotalSize}.
   */
  Paging.prototype.isDetailed = function () {
    return this._detailed;
  };
  /**
   * Sets whether to show the detailed info, such as {@link getTotalSize}.
   */
  Paging.prototype.setDetailed = function (detailed, opts) {
    var o = this._detailed;
    this._detailed = detailed;
    if (o !== detailed || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the number of pages.
   * Note: there is at least one page even no item at all.
   */
  Paging.prototype.getPageCount = function () {
    return this._pageCount;
  };
  /**
   * Sets the number of pages.
   * Note: there is at least one page even no item at all.
   */
  Paging.prototype.setPageCount = function (pageCount, opts) {
    var o = this._pageCount;
    this._pageCount = pageCount;
    if (o !== pageCount || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the active page (starting from 0).
   */
  Paging.prototype.getActivePage = function () {
    return this._activePage;
  };
  /**
   * Sets the active page (starting from 0).
   */
  Paging.prototype.setActivePage = function (activePage, opts) {
    var o = this._activePage;
    this._activePage = activePage;
    if (o !== activePage || typeof opts != 'boolean' && (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    // for client mvvm if activePage is set at client, we should trigger onPaging event to server
    if (opts === undefined) {
      this.fire('onPaging', activePage);
    }
    return this;
  };
  /**
   * @returns the page size, aka., the number rows per page.
   */
  Paging.prototype.getPageSize = function () {
    return this._pageSize;
  };
  /**
   * Sets the page size, aka., the number rows per page.
   */
  Paging.prototype.setPageSize = function (pageSize, opts) {
    var o = this._pageSize;
    this._pageSize = pageSize;
    if (o !== pageSize || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this._updatePageNum();
    }
    return this;
  };
  /**
   * @returns whether to automatically hide this component if there is only one
   * page available.
   * @defaultValue `false`.
   */
  Paging.prototype.isAutohide = function () {
    return !!this._autohide;
  };
  /**
   * Sets whether to automatically hide this component if there is only one
   * page available.
   */
  Paging.prototype.setAutohide = function (autohide, opts) {
    var o = this._autohide;
    this._autohide = autohide;
    if (o !== autohide || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.getPageCount() == 1) this.rerender();
    }
    return this;
  };
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   * @since 8.0.3
   */
  Paging.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /**
   * Sets whether it is disabled.
   * @since 8.0.3
   */
  Paging.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this._drawDisabled(disabled);
    }
    return this;
  };
  /**
   * @returns the associated {@link zul.mesh.MeshWidget} if any.
   * @since 10.0.0
   */
  Paging.prototype.getMeshWidget = function () {
    return this._meshWidget;
  };
  /**
   * Sets the associated {@link zul.mesh.MeshWidget}.
   * @since 10.0.0
   */
  Paging.prototype.setMeshWidget = function (meshWidget) {
    this._meshWidget = meshWidget;
    return this;
  };
  Paging.prototype.setStyle = function (style) {
    _super.prototype.setStyle.call(this, style);
    window.zul.mesh.Paging_._rerenderIfBothPaging(this);
    return this;
  };
  Paging.prototype.setSclass = function (sclass) {
    _super.prototype.setSclass.call(this, sclass);
    window.zul.mesh.Paging_._rerenderIfBothPaging(this);
    return this;
  };
  Paging.prototype.setWidth = function (width) {
    _super.prototype.setWidth.call(this, width);
    window.zul.mesh.Paging_._rerenderIfBothPaging(this);
    if (this.desktop) zUtl.fireSized(this, -1);
    return this;
  };
  Paging.prototype.setHeight = function (height) {
    _super.prototype.setHeight.call(this, height);
    window.zul.mesh.Paging_._rerenderIfBothPaging(this);
    return this;
  };
  Paging.prototype.setLeft = function (left) {
    _super.prototype.setLeft.call(this, left);
    window.zul.mesh.Paging_._rerenderIfBothPaging(this);
    return this;
  };
  Paging.prototype.setTop = function (top) {
    _super.prototype.setTop.call(this, top);
    window.zul.mesh.Paging_._rerenderIfBothPaging(this);
    return this;
  };
  Paging.prototype.setTooltiptext = function (tooltiptext) {
    _super.prototype.setTooltiptext.call(this, tooltiptext);
    window.zul.mesh.Paging_._rerenderIfBothPaging(this);
    return this;
  };
  Paging.prototype.replaceHTML = function (n, desktop, skipper, _trim_, _callback_) {
    if (!window.zul.mesh.Paging_._rerenderIfBothPaging(this)) _super.prototype.replaceHTML.call(this, n, desktop, skipper, _trim_, _callback_);
  };
  /**
   * @returns whether the paging is in both mold. i.e. Top and Bottom
   */
  Paging.prototype.isBothPaging = function () {
    return !!this.parent && this.parent.getPagingPosition && 'both' == this.parent.getPagingPosition();
  };
  /** @internal */
  Paging.prototype._drawDisabled = function (disabled) {
    var uuid = this.uuid,
      ap = this.getActivePage(),
      pc = this.getPageCount(),
      input = jq.$$(uuid, 'real');
    if ('os' == this.getMold()) {
      var btns = jq.$$(uuid, 'button');
      jq(btns).attr('disabled', disabled);
    } else {
      var postfix = ap == 0 && ap == pc - 1 ? [] : ap == 0 ? ['last', 'next'] : ap == pc - 1 ? ['first', 'prev'] : ['first', 'prev', 'last', 'next'];
      for (var j = input.length; j--;) {
        jq(input[j]).attr('disabled', disabled);
        for (var k = postfix.length; k--;) for (var btn = jq.$$(uuid, postfix[k]), i = btn.length; i--;) jq(btn[i]).attr('disabled', disabled);
        var fnm = disabled ? 'addClass' : 'removeClass',
          pgtext = input[j].nextSibling;
        jq(pgtext)[fnm](this.$s('text-disabled'));
      }
    }
  };
  /** @internal */
  Paging.prototype._updatePageNum = function () {
    var _this = this;
    var pageCount = Math.floor((this.getTotalSize() - 1) / this._pageSize + 1);
    if (pageCount == 0) pageCount = 1;
    if (pageCount != this.getPageCount()) {
      this.setPageCount(pageCount);
      if (this.getActivePage() >= pageCount) this.setActivePage(pageCount - 1);
      if (this.desktop && this.parent) {
        if (!window.zul.mesh.Paging_._rerenderIfBothPaging(this)) {
          this.rerender();
          // Bug 2931951
          if (this.parent instanceof zul.mesh.MeshWidget) {
            // Bug ZK-2624
            setTimeout(function () {
              var _a;
              if (_this.desktop) {
                var n = (_a = _this.parent) === null || _a === void 0 ? void 0 : _a.$n();
                // reset and recalculate
                if (n === null || n === void 0 ? void 0 : n._lastsz) {
                  n._lastsz = undefined;
                  _this.parent.onSize();
                }
              }
            });
          }
        }
      }
    }
  };
  /**
   * @returns the information text of the paging, if {@link isDetailed} is enabled.
   * @internal
   */
  Paging.prototype.infoText_ = function () {
    var acp = this.getActivePage(),
      psz = this.getPageSize(),
      tsz = this.getTotalSize(),
      lastItem = (acp + 1) * psz;
    var dash = '';
    if ('os' != this.getMold()) dash = " - ".concat(Math.min(lastItem, tsz));
    return "[ ".concat(acp * psz + 1).concat(dash, " / ").concat(tsz, " ]");
  };
  /** @internal */
  Paging.prototype._infoTags = function (out) {
    if (this.getTotalSize() == 0) return;
    var uuidHTML = this.uuid,
      nameOrId = window.zul.mesh.Paging_._rerenderIfBothPaging(this) ? 'name' : 'id'; // Bug ZK-2280
    out.push('<div ', nameOrId, '="', uuidHTML, '-detail" class="', this.$s('info'), '"><span ', nameOrId, '="', uuidHTML, '-info" aria-hidden="true">', DOMPurify.sanitize(this.infoText_()), '</span></div>');
  };
  /** @internal */
  Paging.prototype._innerTags = function () {
    var out = new zk.Buffer(),
      pinc = this.getPageIncrement(),
      pcount = this.getPageCount(),
      acp = this.getActivePage(),
      half = Math.round(pinc / 2);
    var begin,
      end = acp + half - 1;
    if (end >= pcount) {
      end = pcount - 1;
      begin = end - pinc + 1;
      if (begin < 0) begin = 0;
    } else {
      begin = acp - half;
      if (begin < 0) begin = 0;
      end = begin + pinc - 1;
      if (end >= pcount) end = pcount - 1;
    }
    out.push('<ul>');
    if (acp > 0) {
      if (begin > 0)
        //show first
        this.appendAnchor(out, msgzul.FIRST, 0);
      this.appendAnchor(out, msgzul.PREV, acp - 1);
    }
    var bNext = acp < pcount - 1;
    for (; begin <= end; ++begin) this.appendAnchor(out, begin + 1, begin, begin == acp);
    if (bNext) {
      this.appendAnchor(out, msgzul.NEXT, acp + 1);
      if (end < pcount - 1)
        //show last
        this.appendAnchor(out, msgzul.LAST, pcount - 1);
    }
    out.push('</ul>');
    if (this.isDetailed()) this._infoTags(out);
    return out.join('');
  };
  Paging.prototype.appendAnchor = function (out, label, val, seld) {
    var cls = this.$s('button'),
      navCls = '';
    if (!window.zul.mesh.Paging_._isUnsignedInteger(label)) {
      cls += ' ' + this.$s('noborder');
      navCls = ' class="' + this.$s('navigate') + '"';
    }
    if (seld) cls += ' ' + this.$s('selected');
    out.push('<li', navCls, '><a name="', this.uuid, '-button" class="', /*safe*/cls, '" href="javascript:;" data-paging="', val, '"', seld ? ' aria-current="page"' : '', '>', label, '</a></li>');
  };
  /** @internal */
  Paging.prototype.domClass_ = function (no) {
    var /*safe*/cls = _super.prototype.domClass_.call(this, no),
      added = 'os' == this.getMold() ? ' ' + this.$s('os') : '';
    return cls + added;
  };
  Paging.prototype.isVisible = function (strict) {
    var visible = _super.prototype.isVisible.call(this, strict);
    return visible && (this.getPageCount() > 1 || !this._autohide);
  };
  /** @internal */
  Paging.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onSize: this
    });
    var uuid = this.uuid,
      input = jq.$$(uuid, 'real'),
      pcount = this.getPageCount(),
      acp = this.getActivePage(),
      postfix = ['first', 'prev', 'last', 'next'],
      focusInfo = zul.mesh.Paging._autoFocusInfo;
    if (!this.$weave) for (var i = input.length; i--;) jq(input[i]).on('keydown', this.proxy(this._domKeyDown)).on('blur', this.proxy(this._domBlur));
    for (var k = postfix.length; k--;) {
      var btn = jq.$$(uuid, postfix[k]);
      for (var j = btn.length; j--;) {
        if (!this.$weave) jq(btn[j]).on('click', this.proxy(this["_dom".concat(postfix[k], "Click")]));
        if (pcount == 1) {
          jq(btn[j]).attr('disabled', true);
        } else if (postfix[k] == 'first' || postfix[k] == 'prev') {
          if (acp == 0) jq(btn[j]).attr('disabled', true);
        } else if (acp == pcount - 1) {
          jq(btn[j]).attr('disabled', true);
        }
      }
    }
    if (this.getMold() == 'os') {
      var btns = jq.$$(uuid, 'button');
      var _loop_1 = function (j) {
        // eslint-disable-next-line @typescript-eslint/no-this-alias
        var self = this_1;
        jq(btns[j]).on('click', function () {
          if (self.isDisabled()) return;
          Paging_1.go(self, parseInt(jq(this).attr('data-paging')));
        });
      };
      var this_1 = this;
      for (var j = btns.length; j--;) {
        _loop_1(j);
      }
    }
    if (this.isDisabled()) this._drawDisabled(true);
    if (focusInfo && focusInfo.uuid === this.uuid) {
      var pos = focusInfo.lastPos,
        zinp = zk(input[focusInfo.inpIdx]);
      zinp.focus();
      zinp.setSelectionRange(pos[0], pos[1]);
    }
    //remove second id
    if (this.isBothPaging()) jq(this.parent.$n_('pgib')).find('.' + this.$s())[0].id = '';
  };
  /** @internal */
  Paging.prototype.unbind_ = function (skipper, after, keepRod) {
    var uuid = this.uuid;
    if (this.getMold() == 'os') {
      var btns = jq.$$(uuid, 'button');
      for (var j = btns.length; j--;) jq(btns[j]).off('click');
    } else {
      var input = jq.$$(uuid, 'real'),
        postfix = ['first', 'prev', 'last', 'next'];
      for (var i = input.length; i--;) jq(input[i]).off('keydown', this.proxy(this._domKeyDown)).off('blur', this.proxy(this._domBlur));
      for (var k = postfix.length; k--;) {
        var btn = jq.$$(uuid, postfix[k]);
        for (var j = btn.length; j--;) jq(btn[j]).off('click', this.proxy(this["_dom".concat(postfix[k], "Click")]));
      }
    }
    zWatch.unlisten({
      onSize: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Paging.prototype._domKeyDown = function (evt) {
    var inp = evt.target;
    if (inp.disabled || inp.readOnly) return;
    var code = evt.keyCode;
    switch (code) {
      case 48:
      case 96: //0
      case 49:
      case 97: //1
      case 50:
      case 98: //2
      case 51:
      case 99: //3
      case 52:
      case 100: //4
      case 53:
      case 101: //5
      case 54:
      case 102: //6
      case 55:
      case 103: //7
      case 56:
      case 104: //8
      case 57:
      case 105:
        //9
        break;
      case 37:
        //left
        break;
      case 38:
        //up
        Paging_1._increase(inp, this, 1);
        evt.stop();
        break;
      case 39:
        //right
        break;
      case 40:
        //down
        Paging_1._increase(inp, this, -1);
        evt.stop();
        break;
      case 33:
        // PageUp
        Paging_1._increase(inp, this, -1);
        Paging_1.go(this, +inp.value - 1, inp);
        evt.stop();
        break;
      case 34:
        // PageDown
        Paging_1._increase(inp, this, +1);
        Paging_1.go(this, +inp.value - 1, inp);
        evt.stop();
        break;
      case 36:
        //home
        Paging_1.go(this, 0, inp);
        evt.stop();
        break;
      case 35:
        //end
        Paging_1.go(this, this.getPageCount() - 1, inp);
        evt.stop();
        break;
      case 9:
      case 8:
      case 46:
        //tab, backspace, delete
        break;
      case 13:
        //enter
        Paging_1._increase(inp, this, 0);
        Paging_1.go(this, +inp.value - 1, inp);
        evt.stop();
        break;
      default:
        if (!(code >= 112 && code <= 123) //F1-F12
        && !evt.ctrlKey && !evt.altKey) evt.stop();
    }
  };
  /** @internal */
  Paging.prototype._domBlur = function (evt) {
    var inp = evt.target;
    if (inp.disabled || inp.readOnly) return;
    Paging_1._increase(inp, this, 0);
    Paging_1.go(this, +inp.value - 1);
    evt.stop();
  };
  /** @internal */
  Paging.prototype._domfirstClick = function (evt) {
    if (this.isDisabled()) return;
    var uuid = this.uuid,
      postfix = ['first', 'prev'];
    if (this.getActivePage() != 0) {
      Paging_1.go(this, 0);
      for (var k = postfix.length; k--;) for (var btn = jq.$$(uuid, postfix[k]), i = btn.length; i--;) jq(btn[i]).attr('disabled', true);
    }
    Paging_1._callWgtDoAfterGo(this, evt.currentTarget, 'first');
  };
  /** @internal */
  Paging.prototype._domprevClick = function (evt) {
    if (this.isDisabled()) return;
    var uuid = this.uuid,
      ap = this.getActivePage(),
      postfix = ['first', 'prev'];
    if (ap > 0) {
      Paging_1.go(this, ap - 1);
      if (ap - 1 == 0) {
        for (var k = postfix.length; k--;) for (var btn = jq.$$(uuid, postfix[k]), i = btn.length; i--;) jq(btn[i]).attr('disabled', true);
      }
    }
    Paging_1._callWgtDoAfterGo(this, evt.currentTarget, 'prev');
  };
  /** @internal */
  Paging.prototype._domnextClick = function (evt) {
    if (this.isDisabled()) return;
    var uuid = this.uuid,
      ap = this.getActivePage(),
      pc = this.getPageCount(),
      postfix = ['last', 'next'];
    if (ap < pc - 1) {
      Paging_1.go(this, ap + 1);
      if (ap + 1 == pc - 1) {
        for (var k = postfix.length; k--;) for (var btn = jq.$$(uuid, postfix[k]), i = btn.length; i--;) jq(btn[i]).attr('disabled', true);
      }
    }
    Paging_1._callWgtDoAfterGo(this, evt.currentTarget, 'next');
  };
  /** @internal */
  Paging.prototype._domlastClick = function (evt) {
    if (this._disabled) return;
    var uuid = this.uuid,
      pc = this.getPageCount(),
      postfix = ['last', 'next'];
    if (this.getActivePage() < pc - 1) {
      Paging_1.go(this, pc - 1);
      for (var k = postfix.length; k--;) for (var btn = jq.$$(uuid, postfix[k]), i = btn.length; i--;) jq(btn[i]).attr('disabled', true);
    }
    Paging_1._callWgtDoAfterGo(this, evt.currentTarget, 'last');
  };
  Paging.prototype.onSize = function () {
    if (this.desktop) {
      // There are two nodes if using pagingPosition="both"
      var nodes = jq.$$(this.uuid);
      if (nodes.length > 0) {
        var node = nodes[0],
          navWidth = Paging_1._getNavWidth(node, this),
          tolerant = 50,
          isWide = jq(node).width() > navWidth + tolerant,
          wideChanged = this._lastIsWide != isWide;
        if (wideChanged) this._lastIsWide = this._showFirstLast = isWide;
        // eslint-disable-next-line @typescript-eslint/prefer-for-of
        for (var i = 0; i < nodes.length; i++) Paging_1._fixControl(nodes[i], this, wideChanged);
      }
    }
  };
  /** @internal */
  Paging.prototype._doAfterGo = function (postfix, btnIndex) {
    // This function shoudn't do anything.
  };
  /**
   * Goes to the active page according to the page number.
   * @param anc - the anchor of the page number
   * @param pgno - the page number
   */
  Paging.go = function (anc, pgno, inp) {
    var wgt = anc instanceof zk.Widget ? anc : zk.Widget.$(anc);
    if (wgt && wgt.getActivePage() != pgno) {
      if (inp) {
        var uuid = wgt.uuid,
          focusInfo_1 = zul.mesh.Paging._autoFocusInfo = {
            uuid: uuid
          };
        focusInfo_1.lastPos = zk(inp).getSelectionRange();
        // concern about _pagingPosition equals "both"
        jq(jq.$$(uuid, 'real')).each(function (idx) {
          if (this == inp) {
            focusInfo_1.inpIdx = idx;
            return false;
          }
        });
      } else if (wgt.getMold() == 'os') {
        wgt._doAfterGo(anc.text);
      }
      // 1. update activePage at client for stateless
      // 2. update before onPaging for client mvvm
      wgt.setActivePage(pgno, true);
      wgt.fire('onPaging', pgno);
    }
  };
  /** @internal */
  Paging._increase = function (inp, wgt, add) {
    var value = zk.parseInt(inp.value);
    value += add;
    if (value < 1) value = 1;else if (value > wgt.getPageCount()) value = wgt.getPageCount();
    inp.value = String(value);
  };
  /** @internal */
  Paging._fixControl = function (node, wgt, wideChanged) {
    var control = jq('> ul', node),
      info = jq('> .z-paging-info', node),
      mold = wgt.getMold(),
      showFirstLast = wgt._showFirstLast;
    if (wideChanged) {
      // in mode=os, developer sets pageIncrement smaller manually
      if (mold == 'default') {
        var navs = control.find('li');
        navs.first().toggle(showFirstLast);
        navs.last().toggle(showFirstLast);
      }
    }
    info.css('visibility', function () {
      return zk(control).isOverlapped(this, 1) ? 'hidden' : '';
    });
  };
  /** @internal */
  Paging._getNavWidth = function (node, wgt) {
    if (wgt._navWidth) return wgt._navWidth;
    var navWidth = 0;
    jq('ul > li', node).each(function () {
      navWidth += jq(this).outerWidth(true);
    });
    wgt._navWidth = navWidth;
    return navWidth;
  };
  /** @internal */
  Paging._callWgtDoAfterGo = function (wgt, btn, postfix) {
    var btnIdx = 0;
    jq(jq.$$(wgt.uuid, postfix)).each(function (idx) {
      if (this == btn) {
        btnIdx = idx;
        return false;
      }
    });
    wgt._doAfterGo(postfix, btnIdx);
  };
  var Paging_1;
  Paging = Paging_1 = __decorate([zk.WrapClass('zul.mesh.Paging')], Paging);
  return Paging;
}(zul.Widget);
exports.Paging = Paging;
window.zul.mesh.Paging_.Paging = Paging;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/mesh/SortWidget.ts":
/*!**************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/mesh/SortWidget.ts ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.mesh) window.zul.mesh = {};
if (!window.zul.mesh.SortWidget_) window.zul.mesh.SortWidget_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SortWidget = void 0;
/**
 * A skeletal implementation for a sortable widget.
 */
var SortWidget = /** @class */function (_super) {
  __extends(SortWidget, _super);
  function SortWidget() {
    var _this = _super.call(this) || this; // FIXME: params to be decided
    /** @internal */
    _this._sortDirection = 'natural';
    /** @internal */
    _this._sortAscending = 'none';
    /** @internal */
    _this._sortDescending = 'none';
    _this.listen({
      onSort: _this
    }, -1000);
    return _this;
  }
  /**
   * @returns the sort direction.
   * @defaultValue `"natural"`.
   */
  SortWidget.prototype.getSortDirection = function () {
    return this._sortDirection;
  };
  /**
   * Sets the sort direction. This does not sort the data, it only serves
   * as an indicator as to how the widget is sorted.
   *
   * <p>If you use {@link sort} to sort rows,
   * the sort direction is maintained automatically.
   * If you want to sort it in customized way, you have to set the
   * sort direction manually.
   *
   * @param sortDirection - one of "ascending", "descending" and "natural"
   */
  SortWidget.prototype.setSortDirection = function (sortDirection, opts) {
    var o = this._sortDirection;
    this._sortDirection = sortDirection;
    if (o !== sortDirection || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        var $n = jq(this.$n_('sort-icon'));
        $n.removeClass();
        switch (sortDirection) {
          case 'ascending':
            $n.addClass('z-icon-caret-up');
            break;
          case 'descending':
            $n.addClass('z-icon-caret-down');
        }
      }
    }
    return this;
  };
  /**
   * @returns the ascending sorter, or null if not available.
   */
  SortWidget.prototype.getSortAscending = function () {
    return this._sortAscending;
  };
  /**
   * Sets the ascending sorter with "client", "auto", or null for
   * no sorter for the ascending order.
   */
  SortWidget.prototype.setSortAscending = function (sortAscending, opts) {
    var o = this._sortAscending;
    this._sortAscending = sortAscending;
    if (o !== sortAscending || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (!sortAscending) this._sortAscending = sortAscending = 'none';
      if (this.desktop) {
        this.setSortDirection('natural');
        jq(this.$n_()).toggleClass(this.$s('sort'), this.isSortable_());
      }
    }
    return this;
  };
  /**
   * @returns the descending sorter, or null if not available.
   */
  SortWidget.prototype.getSortDescending = function () {
    return this._sortDescending;
  };
  /**
   * Sets the descending sorter with "client", "auto", or null for
   * no sorter for the descending order.
   */
  SortWidget.prototype.setSortDescending = function (sortDescending, opts) {
    var o = this._sortDescending;
    this._sortDescending = sortDescending;
    if (o !== sortDescending || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (!sortDescending) this._sortDescending = sortDescending = 'none';
      if (this.desktop) {
        this.setSortDirection('natural');
        jq(this.$n_()).toggleClass(this.$s('sort'), this.isSortable_());
      }
    }
    return this;
  };
  /**
   * Sets the type of the sorter.
   * You might specify either "auto", "client", or "none".
   *
   * <p>If "client" or "client(number)" is specified,
   * the sort functionality will be done by Javascript at client without notifying
   * to server, that is, the order of the component in the row is out of sync.
   * <ul>
   * <li> "client" : it is treated by a string</li>
   * <li> "client(number)" : it is treated by a number</li>
   * </ul>
   * <p>Note: client sorting cannot work in model case.
   */
  SortWidget.prototype.setSort = function (sort) {
    if (sort && sort.startsWith('client')) {
      this.setSortAscending(sort);
      this.setSortDescending(sort);
    } else {
      this.setSortAscending('none');
      this.setSortDescending('none');
    }
    return this;
  };
  /** @internal */
  SortWidget.prototype.isSortable_ = function () {
    return this._sortAscending != 'none' || this._sortDescending != 'none';
  };
  /**
   * Sorts the data.
   */
  SortWidget.prototype.sort = function (ascending, evt) {
    if (!this.checkClientSort_(ascending)) return false;
    evt.stop();
    this.replaceCavedChildrenInOrder_(ascending);
    return true;
  };
  /**
   * Check the status whether can be sort in client side.
   * @since 5.0.6
   * @see {@link sort}
   * @internal
   */
  SortWidget.prototype.checkClientSort_ = function (ascending) {
    var dir = this.getSortDirection();
    if (ascending) {
      if ('ascending' == dir) return false;
    } else {
      if ('descending' == dir) return false;
    }
    var sorter = ascending ? this._sortAscending : this._sortDescending;
    if (sorter == 'fromServer') return false;else if (sorter == 'none') {
      return false;
    }
    var mesh = this.getMeshWidget();
    if (!mesh || mesh.isModel()) return false;
    // if in model, the sort should be done by server
    return true;
  };
  /**
   * Replaced the child widgets with the specified order.
   * @since 5.0.6
   * @see {@link sort}
   * @internal
   */
  SortWidget.prototype.replaceCavedChildrenInOrder_ = function (ascending) {
    var mesh = this.getMeshWidget(),
      body = this.getMeshBody(),
      dir = this.getSortDirection(),
      sorter = ascending ? this._sortAscending : this._sortDescending,
      desktop = body.desktop,
      node = body.$n_();
    try {
      body.unbind();
      var d = [],
        col = this.getChildIndex();
      for (var i = 0, z = 0, it = mesh.getBodyWidgetIterator(), w; w = it.next(); z++) for (var k = 0, cell = w.firstChild; cell; cell = cell.nextSibling, k++) if (k == col) {
        d[i++] = {
          wgt: cell,
          index: z
        };
      }
      var dsc = dir == 'ascending' ? -1 : 1,
        fn = this.sorting,
        isNumber = sorter == 'client(number)';
      d.sort(function (a, b) {
        var v = fn(a.wgt, b.wgt, isNumber) * dsc;
        if (v == 0) {
          v = a.index < b.index ? -1 : 1;
        }
        return v;
      });
      for (var i = 0, k = d.length; i < k; i++) {
        body.appendChild(d[i].wgt.parent);
      }
      this._fixDirection(ascending);
    } finally {
      body.replaceHTML(node, desktop);
    }
  };
  /**
   * The default implementation to compare the data.
   * @param a - the first object to be compared.
   * @param b - the second object to be compared.
   */
  SortWidget.prototype.sorting = function (a, b, isNumber) {
    var v1, v2;
    if (typeof a.getLabel == 'function') v1 = a.getLabel();else if (typeof a.getValue == 'function') v1 = a.getValue();else v1 = a;
    if (typeof b.getLabel == 'function') v2 = b.getLabel();else if (typeof b.getValue == 'function') v2 = b.getValue();else v2 = b;
    if (isNumber) return v1 - v2;
    return v1 > v2 ? 1 : v1 < v2 ? -1 : 0;
  };
  /** @internal */
  SortWidget.prototype._fixDirection = function (ascending) {
    //maintain
    var direction = ascending ? 'ascending' : 'descending';
    for (var w = this.parent.firstChild; w; w = w.nextSibling) w.setSortDirection(w == this ? direction : 'natural');
  };
  SortWidget.prototype.onSort = function (evt) {
    var dir = this.getSortDirection();
    if ('ascending' == dir) this.sort(false, evt);else if ('descending' == dir) this.sort(true, evt);else if (!this.sort(true, evt)) this.sort(false, evt);
  };
  /** @internal */
  SortWidget.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    if (this._sortAscending != 'none' || this._sortDescending != 'none') {
      var $n = jq(this.$n_()),
        $sortIcon = jq(this.$n_('sort-icon'));
      $n.addClass(this.$s('sort'));
      switch (this._sortDirection) {
        case 'ascending':
          $sortIcon.addClass('z-icon-caret-up');
          break;
        case 'descending':
          $sortIcon.addClass('z-icon-caret-down');
          break;
        default:
          // "natural"
          break;
      }
    }
  };
  /** @internal */
  SortWidget.prototype.unbind_ = function (skipper, after, keepRod) {
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  SortWidget.prototype.getColumnMenuPopup_ = function () {
    return;
  };
  /** @internal */
  SortWidget.prototype._doMenuClick = function (evt) {
    if (this.parent._menupopup && this.parent._menupopup != 'none') {
      var pp = this.parent._menupopup,
        btn = this.$n_('btn');
      //for not removing hover effect when moving mouse on menupopup
      jq(this.$n_()).addClass(this.$s('visited'));
      if ((pp == 'auto' || pp == 'auto-keep') && this.parent._mpop) pp = this.parent._mpop;else pp = this.$f(this.parent._menupopup);
      if (pp instanceof zul.menu.Menupopup) {
        var ofs = zk(btn).revisedOffset(),
          asc = this.getSortAscending() != 'none',
          desc = this.getSortDescending() != 'none',
          mw = this.getMeshWidget();
        if (pp instanceof zul.mesh.ColumnMenupopup) {
          pp.getAscitem().setVisible(asc);
          pp.getDescitem().setVisible(desc);
          var model = mw.getModel();
          if (zk.feature.pe && pp.getGroupitem()) {
            if (model == 'group' || !model || this.isListen('onGroup', {
              asapOnly: true
            })) pp.getGroupitem().setVisible(asc || desc);else pp.getGroupitem().setVisible(false);
          }
          if (zk.feature.ee && pp.getUngroupitem()) {
            var visible = !model || this.isListen('onUngroup', {
              asapOnly: true
            });
            pp.getUngroupitem().setVisible(visible && mw.hasGroup());
          }
          var sep = pp.getDescitem().nextSibling;
          if (sep) sep.setVisible(asc || desc);
        } else {
          // In general, parent is not zul.mesh.ColumnMenuWidget, but it is here.
          pp.listen({
            onOpen: [this.parent, this.parent._onMenuPopup]
          });
        }
        pp.open(btn, [ofs[0], ofs[1] + btn.offsetHeight - 4], undefined, {
          sendOnOpen: true
        });
      }
      evt.stop(); // avoid onSort event.
    }
  };
  SortWidget = __decorate([zk.WrapClass('zul.mesh.SortWidget')], SortWidget);
  return SortWidget;
}(zul.mesh.HeaderWidget);
exports.SortWidget = SortWidget;
window.zul.mesh.SortWidget_.SortWidget = SortWidget;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/mesh/index.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/mesh/index.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __exportStar = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__exportStar"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = {};
__exportStar(__webpack_require__(/*! ./MeshWidget */ "./zul/src/main/resources/web/js/zul/mesh/MeshWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./HeadWidget */ "./zul/src/main/resources/web/js/zul/mesh/HeadWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./ColumnMenuWidget */ "./zul/src/main/resources/web/js/zul/mesh/ColumnMenuWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./HeaderWidget */ "./zul/src/main/resources/web/js/zul/mesh/HeaderWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./SortWidget */ "./zul/src/main/resources/web/js/zul/mesh/SortWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./FooterWidget */ "./zul/src/main/resources/web/js/zul/mesh/FooterWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./Paging */ "./zul/src/main/resources/web/js/zul/mesh/Paging.ts"), exports);
__exportStar(__webpack_require__(/*! ./Auxhead */ "./zul/src/main/resources/web/js/zul/mesh/Auxhead.ts"), exports);
__exportStar(__webpack_require__(/*! ./Auxheader */ "./zul/src/main/resources/web/js/zul/mesh/Auxheader.ts"), exports);
__exportStar(__webpack_require__(/*! ./Frozen */ "./zul/src/main/resources/web/js/zul/mesh/Frozen.ts"), exports);

/***/ }),

/***/ "./node_modules/tslib/tslib.es6.js":
/*!*****************************************!*\
  !*** ./node_modules/tslib/tslib.es6.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __addDisposableResource: function() { return /* binding */ __addDisposableResource; },
/* harmony export */   __assign: function() { return /* binding */ __assign; },
/* harmony export */   __asyncDelegator: function() { return /* binding */ __asyncDelegator; },
/* harmony export */   __asyncGenerator: function() { return /* binding */ __asyncGenerator; },
/* harmony export */   __asyncValues: function() { return /* binding */ __asyncValues; },
/* harmony export */   __await: function() { return /* binding */ __await; },
/* harmony export */   __awaiter: function() { return /* binding */ __awaiter; },
/* harmony export */   __classPrivateFieldGet: function() { return /* binding */ __classPrivateFieldGet; },
/* harmony export */   __classPrivateFieldIn: function() { return /* binding */ __classPrivateFieldIn; },
/* harmony export */   __classPrivateFieldSet: function() { return /* binding */ __classPrivateFieldSet; },
/* harmony export */   __createBinding: function() { return /* binding */ __createBinding; },
/* harmony export */   __decorate: function() { return /* binding */ __decorate; },
/* harmony export */   __disposeResources: function() { return /* binding */ __disposeResources; },
/* harmony export */   __esDecorate: function() { return /* binding */ __esDecorate; },
/* harmony export */   __exportStar: function() { return /* binding */ __exportStar; },
/* harmony export */   __extends: function() { return /* binding */ __extends; },
/* harmony export */   __generator: function() { return /* binding */ __generator; },
/* harmony export */   __importDefault: function() { return /* binding */ __importDefault; },
/* harmony export */   __importStar: function() { return /* binding */ __importStar; },
/* harmony export */   __makeTemplateObject: function() { return /* binding */ __makeTemplateObject; },
/* harmony export */   __metadata: function() { return /* binding */ __metadata; },
/* harmony export */   __param: function() { return /* binding */ __param; },
/* harmony export */   __propKey: function() { return /* binding */ __propKey; },
/* harmony export */   __read: function() { return /* binding */ __read; },
/* harmony export */   __rest: function() { return /* binding */ __rest; },
/* harmony export */   __runInitializers: function() { return /* binding */ __runInitializers; },
/* harmony export */   __setFunctionName: function() { return /* binding */ __setFunctionName; },
/* harmony export */   __spread: function() { return /* binding */ __spread; },
/* harmony export */   __spreadArray: function() { return /* binding */ __spreadArray; },
/* harmony export */   __spreadArrays: function() { return /* binding */ __spreadArrays; },
/* harmony export */   __values: function() { return /* binding */ __values; }
/* harmony export */ });
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

/* harmony default export */ __webpack_exports__["default"] = ({
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
});


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./zul/src/main/resources/web/js/zul/mesh/index.ts");
/******/ 	var __webpack_export_target__ = window;
/******/ 	var __webpack_exports_export__ = __webpack_exports__["default"];
/******/ 	for(var i in __webpack_exports_export__) __webpack_export_target__[i] = __webpack_exports_export__[i];
/******/ 	if(__webpack_exports_export__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;